/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.async.AsyncQuota;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.ipc.CallerContext;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestRouterAsyncQuota {
    private static Configuration routerConf;
    private static MiniRouterDFSCluster cluster;
    private static String ns0;
    private MiniRouterDFSCluster.RouterContext router;
    private FileSystem routerFs;
    private RouterRpcServer routerRpcServer;
    private AsyncQuota asyncQuota;
    private final String testfilePath = "/testdir/testAsyncQuota.file";

    @BeforeAll
    public static void setUpCluster() throws Exception {
        cluster = new MiniRouterDFSCluster(true, 1, 2, MiniRouterDFSCluster.DEFAULT_HEARTBEAT_INTERVAL_MS, 1000L);
        cluster.setNumDatanodesPerNameservice(3);
        cluster.setRacks(new String[]{"/rack1", "/rack2", "/rack3"});
        cluster.startCluster();
        if (cluster.isHighAvailability()) {
            for (String ns : cluster.getNameservices()) {
                cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
            }
        }
        routerConf = new RouterConfigBuilder().rpc().quota(true).build();
        routerConf.setInt("dfs.federation.router.client.thread-size", 1);
        routerConf.setInt("dfs.federation.router.async.rpc.handler.count", 1);
        routerConf.setInt("dfs.federation.router.async.rpc.responder.count", 1);
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        routerConf.setBoolean("dfs.quota.by.storage.type.enabled", true);
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
        cluster.waitActiveNamespaces();
        ns0 = cluster.getNameservices().get(0);
    }

    @AfterAll
    public static void shutdownCluster() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.router = cluster.getRandomRouter();
        this.routerFs = this.router.getFileSystem();
        this.routerRpcServer = this.router.getRouterRpcServer();
        this.routerRpcServer.initAsyncThreadPools(routerConf);
        RouterAsyncRpcClient asyncRpcClient = new RouterAsyncRpcClient(routerConf, this.router.getRouter(), this.routerRpcServer.getNamenodeResolver(), this.routerRpcServer.getRPCMonitor(), this.routerRpcServer.getRouterStateIdContext());
        RouterRpcServer spy = (RouterRpcServer)Mockito.spy((Object)this.routerRpcServer);
        Mockito.when((Object)spy.getRPCClient()).thenReturn((Object)asyncRpcClient);
        this.asyncQuota = new AsyncQuota(this.router.getRouter(), spy);
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        resolver.addLocation("/", ns0, "/");
        FsPermission permission = new FsPermission("705");
        this.routerFs.mkdirs(new Path("/testdir"), permission);
        FSDataOutputStream fsDataOutputStream = this.routerFs.create(new Path("/testdir/testAsyncQuota.file"), true);
        fsDataOutputStream.write(new byte[1024]);
        fsDataOutputStream.close();
    }

    @AfterEach
    public void tearDown() throws IOException {
        CallerContext.setCurrent(null);
        boolean delete = this.routerFs.delete(new Path("/testdir"));
        Assertions.assertTrue((boolean)delete);
        if (this.routerFs != null) {
            this.routerFs.close();
        }
    }

    @Test
    public void testRouterAsyncGetQuotaUsage() throws Exception {
        this.asyncQuota.getQuotaUsage("/testdir");
        QuotaUsage quotaUsage = (QuotaUsage)AsyncUtil.syncReturn(QuotaUsage.class);
        Assertions.assertEquals((long)3072L, (long)quotaUsage.getSpaceConsumed());
        Assertions.assertEquals((long)2L, (long)quotaUsage.getFileAndDirectoryCount());
    }

    @Test
    public void testRouterAsyncSetQuotaUsage() throws Exception {
        this.asyncQuota.setQuota("/testdir", Long.MAX_VALUE, 8096L, StorageType.DISK, false);
        AsyncUtil.syncReturn(Void.TYPE);
        this.asyncQuota.getQuotaUsage("/testdir");
        QuotaUsage quotaUsage = (QuotaUsage)AsyncUtil.syncReturn(QuotaUsage.class);
        Assertions.assertEquals((long)8096L, (long)quotaUsage.getTypeQuota(StorageType.DISK));
    }
}

