/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.federation.router.RouterNamenodeProtocol;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncNamenodeProtocol;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncProtocolTestBase;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterAsyncNamenodeProtocol
extends RouterAsyncProtocolTestBase {
    private RouterAsyncNamenodeProtocol asyncNamenodeProtocol;
    private RouterNamenodeProtocol namenodeProtocol;

    @BeforeEach
    public void setup() throws Exception {
        this.asyncNamenodeProtocol = new RouterAsyncNamenodeProtocol(this.getRouterAsyncRpcServer());
        this.namenodeProtocol = new RouterNamenodeProtocol(this.getRouterRpcServer());
    }

    @Test
    public void getBlocks() throws Exception {
        DatanodeInfo[] dns = this.getRouter().getClient().getNamenode().getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
        DatanodeInfo dn0 = dns[0];
        this.asyncNamenodeProtocol.getBlocks(dn0, 1024L, 0L, 0L, null);
        BlocksWithLocations asyncRouterBlockLocations = (BlocksWithLocations)AsyncUtil.syncReturn(BlocksWithLocations.class);
        Assertions.assertNotNull((Object)asyncRouterBlockLocations);
        BlocksWithLocations syncRouterBlockLocations = this.namenodeProtocol.getBlocks(dn0, 1024L, 0L, 0L, null);
        BlocksWithLocations.BlockWithLocations[] asyncRouterBlocks = asyncRouterBlockLocations.getBlocks();
        BlocksWithLocations.BlockWithLocations[] syncRouterBlocks = syncRouterBlockLocations.getBlocks();
        Assertions.assertEquals((int)asyncRouterBlocks.length, (int)syncRouterBlocks.length);
        for (int i = 0; i < syncRouterBlocks.length; ++i) {
            Assertions.assertEquals((long)asyncRouterBlocks[i].getBlock().getBlockId(), (long)syncRouterBlocks[i].getBlock().getBlockId());
        }
    }

    @Test
    public void getBlockKeys() throws Exception {
        this.asyncNamenodeProtocol.getBlockKeys();
        ExportedBlockKeys asyncBlockKeys = (ExportedBlockKeys)AsyncUtil.syncReturn(ExportedBlockKeys.class);
        Assertions.assertNotNull((Object)asyncBlockKeys);
        ExportedBlockKeys syncBlockKeys = this.namenodeProtocol.getBlockKeys();
        this.compareBlockKeys(asyncBlockKeys, syncBlockKeys);
    }

    @Test
    public void getTransactionID() throws Exception {
        this.asyncNamenodeProtocol.getTransactionID();
        long asyncTransactionID = (Long)AsyncUtil.syncReturn(Long.class);
        Assertions.assertNotNull((Object)asyncTransactionID);
        long transactionID = this.namenodeProtocol.getTransactionID();
        Assertions.assertEquals((long)asyncTransactionID, (long)transactionID);
    }

    @Test
    public void getMostRecentCheckpointTxId() throws Exception {
        this.asyncNamenodeProtocol.getMostRecentCheckpointTxId();
        long asyncMostRecentCheckpointTxId = (Long)AsyncUtil.syncReturn(Long.class);
        Assertions.assertNotNull((Object)asyncMostRecentCheckpointTxId);
        long mostRecentCheckpointTxId = this.namenodeProtocol.getMostRecentCheckpointTxId();
        Assertions.assertEquals((long)asyncMostRecentCheckpointTxId, (long)mostRecentCheckpointTxId);
    }

    @Test
    public void versionRequest() throws Exception {
        this.asyncNamenodeProtocol.versionRequest();
        NamespaceInfo asyncNamespaceInfo = (NamespaceInfo)AsyncUtil.syncReturn(NamespaceInfo.class);
        Assertions.assertNotNull((Object)asyncNamespaceInfo);
        NamespaceInfo syncNamespaceInfo = this.namenodeProtocol.versionRequest();
        this.compareVersion(asyncNamespaceInfo, syncNamespaceInfo);
    }

    private void compareBlockKeys(ExportedBlockKeys blockKeys, ExportedBlockKeys otherBlockKeys) {
        Assertions.assertEquals((Object)blockKeys.getCurrentKey(), (Object)otherBlockKeys.getCurrentKey());
        Assertions.assertEquals((long)blockKeys.getKeyUpdateInterval(), (long)otherBlockKeys.getKeyUpdateInterval());
        Assertions.assertEquals((long)blockKeys.getTokenLifetime(), (long)otherBlockKeys.getTokenLifetime());
    }

    private void compareVersion(NamespaceInfo version, NamespaceInfo otherVersion) {
        Assertions.assertEquals((Object)version.getBlockPoolID(), (Object)otherVersion.getBlockPoolID());
        Assertions.assertEquals((int)version.getNamespaceID(), (int)otherVersion.getNamespaceID());
        Assertions.assertEquals((Object)version.getClusterID(), (Object)otherVersion.getClusterID());
        Assertions.assertEquals((int)version.getLayoutVersion(), (int)otherVersion.getLayoutVersion());
        Assertions.assertEquals((long)version.getCTime(), (long)otherVersion.getCTime());
    }
}

