/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterMountTable;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.BeforeAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterAsyncMountTable
extends TestRouterMountTable {
    public static final Logger LOG = LoggerFactory.getLogger(TestRouterAsyncMountTable.class);

    @BeforeAll
    public static void globalSetUp() throws Exception {
        startTime = Time.now();
        cluster = new StateStoreDFSCluster(false, 2);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        conf.setInt("dfs.federation.router.fs-limits.max-component-length", 20);
        conf.setBoolean("dfs.federation.router.async.rpc.enable", true);
        cluster.addRouterOverrides(conf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        nnContext0 = cluster.getNamenode("ns0", null);
        nnContext1 = cluster.getNamenode("ns1", null);
        nnFs0 = nnContext0.getFileSystem();
        nnFs1 = nnContext1.getFileSystem();
        routerContext = cluster.getRandomRouter();
        routerFs = routerContext.getFileSystem();
        Router router = routerContext.getRouter();
        routerProtocol = routerContext.getClient().getNamenode();
        mountTable = (MountTableResolver)router.getSubclusterResolver();
    }
}

