/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.async.AsyncErasureCoding;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.ipc.CallerContext;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestRouterAsyncErasureCoding {
    private static Configuration routerConf;
    private static MiniRouterDFSCluster cluster;
    private static String ns0;
    private MiniRouterDFSCluster.RouterContext router;
    private FileSystem routerFs;
    private RouterRpcServer routerRpcServer;
    private AsyncErasureCoding asyncErasureCoding;
    private final String testfilePath = "/testdir/testAsyncErasureCoding.file";

    @BeforeAll
    public static void setUpCluster() throws Exception {
        cluster = new MiniRouterDFSCluster(true, 1, 2, MiniRouterDFSCluster.DEFAULT_HEARTBEAT_INTERVAL_MS, 1000L);
        cluster.setNumDatanodesPerNameservice(3);
        cluster.setRacks(new String[]{"/rack1", "/rack2", "/rack3"});
        cluster.startCluster();
        if (cluster.isHighAvailability()) {
            for (String ns : cluster.getNameservices()) {
                cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
            }
        }
        routerConf = new RouterConfigBuilder().rpc().build();
        routerConf.setInt("dfs.federation.router.client.thread-size", 1);
        routerConf.setInt("dfs.federation.router.async.rpc.handler.count", 1);
        routerConf.setInt("dfs.federation.router.async.rpc.responder.count", 1);
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
        cluster.waitActiveNamespaces();
        ns0 = cluster.getNameservices().get(0);
    }

    @AfterAll
    public static void shutdownCluster() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.router = cluster.getRandomRouter();
        this.routerFs = this.router.getFileSystem();
        this.routerRpcServer = this.router.getRouterRpcServer();
        this.routerRpcServer.initAsyncThreadPools(routerConf);
        RouterAsyncRpcClient asyncRpcClient = new RouterAsyncRpcClient(routerConf, this.router.getRouter(), this.routerRpcServer.getNamenodeResolver(), this.routerRpcServer.getRPCMonitor(), this.routerRpcServer.getRouterStateIdContext());
        RouterRpcServer spy = (RouterRpcServer)Mockito.spy((Object)this.routerRpcServer);
        Mockito.when((Object)spy.getRPCClient()).thenReturn((Object)asyncRpcClient);
        this.asyncErasureCoding = new AsyncErasureCoding(spy);
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        resolver.addLocation("/", ns0, "/");
        FsPermission permission = new FsPermission("705");
        this.routerFs.mkdirs(new Path("/testdir"), permission);
        FSDataOutputStream fsDataOutputStream = this.routerFs.create(new Path("/testdir/testAsyncErasureCoding.file"), true);
        fsDataOutputStream.write(new byte[1024]);
        fsDataOutputStream.close();
    }

    @AfterEach
    public void tearDown() throws IOException {
        CallerContext.setCurrent(null);
        boolean delete = this.routerFs.delete(new Path("/testdir"));
        Assertions.assertTrue((boolean)delete);
        if (this.routerFs != null) {
            this.routerFs.close();
        }
    }

    @Test
    public void testRouterAsyncErasureCoding() throws Exception {
        String ecPolicyName = StripedFileTestUtil.getDefaultECPolicy().getName();
        HdfsFileStatus fileInfo = cluster.getNamenodes().get(0).getClient().getFileInfo("/testdir/testAsyncErasureCoding.file");
        Assertions.assertNotNull((Object)fileInfo);
        this.asyncErasureCoding.setErasureCodingPolicy("/testdir", ecPolicyName);
        AsyncUtil.syncReturn(null);
        this.asyncErasureCoding.getErasureCodingPolicy("/testdir");
        ErasureCodingPolicy ecPolicy = (ErasureCodingPolicy)AsyncUtil.syncReturn(ErasureCodingPolicy.class);
        Assertions.assertEquals((Object)StripedFileTestUtil.getDefaultECPolicy().getName(), (Object)ecPolicy.getName());
        this.asyncErasureCoding.getErasureCodingPolicies();
        Object[] erasureCodingPolicies = (ErasureCodingPolicyInfo[])AsyncUtil.syncReturn(ErasureCodingPolicyInfo[].class);
        int numECPolicies = erasureCodingPolicies.length;
        Object[] erasureCodingPoliciesFromNameNode = cluster.getNamenodes().get(0).getClient().getErasureCodingPolicies();
        Assertions.assertArrayEquals((Object[])erasureCodingPoliciesFromNameNode, (Object[])erasureCodingPolicies);
        this.asyncErasureCoding.getErasureCodingCodecs();
        Map erasureCodingCodecs = (Map)AsyncUtil.syncReturn(Map.class);
        Map erasureCodingCodecsFromNameNode = cluster.getNamenodes().get(0).getClient().getErasureCodingCodecs();
        Assertions.assertEquals((Object)erasureCodingCodecs, (Object)erasureCodingCodecsFromNameNode);
        ECSchema schema = new ECSchema("rs", 12, 4);
        ErasureCodingPolicy erasureCodingPolicy = new ErasureCodingPolicy(schema, 0x100000);
        this.asyncErasureCoding.addErasureCodingPolicies(new ErasureCodingPolicy[]{erasureCodingPolicy});
        AddErasureCodingPolicyResponse[] response = (AddErasureCodingPolicyResponse[])AsyncUtil.syncReturn(AddErasureCodingPolicyResponse[].class);
        Assertions.assertEquals((Object)response[0].isSucceed(), (Object)true);
        this.asyncErasureCoding.getErasureCodingPolicies();
        ErasureCodingPolicyInfo[] erasureCodingPolicies2 = (ErasureCodingPolicyInfo[])AsyncUtil.syncReturn(ErasureCodingPolicyInfo[].class);
        int numNewECPolicies = erasureCodingPolicies2.length;
        Assertions.assertEquals((int)(numECPolicies + 1), (int)numNewECPolicies);
        this.asyncErasureCoding.getECTopologyResultForPolicies(new String[]{"RS-6-3-1024k", "RS-12-4-1024k"});
        ECTopologyVerifierResult ecTResultForPolicies = (ECTopologyVerifierResult)AsyncUtil.syncReturn(ECTopologyVerifierResult.class);
        Assertions.assertEquals((Object)false, (Object)ecTResultForPolicies.isSupported());
        this.asyncErasureCoding.getECTopologyResultForPolicies(new String[]{"XOR-2-1-1024k"});
        ECTopologyVerifierResult ecTResultForPolicies2 = (ECTopologyVerifierResult)AsyncUtil.syncReturn(ECTopologyVerifierResult.class);
        Assertions.assertEquals((Object)true, (Object)ecTResultForPolicies2.isSupported());
    }
}

