/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncProtocolTestBase;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterAsyncClientProtocol
extends RouterAsyncProtocolTestBase {
    private RouterAsyncClientProtocol asyncClientProtocol;
    private RouterClientProtocol clientProtocol;
    private final String testPath = "/testdir/test";

    @BeforeEach
    public void setup() throws IOException {
        this.asyncClientProtocol = new RouterAsyncClientProtocol(TestRouterAsyncClientProtocol.getRouterConf(), this.getRouterAsyncRpcServer());
        this.clientProtocol = new RouterClientProtocol(TestRouterAsyncClientProtocol.getRouterConf(), this.getRouterRpcServer());
    }

    @Test
    public void testGetServerDefaults() throws Exception {
        FsServerDefaults serverDefaults = this.clientProtocol.getServerDefaults();
        this.asyncClientProtocol.getServerDefaults();
        FsServerDefaults fsServerDefaults = (FsServerDefaults)AsyncUtil.syncReturn(FsServerDefaults.class);
        Assertions.assertEquals((long)serverDefaults.getBlockSize(), (long)fsServerDefaults.getBlockSize());
        Assertions.assertEquals((short)serverDefaults.getReplication(), (short)fsServerDefaults.getReplication());
        Assertions.assertEquals((Object)serverDefaults.getChecksumType(), (Object)fsServerDefaults.getChecksumType());
        Assertions.assertEquals((byte)serverDefaults.getDefaultStoragePolicyId(), (byte)fsServerDefaults.getDefaultStoragePolicyId());
    }

    @Test
    public void testClientProtocolRpc() throws Exception {
        this.asyncClientProtocol.mkdirs("/testdir/test", new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL), false);
        Boolean success = (Boolean)AsyncUtil.syncReturn(Boolean.class);
        Assertions.assertTrue((boolean)success);
        this.asyncClientProtocol.setPermission("/testdir/test", new FsPermission(FsAction.READ_WRITE, FsAction.READ, FsAction.NONE));
        AsyncUtil.syncReturn(Void.class);
        this.asyncClientProtocol.getFileInfo("/testdir/test");
        HdfsFileStatus hdfsFileStatus = (HdfsFileStatus)AsyncUtil.syncReturn(HdfsFileStatus.class);
        Assertions.assertEquals((Object)hdfsFileStatus.getPermission(), (Object)new FsPermission(FsAction.READ_WRITE, FsAction.READ, FsAction.NONE));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.DEFAULT, (AclEntryType)AclEntryType.USER, (String)"tmpUser", (FsAction)FsAction.ALL)});
        this.asyncClientProtocol.setAcl("/testdir/test", (List)aclSpec);
        AsyncUtil.syncReturn(Void.class);
        this.asyncClientProtocol.setOwner("/testdir/test", "tmpUser", "tmpUserGroup");
        AsyncUtil.syncReturn(Void.class);
        this.asyncClientProtocol.getFileInfo("/testdir/test");
        hdfsFileStatus = (HdfsFileStatus)AsyncUtil.syncReturn(HdfsFileStatus.class);
        Assertions.assertEquals((Object)"tmpUser", (Object)hdfsFileStatus.getOwner());
        Assertions.assertEquals((Object)"tmpUserGroup", (Object)hdfsFileStatus.getGroup());
        this.asyncClientProtocol.create("/testdir/test/testCreate.file", new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL), "testAsyncClient", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), false, (short)1, 0x8000000L, new CryptoProtocolVersion[]{CryptoProtocolVersion.ENCRYPTION_ZONES}, null, null);
        hdfsFileStatus = (HdfsFileStatus)AsyncUtil.syncReturn(HdfsFileStatus.class);
        Assertions.assertTrue((boolean)hdfsFileStatus.isFile());
        Assertions.assertEquals((long)0x8000000L, (long)hdfsFileStatus.getBlockSize());
        this.asyncClientProtocol.getFileRemoteLocation("/testdir/test");
        RemoteLocation remoteLocation = (RemoteLocation)AsyncUtil.syncReturn(RemoteLocation.class);
        Assertions.assertNotNull((Object)remoteLocation);
        Assertions.assertEquals((Object)TestRouterAsyncClientProtocol.getNs0(), (Object)remoteLocation.getNameserviceId());
        Assertions.assertEquals((Object)"/testdir/test", (Object)remoteLocation.getSrc());
        this.asyncClientProtocol.getListing("/testdir/test", new byte[1], true);
        DirectoryListing directoryListing = (DirectoryListing)AsyncUtil.syncReturn(DirectoryListing.class);
        Assertions.assertEquals((int)1, (int)directoryListing.getPartialListing().length);
        this.asyncClientProtocol.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
        DatanodeInfo[] datanodeInfos = (DatanodeInfo[])AsyncUtil.syncReturn(DatanodeInfo[].class);
        Assertions.assertEquals((int)3, (int)datanodeInfos.length);
        this.asyncClientProtocol.createSymlink("/testdir/test/testCreate.file", "/link/link.file", new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL), true);
        AsyncUtil.syncReturn(Void.class);
        this.asyncClientProtocol.getFileLinkInfo("/link/link.file");
        hdfsFileStatus = (HdfsFileStatus)AsyncUtil.syncReturn(HdfsFileStatus.class);
        Assertions.assertEquals((Object)"testCreate.file", (Object)hdfsFileStatus.getSymlink().getName());
        this.asyncClientProtocol.rename("/testdir/test/testCreate.file", "/testdir/test/testRename.file");
        success = (Boolean)AsyncUtil.syncReturn(Boolean.TYPE);
        Assertions.assertTrue((boolean)success);
        this.asyncClientProtocol.delete("/testdir/test", true);
        success = (Boolean)AsyncUtil.syncReturn(Boolean.TYPE);
        Assertions.assertTrue((boolean)success);
    }
}

