/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncCacheAdmin;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncProtocolTestBase;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterAsyncCacheAdmin
extends RouterAsyncProtocolTestBase {
    private RouterAsyncCacheAdmin asyncCacheAdmin;

    @BeforeEach
    public void setup() throws IOException {
        this.asyncCacheAdmin = new RouterAsyncCacheAdmin(this.getRouterAsyncRpcServer());
        FSDataOutputStream fsDataOutputStream = this.getRouterFs().create(new Path("/testCache.file"), true);
        fsDataOutputStream.write(new byte[1024]);
        fsDataOutputStream.close();
    }

    @Test
    public void testRouterAsyncCacheAdmin() throws Exception {
        this.asyncCacheAdmin.addCachePool(new CachePoolInfo("pool"));
        AsyncUtil.syncReturn(null);
        CacheDirectiveInfo path = new CacheDirectiveInfo.Builder().setPool("pool").setPath(new Path("/testCache.file")).build();
        this.asyncCacheAdmin.addCacheDirective(path, EnumSet.of(CacheFlag.FORCE));
        long result = (Long)AsyncUtil.syncReturn(Long.TYPE);
        Assertions.assertEquals((long)1L, (long)result);
        this.asyncCacheAdmin.listCachePools("");
        BatchedRemoteIterator.BatchedEntries cachePoolEntries = (BatchedRemoteIterator.BatchedEntries)AsyncUtil.syncReturn(BatchedRemoteIterator.BatchedEntries.class);
        Assertions.assertEquals((Object)"pool", (Object)((CachePoolEntry)cachePoolEntries.get(0)).getInfo().getPoolName());
        CacheDirectiveInfo filter = new CacheDirectiveInfo.Builder().setPool("pool").build();
        this.asyncCacheAdmin.listCacheDirectives(0L, filter);
        BatchedRemoteIterator.BatchedEntries cacheDirectiveEntries = (BatchedRemoteIterator.BatchedEntries)AsyncUtil.syncReturn(BatchedRemoteIterator.BatchedEntries.class);
        Assertions.assertEquals((Object)new Path("/testCache.file"), (Object)((CacheDirectiveEntry)cacheDirectiveEntries.get(0)).getInfo().getPath());
        CachePoolInfo pool = new CachePoolInfo("pool").setOwnerName("pool_user");
        this.asyncCacheAdmin.modifyCachePool(pool);
        AsyncUtil.syncReturn(null);
        this.asyncCacheAdmin.listCachePools("");
        cachePoolEntries = (BatchedRemoteIterator.BatchedEntries)AsyncUtil.syncReturn(BatchedRemoteIterator.BatchedEntries.class);
        Assertions.assertEquals((Object)"pool_user", (Object)((CachePoolEntry)cachePoolEntries.get(0)).getInfo().getOwnerName());
        path = new CacheDirectiveInfo.Builder().setPool("pool").setPath(new Path("/testCache.file")).setReplication(Short.valueOf((short)2)).setId(Long.valueOf(1L)).build();
        this.asyncCacheAdmin.modifyCacheDirective(path, EnumSet.of(CacheFlag.FORCE));
        AsyncUtil.syncReturn(null);
        this.asyncCacheAdmin.listCacheDirectives(0L, filter);
        cacheDirectiveEntries = (BatchedRemoteIterator.BatchedEntries)AsyncUtil.syncReturn(BatchedRemoteIterator.BatchedEntries.class);
        Assertions.assertEquals((Short)2, (Short)((CacheDirectiveEntry)cacheDirectiveEntries.get(0)).getInfo().getReplication());
        this.asyncCacheAdmin.removeCacheDirective(1L);
        AsyncUtil.syncReturn(null);
        this.asyncCacheAdmin.removeCachePool("pool");
        AsyncUtil.syncReturn(null);
    }
}

