/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterAdmin;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.BeforeAll;
import org.mockito.Mockito;

public class TestAsyncRouterAdmin
extends TestRouterAdmin {
    @BeforeAll
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 1);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        conf.setBoolean("dfs.federation.router.admin.mount.check.enable", true);
        conf.setBoolean("dfs.federation.router.async.rpc.enable", true);
        cluster.addRouterOverrides(conf);
        cluster.startRouters();
        routerContext = cluster.getRandomRouter();
        mockMountTable = cluster.generateMockMountTable();
        Router router = routerContext.getRouter();
        stateStore = router.getStateStore();
        ActiveNamenodeResolver membership = router.getNamenodeResolver();
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns0", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns1", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        stateStore.refreshCaches(true);
        TestAsyncRouterAdmin.setUpMocks();
    }

    private static void setUpMocks() throws IOException, NoSuchFieldException, IllegalAccessException {
        RouterRpcServer spyRpcServer = (RouterRpcServer)Mockito.spy((Object)routerContext.getRouter().createRpcServer());
        TestAsyncRouterAdmin.setField(routerContext.getRouter(), "rpcServer", spyRpcServer);
        ((RouterRpcServer)Mockito.doReturn(null).when((Object)spyRpcServer)).getFileInfo(Mockito.anyString());
        mockRpcClient = (RouterRpcClient)Mockito.spy((Object)spyRpcServer.getRPCClient());
        TestAsyncRouterAdmin.setField(spyRpcServer, "rpcClient", mockRpcClient);
        RemoteLocation remoteLocation0 = new RemoteLocation("ns0", "/testdir", null);
        RemoteLocation remoteLocation1 = new RemoteLocation("ns1", "/", null);
        HashMap<RemoteLocation, HdfsFileStatus> mockResponse0 = new HashMap<RemoteLocation, HdfsFileStatus>();
        HashMap<RemoteLocation, HdfsFileStatus> mockResponse1 = new HashMap<RemoteLocation, HdfsFileStatus>();
        mockResponse0.put(remoteLocation0, new HdfsFileStatus.Builder().build());
        ((RouterRpcClient)Mockito.doAnswer(invocationOnMock -> {
            AsyncUtil.asyncComplete((Object)mockResponse0);
            return null;
        }).when((Object)mockRpcClient)).invokeConcurrent((Collection)Mockito.eq((Object)Lists.newArrayList((Object[])new RemoteLocation[]{remoteLocation0})), (RemoteMethod)Mockito.any(RemoteMethod.class), Mockito.eq((boolean)false), Mockito.eq((boolean)false), (Class)Mockito.eq(HdfsFileStatus.class));
        mockResponse1.put(remoteLocation1, new HdfsFileStatus.Builder().build());
        ((RouterRpcClient)Mockito.doAnswer(invocationOnMock -> {
            AsyncUtil.asyncComplete((Object)mockResponse1);
            return null;
        }).when((Object)mockRpcClient)).invokeConcurrent((Collection)Mockito.eq((Object)Lists.newArrayList((Object[])new RemoteLocation[]{remoteLocation1})), (RemoteMethod)Mockito.any(RemoteMethod.class), Mockito.eq((boolean)false), Mockito.eq((boolean)false), (Class)Mockito.eq(HdfsFileStatus.class));
    }
}

