/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncRpcClient;
import org.apache.hadoop.ipc.CallerContext;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;

public class RouterAsyncProtocolTestBase {
    private static Configuration routerConf;
    private static MiniRouterDFSCluster cluster;
    private static String ns0;
    private MiniRouterDFSCluster.RouterContext router;
    private FileSystem routerFs;
    private RouterRpcServer routerRpcServer;
    private RouterRpcServer routerAsyncRpcServer;
    protected static final String TEST_DIR_PATH = "/testdir";

    @BeforeAll
    public static void setUpCluster() throws Exception {
        cluster = new MiniRouterDFSCluster(true, 1, 2, MiniRouterDFSCluster.DEFAULT_HEARTBEAT_INTERVAL_MS, 1000L);
        cluster.setNumDatanodesPerNameservice(3);
        cluster.startCluster();
        if (cluster.isHighAvailability()) {
            for (String ns : cluster.getNameservices()) {
                cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
            }
        }
        routerConf = new RouterConfigBuilder().rpc().build();
        routerConf.setInt("dfs.federation.router.client.thread-size", 1);
        routerConf.setInt("dfs.federation.router.async.rpc.handler.count", 1);
        routerConf.setInt("dfs.federation.router.async.rpc.responder.count", 1);
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
        cluster.waitActiveNamespaces();
        ns0 = cluster.getNameservices().get(0);
    }

    @AfterAll
    public static void shutdownCluster() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.router = cluster.getRandomRouter();
        this.routerFs = this.router.getFileSystem();
        this.routerRpcServer = this.router.getRouterRpcServer();
        this.routerRpcServer.initAsyncThreadPools(routerConf);
        RouterAsyncRpcClient asyncRpcClient = new RouterAsyncRpcClient(routerConf, this.router.getRouter(), this.routerRpcServer.getNamenodeResolver(), this.routerRpcServer.getRPCMonitor(), this.routerRpcServer.getRouterStateIdContext());
        this.routerAsyncRpcServer = (RouterRpcServer)Mockito.spy((Object)this.routerRpcServer);
        Mockito.when((Object)this.routerAsyncRpcServer.getRPCClient()).thenReturn((Object)asyncRpcClient);
        Mockito.when((Object)this.routerAsyncRpcServer.isAsync()).thenReturn((Object)true);
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        resolver.addLocation("/", ns0, "/");
        FsPermission permission = new FsPermission("705");
        this.routerFs.mkdirs(new Path(TEST_DIR_PATH), permission);
    }

    @AfterEach
    public void tearDown() throws IOException {
        CallerContext.setCurrent(null);
        boolean delete = this.routerFs.delete(new Path(TEST_DIR_PATH));
        Assertions.assertTrue((boolean)delete);
        if (this.routerFs != null) {
            this.routerFs.close();
        }
    }

    public static Configuration getRouterConf() {
        return routerConf;
    }

    public static MiniRouterDFSCluster getCluster() {
        return cluster;
    }

    public static String getNs0() {
        return ns0;
    }

    public MiniRouterDFSCluster.RouterContext getRouter() {
        return this.router;
    }

    public FileSystem getRouterFs() {
        return this.routerFs;
    }

    public RouterRpcServer getRouterRpcServer() {
        return this.routerRpcServer;
    }

    public RouterRpcServer getRouterAsyncRpcServer() {
        return this.routerAsyncRpcServer;
    }
}

