/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSafeMode {
    private MiniRouterDFSCluster cluster;

    @BeforeEach
    public void setup() throws Exception {
        this.cluster = new MiniRouterDFSCluster(true, 2);
        this.cluster.startCluster();
        this.cluster.startRouters();
        this.cluster.registerNamenodes();
        this.cluster.waitNamenodeRegistration();
        this.cluster.installMockLocations();
        if (this.cluster.isHighAvailability()) {
            for (String ns : this.cluster.getNameservices()) {
                this.cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                this.cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
            }
        }
        this.cluster.waitActiveNamespaces();
    }

    @AfterEach
    public void teardown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testProxySetSafemode() throws Exception {
        MiniRouterDFSCluster.RouterContext routerContext = this.cluster.getRandomRouter();
        ClientProtocol routerProtocol = routerContext.getClient().getNamenode();
        routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true);
        routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false);
    }
}

