/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.RouterWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterWebHdfsMethods {
    static final Logger LOG = LoggerFactory.getLogger(TestRouterWebHdfsMethods.class);
    protected static StateStoreDFSCluster cluster;
    protected static MiniRouterDFSCluster.RouterContext router;
    protected static String httpUri;

    @BeforeAll
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 2);
        Configuration conf = new RouterConfigBuilder().stateStore().rpc().http().admin().build();
        cluster.addRouterOverrides(conf);
        cluster.setIndependentDNs();
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        router = cluster.getRandomRouter();
        httpUri = "http://" + router.getHttpAddress();
    }

    @AfterAll
    public static void tearDown() {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testWebHdfsCreate() throws Exception {
        String path = "/tmp/file";
        URL url = new URL(this.getUri(path));
        LOG.info("URL: {}", (Object)url);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        Assertions.assertEquals((int)201, (int)conn.getResponseCode());
        this.verifyFile("ns0", path, true);
        this.verifyFile("ns1", path, false);
        conn.disconnect();
    }

    @Test
    public void testWebHdfsCreateWithMounts() throws Exception {
        String mountPoint = "/tmp-ns1";
        String path = "/tmp-ns1/file";
        FederationTestUtils.createMountTableEntry(router.getRouter(), mountPoint, DestinationOrder.RANDOM, Collections.singletonList("ns1"));
        URL url = new URL(this.getUri(path));
        LOG.info("URL: {}", (Object)url);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        Assertions.assertEquals((int)201, (int)conn.getResponseCode());
        this.verifyFile("ns1", path, true);
        this.verifyFile("ns0", path, false);
        conn.disconnect();
    }

    private String getUri(String path) {
        String user = System.getProperty("user.name");
        StringBuilder uri = new StringBuilder(httpUri);
        uri.append("/webhdfs/v1").append(path).append("?op=CREATE").append("&user.name=" + user);
        return uri.toString();
    }

    private void verifyFile(String ns, String path, boolean shouldExist) throws Exception {
        block3: {
            FileSystem fs = cluster.getNamenode(ns, null).getFileSystem();
            try {
                fs.getFileStatus(new Path(path));
                if (!shouldExist) {
                    Assertions.fail((String)(path + " should not exist in ns " + ns));
                }
            }
            catch (FileNotFoundException e) {
                if (!shouldExist) break block3;
                Assertions.fail((String)(path + " should exist in ns " + ns));
            }
        }
    }

    @Test
    public void testGetNsFromDataNodeNetworkLocation() {
        Assertions.assertEquals((Object)"ns0", (Object)RouterWebHdfsMethods.getNsFromDataNodeNetworkLocation((String)"/ns0/rack-info1"));
        Assertions.assertEquals((Object)"ns0", (Object)RouterWebHdfsMethods.getNsFromDataNodeNetworkLocation((String)"/ns0/row1/rack-info1"));
        Assertions.assertEquals((Object)"", (Object)RouterWebHdfsMethods.getNsFromDataNodeNetworkLocation((String)"/row0"));
        Assertions.assertEquals((Object)"", (Object)RouterWebHdfsMethods.getNsFromDataNodeNetworkLocation((String)"whatever-rack-info1"));
    }

    @Test
    public void testWebHdfsCreateWithInvalidPath() throws Exception {
        String path = "//tmp//file";
        this.assertResponse(path);
    }

    private void assertResponse(String path) throws IOException {
        URL url = new URL(this.getUri(path));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        Assertions.assertEquals((int)400, (int)conn.getResponseCode());
        Map response = WebHdfsFileSystem.jsonParse((HttpURLConnection)conn, (boolean)true);
        Assertions.assertEquals((Object)"InvalidPathException", ((LinkedHashMap)response.get("RemoteException")).get("exception"));
        conn.disconnect();
    }
}

