/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.namenode.sps.Context;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.sps.ExternalSPSContext;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestRouterRpcStoragePolicySatisfier {
    private static MiniRouterDFSCluster cluster;
    private static ClientProtocol routerProtocol;
    private static FileSystem routerFS;
    private static FileSystem nnFS;

    @BeforeAll
    public static void globalSetUp() throws Exception {
        cluster = new MiniRouterDFSCluster(false, 1);
        StorageType[][] newtypes = new StorageType[][]{{StorageType.ARCHIVE, StorageType.DISK}};
        cluster.setStorageTypes(newtypes);
        Configuration conf = cluster.getNamenodes().get(0).getConf();
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        conf.setLong("dfs.storage.policy.satisfier.datanode.cache.refresh.interval.ms", 1000L);
        cluster.addNamenodeOverrides(conf);
        cluster.setNumDatanodesPerNameservice(1);
        cluster.startCluster();
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().build();
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
        cluster.installMockLocations();
        MiniRouterDFSCluster.RouterContext rndRouter = cluster.getRandomRouter();
        routerProtocol = rndRouter.getClient().getNamenode();
        routerFS = rndRouter.getFileSystem();
        nnFS = cluster.getNamenodes().get(0).getFileSystem();
        NameNodeConnector nnc = DFSTestUtil.getNameNodeConnector((Configuration)conf, (Path)HdfsServerConstants.MOVER_ID_PATH, (int)1, (boolean)false);
        StoragePolicySatisfier externalSps = new StoragePolicySatisfier(conf);
        ExternalSPSContext externalCtxt = new ExternalSPSContext((SPSService)externalSps, nnc);
        externalSps.init((Context)externalCtxt);
        externalSps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
    }

    @AfterAll
    public static void tearDown() {
        cluster.shutdown();
    }

    @Test
    public void testStoragePolicySatisfier() throws Exception {
        String file = "/testStoragePolicySatisfierCommand";
        short repl = 1;
        int size = 32;
        DFSTestUtil.createFile((FileSystem)routerFS, (Path)new Path("/testStoragePolicySatisfierCommand"), (long)size, (short)repl, (long)0L);
        DFSTestUtil.waitExpectedStorageType((String)"/testStoragePolicySatisfierCommand", (StorageType)StorageType.DISK, (int)1, (int)20000, (DistributedFileSystem)((DistributedFileSystem)routerFS));
        routerProtocol.setStoragePolicy("/testStoragePolicySatisfierCommand", "COLD");
        BlockStoragePolicy storagePolicy = routerProtocol.getStoragePolicy("/testStoragePolicySatisfierCommand");
        Assertions.assertEquals((Object)"COLD", (Object)storagePolicy.getName());
        routerProtocol.satisfyStoragePolicy("/testStoragePolicySatisfierCommand");
        DFSTestUtil.waitExpectedStorageType((String)"/testStoragePolicySatisfierCommand", (StorageType)StorageType.ARCHIVE, (int)1, (int)20000, (DistributedFileSystem)((DistributedFileSystem)routerFS));
        DFSTestUtil.waitExpectedStorageType((String)"/testStoragePolicySatisfierCommand", (StorageType)StorageType.ARCHIVE, (int)1, (int)20000, (DistributedFileSystem)((DistributedFileSystem)nnFS));
    }
}

