/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterRpcSingleNS {
    private static MiniRouterDFSCluster cluster;
    private MiniRouterDFSCluster.RouterContext router;
    private String ns;
    private MiniRouterDFSCluster.NamenodeContext namenode;
    private ClientProtocol routerProtocol;
    private ClientProtocol nnProtocol;
    private NamenodeProtocol routerNamenodeProtocol;
    private NamenodeProtocol nnNamenodeProtocol;
    private FileSystem routerFS;
    private FileSystem nnFS;
    private String routerFile;
    private String nnFile;

    @BeforeAll
    public static void globalSetUp() throws Exception {
        cluster = new MiniRouterDFSCluster(false, 1);
        cluster.setNumDatanodesPerNameservice(2);
        cluster.startCluster();
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().build();
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
    }

    @AfterAll
    public static void tearDown() {
        cluster.shutdown();
    }

    @BeforeEach
    public void testSetup() throws Exception {
        cluster.installMockLocations();
        cluster.deleteAllFiles();
        cluster.createTestDirectoriesNamenode();
        Thread.sleep(100L);
        MiniRouterDFSCluster.RouterContext rndRouter = cluster.getRandomRouter();
        this.setRouter(rndRouter);
        String ns0 = cluster.getNameservices().get(0);
        this.setNs(ns0);
        this.setNamenode(cluster.getNamenode(ns0, null));
        Random rnd = new Random();
        String randomFile = "testfile-" + rnd.nextInt();
        this.nnFile = cluster.getNamenodeTestDirectoryForNS(this.ns) + "/" + randomFile;
        this.routerFile = cluster.getFederatedTestDirectoryForNS(this.ns) + "/" + randomFile;
        FederationTestUtils.createFile(this.nnFS, this.nnFile, 32L);
        FederationTestUtils.verifyFileExists(this.nnFS, this.nnFile);
    }

    protected void setRouter(MiniRouterDFSCluster.RouterContext r) throws IOException, URISyntaxException {
        this.router = r;
        this.routerProtocol = r.getClient().getNamenode();
        this.routerFS = r.getFileSystem();
        this.routerNamenodeProtocol = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)this.router.getConf(), (URI)this.router.getFileSystem().getUri(), NamenodeProtocol.class).getProxy();
    }

    protected void setNs(String nameservice) {
        this.ns = nameservice;
    }

    protected void setNamenode(MiniRouterDFSCluster.NamenodeContext nn) throws IOException, URISyntaxException {
        this.namenode = nn;
        this.nnProtocol = nn.getClient().getNamenode();
        this.nnFS = nn.getFileSystem();
        String ns0 = cluster.getNameservices().get(0);
        MiniRouterDFSCluster.NamenodeContext nn0 = cluster.getNamenode(ns0, null);
        this.nnNamenodeProtocol = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)nn0.getConf(), (URI)nn0.getFileSystem().getUri(), NamenodeProtocol.class).getProxy();
    }

    @Test
    public void testGetCurrentTXIDandRollEdits() throws IOException {
        Long rollEdits = this.routerProtocol.rollEdits();
        Long currentTXID = this.routerProtocol.getCurrentEditLogTxid();
        Assertions.assertEquals((Long)rollEdits, (Long)currentTXID);
    }

    @Test
    public void testSaveNamespace() throws IOException {
        cluster.getCluster().getFileSystem().setSafeMode(SafeModeAction.ENTER);
        Boolean saveNamespace = this.routerProtocol.saveNamespace(0L, 0L);
        Assertions.assertTrue((boolean)saveNamespace);
        cluster.getCluster().getFileSystem().setSafeMode(SafeModeAction.LEAVE);
    }
}

