/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationRPCMetrics;
import org.apache.hadoop.hdfs.server.federation.metrics.NamenodeBeanMetrics;
import org.apache.hadoop.hdfs.server.federation.metrics.RBFMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.router.NoLocationException;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.assertj.core.api.Assertions;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterRpc {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterRpc.class);
    protected static final int NUM_SUBCLUSTERS = 2;
    protected static final int NUM_DNS = 6;
    protected static final Comparator<ErasureCodingPolicyInfo> EC_POLICY_CMP = new Comparator<ErasureCodingPolicyInfo>(){

        @Override
        public int compare(ErasureCodingPolicyInfo ec0, ErasureCodingPolicyInfo ec1) {
            String name0 = ec0.getPolicy().getName();
            String name1 = ec1.getPolicy().getName();
            return name0.compareTo(name1);
        }
    };
    private static MiniRouterDFSCluster cluster;
    private MiniRouterDFSCluster.RouterContext router;
    private String ns;
    private MiniRouterDFSCluster.NamenodeContext namenode;
    private ClientProtocol routerProtocol;
    private ClientProtocol nnProtocol;
    private NamenodeProtocol routerNamenodeProtocol;
    private NamenodeProtocol nnNamenodeProtocol;
    private NamenodeProtocol nnNamenodeProtocol1;
    private FileSystem routerFS;
    private FileSystem nnFS;
    private String routerFile;
    private String nnFile;

    @BeforeAll
    public static void globalSetUp() throws Exception {
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().build();
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        TestRouterRpc.setUp(routerConf);
    }

    public static void setUp(Configuration routerConf) throws Exception {
        Configuration namenodeConf = new Configuration();
        namenodeConf.setBoolean("hadoop.caller.context.enabled", true);
        namenodeConf.set("hadoop.caller.context.max.size", "256");
        namenodeConf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        namenodeConf.setBoolean("dfs.namenode.audit.log.with.remote.port", true);
        cluster = new MiniRouterDFSCluster(false, 2);
        cluster.setNumDatanodesPerNameservice(6);
        cluster.addNamenodeOverrides(namenodeConf);
        cluster.setIndependentDNs();
        Configuration conf = new Configuration();
        conf.set("hadoop.proxyuser.testRealUser.groups", "*");
        conf.set("hadoop.proxyuser.testRealUser.hosts", "*");
        String loginUser = UserGroupInformation.getLoginUser().getUserName();
        conf.set(String.format("hadoop.proxyuser.%s.groups", loginUser), "*");
        conf.set(String.format("hadoop.proxyuser.%s.hosts", loginUser), "*");
        conf.set("dfs.namenode.ip-proxy-users", "placeholder");
        conf.setInt("dfs.ls.limit", 5);
        cluster.addNamenodeOverrides(conf);
        cluster.startCluster();
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
        cluster.getCluster().getNamesystem(0).getBlockManager().getDatanodeManager().setHeartbeatInterval(1L);
        cluster.getCluster().getNamesystem(1).getBlockManager().getDatanodeManager().setHeartbeatInterval(1L);
        cluster.getCluster().getNamesystem(0).getBlockManager().getDatanodeManager().setHeartbeatExpireInterval(3000L);
        cluster.getCluster().getNamesystem(1).getBlockManager().getDatanodeManager().setHeartbeatExpireInterval(3000L);
    }

    @AfterEach
    public void cleanup() {
        CallerContext.setCurrent(null);
    }

    @AfterAll
    public static void tearDown() {
        cluster.shutdown();
    }

    @BeforeEach
    public void testSetup() throws Exception {
        cluster.installMockLocations();
        cluster.deleteAllFiles();
        cluster.createTestDirectoriesNamenode();
        Thread.sleep(100L);
        MiniRouterDFSCluster.RouterContext rndRouter = cluster.getRandomRouter();
        this.setRouter(rndRouter);
        String ns0 = cluster.getNameservices().get(0);
        this.setNs(ns0);
        this.setNamenode(cluster.getNamenode(ns0, null));
        Random rnd = new Random();
        String randomFile = "testfile-" + rnd.nextInt();
        this.nnFile = cluster.getNamenodeTestDirectoryForNS(this.ns) + "/" + randomFile;
        this.routerFile = cluster.getFederatedTestDirectoryForNS(this.ns) + "/" + randomFile;
        FederationTestUtils.createFile(this.nnFS, this.nnFile, 32L);
        FederationTestUtils.verifyFileExists(this.nnFS, this.nnFile);
    }

    @Test
    public void testRpcService() throws IOException {
        Router testRouter = new Router();
        List<String> nss = cluster.getNameservices();
        String ns0 = nss.get(0);
        Configuration routerConfig = cluster.generateRouterConfiguration(ns0, null);
        RouterRpcServer server = new RouterRpcServer(routerConfig, testRouter, testRouter.getNamenodeResolver(), testRouter.getSubclusterResolver());
        server.init(routerConfig);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Service.STATE.INITED, (Object)server.getServiceState());
        server.start();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Service.STATE.STARTED, (Object)server.getServiceState());
        server.stop();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Service.STATE.STOPPED, (Object)server.getServiceState());
        server.close();
        testRouter.close();
    }

    protected MiniRouterDFSCluster getCluster() {
        return cluster;
    }

    protected MiniRouterDFSCluster.RouterContext getRouterContext() {
        return this.router;
    }

    protected void setRouter(MiniRouterDFSCluster.RouterContext r) throws IOException, URISyntaxException {
        this.router = r;
        this.routerProtocol = r.getClient().getNamenode();
        this.routerFS = r.getFileSystem();
        this.routerNamenodeProtocol = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)this.router.getConf(), (URI)this.router.getFileSystem().getUri(), NamenodeProtocol.class).getProxy();
    }

    protected FileSystem getRouterFileSystem() {
        return this.routerFS;
    }

    protected FileSystem getNamenodeFileSystem() {
        return this.nnFS;
    }

    protected ClientProtocol getRouterProtocol() {
        return this.routerProtocol;
    }

    protected ClientProtocol getNamenodeProtocol() {
        return this.nnProtocol;
    }

    protected MiniRouterDFSCluster.NamenodeContext getNamenode() {
        return this.namenode;
    }

    protected void setNamenodeFile(String filename) {
        this.nnFile = filename;
    }

    protected String getNamenodeFile() {
        return this.nnFile;
    }

    protected void setRouterFile(String filename) {
        this.routerFile = filename;
    }

    protected String getRouterFile() {
        return this.routerFile;
    }

    protected void setNamenode(MiniRouterDFSCluster.NamenodeContext nn) throws IOException, URISyntaxException {
        this.namenode = nn;
        this.nnProtocol = nn.getClient().getNamenode();
        this.nnFS = nn.getFileSystem();
        String ns0 = cluster.getNameservices().get(0);
        MiniRouterDFSCluster.NamenodeContext nn0 = cluster.getNamenode(ns0, null);
        this.nnNamenodeProtocol = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)nn0.getConf(), (URI)nn0.getFileSystem().getUri(), NamenodeProtocol.class).getProxy();
        String ns1 = cluster.getNameservices().get(1);
        MiniRouterDFSCluster.NamenodeContext nn1 = cluster.getNamenode(ns1, null);
        this.nnNamenodeProtocol1 = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)nn1.getConf(), (URI)nn1.getFileSystem().getUri(), NamenodeProtocol.class).getProxy();
    }

    protected String getNs() {
        return this.ns;
    }

    protected void setNs(String nameservice) {
        this.ns = nameservice;
    }

    protected static void compareResponses(ClientProtocol protocol1, ClientProtocol protocol2, Method m, Object[] paramList) {
        Object return1 = null;
        Exception exception1 = null;
        try {
            return1 = m.invoke((Object)protocol1, paramList);
        }
        catch (Exception ex) {
            exception1 = ex;
        }
        Object return2 = null;
        Exception exception2 = null;
        try {
            return2 = m.invoke((Object)protocol2, paramList);
        }
        catch (Exception ex) {
            exception2 = ex;
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)return1, (Object)return2);
        if (exception1 == null && exception2 == null) {
            return;
        }
        org.junit.jupiter.api.Assertions.assertEquals(exception1.getCause().getClass(), exception2.getCause().getClass());
    }

    @Test
    public void testProxyListFiles() throws IOException, InterruptedException, URISyntaxException, NoSuchMethodException, SecurityException {
        FileStatus[] iterator;
        TreeSet<String> requiredPaths = new TreeSet<String>();
        FileSubclusterResolver fileResolver = this.router.getRouter().getSubclusterResolver();
        for (String mount : fileResolver.getMountPoints("/")) {
            requiredPaths.add(mount);
        }
        String defaultNs = cluster.getNameservices().get(0);
        MiniRouterDFSCluster.NamenodeContext nn = cluster.getNamenode(defaultNs, null);
        for (FileStatus file : iterator = nn.getFileSystem().listStatus(new Path("/"))) {
            requiredPaths.add(file.getPath().getName());
        }
        DirectoryListing listing = this.routerProtocol.getListing("/", HdfsFileStatus.EMPTY_NAME, false);
        Iterator requiredPathsIterator = requiredPaths.iterator();
        for (HdfsFileStatus f : listing.getPartialListing()) {
            String fileName = (String)requiredPathsIterator.next();
            String currentFile = f.getFullPath(new Path("/")).getName();
            org.junit.jupiter.api.Assertions.assertEquals((Object)currentFile, (Object)fileName);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)requiredPaths.size(), (int)listing.getPartialListing().length);
        Method m = ClientProtocol.class.getMethod("getListing", String.class, byte[].class, Boolean.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, HdfsFileStatus.EMPTY_NAME, false});
    }

    @Test
    public void testProxyListFilesLargeDir() throws IOException {
        int i;
        for (MiniRouterDFSCluster.RouterContext rc : cluster.getRouters()) {
            MockResolver resolver = (MockResolver)rc.getRouter().getSubclusterResolver();
            resolver.addLocation("/parent", this.ns, "/parent");
            resolver.addLocation("/parent/file-0", this.ns, "/parent/file-0");
            resolver.addLocation("/parent/file-7", this.ns, "/parent/file-7");
        }
        FileStatus[] result = this.routerFS.listStatus(new Path("/parent"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)result.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"file-0", (Object)result[0].getPath().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"file-7", (Object)result[1].getPath().getName());
        MiniRouterDFSCluster.NamenodeContext nn = cluster.getNamenode(this.ns, null);
        FileSystem nnFileSystem = nn.getFileSystem();
        for (i = 1; i < 9; ++i) {
            FederationTestUtils.createFile(nnFileSystem, "/parent/file-" + i, 32L);
        }
        result = this.routerFS.listStatus(new Path("/parent"));
        org.junit.jupiter.api.Assertions.assertEquals((int)9, (int)result.length);
        for (i = 0; i < 9; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)("file-" + i), (Object)result[i].getPath().getName());
        }
        for (MiniRouterDFSCluster.RouterContext rc : cluster.getRouters()) {
            MockResolver resolver = (MockResolver)rc.getRouter().getSubclusterResolver();
            resolver.addLocation("/parent/file-9", this.ns, "/parent/file-9");
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FederationTestUtils.verifyFileExists(nnFileSystem, "/parent/file-9"));
        result = this.routerFS.listStatus(new Path("/parent"));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)result.length);
        for (int i2 = 0; i2 < 10; ++i2) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)("file-" + i2), (Object)result[i2].getPath().getName());
        }
    }

    @Test
    public void testProxyListFilesWithConflict() throws IOException, InterruptedException {
        MiniRouterDFSCluster.NamenodeContext nn = cluster.getNamenode(this.ns, null);
        FileSystem nnFs = nn.getFileSystem();
        FederationTestUtils.addDirectory(nnFs, cluster.getFederatedTestDirectoryForNS(this.ns));
        FileSystem routerFs = this.router.getFileSystem();
        int initialCount = FederationTestUtils.countContents(routerFs, "/");
        int newCount = FederationTestUtils.countContents(routerFs, "/");
        org.junit.jupiter.api.Assertions.assertEquals((int)initialCount, (int)newCount);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)FederationTestUtils.countContents(routerFs, cluster.getFederatedPathForNS(this.ns)));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)FederationTestUtils.countContents(nnFs, cluster.getNamenodePathForNS(this.ns)));
    }

    protected void testRename(MiniRouterDFSCluster.RouterContext testRouter, String filename, String renamedFile, boolean exceptionExpected) throws IOException {
        FederationTestUtils.createFile(testRouter.getFileSystem(), filename, 32L);
        FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), filename);
        boolean exceptionThrown = false;
        try {
            DFSClient client = testRouter.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(filename, renamedFile);
        }
        catch (Exception ex) {
            exceptionThrown = true;
        }
        if (exceptionExpected) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)exceptionThrown);
            fileContext = testRouter.getFileContext();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fileContext.delete(new Path(filename), true));
        } else {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)exceptionThrown);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), renamedFile));
            fileContext = testRouter.getFileContext();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fileContext.delete(new Path(renamedFile), true));
        }
    }

    protected void testRename2(MiniRouterDFSCluster.RouterContext testRouter, String filename, String renamedFile, boolean exceptionExpected) throws IOException {
        FederationTestUtils.createFile(testRouter.getFileSystem(), filename, 32L);
        FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), filename);
        boolean exceptionThrown = false;
        try {
            DFSClient client = testRouter.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename2(filename, renamedFile, new Options.Rename[0]);
        }
        catch (Exception ex) {
            exceptionThrown = true;
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)exceptionExpected, (Object)exceptionThrown);
        if (exceptionExpected) {
            fileContext = testRouter.getFileContext();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fileContext.delete(new Path(filename), true));
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), renamedFile));
            fileContext = testRouter.getFileContext();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fileContext.delete(new Path(renamedFile), true));
        }
    }

    @Test
    public void testProxyRenameFiles() throws IOException, InterruptedException {
        Thread.sleep(5000L);
        List<String> nss = cluster.getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        String filename = cluster.getFederatedTestDirectoryForNS(ns0) + "/testrename";
        String renamedFile = filename + "-append";
        this.testRename(this.router, filename, renamedFile, false);
        this.testRename2(this.router, filename, renamedFile, false);
        filename = cluster.getFederatedTestDirectoryForNS(ns0) + "/testrename";
        renamedFile = cluster.getFederatedTestDirectoryForNS(ns1) + "/testrename";
        this.testRename(this.router, filename, renamedFile, true);
        this.testRename2(this.router, filename, renamedFile, true);
    }

    @Test
    public void testProxyChownFiles() throws Exception {
        String newUsername = "TestUser";
        String newGroup = "TestGroup";
        this.routerProtocol.setOwner(this.routerFile, newUsername, newGroup);
        FileStatus file = FederationTestUtils.getFileStatus(this.namenode.getFileSystem(), this.nnFile);
        org.junit.jupiter.api.Assertions.assertEquals((Object)file.getOwner(), (Object)newUsername);
        org.junit.jupiter.api.Assertions.assertEquals((Object)file.getGroup(), (Object)newGroup);
        Method m = ClientProtocol.class.getMethod("setOwner", String.class, String.class, String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, newUsername, newGroup});
    }

    @Test
    public void testProxyGetStats() throws Exception {
        Supplier<Boolean> check = new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    long[] combinedData = TestRouterRpc.this.routerProtocol.getStats();
                    long[] individualData = TestRouterRpc.this.getAggregateStats();
                    int len = Math.min(combinedData.length, individualData.length);
                    for (int i = 0; i < len; ++i) {
                        if (combinedData[i] == individualData[i]) continue;
                        LOG.error("Stats for {} don't match: {} != {}", new Object[]{i, combinedData[i], individualData[i]});
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    LOG.error("Cannot get stats: {}", (Object)e.getMessage());
                    return false;
                }
            }
        };
        GenericTestUtils.waitFor((Supplier)check, (long)500L, (long)5000L);
    }

    private long[] getAggregateStats() throws Exception {
        long[] individualData = new long[10];
        for (String nameservice : cluster.getNameservices()) {
            MiniRouterDFSCluster.NamenodeContext n = cluster.getNamenode(nameservice, null);
            DFSClient client = n.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            long[] data = clientProtocol.getStats();
            for (int i = 0; i < data.length; ++i) {
                int n2 = i;
                individualData[n2] = individualData[n2] + data[i];
            }
        }
        return individualData;
    }

    @Test
    public void testProxyGetDatanodeReport() throws Exception {
        DatanodeInfo[] combinedData = this.routerProtocol.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.routerProtocol.getSlowDatanodeReport().length);
        TreeMap<Integer, String> routerDNMap = new TreeMap<Integer, String>();
        for (DatanodeInfo dn : combinedData) {
            String subcluster = dn.getNetworkLocation().split("/")[1];
            routerDNMap.put(dn.getXferPort(), subcluster);
        }
        TreeMap<Integer, String> nnDNMap = new TreeMap<Integer, String>();
        for (String nameservice : cluster.getNameservices()) {
            MiniRouterDFSCluster.NamenodeContext n = cluster.getNamenode(nameservice, null);
            DFSClient client = n.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            DatanodeInfo[] data = clientProtocol.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
            for (int i = 0; i < data.length; ++i) {
                DatanodeInfo info = data[i];
                nnDNMap.put(info.getXferPort(), nameservice);
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals(nnDNMap, routerDNMap);
    }

    @Test
    public void testProxyGetDatanodeStorageReport() throws IOException, InterruptedException, URISyntaxException {
        DatanodeStorageReport[] combinedData = this.routerProtocol.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL);
        HashSet<String> individualData = new HashSet<String>();
        for (String nameservice : cluster.getNameservices()) {
            DatanodeStorageReport[] data;
            MiniRouterDFSCluster.NamenodeContext n = cluster.getNamenode(nameservice, null);
            DFSClient client = n.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            for (DatanodeStorageReport report : data = clientProtocol.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL)) {
                DatanodeInfo dn = report.getDatanodeInfo();
                individualData.add(dn.toString());
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)combinedData.length, (int)individualData.size());
    }

    @Test
    public void testProxyMkdir() throws Exception {
        Object[] filesInitial = this.routerFS.listStatus(new Path("/"));
        String dirPath = "/testdir";
        FsPermission permission = new FsPermission("705");
        this.routerProtocol.mkdirs(dirPath, permission, false);
        Object[] files = this.routerFS.listStatus(new Path("/"));
        org.junit.jupiter.api.Assertions.assertEquals((int)(filesInitial.length + 1), (int)files.length, (String)(Arrays.toString(files) + " should be " + Arrays.toString(filesInitial) + " + " + dirPath));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, dirPath));
        int foundCount = 0;
        for (MiniRouterDFSCluster.NamenodeContext n : cluster.getNamenodes()) {
            if (!FederationTestUtils.verifyFileExists(n.getFileSystem(), dirPath)) continue;
            ++foundCount;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)foundCount);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.deleteFile(this.routerFS, dirPath));
        Method m = ClientProtocol.class.getMethod("mkdirs", String.class, FsPermission.class, Boolean.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, permission, false});
    }

    @Test
    public void testProxyChmodFiles() throws Exception {
        FsPermission permission = new FsPermission("444");
        this.routerProtocol.setPermission(this.routerFile, permission);
        FileStatus file = FederationTestUtils.getFileStatus(this.namenode.getFileSystem(), this.nnFile);
        org.junit.jupiter.api.Assertions.assertEquals((Object)permission, (Object)file.getPermission());
        Method m = ClientProtocol.class.getMethod("setPermission", String.class, FsPermission.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, permission});
    }

    @Test
    public void testProxySetReplication() throws Exception {
        FileStatus file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)file.getReplication());
        this.routerProtocol.setReplication(this.routerFile, (short)2);
        file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)file.getReplication());
        Method m = ClientProtocol.class.getMethod("setReplication", String.class, Short.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, (short)2});
    }

    @Test
    public void testProxyTruncateFile() throws Exception {
        FileStatus file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        org.junit.jupiter.api.Assertions.assertTrue((file.getLen() > 0L ? 1 : 0) != 0);
        this.routerProtocol.truncate(this.routerFile, 0L, "testclient");
        file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)file.getLen());
        Method m = ClientProtocol.class.getMethod("truncate", String.class, Long.TYPE, String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, 0L, "testclient"});
    }

    @Test
    public void testAllowDisallowSnapshots() throws Exception {
        String dirPath = "/testdir";
        String filePath1 = "/sample";
        FsPermission permission = new FsPermission("705");
        this.routerProtocol.mkdirs(dirPath, permission, false);
        FederationTestUtils.createFile(this.routerFS, filePath1, 32L);
        MiniRouterDFSCluster.NamenodeContext nnContext = cluster.getNamenodes().get(0);
        NameNode nn = nnContext.getNamenode();
        FSNamesystem fsn = NameNodeAdapter.getNamesystem((NameNode)nn);
        FSDirectory fsdir = fsn.getFSDirectory();
        INodeDirectory dirNode = fsdir.getINode4Write(dirPath).asDirectory();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)dirNode.isSnapshottable());
        this.routerProtocol.allowSnapshot("/testdir");
        dirNode = fsdir.getINode4Write(dirPath).asDirectory();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dirNode.isSnapshottable());
        this.routerProtocol.disallowSnapshot("/testdir");
        dirNode = fsdir.getINode4Write(dirPath).asDirectory();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)dirNode.isSnapshottable());
        this.routerProtocol.delete(dirPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManageSnapshot() throws Exception {
        String mountPoint = "/mntsnapshot";
        String snapshotFolder = "/mntsnapshot/folder";
        LOG.info("Setup a mount point for snapshots: {}", (Object)"/mntsnapshot");
        Router r = this.router.getRouter();
        MockResolver resolver = (MockResolver)r.getSubclusterResolver();
        String ns0 = cluster.getNameservices().get(0);
        resolver.addLocation("/mntsnapshot", ns0, "/");
        FsPermission permission = new FsPermission("777");
        this.routerProtocol.mkdirs("/mntsnapshot/folder", permission, false);
        try {
            for (int i = 1; i <= 9; ++i) {
                String folderPath = "/mntsnapshot/folder/subfolder" + i;
                this.routerProtocol.mkdirs(folderPath, permission, false);
            }
            LOG.info("Create the snapshot: {}", (Object)"/mntsnapshot/folder");
            this.routerProtocol.allowSnapshot("/mntsnapshot/folder");
            String snapshotName = this.routerProtocol.createSnapshot("/mntsnapshot/folder", "snap");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"/mntsnapshot/folder/.snapshot/snap", (Object)snapshotName);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, "/mntsnapshot/folder/.snapshot/snap"));
            LOG.info("Rename the snapshot and check it changed");
            this.routerProtocol.renameSnapshot("/mntsnapshot/folder", "snap", "newsnap");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)FederationTestUtils.verifyFileExists(this.routerFS, "/mntsnapshot/folder/.snapshot/snap"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, "/mntsnapshot/folder/.snapshot/newsnap"));
            LambdaTestUtils.intercept(SnapshotException.class, (String)"Cannot delete snapshot snap from path /mntsnapshot/folder:", () -> this.routerFS.deleteSnapshot(new Path("/mntsnapshot/folder"), "snap"));
            LOG.info("Delete the snapshot and check it is not there");
            this.routerProtocol.deleteSnapshot("/mntsnapshot/folder", "newsnap");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)FederationTestUtils.verifyFileExists(this.routerFS, "/mntsnapshot/folder/.snapshot/newsnap"));
        }
        finally {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.routerProtocol.delete("/mntsnapshot/folder", true));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)resolver.removeLocation("/mntsnapshot", ns0, "/"));
        }
    }

    @Test
    public void testGetSnapshotListing() throws IOException {
        String snapshotPath = "/testGetSnapshotListing";
        String childDir = "/testGetSnapshotListing/subdir";
        FsPermission permission = new FsPermission("705");
        this.routerProtocol.mkdirs("/testGetSnapshotListing", permission, false);
        this.routerProtocol.allowSnapshot("/testGetSnapshotListing");
        String snapshot1 = "snap1";
        String snapshot2 = "snap2";
        this.routerProtocol.createSnapshot("/testGetSnapshotListing", "snap1");
        this.routerProtocol.mkdirs("/testGetSnapshotListing/subdir", permission, false);
        this.routerProtocol.createSnapshot("/testGetSnapshotListing", "snap2");
        SnapshottableDirectoryStatus[] dirList = this.routerProtocol.getSnapshottableDirListing();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)dirList.length);
        SnapshottableDirectoryStatus snapshotDir0 = dirList[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/testGetSnapshotListing", (Object)snapshotDir0.getFullPath().toString());
        SnapshotStatus[] snapshots = this.routerProtocol.getSnapshotListing("/testGetSnapshotListing");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)snapshots.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)SnapshotTestHelper.getSnapshotRoot((Path)new Path("/testGetSnapshotListing"), (String)"snap1"), (Object)snapshots[0].getFullPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)SnapshotTestHelper.getSnapshotRoot((Path)new Path("/testGetSnapshotListing"), (String)"snap2"), (Object)snapshots[1].getFullPath());
        SnapshotDiffReport diffReport = this.routerProtocol.getSnapshotDiffReport("/testGetSnapshotListing", "snap1", "snap2");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)diffReport.getDiffList().size());
        byte[] startPath = new byte[]{};
        SnapshotDiffReportListing diffReportListing = this.routerProtocol.getSnapshotDiffReportListing("/testGetSnapshotListing", "snap1", "snap2", startPath, -1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)diffReportListing.getModifyList().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)diffReportListing.getCreateList().size());
        this.routerProtocol.deleteSnapshot("/testGetSnapshotListing", "snap1");
        this.routerProtocol.deleteSnapshot("/testGetSnapshotListing", "snap2");
        this.routerProtocol.disallowSnapshot("/testGetSnapshotListing");
    }

    @Test
    public void testProxyGetBlockLocations() throws Exception {
        LocatedBlocks locations = this.routerProtocol.getBlockLocations(this.routerFile, 0L, 1024L);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)locations.getLocatedBlocks().size());
        Method m = ClientProtocol.class.getMethod("getBlockLocations", String.class, Long.TYPE, Long.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, 0L, 0L});
    }

    @Test
    public void testProxyStoragePolicy() throws Exception {
        HdfsFileStatus status = this.namenode.getClient().getFileInfo(this.nnFile);
        BlockStoragePolicy[] policies = this.namenode.getClient().getStoragePolicies();
        BlockStoragePolicy policy = policies[0];
        while (policy.isCopyOnCreateFile()) {
            Random rand = new Random();
            int randIndex = rand.nextInt(policies.length);
            policy = policies[randIndex];
        }
        this.routerProtocol.setStoragePolicy(this.routerFile, policy.getName());
        HdfsFileStatus newStatus = this.namenode.getClient().getFileInfo(this.nnFile);
        org.junit.jupiter.api.Assertions.assertTrue((newStatus.getStoragePolicy() == policy.getId() ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((newStatus.getStoragePolicy() != status.getStoragePolicy() ? 1 : 0) != 0);
        Method m = ClientProtocol.class.getMethod("setStoragePolicy", String.class, String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, "badpolicy"});
    }

    @Test
    public void testProxyGetAndUnsetStoragePolicy() throws Exception {
        String file = "/testGetStoragePolicy";
        String nnFilePath = cluster.getNamenodeTestDirectoryForNS(this.ns) + file;
        String routerFilePath = cluster.getFederatedTestDirectoryForNS(this.ns) + file;
        FederationTestUtils.createFile(this.routerFS, routerFilePath, 32L);
        BlockStoragePolicy policy = this.routerProtocol.getStoragePolicy(routerFilePath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"HOT", (Object)policy.getName());
        org.junit.jupiter.api.Assertions.assertEquals((byte)7, (byte)policy.getId());
        Object[] policies = this.routerProtocol.getStoragePolicies();
        Object[] nnPolicies = this.namenode.getClient().getStoragePolicies();
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])nnPolicies, (Object[])policies);
        Object newPolicy = policies[0];
        while (newPolicy.isCopyOnCreateFile()) {
            Random rand = new Random();
            int randIndex = rand.nextInt(policies.length);
            newPolicy = policies[randIndex];
        }
        this.routerProtocol.setStoragePolicy(routerFilePath, newPolicy.getName());
        policy = this.routerProtocol.getStoragePolicy(routerFilePath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)newPolicy.getName(), (Object)policy.getName());
        org.junit.jupiter.api.Assertions.assertEquals((byte)newPolicy.getId(), (byte)policy.getId());
        BlockStoragePolicy nnPolicy = this.namenode.getClient().getStoragePolicy(nnFilePath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)nnPolicy.getName(), (Object)policy.getName());
        org.junit.jupiter.api.Assertions.assertEquals((byte)nnPolicy.getId(), (byte)policy.getId());
        this.routerProtocol.unsetStoragePolicy(routerFilePath);
        policy = this.routerProtocol.getStoragePolicy(routerFilePath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"HOT", (Object)policy.getName());
        org.junit.jupiter.api.Assertions.assertEquals((byte)7, (byte)policy.getId());
        nnPolicy = this.namenode.getClient().getStoragePolicy(nnFilePath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)nnPolicy.getName(), (Object)policy.getName());
        org.junit.jupiter.api.Assertions.assertEquals((byte)nnPolicy.getId(), (byte)policy.getId());
    }

    @Test
    public void testListStoragePolicies() throws IOException, URISyntaxException {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            Object[] policies = this.namenode.getClient().getStoragePolicies();
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])policies, (Object[])this.routerProtocol.getStoragePolicies());
            resolver.setDisableNamespace(true);
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])policies, (Object[])this.routerProtocol.getStoragePolicies());
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    @Test
    public void testGetServerDefaults() throws IOException, URISyntaxException {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            FsServerDefaults defaults = this.namenode.getClient().getServerDefaults();
            org.junit.jupiter.api.Assertions.assertEquals((long)defaults.getBlockSize(), (long)this.routerProtocol.getServerDefaults().getBlockSize());
            resolver.setDisableNamespace(true);
            org.junit.jupiter.api.Assertions.assertEquals((long)defaults.getBlockSize(), (long)this.routerProtocol.getServerDefaults().getBlockSize());
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    @Test
    public void testProxyGetPreferedBlockSize() throws Exception {
        long namenodeSize = this.nnProtocol.getPreferredBlockSize(this.nnFile);
        long routerSize = this.routerProtocol.getPreferredBlockSize(this.routerFile);
        org.junit.jupiter.api.Assertions.assertEquals((long)routerSize, (long)namenodeSize);
        Method m = ClientProtocol.class.getMethod("getPreferredBlockSize", String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath});
    }

    private void testConcat(String source, String target, boolean failureExpected, boolean verfiyException, String msg) {
        boolean failure;
        block2: {
            failure = false;
            try {
                this.routerProtocol.concat(target, new String[]{source});
            }
            catch (IOException ex) {
                failure = true;
                if (!verfiyException) break block2;
                GenericTestUtils.assertExceptionContains((String)msg, (Throwable)ex);
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)failureExpected, (Object)failure);
    }

    private void testConcat(String source, String target, boolean failureExpected) {
        boolean failure = false;
        try {
            this.routerProtocol.concat(target, new String[]{source});
        }
        catch (IOException ex) {
            failure = true;
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)failureExpected, (Object)failure);
    }

    @Test
    public void testProxyConcatFile() throws Exception {
        String sameNameservice = this.ns;
        String existingFile = cluster.getFederatedTestDirectoryForNS(sameNameservice) + "_concatfile";
        int existingFileSize = 32;
        FederationTestUtils.createFile(this.routerFS, existingFile, existingFileSize);
        String alternateNameservice = null;
        for (String n : cluster.getNameservices()) {
            if (n.equals(sameNameservice)) continue;
            alternateNameservice = n;
            break;
        }
        String altRouterFile = cluster.getFederatedTestDirectoryForNS(alternateNameservice) + "_newfile";
        String sameRouterFile = cluster.getFederatedTestDirectoryForNS(sameNameservice) + "_newfile";
        FederationTestUtils.createFile(this.routerFS, altRouterFile, 0x8000000L);
        FederationTestUtils.createFile(this.routerFS, sameRouterFile, 0x8000000L);
        this.testConcat(existingFile, altRouterFile, true);
        this.testConcat(existingFile, sameRouterFile, false);
        FileStatus status = FederationTestUtils.getFileStatus(this.routerFS, sameRouterFile);
        org.junit.jupiter.api.Assertions.assertEquals((long)((long)existingFileSize + 0x8000000L), (long)status.getLen());
        Method m = ClientProtocol.class.getMethod("concat", String.class, String[].class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, new String[]{this.routerFile}});
        FederationTestUtils.createFile(this.routerFS, existingFile, existingFileSize);
        String sameRouterEmptyFile = cluster.getFederatedTestDirectoryForNS(sameNameservice) + "_newemptyfile";
        FederationTestUtils.createFile(this.routerFS, sameRouterEmptyFile, 0L);
        this.testConcat(existingFile, sameRouterEmptyFile, false);
        FileStatus mergedStatus = FederationTestUtils.getFileStatus(this.routerFS, sameRouterEmptyFile);
        org.junit.jupiter.api.Assertions.assertEquals((long)existingFileSize, (long)mergedStatus.getLen());
        String srcEmptyFile = cluster.getFederatedTestDirectoryForNS(sameNameservice) + "_srcEmptyFile";
        FederationTestUtils.createFile(this.routerFS, srcEmptyFile, 0L);
        String targetFile = cluster.getFederatedTestDirectoryForNS(sameNameservice) + "_targetFile";
        FederationTestUtils.createFile(this.routerFS, targetFile, existingFileSize);
        this.testConcat(srcEmptyFile, targetFile, true, true, "org.apache.hadoop.ipc.RemoteException(org.apache.hadoop.HadoopIllegalArgumentException): concat: source file " + srcEmptyFile + " is invalid or empty or underConstruction");
    }

    @Test
    public void testProxyAppend() throws Exception {
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.APPEND);
        DFSClient routerClient = this.getRouterContext().getClient();
        HdfsDataOutputStream stream = routerClient.append(this.routerFile, 1024, createFlag, null, null);
        stream.writeBytes("teststring");
        stream.close();
        FileStatus status = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        org.junit.jupiter.api.Assertions.assertTrue((status.getLen() > (long)"teststring".length() ? 1 : 0) != 0);
        Method m = ClientProtocol.class.getMethod("append", String.class, String.class, EnumSetWritable.class);
        String badPath = "/unknownlocation/unknowndir";
        EnumSetWritable createFlagWritable = new EnumSetWritable(createFlag);
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, "testClient", createFlagWritable});
    }

    @Test
    public void testProxyGetAdditionalDatanode() throws IOException, InterruptedException, URISyntaxException {
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE);
        String clientName = this.getRouterContext().getClient().getClientName();
        String newRouterFile = this.routerFile + "_additionalDatanode";
        HdfsFileStatus status = this.routerProtocol.create(newRouterFile, new FsPermission("777"), clientName, new EnumSetWritable(createFlag), true, (short)1, 1024L, CryptoProtocolVersion.supported(), null, null);
        LocatedBlock block = this.routerProtocol.addBlock(newRouterFile, clientName, null, null, status.getFileId(), null, null);
        DatanodeInfo[] exclusions = DatanodeInfo.EMPTY_ARRAY;
        LocatedBlock newBlock = this.routerProtocol.getAdditionalDatanode(newRouterFile, status.getFileId(), block.getBlock(), (DatanodeInfo[])block.getLocations(), block.getStorageIDs(), exclusions, 1, clientName);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)newBlock);
    }

    @Test
    public void testProxyCreateFileAlternateUser() throws IOException, URISyntaxException, InterruptedException {
        String routerDir = cluster.getFederatedTestDirectoryForNS(this.ns);
        String namenodeDir = cluster.getNamenodeTestDirectoryForNS(this.ns);
        String newRouterFile = routerDir + "/unknownuser";
        String newNamenodeFile = namenodeDir + "/unknownuser";
        String username = "unknownuser";
        this.namenode.getFileContext().setPermission(new Path(namenodeDir), new FsPermission("777"));
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)username);
        DFSClient client = this.getRouterContext().getClient(ugi);
        client.create(newRouterFile, true);
        FileStatus status = FederationTestUtils.getFileStatus(this.nnFS, newNamenodeFile);
        org.junit.jupiter.api.Assertions.assertEquals((Object)status.getOwner(), (Object)username);
    }

    @Test
    public void testProxyGetFileInfoAcessException() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"unknownuser");
        Exception nnFailure = null;
        try {
            String testFile = cluster.getNamenodeTestFileForNS(this.ns);
            this.namenode.getClient(ugi).getLocatedBlocks(testFile, 0L);
        }
        catch (Exception e) {
            nnFailure = e;
        }
        org.junit.jupiter.api.Assertions.assertNotNull((Object)nnFailure);
        Exception routerFailure = null;
        try {
            String testFile = cluster.getFederatedTestFileForNS(this.ns);
            this.getRouterContext().getClient(ugi).getLocatedBlocks(testFile, 0L);
        }
        catch (Exception e) {
            routerFailure = e;
        }
        org.junit.jupiter.api.Assertions.assertNotNull((Object)routerFailure);
        org.junit.jupiter.api.Assertions.assertEquals(routerFailure.getClass(), nnFailure.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyVersionRequest() throws Exception {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            NamespaceInfo rVersion = this.routerNamenodeProtocol.versionRequest();
            NamespaceInfo nnVersion = this.nnNamenodeProtocol.versionRequest();
            NamespaceInfo nnVersion1 = this.nnNamenodeProtocol1.versionRequest();
            this.compareVersion(rVersion, nnVersion);
            resolver.setDisableNamespace(true);
            boolean isNN0 = rVersion.getBlockPoolID().equals(nnVersion.getBlockPoolID());
            this.compareVersion(rVersion, isNN0 ? nnVersion : nnVersion1);
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    private void compareVersion(NamespaceInfo rVersion, NamespaceInfo nnVersion) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)nnVersion.getBlockPoolID(), (Object)rVersion.getBlockPoolID());
        org.junit.jupiter.api.Assertions.assertEquals((int)nnVersion.getNamespaceID(), (int)rVersion.getNamespaceID());
        org.junit.jupiter.api.Assertions.assertEquals((Object)nnVersion.getClusterID(), (Object)rVersion.getClusterID());
        org.junit.jupiter.api.Assertions.assertEquals((int)nnVersion.getLayoutVersion(), (int)rVersion.getLayoutVersion());
        org.junit.jupiter.api.Assertions.assertEquals((long)nnVersion.getCTime(), (long)rVersion.getCTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyGetBlockKeys() throws Exception {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            ExportedBlockKeys rKeys = this.routerNamenodeProtocol.getBlockKeys();
            ExportedBlockKeys nnKeys = this.nnNamenodeProtocol.getBlockKeys();
            this.compareBlockKeys(rKeys, nnKeys);
            resolver.setDisableNamespace(true);
            rKeys = this.routerNamenodeProtocol.getBlockKeys();
            this.compareBlockKeys(rKeys, nnKeys);
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    private void compareBlockKeys(ExportedBlockKeys rKeys, ExportedBlockKeys nnKeys) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)nnKeys.getCurrentKey(), (Object)rKeys.getCurrentKey());
        org.junit.jupiter.api.Assertions.assertEquals((long)nnKeys.getKeyUpdateInterval(), (long)rKeys.getKeyUpdateInterval());
        org.junit.jupiter.api.Assertions.assertEquals((long)nnKeys.getTokenLifetime(), (long)rKeys.getTokenLifetime());
    }

    @Test
    public void testProxyGetBlocks() throws Exception {
        DatanodeInfo[] dns = this.routerProtocol.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
        DatanodeInfo dn0 = dns[0];
        BlocksWithLocations routerBlockLocations = this.routerNamenodeProtocol.getBlocks(dn0, 1024L, 0L, 0L, null);
        BlocksWithLocations nnBlockLocations = this.nnNamenodeProtocol.getBlocks(dn0, 1024L, 0L, 0L, null);
        BlocksWithLocations.BlockWithLocations[] routerBlocks = routerBlockLocations.getBlocks();
        BlocksWithLocations.BlockWithLocations[] nnBlocks = nnBlockLocations.getBlocks();
        org.junit.jupiter.api.Assertions.assertEquals((int)nnBlocks.length, (int)routerBlocks.length);
        for (int i = 0; i < routerBlocks.length; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((long)nnBlocks[i].getBlock().getBlockId(), (long)routerBlocks[i].getBlock().getBlockId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyGetTransactionID() throws IOException {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            long routerTransactionID = this.routerNamenodeProtocol.getTransactionID();
            long nnTransactionID = this.nnNamenodeProtocol.getTransactionID();
            long nnTransactionID1 = this.nnNamenodeProtocol1.getTransactionID();
            org.junit.jupiter.api.Assertions.assertEquals((long)nnTransactionID, (long)routerTransactionID);
            resolver.setDisableNamespace(true);
            routerTransactionID = this.routerNamenodeProtocol.getTransactionID();
            Assertions.assertThat((long)routerTransactionID).isIn(new Object[]{nnTransactionID, nnTransactionID1});
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyGetMostRecentCheckpointTxId() throws IOException {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            long routerCheckPointId = this.routerNamenodeProtocol.getMostRecentCheckpointTxId();
            long nnCheckPointId = this.nnNamenodeProtocol.getMostRecentCheckpointTxId();
            org.junit.jupiter.api.Assertions.assertEquals((long)nnCheckPointId, (long)routerCheckPointId);
            resolver.setDisableNamespace(true);
            long l = this.routerNamenodeProtocol.getMostRecentCheckpointTxId();
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    @Test
    public void testProxySetSafemode() throws Exception {
        boolean routerSafemode = this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false);
        boolean nnSafemode = this.nnProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)nnSafemode, (Object)routerSafemode);
        routerSafemode = this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true);
        nnSafemode = this.nnProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)nnSafemode, (Object)routerSafemode);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false));
    }

    @Test
    public void testProxyRestoreFailedStorage() throws Exception {
        boolean routerSuccess = this.routerProtocol.restoreFailedStorage("check");
        boolean nnSuccess = this.nnProtocol.restoreFailedStorage("check");
        org.junit.jupiter.api.Assertions.assertEquals((Object)nnSuccess, (Object)routerSuccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRenewLeaseInternal(DistributedFileSystem dfs, FederationRPCMetrics rpcMetrics, Path testPath, boolean createFlag) throws Exception {
        try (FSDataOutputStream outputStream = null;){
            outputStream = createFlag ? dfs.create(testPath) : dfs.append(testPath);
            outputStream.write("hello world. \n".getBytes());
            long proxyOpBeforeRenewLease = rpcMetrics.getProxyOps();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)dfs.getClient().renewLease());
            long proxyOpAfterRenewLease = rpcMetrics.getProxyOps();
            org.junit.jupiter.api.Assertions.assertEquals((long)(proxyOpBeforeRenewLease + 1L), (long)proxyOpAfterRenewLease);
        }
    }

    @Test
    public void testRenewLeaseForECFile() throws Exception {
        String ecName = "RS-6-3-1024k";
        FederationRPCMetrics metrics = this.router.getRouterRpcServer().getRPCMetrics();
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        String ns0 = cluster.getNameservices().get(0);
        resolver.addLocation("/testRenewLease0", ns0, "/testRenewLease0");
        DistributedFileSystem routerDFS = (DistributedFileSystem)this.routerFS;
        routerDFS.getClient().getLeaseRenewer().interruptAndJoin();
        Path testECPath = new Path("/testRenewLease0/ecDirectory/test_ec.txt");
        routerDFS.mkdirs(testECPath.getParent());
        routerDFS.setErasureCodingPolicy(testECPath.getParent(), ecName);
        this.testRenewLeaseInternal(routerDFS, metrics, testECPath, true);
        ErasureCodingPolicy ecPolicy = routerDFS.getErasureCodingPolicy(testECPath);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)ecPolicy);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ecName, (Object)ecPolicy.getName());
    }

    @Test
    public void testRenewLeaseForReplicaFile() throws Exception {
        FederationRPCMetrics metrics = this.router.getRouterRpcServer().getRPCMetrics();
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        String ns0 = cluster.getNameservices().get(0);
        resolver.addLocation("/testRenewLease0", ns0, "/testRenewLease0");
        DistributedFileSystem routerDFS = (DistributedFileSystem)this.routerFS;
        routerDFS.getClient().getLeaseRenewer().interruptAndJoin();
        Path testPath = new Path("/testRenewLease0/test_replica.txt");
        this.testRenewLeaseInternal(routerDFS, metrics, testPath, true);
        this.testRenewLeaseInternal(routerDFS, metrics, testPath, false);
    }

    @Test
    public void testRenewLeaseWithMultiStream() throws Exception {
        FederationRPCMetrics metrics = this.router.getRouterRpcServer().getRPCMetrics();
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        String ns0 = cluster.getNameservices().get(0);
        String ns1 = cluster.getNameservices().get(1);
        resolver.addLocation("/testRenewLease0", ns0, "/testRenewLease0");
        resolver.addLocation("/testRenewLease1", ns1, "/testRenewLease1");
        DistributedFileSystem routerDFS = (DistributedFileSystem)this.routerFS;
        routerDFS.getClient().getLeaseRenewer().interruptAndJoin();
        Path newTestPath0 = new Path("/testRenewLease0/test1.txt");
        Path newTestPath1 = new Path("/testRenewLease1/test1.txt");
        try (FSDataOutputStream outStream1 = routerDFS.create(newTestPath0);
             FSDataOutputStream outStream2 = routerDFS.create(newTestPath1);){
            outStream1.write("hello world \n".getBytes());
            outStream2.write("hello world \n".getBytes());
            long proxyOpBeforeRenewLease2 = metrics.getProxyOps();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)routerDFS.getClient().renewLease());
            long proxyOpAfterRenewLease2 = metrics.getProxyOps();
            org.junit.jupiter.api.Assertions.assertEquals((long)(proxyOpBeforeRenewLease2 + 2L), (long)proxyOpAfterRenewLease2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMkdirWithDisableNameService() throws Exception {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        String ns0 = cluster.getNameservices().get(0);
        resolver.addLocation("/mnt", ns0, "/");
        MockResolver activeNamenodeResolver = (MockResolver)this.router.getRouter().getNamenodeResolver();
        activeNamenodeResolver.disableNamespace(ns0);
        try {
            FsPermission permission = new FsPermission("777");
            RouterRpcServer rpcServer = this.router.getRouter().getRpcServer();
            LambdaTestUtils.intercept(NoLocationException.class, () -> rpcServer.mkdirs("/mnt/folder0/folder1", permission, true));
        }
        finally {
            activeNamenodeResolver.clearDisableNamespaces();
        }
    }

    @Test
    public void testProxyExceptionMessages() throws IOException {
        FsPermission permission;
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        String ns0 = cluster.getNameservices().get(0);
        resolver.addLocation("/mnt", ns0, "/");
        try {
            permission = new FsPermission("777");
            this.routerProtocol.mkdirs("/mnt/folder0/folder1", permission, false);
            org.junit.jupiter.api.Assertions.fail((String)"mkdirs for non-existing parent folder should have failed");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"/mnt/folder0", (Throwable)ioe, (String)"Wrong path in exception for mkdirs");
        }
        try {
            permission = new FsPermission("777");
            this.routerProtocol.setPermission("/mnt/testfile.txt", permission);
            org.junit.jupiter.api.Assertions.fail((String)"setPermission for non-existing file should have failed");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"/mnt/testfile.txt", (Throwable)ioe, (String)"Wrong path in exception for setPermission");
        }
        try {
            permission = new FsPermission("777");
            this.routerProtocol.mkdirs("/mnt/folder0/folder1", permission, false);
            this.routerProtocol.delete("/mnt/folder0", false);
            org.junit.jupiter.api.Assertions.fail((String)"delete for non-existing file should have failed");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"/mnt/folder0", (Throwable)ioe, (String)"Wrong path in exception for delete");
        }
        resolver.cleanRegistrations();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Parent directory doesn't exist: /ns1/a/a/b", (Object)RouterRpcClient.processExceptionMsg((String)"Parent directory doesn't exist: /a/a/b", (String)"/a", (String)"/ns1/a"));
    }

    @Test
    public void testGetReplicatedBlockStats() throws Exception {
        String testFile = "/test-file";
        for (String nsid : cluster.getNameservices()) {
            MiniRouterDFSCluster.NamenodeContext context = cluster.getNamenode(nsid, null);
            NameNode nameNode = context.getNamenode();
            FSNamesystem namesystem = nameNode.getNamesystem();
            BlockManager bm = namesystem.getBlockManager();
            FileSystem fileSystem = context.getFileSystem();
            FederationTestUtils.createFile(fileSystem, testFile, 1024L);
            LocatedBlock block = NameNodeAdapter.getBlockLocations((NameNode)nameNode, (String)testFile, (long)0L, (long)1024L).get(0);
            namesystem.writeLock(RwLockMode.BM);
            bm.findAndMarkBlockAsCorrupt(block.getBlock(), (DatanodeInfo)block.getLocations()[0], "STORAGE_ID", "TEST");
            namesystem.writeUnlock(RwLockMode.BM, "findAndMarkBlockAsCorrupt");
            BlockManagerTestUtil.updateState((BlockManager)bm);
            DFSTestUtil.waitCorruptReplicas((FileSystem)fileSystem, (FSNamesystem)namesystem, (Path)new Path(testFile), (ExtendedBlock)block.getBlock(), (int)1);
            ReplicatedBlockStats stats = context.getClient().getNamenode().getReplicatedBlockStats();
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)stats.getCorruptBlocks());
        }
        ReplicatedBlockStats routerStat = this.routerProtocol.getReplicatedBlockStats();
        org.junit.jupiter.api.Assertions.assertEquals((long)cluster.getNameservices().size(), (long)routerStat.getCorruptBlocks(), (String)"There should be 1 corrupt blocks for each NN");
    }

    @Test
    public void testErasureCoding() throws Exception {
        ErasureCodingPolicyInfo[] policies;
        LOG.info("List the available erasurce coding policies");
        for (ErasureCodingPolicyInfo policy : policies = this.checkErasureCodingPolicies()) {
            LOG.info("  {}", (Object)policy);
        }
        LOG.info("List the erasure coding codecs");
        Map codecsRouter = this.routerProtocol.getErasureCodingCodecs();
        Map codecsNamenode = this.nnProtocol.getErasureCodingCodecs();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Maps.difference((Map)codecsRouter, (Map)codecsNamenode).areEqual());
        for (Map.Entry entry : codecsRouter.entrySet()) {
            LOG.info("  {}: {}", entry.getKey(), entry.getValue());
        }
        LOG.info("Create a testing directory via the router at the root level");
        String dirPath = "/testec";
        String filePath1 = dirPath + "/testfile1";
        FsPermission permission = new FsPermission("755");
        this.routerProtocol.mkdirs(dirPath, permission, false);
        FederationTestUtils.createFile(this.routerFS, filePath1, 32L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, filePath1));
        DFSClient file1Protocol = this.getFileDFSClient(filePath1);
        LOG.info("The policy for the new file should not be set");
        org.junit.jupiter.api.Assertions.assertNull((Object)this.routerProtocol.getErasureCodingPolicy(filePath1));
        org.junit.jupiter.api.Assertions.assertNull((Object)file1Protocol.getErasureCodingPolicy(filePath1));
        String policyName = "RS-6-3-1024k";
        LOG.info("Set policy \"{}\" for \"{}\"", (Object)policyName, (Object)dirPath);
        this.routerProtocol.setErasureCodingPolicy(dirPath, policyName);
        String filePath2 = dirPath + "/testfile2";
        LOG.info("Create {} in the path with the new EC policy", (Object)filePath2);
        FederationTestUtils.createFile(this.routerFS, filePath2, 32L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, filePath2));
        DFSClient file2Protocol = this.getFileDFSClient(filePath2);
        LOG.info("Check that the policy is set for {}", (Object)filePath2);
        ErasureCodingPolicy policyRouter1 = this.routerProtocol.getErasureCodingPolicy(filePath2);
        ErasureCodingPolicy policyNamenode1 = file2Protocol.getErasureCodingPolicy(filePath2);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)policyRouter1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)policyName, (Object)policyRouter1.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)policyName, (Object)policyNamenode1.getName());
        LOG.info("Create a new erasure coding policy");
        String newPolicyName = "RS-6-3-128k";
        ECSchema ecSchema = new ECSchema("rs", 6, 3);
        ErasureCodingPolicy ecPolicy = new ErasureCodingPolicy(newPolicyName, ecSchema, 131072, -1);
        ErasureCodingPolicy[] newPolicies = new ErasureCodingPolicy[]{ecPolicy};
        AddErasureCodingPolicyResponse[] responses = this.routerProtocol.addErasureCodingPolicies(newPolicies);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)responses.length);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responses[0].isSucceed());
        this.routerProtocol.disableErasureCodingPolicy(newPolicyName);
        LOG.info("The new policy should be there and disabled");
        policies = this.checkErasureCodingPolicies();
        boolean found = false;
        for (ErasureCodingPolicyInfo policy : policies) {
            LOG.info("  {}" + policy);
            if (!policy.getPolicy().getName().equals(newPolicyName)) continue;
            found = true;
            org.junit.jupiter.api.Assertions.assertEquals((Object)ErasureCodingPolicyState.DISABLED, (Object)policy.getState());
            break;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)found);
        LOG.info("Set the test folder to use the new policy");
        this.routerProtocol.enableErasureCodingPolicy(newPolicyName);
        this.routerProtocol.setErasureCodingPolicy(dirPath, newPolicyName);
        LOG.info("Create a file in the path with the new EC policy");
        String filePath3 = dirPath + "/testfile3";
        FederationTestUtils.createFile(this.routerFS, filePath3, 32L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, filePath3));
        DFSClient file3Protocol = this.getFileDFSClient(filePath3);
        ErasureCodingPolicy policyRouterFile3 = this.routerProtocol.getErasureCodingPolicy(filePath3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)newPolicyName, (Object)policyRouterFile3.getName());
        ErasureCodingPolicy policyNamenodeFile3 = file3Protocol.getErasureCodingPolicy(filePath3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)newPolicyName, (Object)policyNamenodeFile3.getName());
        LOG.info("Remove the policy and check the one for the test folder");
        this.routerProtocol.removeErasureCodingPolicy(newPolicyName);
        ErasureCodingPolicy policyRouter3 = this.routerProtocol.getErasureCodingPolicy(filePath3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)newPolicyName, (Object)policyRouter3.getName());
        ErasureCodingPolicy policyNamenode3 = file3Protocol.getErasureCodingPolicy(filePath3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)newPolicyName, (Object)policyNamenode3.getName());
        LOG.info("Check the stats");
        ECBlockGroupStats statsRouter = this.routerProtocol.getECBlockGroupStats();
        ECBlockGroupStats statsNamenode = this.getNamenodeECBlockGroupStats();
        org.junit.jupiter.api.Assertions.assertEquals((Object)statsNamenode, (Object)statsRouter);
    }

    private ECBlockGroupStats getNamenodeECBlockGroupStats() throws Exception {
        ArrayList<ECBlockGroupStats> nnStats = new ArrayList<ECBlockGroupStats>();
        for (MiniRouterDFSCluster.NamenodeContext nnContext : cluster.getNamenodes()) {
            ClientProtocol cp = nnContext.getClient().getNamenode();
            nnStats.add(cp.getECBlockGroupStats());
        }
        return ECBlockGroupStats.merge(nnStats);
    }

    @Test
    public void testGetCurrentTXIDandRollEdits() throws IOException {
        Long rollEdits = this.routerProtocol.rollEdits();
        Long currentTXID = this.routerProtocol.getCurrentEditLogTxid();
        org.junit.jupiter.api.Assertions.assertEquals((Long)rollEdits, (Long)currentTXID);
    }

    @Test
    public void testSaveNamespace() throws IOException {
        cluster.getCluster().getFileSystem(0).setSafeMode(SafeModeAction.ENTER);
        cluster.getCluster().getFileSystem(1).setSafeMode(SafeModeAction.ENTER);
        Boolean saveNamespace = this.routerProtocol.saveNamespace(0L, 0L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)saveNamespace);
        cluster.getCluster().getFileSystem(0).setSafeMode(SafeModeAction.LEAVE);
        cluster.getCluster().getFileSystem(1).setSafeMode(SafeModeAction.LEAVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamenodeMetrics() throws Exception {
        final NamenodeBeanMetrics metrics = this.router.getRouter().getNamenodeMetrics();
        final String jsonString0 = metrics.getLiveNodes();
        JSONObject jsonObject = new JSONObject(jsonString0);
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)jsonObject.names().length());
        JSONObject jsonObjectNn = new JSONObject(cluster.getRandomNamenode().getNamenode().getNamesystem().getLiveNodes());
        String randomDn = (String)jsonObjectNn.names().get(0);
        JSONObject randomReportNn = jsonObjectNn.getJSONObject(randomDn);
        JSONObject randomReportRouter = jsonObject.getJSONObject(randomDn);
        JSONArray keys = randomReportNn.names();
        for (int i = 0; i < keys.length(); ++i) {
            String key = keys.getString(i);
            if (key.equals("blockScheduled") || key.equals("volfails")) continue;
            org.junit.jupiter.api.Assertions.assertEquals((Object)randomReportRouter.get(key), (Object)randomReportNn.get(key));
        }
        String jsonString1 = metrics.getLiveNodes();
        org.junit.jupiter.api.Assertions.assertEquals((Object)jsonString0, (Object)jsonString1);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return !jsonString0.equals(metrics.getLiveNodes());
            }
        }, (long)500L, (long)5000L);
        final String jsonString2 = metrics.getLiveNodes();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)jsonString0, (Object)jsonString2);
        MockResolver resolver = (MockResolver)this.router.getRouter().getNamenodeResolver();
        resolver.cleanRegistrations();
        resolver.setDisableRegistration(true);
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return !jsonString2.equals(metrics.getLiveNodes());
                }
            }, (long)500L, (long)5000L);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"{}", (Object)metrics.getLiveNodes());
        }
        finally {
            resolver.setDisableRegistration(false);
            cluster.registerNamenodes();
            cluster.waitNamenodeRegistration();
        }
    }

    @Test
    public void testRBFMetricsMethodsRelayOnStateStore() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.router.getRouter().getStateStore());
        RBFMetrics metrics = this.router.getRouter().getMetrics();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{}", (Object)metrics.getNamenodes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"[]", (Object)metrics.getMountTable());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{}", (Object)metrics.getRouters());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)metrics.getNumNamenodes());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)metrics.getNumExpiredNamenodes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"[]", (Object)metrics.getClusterId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"[]", (Object)metrics.getBlockPoolId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{}", (Object)metrics.getNameservices());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)metrics.getNumLiveNodes());
    }

    @Test
    public void testNamenodeMetricsEnteringMaintenanceNodes() throws IOException {
        NamenodeBeanMetrics metrics = this.router.getRouter().getNamenodeMetrics();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{}", (Object)metrics.getEnteringMaintenanceNodes());
    }

    @Test
    public void testCacheAdmin() throws Exception {
        DistributedFileSystem routerDFS = (DistributedFileSystem)this.routerFS;
        CachePoolInfo cpInfo = new CachePoolInfo("Check");
        cpInfo.setOwnerName("Owner");
        this.routerProtocol.addCachePool(cpInfo);
        RemoteIterator iter = routerDFS.listCachePools();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iter.hasNext());
        CachePoolInfo info = ((CachePoolEntry)iter.next()).getInfo();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Owner", (Object)info.getOwnerName());
        cpInfo.setOwnerName("new Owner");
        this.routerProtocol.modifyCachePool(cpInfo);
        iter = routerDFS.listCachePools();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iter.hasNext());
        info = ((CachePoolEntry)iter.next()).getInfo();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new Owner", (Object)info.getOwnerName());
        this.routerProtocol.removeCachePool("Check");
        iter = routerDFS.listCachePools();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iter.hasNext());
        cpInfo.setOwnerName("Owner");
        this.routerProtocol.addCachePool(cpInfo);
        routerDFS.mkdirs(new Path("/ns1/dir"));
        CacheDirectiveInfo cacheDir = new CacheDirectiveInfo.Builder().setPath(new Path("/ns1/dir")).setReplication(Short.valueOf((short)1)).setPool("Check").build();
        long id = routerDFS.addCacheDirective(cacheDir);
        CacheDirectiveInfo filter = new CacheDirectiveInfo.Builder().setPath(new Path("/ns1/dir")).build();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)routerDFS.listCacheDirectives(filter).hasNext());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Check", (Object)((CacheDirectiveEntry)routerDFS.listCacheDirectives(filter).next()).getInfo().getPool());
        cacheDir = new CacheDirectiveInfo.Builder().setReplication(Short.valueOf((short)2)).setId(Long.valueOf(id)).setPath(new Path("/ns1/dir")).build();
        routerDFS.modifyCacheDirective(cacheDir);
        org.junit.jupiter.api.Assertions.assertEquals((short)2, (short)((CacheDirectiveEntry)routerDFS.listCacheDirectives(filter).next()).getInfo().getReplication());
        routerDFS.removeCacheDirective(id);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)routerDFS.listCacheDirectives(filter).hasNext());
    }

    @Test
    public void testgetGroupsForUser() throws Exception {
        Object[] group = new String[]{"bar", "group2"};
        UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"bar", "group2"});
        Object[] result = this.router.getRouter().getRpcServer().getGroupsForUser("user");
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])group, (Object[])result);
    }

    @Test
    public void testGetCachedDatanodeReport() throws Exception {
        final RouterRpcServer rpcServer = this.router.getRouter().getRpcServer();
        Object[] datanodeReport = rpcServer.getCachedDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)datanodeReport.length);
        Object[] datanodeReport1 = rpcServer.getCachedDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])datanodeReport1, (Object[])datanodeReport);
        MiniDFSCluster miniDFSCluster = this.getCluster().getCluster();
        MiniDFSCluster.DataNodeProperties dnprop = miniDFSCluster.stopDataNode(0);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){
            final /* synthetic */ DatanodeInfo[] val$datanodeReport;
            {
                this.val$datanodeReport = datanodeInfoArray;
            }

            @Override
            public Boolean get() {
                Object[] dn = null;
                try {
                    dn = rpcServer.getCachedDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
                }
                catch (IOException ex) {
                    LOG.error("Error on getCachedDatanodeReport");
                }
                return !Arrays.equals(this.val$datanodeReport, dn);
            }
        }, (long)500L, (long)5000L);
        DatanodeInfo[] datanodeReport2 = rpcServer.getCachedDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        org.junit.jupiter.api.Assertions.assertEquals((int)(datanodeReport.length - 1), (int)datanodeReport2.length);
        miniDFSCluster.restartDataNode(dnprop);
        miniDFSCluster.waitActive();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){
            final /* synthetic */ DatanodeInfo[] val$datanodeReport;
            {
                this.val$datanodeReport = datanodeInfoArray;
            }

            @Override
            public Boolean get() {
                DatanodeInfo[] dn = null;
                try {
                    dn = rpcServer.getCachedDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
                }
                catch (IOException ex) {
                    LOG.error("Error on getCachedDatanodeReport");
                }
                return this.val$datanodeReport.length == dn.length;
            }
        }, (long)100L, (long)10000L);
        DatanodeInfo[] datanodeReport3 = rpcServer.getCachedDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        org.junit.jupiter.api.Assertions.assertEquals((int)datanodeReport.length, (int)datanodeReport3.length);
    }

    private ErasureCodingPolicyInfo[] checkErasureCodingPolicies() throws IOException {
        Object[] policiesRouter = this.routerProtocol.getErasureCodingPolicies();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)policiesRouter);
        Object[] policiesNamenode = this.nnProtocol.getErasureCodingPolicies();
        Arrays.sort(policiesRouter, EC_POLICY_CMP);
        Arrays.sort(policiesNamenode, EC_POLICY_CMP);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])policiesRouter, (Object[])policiesNamenode);
        return policiesRouter;
    }

    private DFSClient getFileDFSClient(String path) {
        for (String nsId : cluster.getNameservices()) {
            LOG.info("Checking {} for {}", (Object)nsId, (Object)path);
            MiniRouterDFSCluster.NamenodeContext nn = cluster.getNamenode(nsId, null);
            try {
                DFSClient nnClientProtocol = nn.getClient();
                if (nnClientProtocol.getFileInfo(path) == null) continue;
                return nnClientProtocol;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Test
    public void testMkdirsWithCallerContext() throws IOException {
        GenericTestUtils.LogCapturer auditlog = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.AUDIT_LOG);
        org.junit.jupiter.api.Assertions.assertNull((Object)CallerContext.getCurrent());
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("clientContext").build());
        String dirPath = "/test_dir_with_callercontext";
        FsPermission permission = new FsPermission("755");
        this.routerProtocol.mkdirs(dirPath, permission, false);
        String logOutput = auditlog.getOutput();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)logOutput.contains("clientIp:"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)logOutput.contains("clientContext"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)logOutput.contains("clientId"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)logOutput.contains("clientCallId"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, dirPath));
    }

    @Test
    public void testRealUserPropagationInCallerContext() throws IOException, InterruptedException {
        GenericTestUtils.LogCapturer auditlog = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.AUDIT_LOG);
        org.junit.jupiter.api.Assertions.assertNull((Object)CallerContext.getCurrent());
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        UserGroupInformation realUser = UserGroupInformation.createUserForTesting((String)"testRealUser", (String[])new String[]{"group"});
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)"testProxyUser", (UserGroupInformation)realUser);
        FileSystem proxyFs = (FileSystem)proxyUser.doAs(() -> this.router.getFileSystem());
        proxyFs.listStatus(new Path("/"));
        String logOutput = auditlog.getOutput();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)loginUser.getUserName(), (Object)realUser.getUserName());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)logOutput.contains(String.format("ugi=%s (auth:PROXY) via %s (auth:SIMPLE)", proxyUser.getUserName(), loginUser.getUserName())), (String)"The login user is the proxyUser in the UGI field");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)logOutput.contains(String.format("realUser:%s", realUser.getUserName())), (String)"The audit log should contain the real user.");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)logOutput.contains("proxyUserPort"), (String)"The audit log should contain the proxyuser port.");
    }

    @Test
    public void testSetBalancerBandwidth() throws Exception {
        long defaultBandwidth = 0x6400000L;
        long newBandwidth = defaultBandwidth * 2L;
        this.routerProtocol.setBalancerBandwidth(newBandwidth);
        ArrayList datanodes = cluster.getCluster().getDataNodes();
        GenericTestUtils.waitFor(() -> ((DataNode)datanodes.get(0)).getBalancerBandwidth() == newBandwidth, (long)100L, (long)60000L);
    }

    @Test
    public void testAddClientIpPortToCallerContext() throws IOException {
        GenericTestUtils.LogCapturer auditLog = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.AUDIT_LOG);
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("clientContext").build());
        String dirPath = "/test";
        this.routerProtocol.mkdirs(dirPath, new FsPermission("755"), false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)auditLog.getOutput().contains("clientIp:"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)auditLog.getOutput().contains("clientPort:"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, dirPath));
        auditLog.clearOutput();
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("clientContext,clientIp:1.1.1.1,clientPort:1234").build());
        this.routerProtocol.getFileInfo(dirPath);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)auditLog.getOutput().contains("clientIp:1.1.1.1"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)auditLog.getOutput().contains("clientPort:1234"));
    }

    @Test
    public void testAddClientIdAndCallIdToCallerContext() throws IOException {
        GenericTestUtils.LogCapturer auditLog = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.AUDIT_LOG);
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("clientContext").build());
        String dirPath = "/test";
        this.routerProtocol.mkdirs(dirPath, new FsPermission("755"), false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)auditLog.getOutput().contains("clientId:"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)auditLog.getOutput().contains("clientCallId:"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, dirPath));
        auditLog.clearOutput();
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("clientContext,clientId:mockClientId,clientCallId:4321").build());
        this.routerProtocol.getFileInfo(dirPath);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)auditLog.getOutput().contains("clientId:mockClientId"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)auditLog.getOutput().contains("clientCallId:4321"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentSummaryWithSnapshot() throws Exception {
        DistributedFileSystem routerDFS = (DistributedFileSystem)this.routerFS;
        Path dirPath = new Path("/testdir");
        Path subdirPath = new Path(dirPath, "subdir");
        Path filePath1 = new Path(dirPath, "file");
        Path filePath2 = new Path(subdirPath, "file2");
        routerDFS.mkdirs(dirPath);
        routerDFS.mkdirs(subdirPath);
        FederationTestUtils.createFile((FileSystem)routerDFS, filePath1.toString(), 32L);
        FederationTestUtils.createFile((FileSystem)routerDFS, filePath2.toString(), 16L);
        routerDFS.allowSnapshot(dirPath);
        routerDFS.createSnapshot(dirPath, "s1");
        try {
            ContentSummary contentSummary = routerDFS.getContentSummary(dirPath);
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)contentSummary.getSnapshotDirectoryCount());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)contentSummary.getSnapshotFileCount());
            routerDFS.delete(filePath1, true);
            routerDFS.delete(subdirPath, true);
            contentSummary = routerDFS.getContentSummary(dirPath);
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)contentSummary.getSnapshotDirectoryCount());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)contentSummary.getSnapshotFileCount());
        }
        finally {
            routerDFS.deleteSnapshot(dirPath, "s1");
            routerDFS.disallowSnapshot(dirPath);
            routerDFS.delete(dirPath, true);
        }
    }

    @Test
    public void testDisableNodeUsageInRBFMetrics() throws JSONException {
        RBFMetrics rbfMetrics = this.router.getRouter().getMetrics();
        FederationRPCMetrics federationRPCMetrics = this.router.getRouter().getRpcServer().getRPCMetrics();
        long proxyOpBefore = federationRPCMetrics.getProxyOps();
        String nodeUsageEnable = this.router.getRouter().getMetrics().getNodeUsage();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)nodeUsageEnable);
        long proxyOpAfterWithEnable = federationRPCMetrics.getProxyOps();
        org.junit.jupiter.api.Assertions.assertEquals((long)(proxyOpBefore + 2L), (long)proxyOpAfterWithEnable);
        rbfMetrics.setEnableGetDNUsage(false);
        String nodeUsageDisable = rbfMetrics.getNodeUsage();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)nodeUsageDisable);
        long proxyOpAfterWithDisable = federationRPCMetrics.getProxyOps();
        org.junit.jupiter.api.Assertions.assertEquals((long)proxyOpAfterWithEnable, (long)proxyOpAfterWithDisable);
        JSONObject jsonObject = new JSONObject(nodeUsageDisable);
        JSONObject json = jsonObject.getJSONObject("nodeUsage");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0.00%", (Object)json.get("min"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0.00%", (Object)json.get("median"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0.00%", (Object)json.get("max"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0.00%", (Object)json.get("stdDev"));
        rbfMetrics.setEnableGetDNUsage(true);
        String nodeUsageWithReEnable = rbfMetrics.getNodeUsage();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)nodeUsageWithReEnable);
        long proxyOpAfterWithReEnable = federationRPCMetrics.getProxyOps();
        org.junit.jupiter.api.Assertions.assertEquals((long)(proxyOpAfterWithDisable + 2L), (long)proxyOpAfterWithReEnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetListingOrder() throws Exception {
        String ns1 = this.getCluster().getNameservices().get(1);
        String destBasePath = cluster.getNamenodeTestDirectoryForNS(ns1);
        String testPath1 = destBasePath + "/\u00dftestGetListingOrder";
        String testPath2 = destBasePath + "/%testGetListingOrder";
        FileSystem fileSystem1 = this.getCluster().getNamenode(ns1, null).getFileSystem();
        try {
            FederationTestUtils.createFile(fileSystem1, testPath1, 32L);
            FederationTestUtils.createFile(fileSystem1, testPath2, 32L);
            MiniRouterDFSCluster.NamenodeContext nn = cluster.getNamenode(ns1, null);
            FileStatus[] fileStatuses = nn.getFileSystem().listStatus(new Path(destBasePath));
            List requiredPaths = Arrays.stream(fileStatuses).map(fileStatus -> fileStatus.getPath().getName()).collect(Collectors.toList());
            Iterator requiredPathsIterator = requiredPaths.iterator();
            DirectoryListing listing = this.routerProtocol.getListing(cluster.getFederatedTestDirectoryForNS(ns1), HdfsFileStatus.EMPTY_NAME, false);
            org.junit.jupiter.api.Assertions.assertEquals((int)requiredPaths.size(), (int)listing.getPartialListing().length);
            for (HdfsFileStatus f : listing.getPartialListing()) {
                String fileName = (String)requiredPathsIterator.next();
                String currentFile = f.getFullPath(new Path("/")).getName();
                org.junit.jupiter.api.Assertions.assertEquals((Object)currentFile, (Object)fileName);
            }
        }
        finally {
            fileSystem1.delete(new Path(testPath1), true);
            fileSystem1.delete(new Path(testPath2), true);
        }
    }

    @Test
    public void testCallerContextNotResetByAsyncHandler() throws IOException {
        GenericTestUtils.LogCapturer auditLog = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.AUDIT_LOG);
        String dirPath = "/test";
        Thread t1 = new Thread(() -> {
            CallerContext.setCurrent((CallerContext)new CallerContext.Builder("async:true").build());
            for (int i = 0; i < 10; ++i) {
                try {
                    this.routerProtocol.mkdirs(dirPath, new FsPermission("755"), false);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, dirPath));
                    this.routerProtocol.delete(dirPath, true);
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)FederationTestUtils.verifyFileExists(this.routerFS, dirPath));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)auditLog.getOutput().contains("async:true"));
            auditLog.clearOutput();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)auditLog.getOutput().contains("async:true"));
        });
        t1.start();
        try {
            t1.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.routerProtocol.getFileInfo(dirPath);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)auditLog.getOutput().contains("async:true"));
    }

    @Test
    public void testConcurrentCallExecutorInitial() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.router.getRouterRpcClient().getExecutorService());
    }
}

