/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterRetryCache {
    private MiniRouterDFSCluster cluster;

    @BeforeEach
    public void setup() throws Exception {
        UserGroupInformation routerUser = UserGroupInformation.getLoginUser();
        Configuration conf = new Configuration();
        String adminUser = routerUser.getUserName();
        conf.set("hadoop.proxyuser." + adminUser + ".hosts", "*");
        conf.set("hadoop.proxyuser." + adminUser + ".groups", "*");
        conf.set("hadoop.proxyuser.fake_joe.hosts", "*");
        conf.set("hadoop.proxyuser.fake_joe.groups", "*");
        conf.set("dfs.namenode.ip-proxy-users", routerUser.getShortUserName());
        this.cluster = new MiniRouterDFSCluster(true, 1, conf);
        this.cluster.addNamenodeOverrides(conf);
        this.cluster.startCluster();
        this.cluster.startRouters();
        this.cluster.registerNamenodes();
        this.cluster.waitNamenodeRegistration();
        this.cluster.installMockLocations();
        if (this.cluster.isHighAvailability()) {
            for (String ns : this.cluster.getNameservices()) {
                this.cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                this.cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
            }
        }
        this.cluster.waitActiveNamespaces();
    }

    @AfterEach
    public void teardown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testRetryCacheWithOneLevelProxyUser() throws Exception {
        this.internalTestRetryCache(false);
    }

    @Test
    public void testRetryCacheWithTwoLevelProxyUser() throws Exception {
        this.internalTestRetryCache(true);
    }

    private void internalTestRetryCache(boolean twoLevelProxyUGI) throws Exception {
        RetryInvocationHandler.SET_CALL_ID_FOR_TEST.set(false);
        FileSystem routerFS = this.cluster.getRandomRouter().getFileSystem();
        Path testDir = new Path("/target-ns0/testdir");
        routerFS.mkdirs(testDir);
        routerFS.setPermission(testDir, FsPermission.getDefault());
        UserGroupInformation joe = UserGroupInformation.createUserForTesting((String)"fake_joe", (String[])new String[]{"fake_group"});
        if (twoLevelProxyUGI) {
            joe = UserGroupInformation.createProxyUser((String)"fake_proxy_joe", (UserGroupInformation)joe);
        }
        FileSystem joeFS = (FileSystem)joe.doAs(() -> FileSystem.newInstance((URI)routerFS.getUri(), (Configuration)routerFS.getConf()));
        Path renameSrc = new Path(testDir, "renameSrc");
        Path renameDst = new Path(testDir, "renameDst");
        joeFS.mkdirs(renameSrc);
        Assertions.assertEquals((Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)this.cluster.getCluster().getNamesystem(0).getState());
        int callId = Client.nextCallId();
        Client.setCallIdAndRetryCount((int)callId, (int)0, null);
        Assertions.assertTrue((boolean)joeFS.rename(renameSrc, renameDst));
        Client.setCallIdAndRetryCount((int)callId, (int)0, null);
        Assertions.assertTrue((boolean)joeFS.rename(renameSrc, renameDst));
        String ns0 = this.cluster.getNameservices().get(0);
        this.cluster.switchToStandby(ns0, FederationTestUtils.NAMENODES[0]);
        this.cluster.switchToActive(ns0, FederationTestUtils.NAMENODES[1]);
        Assertions.assertEquals((Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)this.cluster.getCluster().getNamesystem(1).getState());
        Client.setCallIdAndRetryCount((int)callId, (int)0, null);
        Assertions.assertTrue((boolean)joeFS.rename(renameSrc, renameDst));
        FileStatus fileStatus = joeFS.getFileStatus(renameDst);
        if (twoLevelProxyUGI) {
            Assertions.assertEquals((Object)"fake_proxy_joe", (Object)fileStatus.getOwner());
        } else {
            Assertions.assertEquals((Object)"fake_joe", (Object)fileStatus.getOwner());
        }
        joeFS.delete(renameDst, true);
    }

    @Test
    public void testParseSpecialValue() {
        String mockContent = "mockContent,clientIp:127.0.0.1,clientCallId:12345,clientId:mockClientId";
        String clientIp = NameNode.parseSpecialValue((String)mockContent, (String)"clientIp:");
        Assertions.assertEquals((Object)"127.0.0.1", (Object)clientIp);
        String clientCallId = NameNode.parseSpecialValue((String)mockContent, (String)"clientCallId:");
        Assertions.assertEquals((Object)"12345", (Object)clientCallId);
        String clientId = NameNode.parseSpecialValue((String)mockContent, (String)"clientId:");
        Assertions.assertEquals((Object)"mockClientId", (Object)clientId);
        String clientRetryNum = NameNode.parseSpecialValue((String)mockContent, (String)"clientRetryNum:");
        Assertions.assertNull((Object)clientRetryNum);
    }
}

