/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.util.Set;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaManager;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterQuotaManager {
    private static RouterQuotaManager manager;

    @BeforeEach
    public void setup() {
        manager = new RouterQuotaManager();
    }

    @AfterEach
    public void cleanup() {
        manager.clear();
    }

    @Test
    public void testGetChildrenPaths() {
        RouterQuotaUsage quotaUsage = new RouterQuotaUsage.Builder().build();
        manager.put("/path1", quotaUsage);
        manager.put("/path2", quotaUsage);
        manager.put("/path1/subdir", quotaUsage);
        manager.put("/path1/subdir/subdir", quotaUsage);
        Set childrenPaths = manager.getPaths("/path1");
        Assertions.assertEquals((int)3, (int)childrenPaths.size());
        Assertions.assertTrue((childrenPaths.contains("/path1/subdir") && childrenPaths.contains("/path1/subdir/subdir") && childrenPaths.contains("/path1") ? 1 : 0) != 0);
        manager.put("/path3", quotaUsage);
        manager.put("/path3/subdir", quotaUsage);
        manager.put("/path3-subdir", quotaUsage);
        childrenPaths = manager.getPaths("/path3");
        Assertions.assertEquals((int)2, (int)childrenPaths.size());
        Assertions.assertTrue((childrenPaths.contains("/path3") && childrenPaths.contains("/path3/subdir") && !childrenPaths.contains("/path3-subdir") ? 1 : 0) != 0);
    }

    @Test
    public void testGetQuotaUsage() {
        RouterQuotaUsage quotaGet = manager.getQuotaUsage("/non-exist-path");
        Assertions.assertNull((Object)quotaGet);
        RouterQuotaUsage.Builder quota = new RouterQuotaUsage.Builder().quota(-1L).spaceQuota(-1L);
        manager.put("/noQuotaSet", quota.build());
        quotaGet = manager.getQuotaUsage("/noQuotaSet");
        Assertions.assertNull((Object)quotaGet);
        quota.quota(1L);
        quota.spaceQuota(-1L);
        manager.put("/hasQuotaSet", quota.build());
        quotaGet = manager.getQuotaUsage("/hasQuotaSet");
        Assertions.assertEquals((long)1L, (long)quotaGet.getQuota());
        Assertions.assertEquals((long)-1L, (long)quotaGet.getSpaceQuota());
        quotaGet = manager.getQuotaUsage("/hasQuotaSet/file");
        Assertions.assertEquals((long)1L, (long)quotaGet.getQuota());
        Assertions.assertEquals((long)-1L, (long)quotaGet.getSpaceQuota());
        quota.quota(-1L);
        quota.spaceQuota(-1L);
        manager.put("/hasQuotaSet/noQuotaSet", quota.build());
        quotaGet = manager.getQuotaUsage("/hasQuotaSet/noQuotaSet/file");
        Assertions.assertEquals((long)1L, (long)quotaGet.getQuota());
        Assertions.assertEquals((long)-1L, (long)quotaGet.getSpaceQuota());
        quota.quota(2L);
        quota.spaceQuota(-1L);
        manager.put("/hasQuotaSet/hasQuotaSet", quota.build());
        quotaGet = manager.getQuotaUsage("/hasQuotaSet/hasQuotaSet/file");
        Assertions.assertEquals((long)2L, (long)quotaGet.getQuota());
        Assertions.assertEquals((long)-1L, (long)quotaGet.getSpaceQuota());
    }
}

