/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.hdfs.protocolPB.RouterPolicyProvider;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.federation.router.RouterAdminServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.util.Sets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterPolicyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterPolicyProvider.class);
    private static Set<Class<?>> policyProviderProtocols;
    private Class<?> rpcServerClass;

    @BeforeAll
    public static void initialize() {
        Service[] services = new RouterPolicyProvider().getServices();
        policyProviderProtocols = new HashSet(services.length);
        for (Service service : services) {
            policyProviderProtocols.add(service.getProtocol());
        }
    }

    public void initTestRouterPolicyProvider(Class<?> pRpcServerClass) {
        this.rpcServerClass = pRpcServerClass;
    }

    public static List<Class<?>[]> data() {
        return Arrays.asList({RouterRpcServer.class}, {NameNodeRpcServer.class}, {DataNode.class}, {RouterAdminServer.class});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testPolicyProviderForServer(Class<?> pRpcServerClass, TestInfo testInfo) {
        this.initTestRouterPolicyProvider(pRpcServerClass);
        List ifaces = ClassUtils.getAllInterfaces(this.rpcServerClass);
        HashSet<Class> serverProtocols = new HashSet<Class>(ifaces.size());
        for (Object obj : ifaces) {
            Class iface = (Class)obj;
            if (!iface.getSimpleName().endsWith("Protocol")) continue;
            serverProtocols.add(iface);
        }
        LOG.info("Running test {} for RPC server {}.  Found server protocols {} and policy provider protocols {}.", new Object[]{testInfo.getDisplayName(), this.rpcServerClass.getName(), serverProtocols, policyProviderProtocols});
        Assertions.assertFalse((boolean)serverProtocols.isEmpty(), (String)"Expected to find at least one protocol in server.");
        Set differenceSet = Sets.difference(serverProtocols, policyProviderProtocols);
        Assertions.assertTrue((boolean)differenceSet.isEmpty(), (String)String.format("Following protocols for server %s are not defined in %s: %s", this.rpcServerClass.getName(), RouterPolicyProvider.class.getName(), Arrays.toString(differenceSet.toArray())));
    }
}

