/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.RouterServerHelper;
import org.apache.hadoop.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestRouterNetworkTopologyServlet {
    public static StateStoreDFSCluster clusterWithDatanodes;
    public static StateStoreDFSCluster clusterNoDatanodes;
    public static final String ASYNC_MODE = "ASYNC";
    public static final String SYNC_MODE = "SYNC";

    public static void setUp(String rpcMode) throws Exception {
        Configuration routerConf = new RouterConfigBuilder().stateStore().admin().quota().rpc().build();
        routerConf.set("dfs.federation.router.http.enable", "true");
        if (rpcMode.equals(ASYNC_MODE)) {
            routerConf.setBoolean("dfs.federation.router.async.rpc.enable", true);
        }
        Configuration hdfsConf = new Configuration(false);
        clusterWithDatanodes = new StateStoreDFSCluster(false, 2, MultipleDestinationMountTableResolver.class);
        clusterWithDatanodes.addNamenodeOverrides(hdfsConf);
        clusterWithDatanodes.addRouterOverrides(routerConf);
        clusterWithDatanodes.setNumDatanodesPerNameservice(9);
        clusterWithDatanodes.setIndependentDNs();
        clusterWithDatanodes.setRacks(new String[]{"/rack1", "/rack1", "/rack1", "/rack2", "/rack2", "/rack2", "/rack3", "/rack3", "/rack3", "/rack4", "/rack4", "/rack4", "/rack5", "/rack5", "/rack5", "/rack6", "/rack6", "/rack6"});
        clusterWithDatanodes.startCluster();
        clusterWithDatanodes.startRouters();
        clusterWithDatanodes.waitClusterUp();
        clusterWithDatanodes.waitActiveNamespaces();
        clusterNoDatanodes = new StateStoreDFSCluster(false, 2, MultipleDestinationMountTableResolver.class);
        clusterNoDatanodes.addNamenodeOverrides(hdfsConf);
        clusterNoDatanodes.addRouterOverrides(routerConf);
        clusterNoDatanodes.setNumDatanodesPerNameservice(0);
        clusterNoDatanodes.setIndependentDNs();
        clusterNoDatanodes.startCluster();
        clusterNoDatanodes.startRouters();
        clusterNoDatanodes.waitClusterUp();
        clusterNoDatanodes.waitActiveNamespaces();
    }

    public void testPrintTopologyTextFormat() throws Exception {
        String httpAddress = clusterWithDatanodes.getRandomRouter().getRouter().getHttpServerAddress().toString();
        URL url = new URL("http:/" + httpAddress + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        StringBuilder sb = new StringBuilder("-- Network Topology -- \n");
        sb.append(out);
        sb.append("\n-- Network Topology -- ");
        String topology = sb.toString();
        Assertions.assertTrue((boolean)topology.contains("/ns0/rack1"));
        Assertions.assertTrue((boolean)topology.contains("/ns0/rack2"));
        Assertions.assertTrue((boolean)topology.contains("/ns0/rack3"));
        Assertions.assertTrue((boolean)topology.contains("/ns1/rack4"));
        Assertions.assertTrue((boolean)topology.contains("/ns1/rack5"));
        Assertions.assertTrue((boolean)topology.contains("/ns1/rack6"));
        Assertions.assertEquals((int)18, (int)(topology.split("127.0.0.1").length - 1));
    }

    public void testPrintTopologyJsonFormat() throws Exception {
        String httpAddress = clusterWithDatanodes.getRandomRouter().getRouter().getHttpServerAddress().toString();
        URL url = new URL("http:/" + httpAddress + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.setRequestProperty("Accept", "application/json");
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        String topology = out.toString();
        JsonNode racks = new ObjectMapper().readTree(topology);
        Assertions.assertEquals((int)6, (int)racks.size());
        Assertions.assertTrue((boolean)topology.contains("/ns0/rack1"));
        Assertions.assertTrue((boolean)topology.contains("/ns0/rack2"));
        Assertions.assertTrue((boolean)topology.contains("/ns0/rack3"));
        Assertions.assertTrue((boolean)topology.contains("/ns1/rack4"));
        Assertions.assertTrue((boolean)topology.contains("/ns1/rack5"));
        Assertions.assertTrue((boolean)topology.contains("/ns1/rack6"));
        Iterator elements = racks.elements();
        int dataNodesCount = 0;
        while (elements.hasNext()) {
            JsonNode rack = (JsonNode)elements.next();
            Iterator fields = rack.fields();
            while (fields.hasNext()) {
                dataNodesCount += ((JsonNode)((Map.Entry)fields.next()).getValue()).size();
            }
        }
        Assertions.assertEquals((int)18, (int)dataNodesCount);
    }

    public void testPrintTopologyNoDatanodesTextFormat() throws Exception {
        String httpAddress = clusterNoDatanodes.getRandomRouter().getRouter().getHttpServerAddress().toString();
        URL url = new URL("http:/" + httpAddress + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        StringBuilder sb = new StringBuilder("-- Network Topology -- \n");
        sb.append(out);
        sb.append("\n-- Network Topology -- ");
        String topology = sb.toString();
        Assertions.assertTrue((boolean)topology.contains("No DataNodes"));
    }

    public void testPrintTopologyNoDatanodesJsonFormat() throws Exception {
        String httpAddress = clusterNoDatanodes.getRandomRouter().getRouter().getHttpServerAddress().toString();
        URL url = new URL("http:/" + httpAddress + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.setRequestProperty("Accept", "application/json");
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        StringBuilder sb = new StringBuilder("-- Network Topology -- \n");
        sb.append(out);
        sb.append("\n-- Network Topology -- ");
        String topology = sb.toString();
        Assertions.assertTrue((boolean)topology.contains("No DataNodes"));
    }

    @Nested
    @ExtendWith(value={RouterServerHelper.class})
    class TestWithSyncRouterRpc {
        TestWithSyncRouterRpc() {
        }

        @ParameterizedTest
        @ValueSource(strings={"SYNC"})
        public void testPrintTopologyTextFormatSync(String rpcMode) throws Exception {
            TestRouterNetworkTopologyServlet.this.testPrintTopologyTextFormat();
        }

        @ParameterizedTest
        @ValueSource(strings={"SYNC"})
        public void testPrintTopologyJsonFormatSync(String rpcMode) throws Exception {
            TestRouterNetworkTopologyServlet.this.testPrintTopologyJsonFormat();
        }

        @ParameterizedTest
        @ValueSource(strings={"SYNC"})
        public void testPrintTopologyNoDatanodesTextFormatSync(String rpcMode) throws Exception {
            TestRouterNetworkTopologyServlet.this.testPrintTopologyNoDatanodesTextFormat();
        }

        @ParameterizedTest
        @ValueSource(strings={"SYNC"})
        public void testPrintTopologyNoDatanodesJsonFormatSync(String rpcMode) throws Exception {
            TestRouterNetworkTopologyServlet.this.testPrintTopologyNoDatanodesJsonFormat();
        }
    }

    @Nested
    @ExtendWith(value={RouterServerHelper.class})
    class TestWithAsyncRouterRpc {
        TestWithAsyncRouterRpc() {
        }

        @ParameterizedTest
        @ValueSource(strings={"ASYNC"})
        public void testPrintTopologyTextFormatAsync(String rpcMode) throws Exception {
            TestRouterNetworkTopologyServlet.this.testPrintTopologyTextFormat();
        }

        @ParameterizedTest
        @ValueSource(strings={"ASYNC"})
        public void testPrintTopologyJsonFormatAsync(String rpcMode) throws Exception {
            TestRouterNetworkTopologyServlet.this.testPrintTopologyJsonFormat();
        }

        @ParameterizedTest
        @ValueSource(strings={"ASYNC"})
        public void testPrintTopologyNoDatanodesTextFormatAsync(String rpcMode) throws Exception {
            TestRouterNetworkTopologyServlet.this.testPrintTopologyNoDatanodesTextFormat();
        }

        @ParameterizedTest
        @ValueSource(strings={"ASYNC"})
        public void testPrintTopologyNoDatanodesJsonFormatAsync(String rpcMode) throws Exception {
            TestRouterNetworkTopologyServlet.this.testPrintTopologyNoDatanodesJsonFormat();
        }
    }
}

