/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.MockNamenode;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.NamenodeHeartbeatService;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.util.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterNamenodeWebScheme {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterNamenodeWebScheme.class);
    private Router router;
    private Map<String, Map<String, MockNamenode>> nns = new HashMap<String, Map<String, MockNamenode>>();
    private List<String> nsIds = Arrays.asList("ns0", "ns1");

    @BeforeEach
    public void setup() throws Exception {
        LOG.info("Initialize the Mock Namenodes to monitor");
        for (String string : this.nsIds) {
            this.nns.put(string, new HashMap());
            for (String nnId : Arrays.asList("nn0", "nn1")) {
                this.nns.get(string).put(nnId, new MockNamenode(string));
            }
        }
        LOG.info("Set nn0 to active for all nameservices");
        for (Map map : this.nns.values()) {
            ((MockNamenode)map.get("nn0")).transitionToActive();
            ((MockNamenode)map.get("nn1")).transitionToStandby();
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        for (Map<String, MockNamenode> nnNS : this.nns.values()) {
            for (MockNamenode nn : nnNS.values()) {
                nn.stop();
            }
        }
        this.nns.clear();
        if (this.router != null) {
            this.router.stop();
        }
    }

    private Configuration getNamenodesConfig() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", StringUtils.join((CharSequence)",", this.nns.keySet()));
        for (String nsId : this.nns.keySet()) {
            Set<String> nnIds = this.nns.get(nsId).keySet();
            StringBuilder sb = new StringBuilder();
            sb.append("dfs.ha.namenodes");
            sb.append(".").append(nsId);
            conf.set(sb.toString(), StringUtils.join((CharSequence)",", nnIds));
            for (String nnId : nnIds) {
                MockNamenode nn = this.nns.get(nsId).get(nnId);
                sb = new StringBuilder();
                sb.append("dfs.namenode.rpc-address");
                sb.append(".").append(nsId);
                sb.append(".").append(nnId);
                conf.set(sb.toString(), "localhost:" + nn.getRPCPort());
                sb = new StringBuilder();
                sb.append("dfs.namenode.http-address");
                sb.append(".").append(nsId);
                sb.append(".").append(nnId);
                conf.set(sb.toString(), "localhost:" + nn.getHTTPPort());
            }
        }
        return conf;
    }

    @Test
    public void testWebSchemeHttp() throws IOException {
        this.testWebScheme(HttpConfig.Policy.HTTP_ONLY, "http");
    }

    @Test
    public void testWebSchemeHttps() throws IOException {
        this.testWebScheme(HttpConfig.Policy.HTTPS_ONLY, "https");
    }

    private void testWebScheme(HttpConfig.Policy httpPolicy, String expectedScheme) throws IOException {
        Configuration nsConf = this.getNamenodesConfig();
        Configuration stateStoreConfig = FederationStateStoreTestUtils.getStateStoreConfiguration();
        stateStoreConfig.setClass("dfs.federation.router.namenode.resolver.client.class", MembershipNamenodeResolver.class, ActiveNamenodeResolver.class);
        stateStoreConfig.setClass("dfs.federation.router.file.resolver.client.class", MountTableResolver.class, FileSubclusterResolver.class);
        Configuration routerConf = new RouterConfigBuilder(nsConf).enableLocalHeartbeat(true).heartbeat().stateStore().rpc().build();
        routerConf.set("dfs.http.policy", httpPolicy.name());
        routerConf.set("dfs.federation.router.rpc-address", "0.0.0.0:0");
        routerConf.set("dfs.federation.router.monitor.namenode", "ns1.nn0,ns1.nn1");
        routerConf.addResource(stateStoreConfig);
        routerConf.set("dfs.nameservice.id", "ns0");
        routerConf.set("dfs.ha.namenode.id", "nn1");
        this.router = new Router();
        this.router.init(routerConf);
        this.router.start();
        Collection heartbeatServices = this.router.getNamenodeHeartbeatServices();
        for (NamenodeHeartbeatService service : heartbeatServices) {
            service.periodicInvoke();
        }
        MembershipNamenodeResolver resolver = (MembershipNamenodeResolver)this.router.getNamenodeResolver();
        resolver.loadCache(true);
        ArrayList namespaceInfo = new ArrayList();
        for (String nsId : this.nns.keySet()) {
            List nnReports = resolver.getNamenodesForNameserviceId(nsId, false);
            namespaceInfo.addAll(nnReports);
        }
        for (FederationNamenodeContext nnInfo : namespaceInfo) {
            Assertions.assertEquals((Object)nnInfo.getWebScheme(), (Object)expectedScheme, (String)("Unexpected scheme for Policy: " + httpPolicy.name()));
        }
    }
}

