/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LogVerificationAppender;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MockNamenode;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.router.NamenodeHeartbeatService;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Appender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestRouterNamenodeMonitoring {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterNamenodeMonitoring.class);
    private Router router;
    private Map<String, Map<String, MockNamenode>> nns = new HashMap<String, Map<String, MockNamenode>>();
    private List<String> nsIds = Arrays.asList("ns0", "ns1");
    private List<String> nnIds = Arrays.asList("nn0", "nn1");
    private long initializedTime;

    @BeforeEach
    public void setup() throws Exception {
        LOG.info("Initialize the Mock Namenodes to monitor");
        for (String string : this.nsIds) {
            this.nns.put(string, new HashMap());
            for (String nnId : this.nnIds) {
                this.nns.get(string).put(nnId, new MockNamenode(string));
            }
        }
        LOG.info("Set nn0 to active for all nameservices");
        for (Map map : this.nns.values()) {
            ((MockNamenode)map.get("nn0")).transitionToActive();
            ((MockNamenode)map.get("nn1")).transitionToStandby();
        }
        this.initializedTime = Time.now();
    }

    @AfterEach
    public void cleanup() throws Exception {
        for (Map<String, MockNamenode> nnNS : this.nns.values()) {
            for (MockNamenode nn : nnNS.values()) {
                nn.stop();
            }
        }
        this.nns.clear();
        if (this.router != null) {
            this.router.stop();
        }
    }

    private Configuration getNamenodesConfig() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", StringUtils.join((CharSequence)",", this.nns.keySet()));
        for (String nsId : this.nns.keySet()) {
            Set<String> nsNnIds = this.nns.get(nsId).keySet();
            StringBuilder sb = new StringBuilder();
            sb.append("dfs.ha.namenodes");
            sb.append(".").append(nsId);
            conf.set(sb.toString(), StringUtils.join((CharSequence)",", nsNnIds));
            for (String nnId : nsNnIds) {
                MockNamenode nn = this.nns.get(nsId).get(nnId);
                sb = new StringBuilder();
                sb.append("dfs.namenode.rpc-address");
                sb.append(".").append(nsId);
                sb.append(".").append(nnId);
                conf.set(sb.toString(), "localhost:" + nn.getRPCPort());
                sb = new StringBuilder();
                sb.append("dfs.namenode.http-address");
                sb.append(".").append(nsId);
                sb.append(".").append(nnId);
                conf.set(sb.toString(), "localhost:" + nn.getHTTPPort());
            }
        }
        return conf;
    }

    @Test
    public void testNamenodeMonitoring() throws Exception {
        Configuration nsConf = this.getNamenodesConfig();
        Configuration stateStoreConfig = FederationStateStoreTestUtils.getStateStoreConfiguration();
        stateStoreConfig.setClass("dfs.federation.router.namenode.resolver.client.class", MembershipNamenodeResolver.class, ActiveNamenodeResolver.class);
        stateStoreConfig.setClass("dfs.federation.router.file.resolver.client.class", MountTableResolver.class, FileSubclusterResolver.class);
        Configuration routerConf = new RouterConfigBuilder(nsConf).enableLocalHeartbeat(true).heartbeat().stateStore().rpc().build();
        routerConf.set("dfs.federation.router.rpc-address", "0.0.0.0:0");
        routerConf.set("dfs.federation.router.monitor.namenode", "ns1.nn0,ns1.nn1");
        routerConf.addResource(stateStoreConfig);
        routerConf.set("dfs.nameservice.id", "ns0");
        routerConf.set("dfs.ha.namenode.id", "nn1");
        this.router = new Router();
        this.router.init(routerConf);
        this.router.start();
        Collection heartbeatServices = this.router.getNamenodeHeartbeatServices();
        for (NamenodeHeartbeatService service : heartbeatServices) {
            service.periodicInvoke();
        }
        MembershipNamenodeResolver resolver = (MembershipNamenodeResolver)this.router.getNamenodeResolver();
        resolver.loadCache(true);
        ArrayList namespaceInfo = new ArrayList();
        for (String nsId : this.nns.keySet()) {
            List nnReports = resolver.getNamenodesForNameserviceId(nsId, false);
            namespaceInfo.addAll(nnReports);
        }
        for (FederationNamenodeContext nnInfo : namespaceInfo) {
            long modTime = nnInfo.getDateModified();
            long diff = modTime - this.initializedTime;
            if ("ns0".equals(nnInfo.getNameserviceId()) && "nn0".equals(nnInfo.getNamenodeId())) {
                Assertions.assertTrue((modTime < this.initializedTime ? 1 : 0) != 0, (String)(nnInfo + " shouldn't be updated: " + diff));
                continue;
            }
            Assertions.assertTrue((modTime > this.initializedTime ? 1 : 0) != 0, (String)(nnInfo + " should be updated: " + diff));
        }
    }

    @Test
    public void testNamenodeMonitoringConfig() throws Exception {
        this.testConfig(Arrays.asList(new String[0]), "");
        this.testConfig(Arrays.asList("ns1.nn0"), "ns1.nn0");
        this.testConfig(Arrays.asList("ns1.nn0", "ns1.nn1"), "ns1.nn0,ns1.nn1");
        this.testConfig(Arrays.asList("ns1.nn0", "ns1.nn1"), "ns1.nn0, ns1.nn1");
        this.testConfig(Arrays.asList("ns1.nn0", "ns1.nn1"), " ns1.nn0,ns1.nn1");
        this.testConfig(Arrays.asList("ns1.nn0", "ns1.nn1"), "ns1.nn0,ns1.nn1,");
    }

    private void testConfig(Collection<String> expectedNNs, String confNsIds) {
        Configuration conf = this.getNamenodesConfig();
        Configuration routerConf = new RouterConfigBuilder(conf).heartbeat(true).build();
        routerConf.set("dfs.federation.router.rpc-address", "0.0.0.0:0");
        routerConf.set("dfs.federation.router.monitor.namenode", confNsIds);
        this.router = new Router();
        this.router.init(routerConf);
        Collection heartbeatServices = this.router.getNamenodeHeartbeatServices();
        TestRouterNamenodeMonitoring.assertNamenodeHeartbeatService(expectedNNs, heartbeatServices);
    }

    private static void assertNamenodeHeartbeatService(Collection<String> expected, Collection<NamenodeHeartbeatService> actual) {
        TreeSet<String> actualSet = new TreeSet<String>();
        for (NamenodeHeartbeatService heartbeatService : actual) {
            NamenodeStatusReport report = heartbeatService.getNamenodeStatusReport();
            StringBuilder sb = new StringBuilder();
            sb.append(report.getNameserviceId());
            sb.append(".");
            sb.append(report.getNamenodeId());
            actualSet.add(sb.toString());
        }
        Assertions.assertTrue((boolean)expected.containsAll(actualSet), (String)(expected + " does not contain all " + actualSet));
        Assertions.assertTrue((boolean)actualSet.containsAll(expected), (String)(actualSet + " does not contain all " + expected));
    }

    @Test
    public void testJmxUrlHTTP() {
        this.verifyUrlSchemes(HttpConfig.Policy.HTTP_ONLY.name());
    }

    @Test
    public void testJmxUrlHTTPs() {
        this.verifyUrlSchemes(HttpConfig.Policy.HTTPS_ONLY.name());
    }

    @Test
    public void testJmxRequestFrequency() {
        Configuration conf = this.getNamenodesConfig();
        conf.setLong("dfs.federation.router.namenode.heartbeat.jmx.interval", -1L);
        this.verifyUrlSchemes(HttpConfig.Policy.HTTPS_ONLY.name(), conf, 0, 0, 1);
        conf = this.getNamenodesConfig();
        conf.setLong("dfs.federation.router.namenode.heartbeat.jmx.interval", TimeUnit.MINUTES.toMillis(5L));
        this.verifyUrlSchemes(HttpConfig.Policy.HTTPS_ONLY.name(), conf, 0, 1, 2);
        conf = this.getNamenodesConfig();
        this.verifyUrlSchemes(HttpConfig.Policy.HTTPS_ONLY.name(), conf, 0, 2, 2);
    }

    private void verifyUrlSchemes(String scheme) {
        int httpRequests = HttpConfig.Policy.HTTP_ONLY.name().equals(scheme) ? 1 : 0;
        int httpsRequests = HttpConfig.Policy.HTTPS_ONLY.name().equals(scheme) ? 1 : 0;
        this.verifyUrlSchemes(scheme, this.getNamenodesConfig(), httpRequests, httpsRequests, 1);
    }

    private void verifyUrlSchemes(String scheme, Configuration conf, int httpRequests, int httpsRequests, int requestsPerService) {
        LogVerificationAppender appender = new LogVerificationAppender();
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        conf.set("dfs.http.policy", scheme);
        Configuration routerConf = new RouterConfigBuilder(conf).heartbeat(true).build();
        routerConf.set("dfs.federation.router.rpc-address", "0.0.0.0:0");
        routerConf.set("dfs.federation.router.monitor.namenode", "ns1.nn0");
        this.router = new Router();
        this.router.init(routerConf);
        Collection heartbeatServices = this.router.getNamenodeHeartbeatServices();
        for (NamenodeHeartbeatService heartbeatService : heartbeatServices) {
            for (int request = 0; request < requestsPerService; ++request) {
                heartbeatService.getNamenodeStatusReport();
            }
        }
        Assertions.assertEquals((int)(httpsRequests * 2), (int)appender.countLinesWithMessage("JMX URL: https://"));
        Assertions.assertEquals((int)(httpRequests * 2), (int)appender.countLinesWithMessage("JMX URL: http://"));
    }

    @Test
    public void testDatanodesView() throws IOException {
        Configuration routerConf = new RouterConfigBuilder().stateStore().rpc().build();
        this.router = new Router();
        this.router.init(routerConf);
        this.router.start();
        for (String nsId : this.nsIds) {
            MockNamenode.registerSubclusters(this.router, this.nns.get(nsId).values());
            for (String nnId : this.nnIds) {
                MockNamenode nn = this.nns.get(nsId).get(nnId);
                if ("nn0".equals(nnId)) {
                    nn.transitionToActive();
                }
                nn.addDatanodeMock();
            }
        }
        long time = Time.now();
        for (String nsId : this.nsIds) {
            for (String nnId : this.nnIds) {
                DatanodeInfo.DatanodeInfoBuilder dn0Builder = new DatanodeInfo.DatanodeInfoBuilder().setDatanodeUuid("dn0").setHostName("dn0").setIpAddr("dn0").setXferPort(10000);
                if ("ns0".equals(nsId)) {
                    dn0Builder.setLastUpdate(time - 1000L);
                    dn0Builder.setAdminState(DatanodeInfo.AdminStates.NORMAL);
                } else if ("ns1".equals(nsId)) {
                    dn0Builder.setLastUpdate(time - 500L);
                    dn0Builder.setAdminState(DatanodeInfo.AdminStates.DECOMMISSIONED);
                }
                DatanodeInfo.DatanodeInfoBuilder dn1Builder = new DatanodeInfo.DatanodeInfoBuilder().setDatanodeUuid("dn1").setHostName("dn1").setIpAddr("dn1").setXferPort(10000);
                if ("ns0".equals(nsId)) {
                    dn1Builder.setLastUpdate(time - 1000L);
                    dn1Builder.setAdminState(DatanodeInfo.AdminStates.NORMAL);
                } else if ("ns1".equals(nsId)) {
                    dn1Builder.setLastUpdate(time - 5000L);
                    dn1Builder.setAdminState(DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
                }
                MockNamenode nn = this.nns.get(nsId).get(nnId);
                List<DatanodeInfo> dns = nn.getDatanodes();
                dns.add(dn0Builder.build());
                dns.add(dn1Builder.build());
            }
        }
        DistributedFileSystem dfs = (DistributedFileSystem)FederationTestUtils.getFileSystem(this.router);
        DFSClient dfsClient = dfs.getClient();
        DatanodeStorageReport[] dns = dfsClient.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL);
        Assertions.assertEquals((int)2, (int)dns.length);
        for (DatanodeStorageReport dn : dns) {
            DatanodeInfo dnInfo = dn.getDatanodeInfo();
            if ("dn0".equals(dnInfo.getHostName())) {
                Assertions.assertEquals((Object)DatanodeInfo.AdminStates.DECOMMISSIONED, (Object)dnInfo.getAdminState());
                continue;
            }
            if ("dn1".equals(dnInfo.getHostName())) {
                Assertions.assertEquals((Object)DatanodeInfo.AdminStates.NORMAL, (Object)dnInfo.getAdminState());
                continue;
            }
            Assertions.fail((String)("Unexpected DN: " + dnInfo.getHostName()));
        }
    }
}

