/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.contract.router.SecurityConfUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.router.NamenodeHeartbeatService;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.net.MockDomainNameResolver;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestRouterNamenodeHeartbeat {
    private static MiniRouterDFSCluster cluster;
    private static ActiveNamenodeResolver namenodeResolver;
    private static List<NamenodeHeartbeatService> services;

    @BeforeAll
    public static void globalSetUp() throws Exception {
        cluster = new MiniRouterDFSCluster(true, 2);
        cluster.startCluster();
        List<String> nss = cluster.getNameservices();
        String ns = nss.get(0);
        Configuration conf = cluster.generateNamenodeConfiguration(ns);
        namenodeResolver = new MockResolver(conf);
        namenodeResolver.setRouterId("testrouter");
        services = new ArrayList<NamenodeHeartbeatService>();
        for (MiniRouterDFSCluster.NamenodeContext nn : cluster.getNamenodes()) {
            String nsId = nn.getNameserviceId();
            String nnId = nn.getNamenodeId();
            NamenodeHeartbeatService service = new NamenodeHeartbeatService(namenodeResolver, nsId, nnId);
            service.init(conf);
            service.start();
            services.add(service);
        }
    }

    @AfterAll
    public static void tearDown() throws IOException {
        cluster.shutdown();
        for (NamenodeHeartbeatService service : services) {
            service.stop();
            service.close();
        }
    }

    @Test
    public void testNamenodeHeartbeatService() throws IOException {
        MiniRouterDFSCluster testCluster = new MiniRouterDFSCluster(true, 1);
        Configuration heartbeatConfig = testCluster.generateNamenodeConfiguration(FederationTestUtils.NAMESERVICES[0]);
        NamenodeHeartbeatService server = new NamenodeHeartbeatService(namenodeResolver, FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0]);
        server.init(heartbeatConfig);
        Assertions.assertEquals((Object)Service.STATE.INITED, (Object)server.getServiceState());
        server.start();
        Assertions.assertEquals((Object)Service.STATE.STARTED, (Object)server.getServiceState());
        server.stop();
        Assertions.assertEquals((Object)Service.STATE.STOPPED, (Object)server.getServiceState());
        server.close();
    }

    @Test
    public void testLocalNamenodeHeartbeatService() throws IOException {
        Router router = new Router();
        Configuration conf = new Configuration();
        Assertions.assertEquals(null, (Object)DFSUtil.getNamenodeNameServiceId((Configuration)conf));
        router.setConf(conf);
        Assertions.assertNull((Object)router.createLocalNamenodeHeartbeatService());
        conf.set("dfs.nameservices", "ns1");
        Assertions.assertEquals((Object)"ns1", (Object)DFSUtil.getNamenodeNameServiceId((Configuration)conf));
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{"ns1"}), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn1"}), "localhost:8020");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn2"}), "ns1-nn2.example.com:8020");
        router.setConf(conf);
        NamenodeHeartbeatService heartbeatService = router.createLocalNamenodeHeartbeatService();
        Assertions.assertNotNull((Object)heartbeatService);
        heartbeatService.init(conf);
        Assertions.assertEquals((Object)"ns1-nn1:localhost:8020", (Object)heartbeatService.getNamenodeDesc());
        heartbeatService.stop();
    }

    @Test
    public void testHearbeat() throws InterruptedException, IOException {
        if (cluster.isHighAvailability()) {
            for (String ns : cluster.getNameservices()) {
                cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
            }
        }
        Thread.sleep(5000L);
        for (String ns : cluster.getNameservices()) {
            List nns = namenodeResolver.getNamenodesForNameserviceId(ns, false);
            FederationNamenodeContext active = (FederationNamenodeContext)nns.get(0);
            Assertions.assertEquals((Object)FederationTestUtils.NAMENODES[0], (Object)active.getNamenodeId());
            FederationNamenodeContext standby = (FederationNamenodeContext)nns.get(1);
            Assertions.assertEquals((Object)FederationTestUtils.NAMENODES[1], (Object)standby.getNamenodeId());
        }
        List<String> nss = cluster.getNameservices();
        String failoverNS = nss.get(0);
        String normalNs = nss.get(1);
        cluster.switchToStandby(failoverNS, FederationTestUtils.NAMENODES[0]);
        cluster.switchToActive(failoverNS, FederationTestUtils.NAMENODES[1]);
        Thread.sleep(5000L);
        List failoverNSs = namenodeResolver.getNamenodesForNameserviceId(failoverNS, false);
        FederationNamenodeContext active = (FederationNamenodeContext)failoverNSs.get(0);
        Assertions.assertEquals((Object)FederationTestUtils.NAMENODES[1], (Object)active.getNamenodeId());
        FederationNamenodeContext standby = (FederationNamenodeContext)failoverNSs.get(1);
        Assertions.assertEquals((Object)FederationTestUtils.NAMENODES[0], (Object)standby.getNamenodeId());
        List normalNss = namenodeResolver.getNamenodesForNameserviceId(normalNs, false);
        active = (FederationNamenodeContext)normalNss.get(0);
        Assertions.assertEquals((Object)FederationTestUtils.NAMENODES[0], (Object)active.getNamenodeId());
        standby = (FederationNamenodeContext)normalNss.get(1);
        Assertions.assertEquals((Object)FederationTestUtils.NAMENODES[1], (Object)standby.getNamenodeId());
    }

    @Test
    public void testNamenodeHeartbeatServiceHAServiceProtocolProxy() {
        if (Shell.isJavaVersionAtLeast((int)14)) {
            this.testNamenodeHeartbeatServiceHAServiceProtocol("test-ns", "nn", 1000, -1, -1, 1003, "host01.test/<unresolved>:1000", "host02.test/<unresolved>:1000");
            this.testNamenodeHeartbeatServiceHAServiceProtocol("test-ns", "nn", 1000, 1001, -1, 1003, "host01.test/<unresolved>:1001", "host02.test/<unresolved>:1001");
            this.testNamenodeHeartbeatServiceHAServiceProtocol("test-ns", "nn", 1000, -1, 1002, 1003, "host01.test/<unresolved>:1002", "host02.test/<unresolved>:1002");
            this.testNamenodeHeartbeatServiceHAServiceProtocol("test-ns", "nn", 1000, 1001, 1002, 1003, "host01.test/<unresolved>:1002", "host02.test/<unresolved>:1002");
        } else {
            this.testNamenodeHeartbeatServiceHAServiceProtocol("test-ns", "nn", 1000, -1, -1, 1003, "host01.test:1000", "host02.test:1000");
            this.testNamenodeHeartbeatServiceHAServiceProtocol("test-ns", "nn", 1000, 1001, -1, 1003, "host01.test:1001", "host02.test:1001");
            this.testNamenodeHeartbeatServiceHAServiceProtocol("test-ns", "nn", 1000, -1, 1002, 1003, "host01.test:1002", "host02.test:1002");
            this.testNamenodeHeartbeatServiceHAServiceProtocol("test-ns", "nn", 1000, 1001, 1002, 1003, "host01.test:1002", "host02.test:1002");
        }
    }

    private void testNamenodeHeartbeatServiceHAServiceProtocol(String nsId, String nnId, int rpcPort, int servicePort, int lifelinePort, int webAddressPort, String expected0, String expected1) {
        Configuration conf = this.generateNamenodeConfiguration(nsId, nnId, rpcPort, servicePort, lifelinePort, webAddressPort);
        Router testRouter = new Router();
        testRouter.setConf(conf);
        Collection heartbeatServices = testRouter.createNamenodeHeartbeatServices();
        Assertions.assertEquals((int)2, (int)heartbeatServices.size());
        Iterator iterator = heartbeatServices.iterator();
        NamenodeHeartbeatService service0 = (NamenodeHeartbeatService)iterator.next();
        service0.init(conf);
        Assertions.assertNotNull((Object)service0.getLocalTarget());
        Assertions.assertEquals((Object)expected0, (Object)service0.getLocalTarget().getHealthMonitorAddress().toString());
        NamenodeHeartbeatService service1 = (NamenodeHeartbeatService)iterator.next();
        service1.init(conf);
        Assertions.assertNotNull((Object)service1.getLocalTarget());
        Assertions.assertEquals((Object)expected1, (Object)service1.getLocalTarget().getHealthMonitorAddress().toString());
    }

    @Test
    public void testNamenodeHeartbeatServiceNNResolution() {
        String nsId = "test-ns";
        String nnId = "nn";
        int rpcPort = 1000;
        int servicePort = 1001;
        int lifelinePort = 1002;
        int webAddressPort = 1003;
        Configuration conf = this.generateNamenodeConfiguration(nsId, nnId, rpcPort, servicePort, lifelinePort, webAddressPort);
        Router testRouter = new Router();
        testRouter.setConf(conf);
        Collection heartbeatServices = testRouter.createNamenodeHeartbeatServices();
        Assertions.assertEquals((int)2, (int)heartbeatServices.size());
        Iterator iterator = heartbeatServices.iterator();
        NamenodeHeartbeatService service = (NamenodeHeartbeatService)iterator.next();
        service.init(conf);
        Assertions.assertEquals((Object)"test-ns-nn-host01.test:host01.test:1001", (Object)service.getNamenodeDesc());
        service = (NamenodeHeartbeatService)iterator.next();
        service.init(conf);
        Assertions.assertEquals((Object)"test-ns-nn-host02.test:host02.test:1001", (Object)service.getNamenodeDesc());
    }

    private Configuration generateNamenodeConfiguration(String nsId, String nnId, int rpcPort, int servicePort, int lifelinePort, int webAddressPort) {
        HdfsConfiguration conf = new HdfsConfiguration();
        String suffix = nsId + "." + nnId;
        conf.setBoolean("dfs.federation.router.monitor.localnamenode.enable", false);
        conf.set("dfs.federation.router.monitor.namenode", nsId + "." + nnId);
        conf.setBoolean("dfs.federation.router.monitor.namenode.nameservice.resolution-enabled." + nsId, true);
        conf.set("dfs.federation.router.monitor.namenode.nameservice.resolver.impl." + nsId, MockDomainNameResolver.class.getName());
        conf.set("dfs.namenode.rpc-address." + suffix, "test.foo.bar:" + rpcPort);
        if (servicePort >= 0) {
            conf.set("dfs.namenode.servicerpc-address." + suffix, "test.foo.bar:" + servicePort);
        }
        if (lifelinePort >= 0) {
            conf.set("dfs.namenode.lifeline.rpc-address." + suffix, "test.foo.bar:" + lifelinePort);
        }
        conf.set("dfs.namenode.http-address." + suffix, "test.foo.bar:" + webAddressPort);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamenodeHeartbeatWithSecurity() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        MiniRouterDFSCluster testCluster = null;
        try {
            testCluster = new MiniRouterDFSCluster(true, 1, conf);
            testCluster.startCluster(conf);
            testCluster.startRouters();
            testCluster.registerNamenodes();
            testCluster.waitNamenodeRegistration();
            for (MiniRouterDFSCluster.RouterContext routerContext : testCluster.getRouters()) {
                ActiveNamenodeResolver resolver = routerContext.getRouter().getNamenodeResolver();
                Assertions.assertNotNull((Object)resolver.getNamespaces());
                Assertions.assertFalse((boolean)resolver.getNamespaces().isEmpty());
            }
        }
        finally {
            if (testCluster != null) {
                testCluster.shutdown();
            }
            UserGroupInformation.reset();
            SecurityConfUtil.destroy();
        }
    }
}

