/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestRouterMultiRack {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static DistributedFileSystem routerFs;
    private static MiniRouterDFSCluster.NamenodeContext nnContext0;
    private static MiniRouterDFSCluster.NamenodeContext nnContext1;
    private static DistributedFileSystem nnFs0;
    private static DistributedFileSystem nnFs1;

    @BeforeAll
    public static void setUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 2, MultipleDestinationMountTableResolver.class);
        Configuration routerConf = new RouterConfigBuilder().stateStore().admin().quota().rpc().build();
        Configuration hdfsConf = new Configuration(false);
        cluster.addNamenodeOverrides(hdfsConf);
        cluster.addRouterOverrides(routerConf);
        cluster.setNumDatanodesPerNameservice(9);
        cluster.setIndependentDNs();
        cluster.setRacks(new String[]{"/rack1", "/rack1", "/rack1", "/rack2", "/rack2", "/rack2", "/rack3", "/rack3", "/rack3", "/rack4", "/rack4", "/rack4", "/rack5", "/rack5", "/rack5", "/rack6", "/rack6", "/rack6"});
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        routerContext = cluster.getRandomRouter();
        routerFs = (DistributedFileSystem)routerContext.getFileSystem();
        nnContext0 = cluster.getNamenode("ns0", null);
        nnContext1 = cluster.getNamenode("ns1", null);
        nnFs0 = (DistributedFileSystem)nnContext0.getFileSystem();
        nnFs1 = (DistributedFileSystem)nnContext1.getFileSystem();
    }

    @AfterAll
    public static void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testGetECTopologyResultForPolicies() throws IOException {
        routerFs.enableErasureCodingPolicy("RS-6-3-1024k");
        ECTopologyVerifierResult result = routerFs.getECTopologyResultForPolicies(new String[0]);
        Assertions.assertTrue((boolean)result.isSupported());
        result = routerFs.getECTopologyResultForPolicies(new String[]{"RS-10-4-1024k"});
        Assertions.assertFalse((boolean)result.isSupported());
        result = routerFs.getECTopologyResultForPolicies(new String[]{"RS-10-4-1024k", "RS-3-2-1024k"});
        Assertions.assertFalse((boolean)result.isSupported());
        result = routerFs.getECTopologyResultForPolicies(new String[]{"XOR-2-1-1024k", "RS-3-2-1024k"});
        Assertions.assertTrue((boolean)result.isSupported());
        result = routerFs.getECTopologyResultForPolicies(new String[]{"RS-10-4-1024k", "RS-3-2-1024k"});
        Assertions.assertFalse((boolean)result.isSupported());
        routerFs.enableErasureCodingPolicy("RS-10-4-1024k");
        result = routerFs.getECTopologyResultForPolicies(new String[0]);
        Assertions.assertFalse((boolean)result.isSupported());
        nnFs0.disableErasureCodingPolicy("RS-10-4-1024k");
        nnFs1.enableErasureCodingPolicy("RS-10-4-1024k");
        result = routerFs.getECTopologyResultForPolicies(new String[0]);
        Assertions.assertFalse((boolean)result.isSupported());
        nnFs1.disableErasureCodingPolicy("RS-10-4-1024k");
        nnFs0.enableErasureCodingPolicy("RS-10-4-1024k");
        result = routerFs.getECTopologyResultForPolicies(new String[0]);
        Assertions.assertFalse((boolean)result.isSupported());
    }
}

