/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientProtocol;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestRouterMountTable {
    protected static StateStoreDFSCluster cluster;
    protected static MiniRouterDFSCluster.NamenodeContext nnContext0;
    protected static MiniRouterDFSCluster.NamenodeContext nnContext1;
    protected static MiniRouterDFSCluster.RouterContext routerContext;
    protected static MountTableResolver mountTable;
    protected static ClientProtocol routerProtocol;
    protected static long startTime;
    protected static FileSystem nnFs0;
    protected static FileSystem nnFs1;
    protected static FileSystem routerFs;

    @BeforeAll
    public static void globalSetUp() throws Exception {
        startTime = Time.now();
        cluster = new StateStoreDFSCluster(false, 2);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        conf.setInt("dfs.federation.router.fs-limits.max-component-length", 20);
        cluster.addRouterOverrides(conf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        nnContext0 = cluster.getNamenode("ns0", null);
        nnContext1 = cluster.getNamenode("ns1", null);
        nnFs0 = nnContext0.getFileSystem();
        nnFs1 = nnContext1.getFileSystem();
        routerContext = cluster.getRandomRouter();
        routerFs = routerContext.getFileSystem();
        Router router = routerContext.getRouter();
        routerProtocol = routerContext.getClient().getNamenode();
        mountTable = (MountTableResolver)router.getSubclusterResolver();
    }

    @AfterAll
    public static void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @AfterEach
    public void clearMountTable() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        GetMountTableEntriesRequest req1 = GetMountTableEntriesRequest.newInstance((String)"/");
        GetMountTableEntriesResponse response = mountTableManager.getMountTableEntries(req1);
        for (MountTable entry : response.getEntries()) {
            RemoveMountTableEntryRequest req2 = RemoveMountTableEntryRequest.newInstance((String)entry.getSourcePath());
            mountTableManager.removeMountTableEntry(req2);
        }
        mountTable.setDefaultNSEnable(true);
    }

    @Test
    public void testReadOnly() throws Exception {
        MountTable readOnlyEntry = MountTable.newInstance((String)"/readonly", Collections.singletonMap("ns0", "/testdir"));
        readOnlyEntry.setReadOnly(true);
        Assertions.assertTrue((boolean)this.addMountTable(readOnlyEntry));
        MountTable regularEntry = MountTable.newInstance((String)"/regular", Collections.singletonMap("ns0", "/testdir"));
        Assertions.assertTrue((boolean)this.addMountTable(regularEntry));
        Assertions.assertTrue((boolean)routerFs.mkdirs(new Path("/regular/newdir")));
        FileStatus dirStatusNn = nnFs0.getFileStatus(new Path("/testdir/newdir"));
        Assertions.assertTrue((boolean)dirStatusNn.isDirectory());
        FileStatus dirStatusRegular = routerFs.getFileStatus(new Path("/regular/newdir"));
        Assertions.assertTrue((boolean)dirStatusRegular.isDirectory());
        FileStatus dirStatusReadOnly = routerFs.getFileStatus(new Path("/readonly/newdir"));
        Assertions.assertTrue((boolean)dirStatusReadOnly.isDirectory());
        try {
            routerFs.mkdirs(new Path("/readonly/newdirfail"));
            Assertions.fail((String)"We should not be able to write into a read only mount point");
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            Assertions.assertTrue((boolean)msg.startsWith("/readonly/newdirfail is in a read only mount point"));
        }
    }

    private boolean addMountTable(MountTable entry) throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)entry);
        AddMountTableEntryResponse addResponse = mountTableManager.addMountTableEntry(addRequest);
        mountTable.loadCache(true);
        return addResponse.getStatus();
    }

    private boolean updateMountTable(MountTable entry) throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance((MountTable)entry);
        UpdateMountTableEntryResponse updateResponse = mountTableManager.updateMountTableEntry(updateRequest);
        mountTable.loadCache(true);
        return updateResponse.getStatus();
    }

    @Test
    public void testMountPointLimit() throws Exception {
        MountTable addEntry = MountTable.newInstance((String)"/testdir-shortlength", Collections.singletonMap("ns0", "/testdir-shortlength"));
        Assertions.assertTrue((boolean)this.addMountTable(addEntry));
        MountTable longAddEntry = MountTable.newInstance((String)"/testdir-verylonglength", Collections.singletonMap("ns0", "/testdir-verylonglength"));
        LambdaTestUtils.intercept(IOException.class, (String)"The maximum path component name limit of testdir-verylonglength in directory /testdir-verylonglength is exceeded", () -> this.addMountTable(longAddEntry));
        MountTable updateEntry = MountTable.newInstance((String)"/testdir-shortlength", Collections.singletonMap("ns0", "/testdir-shortlength-change-to-long"));
        LambdaTestUtils.intercept(IOException.class, (String)"The maximum path component name limit of testdir-shortlength-change-to-long in directory /testdir-shortlength-change-to-long is exceeded", () -> this.updateMountTable(updateEntry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListFilesTime() throws Exception {
        try {
            FileStatus[] iterator;
            MountTable addEntry = MountTable.newInstance((String)"/testdir", Collections.singletonMap("ns0", "/testdir"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testdir2", Collections.singletonMap("ns0", "/testdir2"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testdir/subdir", Collections.singletonMap("ns0", "/testdir/subdir"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testdir3/subdir1", Collections.singletonMap("ns0", "/testdir3"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testA/testB/testC/testD", Collections.singletonMap("ns0", "/test"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            Assertions.assertTrue((boolean)nnFs0.mkdirs(new Path("/newdir")));
            TreeMap<Object, Long> pathModTime = new TreeMap<Object, Long>();
            for (FileStatus[] mount : mountTable.getMountPoints("/")) {
                if (mountTable.getMountPoint("/" + (String)mount) != null) {
                    pathModTime.put(mount, mountTable.getMountPoint("/" + (String)mount).getDateModified());
                    continue;
                }
                List entries = mountTable.getMounts("/" + (String)mount);
                for (MountTable entry : entries) {
                    if (pathModTime.get(mount) != null && (Long)pathModTime.get(mount) >= entry.getDateModified()) continue;
                    pathModTime.put(mount, entry.getDateModified());
                }
            }
            for (FileStatus file : iterator = nnFs0.listStatus(new Path("/"))) {
                pathModTime.put(file.getPath().getName(), file.getModificationTime());
            }
            DirectoryListing listing = routerProtocol.getListing("/", HdfsFileStatus.EMPTY_NAME, false);
            Iterator pathModTimeIterator = pathModTime.keySet().iterator();
            for (HdfsFileStatus f : listing.getPartialListing()) {
                String fileName = (String)pathModTimeIterator.next();
                String currentFile = f.getFullPath(new Path("/")).getName();
                Long currentTime = f.getModificationTime();
                Long expectedTime = (Long)pathModTime.get(currentFile);
                Assertions.assertEquals((Object)currentFile, (Object)fileName);
                Assertions.assertTrue((currentTime > startTime ? 1 : 0) != 0);
                Assertions.assertEquals((Long)currentTime, (Long)expectedTime);
            }
            Assertions.assertEquals((int)pathModTime.size(), (int)listing.getPartialListing().length);
        }
        finally {
            nnFs0.delete(new Path("/newdir"), true);
        }
    }

    @Test
    public void testGetMountPointStatusWithIOException() throws IOException, InterruptedException {
        try {
            MountTable addEntry = MountTable.newInstance((String)"/testA", Collections.singletonMap("ns0", "/testA"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testA/testB", Collections.singletonMap("ns0", "/testA/testB"));
            addEntry.setOwnerName("userB");
            addEntry.setGroupName("groupB");
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testB", Collections.singletonMap("ns0", "/test1/testB"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            Assertions.assertTrue((boolean)nnFs0.mkdirs(new Path("/test1")));
            nnFs0.setPermission(new Path("/test1"), FsPermission.createImmutable((short)448));
            UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"mock_user", (String[])new String[]{"mock_group"});
            LambdaTestUtils.doAs((UserGroupInformation)user, () -> this.getListing("/testA"));
        }
        finally {
            nnFs0.delete(new Path("/test1"), true);
        }
    }

    @Test
    public void testGetMountPointStatus() throws IOException {
        MountTable addEntry = MountTable.newInstance((String)"/testA/testB/testC/testD", Collections.singletonMap("ns0", "/testA/testB/testC/testD"));
        Assertions.assertTrue((boolean)this.addMountTable(addEntry));
        RouterClientProtocol clientProtocol = new RouterClientProtocol(nnFs0.getConf(), routerContext.getRouter().getRpcServer());
        String src = "/";
        String child = "testA";
        Path childPath = new Path(src, child);
        HdfsFileStatus dirStatus = clientProtocol.getMountPointStatus(childPath.toString(), 0, 0L);
        Assertions.assertEquals((Object)child, (Object)dirStatus.getLocalName());
        String src1 = "/testA";
        String child1 = "testB";
        Path childPath1 = new Path(src1, child1);
        HdfsFileStatus dirStatus1 = clientProtocol.getMountPointStatus(childPath1.toString(), 0, 0L);
        Assertions.assertEquals((Object)child1, (Object)dirStatus1.getLocalName());
        String src2 = "/testA/testB";
        String child2 = "testC";
        Path childPath2 = new Path(src2, child2);
        HdfsFileStatus dirStatus2 = clientProtocol.getMountPointStatus(childPath2.toString(), 0, 0L);
        Assertions.assertEquals((Object)child2, (Object)dirStatus2.getLocalName());
        HdfsFileStatus dirStatus3 = clientProtocol.getMountPointStatus(childPath2.toString(), 0, 0L, false);
        Assertions.assertTrue((boolean)dirStatus3.isEmptyLocalName());
    }

    private void getListing(String testPath) throws IOException, URISyntaxException {
        ClientProtocol clientProtocol1 = routerContext.getClient().getNamenode();
        DirectoryListing listing = clientProtocol1.getListing(testPath, HdfsFileStatus.EMPTY_NAME, false);
        Assertions.assertEquals((int)1, (int)listing.getPartialListing().length);
        HdfsFileStatus fileStatus = listing.getPartialListing()[0];
        String currentOwner = fileStatus.getOwner();
        String currentGroup = fileStatus.getGroup();
        String currentFileName = fileStatus.getFullPath(new Path("/")).getName();
        Assertions.assertEquals((Object)"testB", (Object)currentFileName);
        Assertions.assertEquals((Object)"userB", (Object)currentOwner);
        Assertions.assertEquals((Object)"groupB", (Object)currentGroup);
    }

    @Test
    public void testListNonExistPath() throws Exception {
        mountTable.setDefaultNSEnable(false);
        LambdaTestUtils.intercept(FileNotFoundException.class, (String)"File /base does not exist.", (String)"Expect FileNotFoundException.", () -> routerFs.listStatus(new Path("/base")));
    }

    @Test
    public void testListWhenDisableDefaultMountTable() throws IOException {
        mountTable.setDefaultNSEnable(false);
        Assertions.assertTrue((boolean)this.addMountTable(this.createEntry("/base/dir1", "ns0", "/base/dir1", "group2", "owner2", (short)488)));
        Assertions.assertTrue((boolean)this.addMountTable(this.createEntry("/base/dir2", "ns0", "/base/dir2", "group3", "owner3", (short)493)));
        FileStatus[] list = routerFs.listStatus(new Path("/base"));
        Assertions.assertEquals((int)2, (int)list.length);
        for (FileStatus status : list) {
            if (status.getPath().toUri().getPath().equals("/base/dir1")) {
                Assertions.assertEquals((Object)"group2", (Object)status.getGroup());
                Assertions.assertEquals((Object)"owner2", (Object)status.getOwner());
                Assertions.assertEquals((short)488, (short)status.getPermission().toShort());
                continue;
            }
            if (status.getPath().toUri().getPath().equals("/base/dir2")) {
                Assertions.assertEquals((Object)"group3", (Object)status.getGroup());
                Assertions.assertEquals((Object)"owner3", (Object)status.getOwner());
                Assertions.assertEquals((short)493, (short)status.getPermission().toShort());
                continue;
            }
            Assertions.fail((String)"list result should be either /base/dir1 or /base/dir2.");
        }
    }

    @Test
    public void testMountTablePermissionsNoDest() throws IOException {
        MountTable addEntry = MountTable.newInstance((String)"/testdir1", Collections.singletonMap("ns0", "/tmp/testdir1"));
        addEntry.setGroupName("group1");
        addEntry.setOwnerName("owner1");
        addEntry.setMode(FsPermission.createImmutable((short)509));
        Assertions.assertTrue((boolean)this.addMountTable(addEntry));
        FileStatus[] list = routerFs.listStatus(new Path("/"));
        Assertions.assertEquals((Object)"group1", (Object)list[0].getGroup());
        Assertions.assertEquals((Object)"owner1", (Object)list[0].getOwner());
        Assertions.assertEquals((short)509, (short)list[0].getPermission().toShort());
    }

    private MountTable createEntry(String mountPath, String ns, String remotePath, String group, String owner, short permission) throws IOException {
        MountTable entry = MountTable.newInstance((String)mountPath, Collections.singletonMap(ns, remotePath));
        entry.setGroupName(group);
        entry.setOwnerName(owner);
        entry.setMode(FsPermission.createImmutable((short)permission));
        return entry;
    }

    @Test
    public void testMountTablePermissionsWithDest() throws IOException {
        try {
            MountTable addEntry = MountTable.newInstance((String)"/testdir", Collections.singletonMap("ns0", "/tmp/testdir"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            nnFs0.mkdirs(new Path("/tmp/testdir"));
            nnFs0.setOwner(new Path("/tmp/testdir"), "Aowner", "Agroup");
            nnFs0.setPermission(new Path("/tmp/testdir"), FsPermission.createImmutable((short)775));
            FileStatus[] list = routerFs.listStatus(new Path("/"));
            Assertions.assertEquals((Object)"Agroup", (Object)list[0].getGroup());
            Assertions.assertEquals((Object)"Aowner", (Object)list[0].getOwner());
            Assertions.assertEquals((short)775, (short)list[0].getPermission().toShort());
        }
        finally {
            nnFs0.delete(new Path("/tmp"), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMountTablePermissionsMultiDest() throws IOException {
        try {
            HashMap<String, String> destMap = new HashMap<String, String>();
            destMap.put("ns0", "/tmp/testdir");
            destMap.put("ns1", "/tmp/testdir01");
            MountTable addEntry = MountTable.newInstance((String)"/testdir", destMap);
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            nnFs0.mkdirs(new Path("/tmp/testdir"));
            nnFs0.setOwner(new Path("/tmp/testdir"), "Aowner", "Agroup");
            nnFs0.setPermission(new Path("/tmp/testdir"), FsPermission.createImmutable((short)775));
            nnFs1.mkdirs(new Path("/tmp/testdir01"));
            nnFs1.setOwner(new Path("/tmp/testdir01"), "Aowner", "Agroup");
            nnFs1.setPermission(new Path("/tmp/testdir01"), FsPermission.createImmutable((short)775));
            FileStatus[] list = routerFs.listStatus(new Path("/"));
            Assertions.assertEquals((Object)"Agroup", (Object)list[0].getGroup());
            Assertions.assertEquals((Object)"Aowner", (Object)list[0].getOwner());
            Assertions.assertEquals((short)775, (short)list[0].getPermission().toShort());
        }
        finally {
            nnFs0.delete(new Path("/tmp"), true);
            nnFs1.delete(new Path("/tmp"), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMountTablePermissionsMultiDestDifferentPerm() throws IOException {
        try {
            HashMap<String, String> destMap = new HashMap<String, String>();
            destMap.put("ns0", "/tmp/testdir");
            destMap.put("ns1", "/tmp/testdir01");
            MountTable addEntry = MountTable.newInstance((String)"/testdir", destMap);
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            nnFs0.mkdirs(new Path("/tmp/testdir"));
            nnFs0.setOwner(new Path("/tmp/testdir"), "Aowner", "Agroup");
            nnFs0.setPermission(new Path("/tmp/testdir"), FsPermission.createImmutable((short)775));
            nnFs1.mkdirs(new Path("/tmp/testdir01"));
            nnFs1.setOwner(new Path("/tmp/testdir01"), "Aowner01", "Agroup01");
            nnFs1.setPermission(new Path("/tmp/testdir01"), FsPermission.createImmutable((short)755));
            FileStatus[] list = routerFs.listStatus(new Path("/"));
            Assertions.assertTrue(("Agroup".equals(list[0].getGroup()) || "Agroup01".equals(list[0].getGroup()) ? 1 : 0) != 0);
            Assertions.assertTrue(("Aowner".equals(list[0].getOwner()) || "Aowner01".equals(list[0].getOwner()) ? 1 : 0) != 0);
            Assertions.assertTrue((775 == list[0].getPermission().toShort() || 755 == list[0].getPermission().toShort() ? 1 : 0) != 0);
        }
        finally {
            nnFs0.delete(new Path("/tmp"), true);
            nnFs1.delete(new Path("/tmp"), true);
        }
    }

    @Test
    public void testMountPointResolved() throws IOException {
        MountTable addEntry = MountTable.newInstance((String)"/testdir", Collections.singletonMap("ns0", "/tmp/testdir"));
        addEntry.setGroupName("group1");
        addEntry.setOwnerName("owner1");
        Assertions.assertTrue((boolean)this.addMountTable(addEntry));
        HdfsFileStatus finfo = routerProtocol.getFileInfo("/testdir");
        FileStatus[] finfo1 = routerFs.listStatus(new Path("/"));
        Assertions.assertEquals((Object)"owner1", (Object)finfo.getOwner());
        Assertions.assertEquals((Object)"owner1", (Object)finfo1[0].getOwner());
        Assertions.assertEquals((Object)"group1", (Object)finfo.getGroup());
        Assertions.assertEquals((Object)"group1", (Object)finfo1[0].getGroup());
    }

    @Test
    public void testMountPointChildren() throws IOException {
        try {
            MountTable addEntry = MountTable.newInstance((String)"/testdir", Collections.singletonMap("ns0", "/tmp/testdir"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            nnFs0.mkdirs(new Path("/tmp/testdir"));
            nnFs0.mkdirs(new Path("/tmp/testdir/1"));
            nnFs0.mkdirs(new Path("/tmp/testdir/2"));
            FileStatus[] finfo1 = routerFs.listStatus(new Path("/"));
            Assertions.assertEquals((int)2, (int)((HdfsFileStatus)finfo1[0]).getChildrenNum());
        }
        finally {
            nnFs0.delete(new Path("/tmp"), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMountPointChildrenMultiDest() throws IOException {
        try {
            HashMap<String, String> destMap = new HashMap<String, String>();
            destMap.put("ns0", "/tmp/testdir");
            destMap.put("ns1", "/tmp/testdir01");
            MountTable addEntry = MountTable.newInstance((String)"/testdir", destMap);
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            nnFs0.mkdirs(new Path("/tmp/testdir"));
            nnFs1.mkdirs(new Path("/tmp/testdir01"));
            nnFs0.mkdirs(new Path("/tmp/testdir/1"));
            nnFs1.mkdirs(new Path("/tmp/testdir01/1"));
            FileStatus[] finfo1 = routerFs.listStatus(new Path("/"));
            Assertions.assertEquals((int)2, (int)((HdfsFileStatus)finfo1[0]).getChildrenNum());
        }
        finally {
            nnFs0.delete(new Path("/tmp"), true);
            nnFs1.delete(new Path("/tmp"), true);
        }
    }

    @Test
    public void testPathInException() throws Exception {
        MountTable addEntry = MountTable.newInstance((String)"/mount", Collections.singletonMap("ns0", "/tmp/testdir"));
        addEntry.setDestOrder(DestinationOrder.HASH_ALL);
        Assertions.assertTrue((boolean)this.addMountTable(addEntry));
        LambdaTestUtils.intercept(FileNotFoundException.class, (String)"Directory/File does not exist /mount/file", () -> routerFs.setOwner(new Path("/mount/file"), "user", "group"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetListingWithTrailingSlash() throws IOException {
        try {
            MountTable addEntry = MountTable.newInstance((String)"/testlist", Collections.singletonMap("ns0", "/testlist"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testlist/tmp0", Collections.singletonMap("ns0", "/testlist/tmp0"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testlist/tmp1", Collections.singletonMap("ns1", "/testlist/tmp1"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            nnFs0.mkdirs(new Path("/testlist/tmp0"));
            nnFs1.mkdirs(new Path("/testlist/tmp1"));
            DirectoryListing list = routerProtocol.getListing("/testlist/", HdfsFileStatus.EMPTY_NAME, false);
            HdfsFileStatus[] statuses = list.getPartialListing();
            Assertions.assertEquals((int)2, (int)statuses.length);
        }
        finally {
            nnFs0.delete(new Path("/testlist/tmp0"), true);
            nnFs1.delete(new Path("/testlist/tmp1"), true);
        }
    }

    @Test
    public void testGetFileInfoWithMountPoint() throws IOException {
        try {
            MountTable addEntry = MountTable.newInstance((String)"/testgetfileinfo/ns1/dir", Collections.singletonMap("ns1", "/testgetfileinfo/ns1/dir"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            nnFs1.mkdirs(new Path("/testgetfileinfo/ns1/dir"));
            FileStatus fileStatus = routerFs.getFileStatus(new Path("/testgetfileinfo/ns1"));
            Assertions.assertEquals((Object)fileStatus.getPath().toUri().getPath(), (Object)"/testgetfileinfo/ns1");
            fileStatus = routerFs.getFileStatus(new Path("/testgetfileinfo/ns1/dir"));
            Assertions.assertEquals((Object)fileStatus.getPath().toUri().getPath(), (Object)"/testgetfileinfo/ns1/dir");
        }
        finally {
            nnFs1.delete(new Path("/testgetfileinfo/ns1/dir"), true);
        }
    }

    @Test
    public void testDeleteMountPoint() throws Exception {
        try {
            MountTable addEntry = MountTable.newInstance((String)"/testdelete/subdir", Collections.singletonMap("ns0", "/testdelete/subdir"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            nnFs0.mkdirs(new Path("/testdelete/subdir"));
            LambdaTestUtils.intercept(AccessControlException.class, (String)"The operation is not allowed because there are mount points: subdir under the path: /testdelete", () -> routerFs.delete(new Path("/testdelete"), true));
            LambdaTestUtils.intercept(AccessControlException.class, (String)"The operation is not allowed because there are mount points: subdir under the path: /testdelete", () -> routerFs.delete(new Path("/testdelete"), false));
            LambdaTestUtils.intercept(AccessControlException.class, (String)"The operation is not allowed because the path: /testdelete/subdir is a mount point", () -> routerFs.delete(new Path("/testdelete/subdir"), true));
            LambdaTestUtils.intercept(AccessControlException.class, (String)"The operation is not allowed because the path: /testdelete/subdir is a mount point", () -> routerFs.delete(new Path("/testdelete/subdir"), false));
        }
        finally {
            nnFs0.delete(new Path("/testdelete"), true);
        }
    }

    @Test
    public void testRenameMountPoint() throws Exception {
        try {
            MountTable addEntry = MountTable.newInstance((String)"/testrename1/sub", Collections.singletonMap("ns0", "/testrename1/sub"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testrename2/sub", Collections.singletonMap("ns0", "/testrename2/sub"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            nnFs0.mkdirs(new Path("/testrename1/sub/sub"));
            nnFs0.mkdirs(new Path("/testrename2"));
            Assertions.assertTrue((boolean)nnFs0.exists(new Path("/testrename1/sub/sub")));
            Assertions.assertFalse((boolean)nnFs0.exists(new Path("/testrename2/sub")));
            Assertions.assertTrue((boolean)routerFs.rename(new Path("/testrename1/sub/sub"), new Path("/testrename2")));
            Assertions.assertFalse((boolean)nnFs0.exists(new Path("/testrename1/sub/sub")));
            Assertions.assertTrue((boolean)nnFs0.exists(new Path("/testrename2/sub")));
            nnFs0.mkdirs(new Path("/testrename1/sub/sub"));
            Assertions.assertFalse((boolean)routerFs.rename(new Path("/testrename1/sub/sub"), new Path("/testrename2")));
            LambdaTestUtils.intercept(AccessControlException.class, (String)"The operation is not allowed because the path: /testrename1/sub is a mount point", () -> routerFs.rename(new Path("/testrename1/sub"), new Path("/testrename2/sub")));
            LambdaTestUtils.intercept(AccessControlException.class, (String)"The operation is not allowed because there are mount points: sub under the path: /testrename1", () -> routerFs.rename(new Path("/testrename1"), new Path("/testrename2/sub")));
        }
        finally {
            nnFs0.delete(new Path("/testrename1"), true);
            nnFs0.delete(new Path("/testrename2"), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListStatusMountPoint() throws Exception {
        try {
            MountTable addEntry = MountTable.newInstance((String)"/mount/testLsMountEntry", Collections.singletonMap("ns0", "/testLsMountEntryDest"));
            Assertions.assertTrue((boolean)this.addMountTable(addEntry));
            nnFs0.mkdirs(new Path("/testLsMountEntryDest"));
            DistributedFileSystem routerDfs = (DistributedFileSystem)routerFs;
            Path mountPath = new Path("/mount/testLsMountEntry");
            routerDfs.setErasureCodingPolicy(mountPath, "RS-6-3-1024k");
            Assertions.assertTrue((boolean)routerDfs.listStatus(new Path("/mount"))[0].isErasureCoded());
        }
        finally {
            nnFs0.delete(new Path("/testLsMountEntryDest"), true);
        }
    }

    @Test
    public void testGetEnclosingRoot() throws Exception {
        MountTable readOnlyEntry = MountTable.newInstance((String)"/readonly", Collections.singletonMap("ns0", "/testdir"));
        readOnlyEntry.setReadOnly(true);
        Assertions.assertTrue((boolean)this.addMountTable(readOnlyEntry));
        Assertions.assertEquals((Object)routerFs.getEnclosingRoot(new Path("/readonly")), (Object)new Path("/readonly"));
        Assertions.assertEquals((Object)routerFs.getEnclosingRoot(new Path("/regular")), (Object)new Path("/"));
        Assertions.assertEquals((Object)routerFs.getEnclosingRoot(new Path("/regular")), (Object)routerFs.getEnclosingRoot(routerFs.getEnclosingRoot(new Path("/regular"))));
        MountTable regularEntry = MountTable.newInstance((String)"/regular", Collections.singletonMap("ns0", "/testdir"));
        Assertions.assertTrue((boolean)this.addMountTable(regularEntry));
        Assertions.assertEquals((Object)routerFs.getEnclosingRoot(new Path("/regular")), (Object)new Path("/regular"));
        Assertions.assertEquals((Object)routerFs.getEnclosingRoot(new Path("/regular/pathDNE")), (Object)new Path("/regular"));
    }
}

