/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MockNamenode;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterMissingFolderMulti {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterMissingFolderMulti.class);
    private static final int NUM_FILES = 10;
    private Map<String, MockNamenode> namenodes = new HashMap<String, MockNamenode>();
    private Router router;

    @BeforeEach
    public void setup() throws Exception {
        LOG.info("Start the Namenodes");
        HdfsConfiguration nnConf = new HdfsConfiguration();
        nnConf.setInt("dfs.namenode.handler.count", 10);
        for (String nsId : Arrays.asList("ns0", "ns1")) {
            MockNamenode nn = new MockNamenode(nsId, (Configuration)nnConf);
            nn.transitionToActive();
            nn.addFileSystemMock();
            this.namenodes.put(nsId, nn);
        }
        LOG.info("Start the Routers");
        Configuration routerConf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        routerConf.set("dfs.federation.router.rpc-address", "0.0.0.0:0");
        routerConf.set("dfs.federation.router.http-address", "0.0.0.0:0");
        routerConf.set("dfs.federation.router.admin-address", "0.0.0.0:0");
        Configuration stateStoreConf = FederationStateStoreTestUtils.getStateStoreConfiguration();
        stateStoreConf.setClass("dfs.federation.router.namenode.resolver.client.class", MembershipNamenodeResolver.class, ActiveNamenodeResolver.class);
        stateStoreConf.setClass("dfs.federation.router.file.resolver.client.class", MultipleDestinationMountTableResolver.class, FileSubclusterResolver.class);
        routerConf.addResource(stateStoreConf);
        routerConf.setBoolean("dfs.federation.router.client.allow-partial-listing", false);
        this.router = new Router();
        this.router.init(routerConf);
        this.router.start();
        LOG.info("Registering the subclusters in the Routers");
        MockNamenode.registerSubclusters(this.router, this.namenodes.values());
    }

    @AfterEach
    public void cleanup() throws Exception {
        LOG.info("Stopping the cluster");
        for (MockNamenode nn : this.namenodes.values()) {
            nn.stop();
        }
        this.namenodes.clear();
        if (this.router != null) {
            this.router.stop();
            this.router = null;
        }
    }

    @Test
    public void testSuccess() throws Exception {
        FileSystem fs = FederationTestUtils.getFileSystem(this.router);
        String mountPoint = "/test-success";
        FederationTestUtils.createMountTableEntry(this.router, mountPoint, DestinationOrder.HASH_ALL, this.namenodes.keySet());
        Path folder = new Path(mountPoint, "folder-all");
        for (int i = 0; i < 10; ++i) {
            Path file = new Path(folder, "file-" + i + ".txt");
            FSDataOutputStream os = fs.create(file);
            os.close();
        }
        FileStatus[] files = fs.listStatus(folder);
        Assertions.assertEquals((int)10, (int)files.length);
        ContentSummary contentSummary = fs.getContentSummary(folder);
        Assertions.assertEquals((long)10L, (long)contentSummary.getFileCount());
    }

    @Test
    public void testFileNotFound() throws Exception {
        FileSystem fs = FederationTestUtils.getFileSystem(this.router);
        String mountPoint = "/test-non-existing";
        FederationTestUtils.createMountTableEntry(this.router, mountPoint, DestinationOrder.HASH_ALL, this.namenodes.keySet());
        Path path = new Path(mountPoint, "folder-all");
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.listStatus(path));
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.getContentSummary(path));
    }

    @Test
    public void testOneMissing() throws Exception {
        FileSystem fs = FederationTestUtils.getFileSystem(this.router);
        String mountPoint = "/test-one-missing";
        FederationTestUtils.createMountTableEntry(this.router, mountPoint, DestinationOrder.HASH_ALL, this.namenodes.keySet());
        MockNamenode nn = this.namenodes.get("ns0");
        int nnRpcPort = nn.getRPCPort();
        FileSystem nnFs = FederationTestUtils.getFileSystem(nnRpcPort);
        Path folder = new Path(mountPoint, "folder-all");
        for (int i = 0; i < 10; ++i) {
            Path file = new Path(folder, "file-" + i + ".txt");
            FSDataOutputStream os = nnFs.create(file);
            os.close();
        }
        FileStatus[] files = fs.listStatus(folder);
        Assertions.assertEquals((int)10, (int)files.length);
        ContentSummary summary = fs.getContentSummary(folder);
        Assertions.assertEquals((long)10L, (long)summary.getFileAndDirectoryCount());
    }
}

