/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.http.HttpServer2;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRouterHttpServerXFrame {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRouterXFrame() throws IOException {
        Configuration conf = new RouterConfigBuilder().http().build();
        conf.setBoolean("dfs.xframe.enabled", true);
        conf.set("dfs.xframe.value", HttpServer2.XFrameOption.SAMEORIGIN.toString());
        Router router = new Router();
        try {
            router.init(conf);
            router.start();
            InetSocketAddress httpAddress = router.getHttpServerAddress();
            URL url = URI.create("http://" + httpAddress.getHostName() + ":" + httpAddress.getPort()).toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
            Assertions.assertNotNull((Object)xfoHeader, (String)"X-FRAME-OPTIONS is absent in the header");
            Assertions.assertTrue((boolean)xfoHeader.endsWith(HttpServer2.XFrameOption.SAMEORIGIN.toString()));
        }
        finally {
            router.stop();
            router.close();
        }
    }
}

