/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ImpersonationProvider;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.fedbalance.DistCpProcedure;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterFederationRenameInKerberosEnv
extends ClientBaseWithFixes {
    private static final int NUM_SUBCLUSTERS = 2;
    private static final int NUM_DNS = 6;
    private static String clientPrincipal = "client@EXAMPLE.COM";
    private static String serverPrincipal = System.getenv().get("USERNAME") + "/localhost@EXAMPLE.COM";
    private static String keytab = new File(System.getProperty("test.dir", "target"), UUID.randomUUID().toString()).getAbsolutePath();
    private static Configuration baseConf = new Configuration(false);
    private static MiniKdc kdc;
    private MiniRouterDFSCluster cluster;
    private MiniRouterDFSCluster.RouterContext router;

    @BeforeAll
    public static void globalSetUp() throws Exception {
        File workDir = new File(System.getProperty("test.dir", "target"));
        kdc = new MiniKdc(MiniKdc.createConf(), workDir);
        kdc.start();
        kdc.createPrincipal(new File(keytab), new String[]{clientPrincipal, serverPrincipal});
        baseConf.setBoolean("hadoop.caller.context.enabled", true);
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)baseConf);
        baseConf.set("dfs.federation.router.kerberos.principal", serverPrincipal);
        baseConf.set("dfs.federation.router.keytab.file", keytab);
        baseConf.set("dfs.namenode.kerberos.principal", serverPrincipal);
        baseConf.set("dfs.namenode.keytab.file", keytab);
        baseConf.set("dfs.datanode.kerberos.principal", serverPrincipal);
        baseConf.set("dfs.datanode.keytab.file", keytab);
        baseConf.setBoolean("dfs.block.access.token.enable", true);
        baseConf.set("dfs.data.transfer.protection", "");
        baseConf.setBoolean("ignore.secure.ports.for.testing", true);
        baseConf.setClass("hadoop.security.impersonation.provider.class", AllowUserImpersonationProvider.class, ImpersonationProvider.class);
        DistCpProcedure.enableForTest();
    }

    @AfterAll
    public static void globalTearDown() {
        kdc.stop();
        DistCpProcedure.disableForTest();
    }

    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.cluster.shutdown();
    }

    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.cluster = new MiniRouterDFSCluster(false, 2);
        this.cluster.setNumDatanodesPerNameservice(6);
        this.cluster.addNamenodeOverrides(baseConf);
        this.cluster.setIndependentDNs();
        this.cluster.startCluster();
        String journal = "hdfs://" + this.cluster.getCluster().getNameNode(1).getClientNamenodeAddress() + "/journal";
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().routerRenameOption().set("hdfs.fedbalance.procedure.scheduler.journal.uri", journal).set("dfs.federation.router.federation.rename.map", "1").set("dfs.federation.router.federation.rename.bandwidth", "1").set("zk-dt-secret-manager.zkConnectionString", this.hostPort).set("zk-dt-secret-manager.zkAuthType", "none").set("yarn.resourcemanager.principal", serverPrincipal).build();
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        this.cluster.addRouterOverrides(baseConf);
        this.cluster.addRouterOverrides(routerConf);
        this.cluster.startRouters();
        this.cluster.registerNamenodes();
        this.cluster.waitNamenodeRegistration();
        this.cluster.getCluster().getNamesystem(0).getBlockManager().getDatanodeManager().setHeartbeatInterval(1L);
        this.cluster.getCluster().getNamesystem(1).getBlockManager().getDatanodeManager().setHeartbeatInterval(1L);
        this.cluster.getCluster().getNamesystem(0).getBlockManager().getDatanodeManager().setHeartbeatExpireInterval(3000L);
        this.cluster.getCluster().getNamesystem(1).getBlockManager().getDatanodeManager().setHeartbeatExpireInterval(3000L);
        this.cluster.installMockLocations();
        this.cluster.createTestDirectoriesNamenode();
        MiniRouterDFSCluster.RouterContext rndRouter = this.cluster.getRandomRouter();
        this.setRouter(rndRouter);
    }

    protected void prepareEnv(FileSystem fs, Path path, Path renamedPath) throws IOException {
        fs.setPermission(path.getParent(), FsPermission.createImmutable((short)511));
        fs.setPermission(renamedPath.getParent(), FsPermission.createImmutable((short)511));
        fs.mkdirs(path);
        String file = path.toString() + "/file";
        FederationTestUtils.createFile(fs, file, 32L);
        FederationTestUtils.verifyFileExists(fs, path.toString());
        FederationTestUtils.verifyFileExists(fs, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testRenameDir(MiniRouterDFSCluster.RouterContext testRouter, String path, String renamedPath, boolean exceptionExpected, Callable<Object> call) throws IOException {
        this.prepareEnv(testRouter.getFileSystem(), new Path(path), new Path(renamedPath));
        boolean exceptionThrown = false;
        try {
            call.call();
            Assertions.assertFalse((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), path));
            Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), renamedPath + "/file"));
        }
        catch (Exception ex) {
            exceptionThrown = true;
            Assertions.assertTrue((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), path + "/file"));
            Assertions.assertFalse((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), renamedPath));
        }
        finally {
            FileContext fileContext = testRouter.getFileContext();
            fileContext.delete(new Path(path), true);
            fileContext.delete(new Path(renamedPath), true);
        }
        if (exceptionExpected) {
            Assertions.assertTrue((boolean)exceptionThrown);
        } else {
            Assertions.assertFalse((boolean)exceptionThrown);
        }
    }

    protected void setRouter(MiniRouterDFSCluster.RouterContext r) throws IOException {
        this.router = r;
    }

    @Test
    public void testClientRename() throws IOException {
        String ns0 = this.cluster.getNameservices().get(0);
        String ns1 = this.cluster.getNameservices().get(1);
        String dir = this.cluster.getFederatedTestDirectoryForNS(ns0) + "/" + GenericTestUtils.getMethodName();
        String renamedDir = this.cluster.getFederatedTestDirectoryForNS(ns1) + "/" + GenericTestUtils.getMethodName();
        this.testRenameDir(this.router, dir, renamedDir, false, () -> {
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)clientPrincipal, (String)keytab);
            ugi.doAs(() -> {
                DFSClient client = this.router.getClient();
                ClientProtocol clientProtocol = client.getNamenode();
                clientProtocol.rename(dir, renamedDir);
                return null;
            });
            return null;
        });
    }

    private static class AllowUserImpersonationProvider
    extends Configured
    implements ImpersonationProvider {
        private AllowUserImpersonationProvider() {
        }

        public void init(String configurationPrefix) {
        }

        public void authorize(UserGroupInformation user, InetAddress remoteAddress) throws AuthorizationException {
            try {
                if (!user.getRealUser().getShortUserName().equals(UserGroupInformation.getCurrentUser().getShortUserName())) {
                    throw new AuthorizationException();
                }
            }
            catch (IOException ioe) {
                throw new AuthorizationException((Throwable)ioe);
            }
        }
    }
}

