/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.TestFileTruncate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterAllResolver {
    private static final String TEST_DIR_HASH_ALL = "/hashall";
    private static final String TEST_DIR_RANDOM = "/random";
    private static final String TEST_DIR_SPACE = "/space";
    private static final int NUM_NAMESPACES = 2;
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static FileSystem routerFs;
    private static List<FileSystem> nsFss;

    @BeforeEach
    public void setup() throws Exception {
        cluster = new StateStoreDFSCluster(false, 2, MultipleDestinationMountTableResolver.class);
        cluster.startCluster();
        Configuration routerConf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        routerContext = cluster.getRandomRouter();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
        this.createMountTableEntry(TEST_DIR_HASH_ALL, DestinationOrder.HASH_ALL);
        this.createMountTableEntry(TEST_DIR_RANDOM, DestinationOrder.RANDOM);
        this.createMountTableEntry(TEST_DIR_SPACE, DestinationOrder.SPACE);
        routerFs = routerContext.getFileSystem();
        for (String nsId : cluster.getNameservices()) {
            List<MiniRouterDFSCluster.NamenodeContext> nns = cluster.getNamenodes(nsId);
            for (MiniRouterDFSCluster.NamenodeContext nn : nns) {
                FileSystem nnFs = nn.getFileSystem();
                nsFss.add(nnFs);
            }
        }
        Assertions.assertEquals((int)2, (int)nsFss.size());
    }

    @AfterEach
    public void cleanup() {
        cluster.shutdown();
        cluster = null;
        routerContext = null;
        routerFs = null;
        nsFss.clear();
    }

    @Test
    public void testHashAll() throws Exception {
        this.testAll(TEST_DIR_HASH_ALL);
    }

    @Test
    public void testRandomAll() throws Exception {
        this.testAll(TEST_DIR_RANDOM);
    }

    @Test
    public void testSpaceAll() throws Exception {
        this.testAll(TEST_DIR_SPACE);
    }

    private void testAll(String path) throws Exception {
        routerFs.mkdirs(new Path(path + "/dir0"));
        routerFs.mkdirs(new Path(path + "/dir1"));
        routerFs.mkdirs(new Path(path + "/dir2/dir20"));
        routerFs.mkdirs(new Path(path + "/dir2/dir21"));
        routerFs.mkdirs(new Path(path + "/dir2/dir22"));
        routerFs.mkdirs(new Path(path + "/dir2/dir22/dir220"));
        routerFs.mkdirs(new Path(path + "/dir2/dir22/dir221"));
        routerFs.mkdirs(new Path(path + "/dir2/dir22/dir222"));
        this.assertDirsEverywhere(path, 9);
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir0/file1.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir0/file2.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir1/file2.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir1/file3.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir2/dir20/file4.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir2/dir20/file5.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir2/dir21/file6.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir2/dir21/file7.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir2/dir22/file8.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir2/dir22/file9.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir2/dir22/dir220/file10.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir2/dir22/dir220/file11.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir2/dir22/dir220/file12.txt");
        TestRouterAllResolver.createTestFile(routerFs, path + "/dir2/dir22/dir220/file13.txt");
        this.assertDirsEverywhere(path, 9);
        this.assertFilesDistributed(path, 14);
        String testFile = path + "/dir2/dir22/dir220/file-append.txt";
        TestRouterAllResolver.createTestFile(routerFs, testFile);
        Path testFilePath = new Path(testFile);
        Assertions.assertTrue((routerFs.getFileStatus(testFilePath).getLen() > 50L ? 1 : 0) != 0, (String)"Created file is too small");
        TestRouterAllResolver.appendTestFile(routerFs, testFile);
        Assertions.assertTrue((routerFs.getFileStatus(testFilePath).getLen() > 110L ? 1 : 0) != 0, (String)"Append file is too small");
        this.assertDirsEverywhere(path, 9);
        this.assertFilesDistributed(path, 15);
        String testTruncateFile = path + "/dir2/dir22/dir220/file-truncate.txt";
        TestRouterAllResolver.createTestFile(routerFs, testTruncateFile);
        Path testTruncateFilePath = new Path(testTruncateFile);
        routerFs.truncate(testTruncateFilePath, 10L);
        TestFileTruncate.checkBlockRecovery((Path)testTruncateFilePath, (DistributedFileSystem)((DistributedFileSystem)routerFs));
        Assertions.assertEquals((long)10L, (long)routerFs.getFileStatus(testTruncateFilePath).getLen(), (String)"Truncate file fails");
        this.assertDirsEverywhere(path, 9);
        this.assertFilesDistributed(path, 16);
        routerFs.delete(new Path(path + "/dir2/dir22/dir220"), true);
        this.assertDirsEverywhere(path, 8);
        this.assertFilesDistributed(path, 10);
        routerFs.delete(new Path(path + "/dir0"), true);
        routerFs.delete(new Path(path + "/dir1"), true);
        routerFs.delete(new Path(path + "/dir2"), true);
        this.assertDirsEverywhere(path, 0);
        this.assertFilesDistributed(path, 0);
    }

    private void assertDirsEverywhere(String path, int expectedNumDirs) throws IOException {
        List<FileStatus> files = this.listRecursive(routerFs, path);
        int numDirs = 0;
        for (FileStatus file : files) {
            if (!file.isDirectory()) continue;
            ++numDirs;
            Path dirPath = file.getPath();
            Path checkPath = TestRouterAllResolver.getRelativePath(dirPath);
            for (FileSystem nsFs : nsFss) {
                FileStatus fileStatus1 = nsFs.getFileStatus(checkPath);
                Assertions.assertTrue((boolean)fileStatus1.isDirectory(), (String)(file + " should be a directory"));
            }
        }
        Assertions.assertEquals((int)expectedNumDirs, (int)numDirs);
    }

    private void assertFilesDistributed(String path, int expectedNumFiles) throws IOException {
        List<FileStatus> routerFiles = this.listRecursive(routerFs, path);
        LinkedList<List<FileStatus>> nssFiles = new LinkedList<List<FileStatus>>();
        for (FileSystem nsFs : nsFss) {
            List<FileStatus> nsFiles = this.listRecursive(nsFs, path);
            nssFiles.add(nsFiles);
        }
        int numRouterFiles = TestRouterAllResolver.getNumTxtFiles(routerFiles);
        Assertions.assertEquals((int)numRouterFiles, (int)expectedNumFiles);
        LinkedList<Integer> numNsFiles = new LinkedList<Integer>();
        int sumNsFiles = 0;
        for (int i = 0; i < 2; ++i) {
            List nsFiles = (List)nssFiles.get(i);
            int numFiles = TestRouterAllResolver.getNumTxtFiles(nsFiles);
            numNsFiles.add(numFiles);
            sumNsFiles += numFiles;
        }
        Assertions.assertEquals((int)numRouterFiles, (int)sumNsFiles);
        if (expectedNumFiles > 0) {
            Iterator iterator = numNsFiles.iterator();
            while (iterator.hasNext()) {
                int numFiles = (Integer)iterator.next();
                Assertions.assertTrue((numFiles > 0 ? 1 : 0) != 0, (String)("Files not distributed: " + numNsFiles));
            }
        }
    }

    private static void createTestFile(FileSystem fs, String filename) throws IOException {
        Path path = new Path(filename);
        FSDataOutputStream os = fs.create(path);
        os.writeUTF("Test data " + filename);
        os.close();
        FSDataInputStream is = fs.open(path);
        String read = is.readUTF();
        Assertions.assertEquals((Object)("Test data " + filename), (Object)read);
        is.close();
    }

    private static void appendTestFile(FileSystem fs, String filename) throws IOException {
        Path path = new Path(filename);
        FSDataOutputStream os = fs.append(path);
        os.writeUTF("Test append data " + filename);
        os.close();
        FSDataInputStream is = fs.open(path);
        String read = is.readUTF();
        Assertions.assertEquals((Object)read, (Object)("Test data " + filename));
        read = is.readUTF();
        Assertions.assertEquals((Object)read, (Object)("Test append data " + filename));
        is.close();
    }

    private static int getNumTxtFiles(List<FileStatus> files) {
        int numFiles = 0;
        for (FileStatus file : files) {
            if (!file.getPath().getName().endsWith(".txt")) continue;
            ++numFiles;
        }
        return numFiles;
    }

    private static Path getRelativePath(Path path) {
        URI uri = path.toUri();
        String uriPath = uri.getPath();
        return new Path(uriPath);
    }

    private List<FileStatus> listRecursive(FileSystem fs, String path) throws IOException {
        LinkedList<FileStatus> ret = new LinkedList<FileStatus>();
        LinkedList<Path> temp = new LinkedList<Path>();
        temp.add(new Path(path));
        while (!temp.isEmpty()) {
            Path p = (Path)temp.remove(0);
            for (FileStatus fileStatus : fs.listStatus(p)) {
                ret.add(fileStatus);
                if (!fileStatus.isDirectory()) continue;
                temp.add(fileStatus.getPath());
            }
        }
        return ret;
    }

    private void createMountTableEntry(String mountPoint, DestinationOrder order) throws Exception {
        RouterClient admin = routerContext.getAdminClient();
        MountTableManager mountTable = admin.getMountTableManager();
        HashMap<String, String> destMap = new HashMap<String, String>();
        for (String nsId : cluster.getNameservices()) {
            destMap.put(nsId, mountPoint);
        }
        MountTable newEntry = MountTable.newInstance((String)mountPoint, destMap);
        newEntry.setDestOrder(order);
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        boolean created = addResponse.getStatus();
        Assertions.assertTrue((boolean)created);
        Router router = routerContext.getRouter();
        StateStoreService stateStore = router.getStateStore();
        stateStore.refreshCaches(true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)mountPoint);
        GetMountTableEntriesResponse getResponse = mountTable.getMountTableEntries(getRequest);
        List entries = getResponse.getEntries();
        Assertions.assertEquals((int)1, (int)entries.size());
        Assertions.assertEquals((Object)mountPoint, (Object)((MountTable)entries.get(0)).getSourcePath());
    }

    static {
        nsFss = new LinkedList<FileSystem>();
    }
}

