/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.router.PoolAlignmentContext;
import org.apache.hadoop.hdfs.server.federation.router.RouterStateIdContext;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPoolAlignmentContext {
    @Test
    public void testNamenodeRequestsOnlyUsePoolLocalStateID() {
        RouterStateIdContext routerStateIdContext = new RouterStateIdContext(new Configuration());
        String namespaceId = "namespace1";
        routerStateIdContext.getNamespaceStateId(namespaceId).accumulate(20L);
        PoolAlignmentContext poolContext1 = new PoolAlignmentContext(routerStateIdContext, namespaceId);
        PoolAlignmentContext poolContext2 = new PoolAlignmentContext(routerStateIdContext, namespaceId);
        this.assertRequestHeaderStateId(poolContext1, Long.MIN_VALUE);
        this.assertRequestHeaderStateId(poolContext2, Long.MIN_VALUE);
        Assertions.assertEquals((long)20L, (long)poolContext1.getLastSeenStateId());
        Assertions.assertEquals((long)20L, (long)poolContext2.getLastSeenStateId());
        poolContext1.advanceClientStateId(Long.valueOf(30L));
        this.assertRequestHeaderStateId(poolContext1, 30L);
        this.assertRequestHeaderStateId(poolContext2, Long.MIN_VALUE);
        Assertions.assertEquals((long)20L, (long)poolContext1.getLastSeenStateId());
        Assertions.assertEquals((long)20L, (long)poolContext2.getLastSeenStateId());
    }

    private void assertRequestHeaderStateId(PoolAlignmentContext poolAlignmentContext, Long expectedValue) {
        RpcHeaderProtos.RpcRequestHeaderProto.Builder builder = RpcHeaderProtos.RpcRequestHeaderProto.newBuilder();
        poolAlignmentContext.updateRequestState(builder);
        Assertions.assertEquals((Long)expectedValue, (long)builder.getStateId());
    }

    @Test
    public void testWhenNamenodeStopsSendingStateId() {
        RouterStateIdContext routerStateIdContext = new RouterStateIdContext(new Configuration());
        String namespaceId = "namespace1";
        PoolAlignmentContext poolContext = new PoolAlignmentContext(routerStateIdContext, namespaceId);
        poolContext.receiveResponseState(this.getRpcResponseHeader(10L));
        Assertions.assertEquals((long)10L, (long)poolContext.getLastSeenStateId());
        this.assertRequestHeaderStateId(poolContext, Long.MIN_VALUE);
        poolContext.advanceClientStateId(Long.valueOf(10L));
        this.assertRequestHeaderStateId(poolContext, 10L);
        poolContext.receiveResponseState(this.getRpcResponseHeader(0L));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)poolContext.getLastSeenStateId());
        this.assertRequestHeaderStateId(poolContext, Long.MIN_VALUE);
    }

    private RpcHeaderProtos.RpcResponseHeaderProto getRpcResponseHeader(long stateID) {
        return RpcHeaderProtos.RpcResponseHeaderProto.newBuilder().setCallId(1).setStatus(RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.SUCCESS).setStateId(stateID).build();
    }
}

