/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationRPCMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.router.NamenodeHeartbeatService;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNoNamenodesAvailableLongTime {
    private static final long CACHE_FLUSH_INTERVAL_MS = 10000L;
    private StateStoreDFSCluster cluster;
    private FileSystem fileSystem;
    private MiniRouterDFSCluster.RouterContext routerContext;
    private FederationRPCMetrics rpcMetrics;

    @AfterEach
    public void cleanup() throws IOException {
        this.rpcMetrics = null;
        this.routerContext = null;
        if (this.fileSystem != null) {
            this.fileSystem.close();
            this.fileSystem = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void setupCluster(int numNameservices, int numberOfObserver, boolean useObserver) throws Exception {
        if (!useObserver) {
            numberOfObserver = 0;
        }
        int numberOfNamenode = 2 + numberOfObserver;
        this.cluster = new StateStoreDFSCluster(true, numNameservices, numberOfNamenode, MiniRouterDFSCluster.DEFAULT_HEARTBEAT_INTERVAL_MS, 10000L);
        Configuration routerConf = new RouterConfigBuilder().stateStore().metrics().admin().rpc().heartbeat().build();
        if (useObserver) {
            routerConf.setBoolean("dfs.federation.router.observer.read.default", true);
            routerConf.setBoolean("dfs.ha.tail-edits.in-progress", true);
            routerConf.set("dfs.ha.tail-edits.period", "0ms");
        }
        routerConf.setInt("dfs.federation.router.client.thread-size", 4);
        this.cluster.setNumDatanodesPerNameservice(0);
        this.cluster.addRouterOverrides(routerConf);
        this.cluster.startCluster();
        if (this.cluster.isHighAvailability()) {
            for (String ns : this.cluster.getNameservices()) {
                List<MiniRouterDFSCluster.NamenodeContext> nnList = this.cluster.getNamenodes(ns);
                this.cluster.switchToActive(ns, nnList.get(0).getNamenodeId());
                this.cluster.switchToStandby(ns, nnList.get(1).getNamenodeId());
                for (int i = 2; i < numberOfNamenode; ++i) {
                    this.cluster.switchToObserver(ns, nnList.get(i).getNamenodeId());
                }
            }
        }
        this.cluster.startRouters();
        this.cluster.waitClusterUp();
    }

    private void initEnv(int numberOfObserver, boolean useObserver) throws Exception {
        this.setupCluster(1, numberOfObserver, useObserver);
        this.transitionActiveToStandby();
        this.allRoutersHeartbeat();
        this.allRoutersLoadCache();
        List<MiniRouterDFSCluster.NamenodeContext> namenodes = this.cluster.getNamenodes();
        for (MiniRouterDFSCluster.NamenodeContext namenodeContext : namenodes) {
            Assertions.assertNotEquals((int)HAServiceProtocol.HAServiceState.ACTIVE.ordinal(), (int)namenodeContext.getNamenode().getNameNodeState());
        }
        this.routerContext = this.cluster.getRandomRouter();
        this.setSecondNonObserverNamenodeInTheRouterCacheActive(numberOfObserver, false);
        this.allRoutersHeartbeat();
        this.rpcMetrics = this.routerContext.getRouter().getRpcServer().getRPCMetrics();
        Assertions.assertTrue((boolean)this.routerCacheNoActiveNamenode(this.routerContext, "ns0", useObserver));
        this.routerContext.getConf().setInt("dfs.client.retry.max.attempts", 1);
        this.fileSystem = useObserver ? this.routerContext.getFileSystemWithObserverReadProxyProvider() : this.routerContext.getFileSystemWithConfiguredFailoverProxyProvider();
    }

    @Test
    public void testShouldRotatedCache() throws Exception {
        this.initEnv(0, false);
        Assertions.assertTrue((boolean)this.routerCacheNoActiveNamenode(this.routerContext, "ns0", false));
        Path path = new Path("/test.file");
        this.fileSystem.create(path);
        Assertions.assertEquals((long)1L, (long)this.rpcMetrics.getProxyOpNoNamenodes());
        Assertions.assertTrue((boolean)this.routerCacheNoActiveNamenode(this.routerContext, "ns0", false));
    }

    @Test
    public void testShouldNotBeRotatedCache() throws Exception {
        this.testShouldRotatedCache();
        long proxyOpNoNamenodes = this.rpcMetrics.getProxyOpNoNamenodes();
        Path path = new Path("/test.file");
        this.fileSystem.setPermission(path, FsPermission.createImmutable((short)416));
        Assertions.assertEquals((long)proxyOpNoNamenodes, (long)this.rpcMetrics.getProxyOpNoNamenodes());
        Assertions.assertTrue((boolean)this.routerCacheNoActiveNamenode(this.routerContext, "ns0", false));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.DEFAULT, (AclEntryType)AclEntryType.USER, (String)"foo", (FsAction)FsAction.ALL)});
        try {
            this.fileSystem.setAcl(path, (List)aclSpec);
        }
        catch (RemoteException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("org.apache.hadoop.hdfs.server.federation.router.NoNamenodesAvailableException: No namenodes available under nameservice ns0"));
            Assertions.assertTrue((boolean)e.getMessage().contains("org.apache.hadoop.hdfs.protocol.AclException: Invalid ACL: only directories may have a default ACL. Path: /test.file"));
        }
        Assertions.assertEquals((long)(proxyOpNoNamenodes + 3L), (long)this.rpcMetrics.getProxyOpNoNamenodes());
        proxyOpNoNamenodes = this.rpcMetrics.getProxyOpNoNamenodes();
        Assertions.assertTrue((boolean)this.routerCacheNoActiveNamenode(this.routerContext, "ns0", false));
        this.fileSystem.getFileStatus(path);
        Assertions.assertEquals((long)proxyOpNoNamenodes, (long)this.rpcMetrics.getProxyOpNoNamenodes());
        Assertions.assertTrue((boolean)this.routerCacheNoActiveNamenode(this.routerContext, "ns0", false));
    }

    @Test
    public void testUseObserver() throws Exception {
        this.initEnv(2, true);
        Path path = new Path("/");
        Assertions.assertTrue((boolean)this.routerCacheNoActiveNamenode(this.routerContext, "ns0", true));
        this.fileSystem.getFileStatus(path);
        Assertions.assertEquals((long)1L, (long)this.rpcMetrics.getObserverProxyOps());
        Assertions.assertEquals((long)1L, (long)this.rpcMetrics.getProxyOpNoNamenodes());
        Assertions.assertTrue((boolean)this.routerCacheNoActiveNamenode(this.routerContext, "ns0", true));
    }

    @Test
    public void testAtLeastOneObserverNormal() throws Exception {
        this.initEnv(2, true);
        this.stopObserver(1);
        this.fileSystem.getFileStatus(new Path("/"));
        Assertions.assertEquals((long)1L, (long)this.rpcMetrics.getProxyOpNoNamenodes());
        Assertions.assertEquals((long)1L, (long)this.rpcMetrics.getObserverProxyOps());
        Assertions.assertTrue((boolean)this.routerCacheNoActiveNamenode(this.routerContext, "ns0", true));
    }

    @Test
    public void testAllObserverAbnormality() throws Exception {
        this.initEnv(2, true);
        this.stopObserver(2);
        this.fileSystem.getFileStatus(new Path("/"));
        Assertions.assertEquals((long)2L, (long)this.rpcMetrics.getProxyOpFailureCommunicate());
        Assertions.assertEquals((long)2L, (long)this.rpcMetrics.getProxyOpNoNamenodes());
        Assertions.assertTrue((boolean)this.routerCacheNoActiveNamenode(this.routerContext, "ns0", true));
    }

    private boolean routerCacheNoActiveNamenode(MiniRouterDFSCluster.RouterContext context, String nsId, boolean useObserver) throws IOException {
        List namenodes = context.getRouter().getNamenodeResolver().getNamenodesForNameserviceId(nsId, useObserver);
        for (FederationNamenodeContext namenode : namenodes) {
            if (namenode.getState() != FederationNamenodeServiceState.ACTIVE) continue;
            return false;
        }
        return true;
    }

    private void allRoutersLoadCache() {
        for (MiniRouterDFSCluster.RouterContext context : this.cluster.getRouters()) {
            context.getRouter().getStateStore().refreshCaches(true);
        }
    }

    private void setSecondNonObserverNamenodeInTheRouterCacheActive(int numberOfObserver, boolean useObserver) throws IOException {
        List ns0 = this.routerContext.getRouter().getNamenodeResolver().getNamenodesForNameserviceId("ns0", useObserver);
        String nsId = ((FederationNamenodeContext)ns0.get(numberOfObserver + 1)).getNamenodeId();
        this.cluster.switchToActive("ns0", nsId);
        Assertions.assertEquals((int)HAServiceProtocol.HAServiceState.ACTIVE.ordinal(), (int)this.cluster.getNamenode("ns0", nsId).getNamenode().getNameNodeState());
    }

    private void allRoutersHeartbeat() throws IOException {
        for (MiniRouterDFSCluster.RouterContext context : this.cluster.getRouters()) {
            Collection heartbeatServices = context.getRouter().getNamenodeHeartbeatServices();
            for (NamenodeHeartbeatService service : heartbeatServices) {
                service.periodicInvoke();
            }
        }
    }

    private void transitionActiveToStandby() {
        if (this.cluster.isHighAvailability()) {
            for (String ns : this.cluster.getNameservices()) {
                List<MiniRouterDFSCluster.NamenodeContext> nnList = this.cluster.getNamenodes(ns);
                for (MiniRouterDFSCluster.NamenodeContext namenodeContext : nnList) {
                    if (!namenodeContext.getNamenode().isActiveState()) continue;
                    this.cluster.switchToStandby(ns, namenodeContext.getNamenodeId());
                }
            }
        }
    }

    private void stopObserver(int num) {
        int numNns = this.cluster.getNamenodes().size();
        for (int nnIndex = 0; nnIndex < numNns && num > 0; ++nnIndex) {
            NameNode nameNode = this.cluster.getCluster().getNameNode(nnIndex);
            if (nameNode == null || !nameNode.isObserverState()) continue;
            this.cluster.getCluster().shutdownNameNode(nnIndex);
            --num;
        }
    }
}

