/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDisableRouterQuota {
    private static Router router;

    @BeforeAll
    public static void setUp() throws Exception {
        router = new Router();
        Configuration routerConf = new RouterConfigBuilder().quota(false).rpc().build();
        routerConf.set("dfs.federation.router.rpc-address", "0.0.0.0:0");
        router.init(routerConf);
        router.setRouterId("TestRouterId");
        router.start();
    }

    @AfterAll
    public static void tearDown() throws IOException {
        if (router != null) {
            router.stop();
            router.close();
        }
    }

    @BeforeEach
    public void checkDisableQuota() {
        Assertions.assertFalse((boolean)router.isQuotaEnabled());
    }

    @Test
    public void testSetQuota() throws Exception {
        long nsQuota = 1024L;
        long ssQuota = 1024L;
        Quota quotaModule = router.getRpcServer().getQuotaModule();
        LambdaTestUtils.intercept(IOException.class, (String)"The quota system is disabled in Router.", (String)"The setQuota call should fail.", () -> quotaModule.setQuota("/test", nsQuota, ssQuota, null, false));
        LambdaTestUtils.intercept(IOException.class, (String)"The quota system is disabled in Router.", (String)"The setQuota call should fail.", () -> quotaModule.setQuota("/test", nsQuota, ssQuota, null, true));
    }

    @Test
    public void testGetQuotaUsage() throws Exception {
        try {
            Quota quotaModule = router.getRpcServer().getQuotaModule();
            quotaModule.getQuotaUsage("/test");
            Assertions.fail((String)"The getQuotaUsage call should fail.");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"The quota system is disabled in Router.", (Throwable)ioe);
        }
    }

    @Test
    public void testGetGlobalQuota() throws Exception {
        LambdaTestUtils.intercept(IOException.class, (String)"The quota system is disabled in Router.", (String)"The getGlobalQuota call should fail.", () -> {
            Quota quotaModule = router.getRpcServer().getQuotaModule();
            quotaModule.getGlobalQuota("/test");
        });
    }
}

