/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.lang.reflect.Method;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterNetworkTopologyServlet;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.ValueSource;

class RouterServerHelper
implements BeforeEachCallback,
AfterAllCallback {
    private static final ThreadLocal<RouterServerHelper> TEST_ROUTER_SERVER_TL = new InheritableThreadLocal<RouterServerHelper>();

    RouterServerHelper() {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Method testMethod = context.getRequiredTestMethod();
        ValueSource enumAnnotation = testMethod.getAnnotation(ValueSource.class);
        if (enumAnnotation != null) {
            String[] strings;
            for (String rpcMode : strings = enumAnnotation.strings()) {
                if (TEST_ROUTER_SERVER_TL.get() != null) continue;
                TestRouterNetworkTopologyServlet.setUp(rpcMode);
            }
        }
        TEST_ROUTER_SERVER_TL.set(this);
    }

    public void afterAll(ExtensionContext context) {
        if (TestRouterNetworkTopologyServlet.clusterWithDatanodes != null) {
            TestRouterNetworkTopologyServlet.clusterWithDatanodes.shutdown();
            TestRouterNetworkTopologyServlet.clusterWithDatanodes = null;
        }
        if (TestRouterNetworkTopologyServlet.clusterNoDatanodes != null) {
            TestRouterNetworkTopologyServlet.clusterNoDatanodes.shutdown();
            TestRouterNetworkTopologyServlet.clusterNoDatanodes = null;
        }
        TEST_ROUTER_SERVER_TL.remove();
    }
}

