/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver.order;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.resolver.order.LeaderFollowerResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.OrderedResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestLeaderFollowerResolver {
    @Test
    public void testResolve() throws Exception {
        Configuration conf = new Configuration();
        Router router = (Router)Mockito.mock(Router.class);
        LeaderFollowerResolver leaderFollowerResolver = new LeaderFollowerResolver();
        MultipleDestinationMountTableResolver resolver = new MultipleDestinationMountTableResolver(conf, router);
        resolver.addResolver(DestinationOrder.LEADER_FOLLOWER, (OrderedResolver)leaderFollowerResolver);
        LinkedHashMap<String, String> mapLocal = new LinkedHashMap<String, String>();
        mapLocal.put("subcluster2", "/local");
        mapLocal.put("subcluster0", "/local");
        mapLocal.put("subcluster1", "/local");
        MountTable localEntry = MountTable.newInstance((String)"/local", mapLocal);
        localEntry.setDestOrder(DestinationOrder.LEADER_FOLLOWER);
        resolver.addEntry(localEntry);
        PathLocation dest = resolver.getDestinationForPath("/local/file0.txt");
        TestLeaderFollowerResolver.assertDestination("subcluster2", dest);
    }

    private static void assertDestination(String expectedNsId, PathLocation loc) {
        List dests = loc.getDestinations();
        RemoteLocation dest = (RemoteLocation)dests.get(0);
        Assertions.assertEquals((Object)expectedNsId, (Object)dest.getNameserviceId());
    }
}

