/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver.order;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.AvailableSpaceResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.resolver.order.OrderedResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipStats;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.impl.pb.MembershipStatsPBImpl;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestAvailableSpaceResolver {
    private static final int SUBCLUSTER_NUM = 10;

    @Test
    public void testResolverWithNoPreference() throws IOException {
        MultipleDestinationMountTableResolver mountTableResolver = this.mockAvailableSpaceResolver(1.0f);
        PathLocation loc = mountTableResolver.getDestinationForPath("/space");
        Assertions.assertEquals((Object)"subcluster9", (Object)((RemoteLocation)loc.getDestinations().get(0)).getNameserviceId());
        loc = mountTableResolver.getDestinationForPath("/space/subdir");
        Assertions.assertEquals((Object)"subcluster9", (Object)((RemoteLocation)loc.getDestinations().get(0)).getNameserviceId());
    }

    @Test
    public void testResolverWithDefaultPreference() throws IOException {
        PathLocation loc;
        MultipleDestinationMountTableResolver mountTableResolver = this.mockAvailableSpaceResolver(0.6f);
        int retries = 10;
        int retryTimes = 0;
        for (retryTimes = 0; retryTimes < retries && "subcluster9".equals(((RemoteLocation)(loc = mountTableResolver.getDestinationForPath("/space")).getDestinations().get(0)).getNameserviceId()); ++retryTimes) {
        }
        Assertions.assertNotEquals((int)retries, (int)retryTimes);
    }

    private MultipleDestinationMountTableResolver mockAvailableSpaceResolver(float balancerPreference) throws IOException {
        Configuration conf = new Configuration();
        conf.setFloat("dfs.federation.router.available-space-resolver.balanced-space-preference-fraction", balancerPreference);
        Router router = (Router)Mockito.mock(Router.class);
        StateStoreService stateStore = (StateStoreService)Mockito.mock(StateStoreService.class);
        MembershipStore membership = (MembershipStore)Mockito.mock(MembershipStore.class);
        Mockito.when((Object)router.getStateStore()).thenReturn((Object)stateStore);
        Mockito.when((Object)stateStore.getRegisteredRecordStore((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)membership);
        GetNamenodeRegistrationsResponse response = GetNamenodeRegistrationsResponse.newInstance();
        LinkedList<MembershipState> records = new LinkedList<MembershipState>();
        for (int i = 0; i < 10; ++i) {
            records.add(TestAvailableSpaceResolver.newMembershipState("subcluster" + i, i));
        }
        response.setNamenodeMemberships(records);
        Mockito.when((Object)membership.getNamenodeRegistrations((GetNamenodeRegistrationsRequest)ArgumentMatchers.any(GetNamenodeRegistrationsRequest.class))).thenReturn((Object)response);
        AvailableSpaceResolver resolver = new AvailableSpaceResolver(conf, router);
        MultipleDestinationMountTableResolver mountTableResolver = new MultipleDestinationMountTableResolver(conf, router);
        mountTableResolver.addResolver(DestinationOrder.SPACE, (OrderedResolver)resolver);
        HashMap<CallSite, String> destinations = new HashMap<CallSite, String>();
        for (int i = 0; i < 10; ++i) {
            destinations.put((CallSite)((Object)("subcluster" + i)), "/space");
        }
        MountTable spaceEntry = MountTable.newInstance((String)"/space", destinations);
        spaceEntry.setDestOrder(DestinationOrder.SPACE);
        mountTableResolver.addEntry(spaceEntry);
        return mountTableResolver;
    }

    public static MembershipState newMembershipState(String nameservice, long availableSpace) {
        MembershipState record = MembershipState.newInstance();
        record.setNameserviceId(nameservice);
        MembershipStatsPBImpl stats = new MembershipStatsPBImpl();
        stats.setAvailableSpace(availableSpace);
        record.setStats((MembershipStats)stats);
        return record;
    }

    @Test
    public void testSubclusterSpaceComparator() {
        this.verifyRank(0.0f, true, false);
        this.verifyRank(1.0f, true, true);
        this.verifyRank(0.5f, false, false);
        this.verifyRank(0.6f, false, false);
        try {
            this.verifyRank(2.0f, false, false);
            Assertions.fail((String)"Subcluster comparison should be failed.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"The balancer preference value should be in the range 0.0 - 1.0", (Throwable)e);
        }
        try {
            this.verifyRank(-1.0f, false, false);
            Assertions.fail((String)"Subcluster comparison should be failed.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"The balancer preference value should be in the range 0.0 - 1.0", (Throwable)e);
        }
    }

    private void verifyRank(float balancerPreference, boolean shouldOrdered, boolean isDesc) {
        int i;
        LinkedList<AvailableSpaceResolver.SubclusterAvailableSpace> subclusters = new LinkedList<AvailableSpaceResolver.SubclusterAvailableSpace>();
        for (int i2 = 0; i2 < 10; ++i2) {
            subclusters.add(new AvailableSpaceResolver.SubclusterAvailableSpace("subcluster" + i2, (long)i2));
        }
        if (shouldOrdered) {
            Collections.shuffle(subclusters);
        }
        AvailableSpaceResolver.SubclusterSpaceComparator comparator = new AvailableSpaceResolver.SubclusterSpaceComparator(balancerPreference);
        Collections.sort(subclusters, comparator);
        for (i = 9; i >= 0; --i) {
            AvailableSpaceResolver.SubclusterAvailableSpace cluster = (AvailableSpaceResolver.SubclusterAvailableSpace)subclusters.get(9 - i);
            if (shouldOrdered) {
                if (isDesc) {
                    Assertions.assertEquals((Object)("subcluster" + i), (Object)cluster.getNameserviceId());
                    Assertions.assertEquals((long)i, (long)cluster.getAvailableSpace());
                    continue;
                }
                Assertions.assertEquals((Object)("subcluster" + (9 - i)), (Object)cluster.getNameserviceId());
                Assertions.assertEquals((long)(9 - i), (long)cluster.getAvailableSpace());
                continue;
            }
            if (!cluster.getNameserviceId().equals("subcluster" + i) && cluster.getAvailableSpace() != (long)i) break;
        }
        if (!shouldOrdered) {
            Assertions.assertNotEquals((int)0, (int)i);
        }
        subclusters.clear();
    }

    @Test
    public void testChooseFirstNamespace() throws Exception {
        MultipleDestinationMountTableResolver mountTableResolver = this.mockAvailableSpaceResolver(1.0f);
        PathLocation loc = mountTableResolver.getDestinationForPath("/space");
        Assertions.assertEquals((Object)"subcluster9", (Object)loc.getDefaultLocation().getNameserviceId());
    }
}

