/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestNamenodeResolver {
    private static StateStoreService stateStore;
    private static ActiveNamenodeResolver namenodeResolver;

    @BeforeAll
    public static void create() throws Exception {
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration();
        conf.setLong("dfs.federation.router.store.membership.expiration", TimeUnit.SECONDS.toMillis(5L));
        stateStore = FederationStateStoreTestUtils.newStateStore(conf);
        Assertions.assertNotNull((Object)stateStore);
        namenodeResolver = new MembershipNamenodeResolver(conf, stateStore);
        namenodeResolver.setRouterId(FederationTestUtils.ROUTERS[0]);
    }

    @AfterAll
    public static void destroy() throws Exception {
        stateStore.stop();
        stateStore.close();
    }

    @BeforeEach
    public void setup() throws IOException, InterruptedException {
        stateStore.loadDriver();
        FederationStateStoreTestUtils.waitStateStore(stateStore, 10000L);
        boolean cleared = FederationStateStoreTestUtils.clearRecords(stateStore, MembershipState.class);
        Assertions.assertTrue((boolean)cleared);
    }

    @Test
    public void testShuffleObserverNNs() throws Exception {
        NamenodeStatusReport activeReport = FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(activeReport));
        NamenodeStatusReport standbyReport = FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(standbyReport));
        stateStore.refreshCaches(true);
        List withoutObserver = namenodeResolver.getNamenodesForNameserviceId(FederationTestUtils.NAMESERVICES[0], true);
        Assertions.assertEquals((int)2, (int)withoutObserver.size());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)((FederationNamenodeContext)withoutObserver.get(0)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.STANDBY, (Object)((FederationNamenodeContext)withoutObserver.get(1)).getState());
        withoutObserver = namenodeResolver.getNamenodesForNameserviceId(FederationTestUtils.NAMESERVICES[0], true);
        Assertions.assertEquals((int)2, (int)withoutObserver.size());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)((FederationNamenodeContext)withoutObserver.get(0)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.STANDBY, (Object)((FederationNamenodeContext)withoutObserver.get(1)).getState());
        NamenodeStatusReport observerReport1 = FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[2], HAServiceProtocol.HAServiceState.OBSERVER);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(observerReport1));
        stateStore.refreshCaches(true);
        List observerList = namenodeResolver.getNamenodesForNameserviceId(FederationTestUtils.NAMESERVICES[0], true);
        Assertions.assertEquals((int)3, (int)observerList.size());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.OBSERVER, (Object)((FederationNamenodeContext)observerList.get(0)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)((FederationNamenodeContext)observerList.get(1)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.STANDBY, (Object)((FederationNamenodeContext)observerList.get(2)).getState());
        observerList = namenodeResolver.getNamenodesForNameserviceId(FederationTestUtils.NAMESERVICES[0], true);
        Assertions.assertEquals((int)3, (int)observerList.size());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.OBSERVER, (Object)((FederationNamenodeContext)observerList.get(0)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)((FederationNamenodeContext)observerList.get(1)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.STANDBY, (Object)((FederationNamenodeContext)observerList.get(2)).getState());
        NamenodeStatusReport observerReport2 = FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[3], HAServiceProtocol.HAServiceState.OBSERVER);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(observerReport2));
        stateStore.refreshCaches(true);
        List observerList2 = namenodeResolver.getNamenodesForNameserviceId(FederationTestUtils.NAMESERVICES[0], true);
        Assertions.assertEquals((int)4, (int)observerList2.size());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.OBSERVER, (Object)((FederationNamenodeContext)observerList2.get(0)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.OBSERVER, (Object)((FederationNamenodeContext)observerList2.get(1)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)((FederationNamenodeContext)observerList2.get(2)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.STANDBY, (Object)((FederationNamenodeContext)observerList2.get(3)).getState());
        observerList2 = namenodeResolver.getNamenodesForNameserviceId(FederationTestUtils.NAMESERVICES[0], true);
        Assertions.assertEquals((int)4, (int)observerList2.size());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.OBSERVER, (Object)((FederationNamenodeContext)observerList2.get(0)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.OBSERVER, (Object)((FederationNamenodeContext)observerList2.get(1)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)((FederationNamenodeContext)observerList2.get(2)).getState());
        Assertions.assertEquals((Object)FederationNamenodeServiceState.STANDBY, (Object)((FederationNamenodeContext)observerList2.get(3)).getState());
        boolean hit = false;
        for (int i = 0; i < 1000; ++i) {
            List observerList3 = namenodeResolver.getNamenodesForNameserviceId(FederationTestUtils.NAMESERVICES[0], true);
            Assertions.assertEquals((Object)FederationNamenodeServiceState.OBSERVER, (Object)((FederationNamenodeContext)observerList3.get(0)).getState());
            Assertions.assertEquals((Object)FederationNamenodeServiceState.OBSERVER, (Object)((FederationNamenodeContext)observerList3.get(1)).getState());
            if (!((FederationNamenodeContext)observerList3.get(0)).getNamenodeId().equals(((FederationNamenodeContext)observerList2.get(1)).getNamenodeId()) || !((FederationNamenodeContext)observerList3.get(1)).getNamenodeId().equals(((FederationNamenodeContext)observerList2.get(0)).getNamenodeId())) continue;
            hit = true;
            break;
        }
        Assertions.assertTrue((boolean)hit);
    }

    @Test
    public void testStateStoreDisconnected() throws Exception {
        NamenodeStatusReport report = FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(report));
        stateStore.closeDriver();
        Assertions.assertFalse((boolean)stateStore.isDriverReady());
        stateStore.refreshCaches(true);
        List nns = namenodeResolver.getNamenodesForBlockPoolId(FederationTestUtils.NAMESERVICES[0]);
        Assertions.assertNull((Object)nns);
        FederationTestUtils.verifyException(namenodeResolver, "registerNamenode", StateStoreUnavailableException.class, new Class[]{NamenodeStatusReport.class}, new Object[]{report});
    }

    private void verifyFirstRegistration(String nsId, String nnId, int resultsCount, FederationNamenodeServiceState state) throws IOException {
        List namenodes = namenodeResolver.getNamenodesForNameserviceId(nsId, false);
        if (resultsCount == 0) {
            Assertions.assertNull((Object)namenodes);
        } else {
            Assertions.assertEquals((int)resultsCount, (int)namenodes.size());
            if (namenodes.size() > 0) {
                FederationNamenodeContext namenode = (FederationNamenodeContext)namenodes.get(0);
                Assertions.assertEquals((Object)state, (Object)namenode.getState());
                Assertions.assertEquals((Object)nnId, (Object)namenode.getNamenodeId());
            }
        }
    }

    @Test
    public void testRegistrationExpired() throws InterruptedException, IOException {
        NamenodeStatusReport report = FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(report));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], 1, FederationNamenodeServiceState.ACTIVE);
        Thread.sleep(6000L);
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], 0, FederationNamenodeServiceState.ACTIVE);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(report));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], 1, FederationNamenodeServiceState.ACTIVE);
    }

    @Test
    public void testRegistrationNamenodeSelection() throws InterruptedException, IOException {
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE)));
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], 2, FederationNamenodeServiceState.ACTIVE);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE)));
        Thread.sleep(6000L);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], 1, FederationNamenodeServiceState.STANDBY);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE)));
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], null)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], 2, FederationNamenodeServiceState.ACTIVE);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY)));
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], null)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], 2, FederationNamenodeServiceState.STANDBY);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], null)));
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY)));
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[2], HAServiceProtocol.HAServiceState.ACTIVE)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[2], 3, FederationNamenodeServiceState.ACTIVE);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.STANDBY)));
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[2], HAServiceProtocol.HAServiceState.STANDBY)));
        Thread.sleep(1500L);
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], 3, FederationNamenodeServiceState.STANDBY);
    }

    @Test
    public void testCacheUpdateOnNamenodeStateUpdate() throws IOException {
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.STANDBY)));
        stateStore.refreshCaches(true);
        FederationNamenodeContext namenode = (FederationNamenodeContext)namenodeResolver.getNamenodesForNameserviceId(FederationTestUtils.NAMESERVICES[0], false).get(0);
        Assertions.assertEquals((Object)FederationNamenodeServiceState.STANDBY, (Object)namenode.getState());
        String rpcAddr = namenode.getRpcAddress();
        InetSocketAddress inetAddr = TestNamenodeResolver.getInetSocketAddress(rpcAddr);
        namenodeResolver.updateActiveNamenode(FederationTestUtils.NAMESERVICES[0], inetAddr);
        FederationNamenodeContext namenode1 = (FederationNamenodeContext)namenodeResolver.getNamenodesForNameserviceId(FederationTestUtils.NAMESERVICES[0], false).get(0);
        Assertions.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)namenode1.getState(), (String)"The namenode state should be ACTIVE post update.");
    }

    @Test
    public void testCacheUpdateOnNamenodeStateUpdateWithIp() throws IOException {
        String rpcAddress = "127.0.0.1:10000";
        Assertions.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], "127.0.0.1:10000", HAServiceProtocol.HAServiceState.STANDBY)));
        stateStore.refreshCaches(true);
        InetSocketAddress inetAddr = TestNamenodeResolver.getInetSocketAddress("127.0.0.1:10000");
        namenodeResolver.updateActiveNamenode(FederationTestUtils.NAMESERVICES[0], inetAddr);
        FederationNamenodeContext namenode = (FederationNamenodeContext)namenodeResolver.getNamenodesForNameserviceId(FederationTestUtils.NAMESERVICES[0], false).get(0);
        Assertions.assertEquals((Object)FederationNamenodeServiceState.ACTIVE, (Object)namenode.getState(), (String)"The namenode state should be ACTIVE post update.");
    }

    private static InetSocketAddress getInetSocketAddress(String rpcAddr) {
        String[] rpcAddrArr = rpcAddr.split(":");
        int port = Integer.parseInt(rpcAddrArr[1]);
        String hostname = rpcAddrArr[0];
        return new InetSocketAddress(hostname, port);
    }
}

