/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.resolver.order.HashResolver;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestMultipleDestinationResolver {
    private MultipleDestinationMountTableResolver resolver;

    @BeforeEach
    public void setup() throws IOException {
        Configuration conf = new Configuration();
        this.resolver = new MultipleDestinationMountTableResolver(conf, null);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("subcluster0", "/tmp");
        this.resolver.addEntry(MountTable.newInstance((String)"/tmp", map1));
        HashMap<String, String> mapDefault = new HashMap<String, String>();
        mapDefault.put("subcluster0", "/");
        mapDefault.put("subcluster1", "/");
        mapDefault.put("subcluster2", "/");
        MountTable defaultEntry = MountTable.newInstance((String)"/", mapDefault);
        this.resolver.addEntry(defaultEntry);
        HashMap<String, String> mapHash = new HashMap<String, String>();
        mapHash.put("subcluster0", "/hash");
        mapHash.put("subcluster1", "/hash");
        mapHash.put("subcluster2", "/hash");
        MountTable hashEntry = MountTable.newInstance((String)"/hash", mapHash);
        hashEntry.setDestOrder(DestinationOrder.HASH);
        this.resolver.addEntry(hashEntry);
        HashMap<String, String> mapHashAll = new HashMap<String, String>();
        mapHashAll.put("subcluster0", "/hashall");
        mapHashAll.put("subcluster1", "/hashall");
        mapHashAll.put("subcluster2", "/hashall");
        MountTable hashEntryAll = MountTable.newInstance((String)"/hashall", mapHashAll);
        hashEntryAll.setDestOrder(DestinationOrder.HASH_ALL);
        this.resolver.addEntry(hashEntryAll);
        HashMap<String, String> mapLocal = new HashMap<String, String>();
        mapLocal.put("subcluster0", "/local");
        mapLocal.put("subcluster1", "/local");
        mapLocal.put("subcluster2", "/local");
        MountTable localEntry = MountTable.newInstance((String)"/local", mapLocal);
        localEntry.setDestOrder(DestinationOrder.LOCAL);
        this.resolver.addEntry(localEntry);
        HashMap<String, String> mapRandom = new HashMap<String, String>();
        mapRandom.put("subcluster0", "/random");
        mapRandom.put("subcluster1", "/random");
        mapRandom.put("subcluster2", "/random");
        MountTable randomEntry = MountTable.newInstance((String)"/random", mapRandom);
        randomEntry.setDestOrder(DestinationOrder.RANDOM);
        this.resolver.addEntry(randomEntry);
        HashMap<String, String> mapReadOnly = new HashMap<String, String>();
        mapReadOnly.put("subcluster0", "/readonly");
        mapReadOnly.put("subcluster1", "/readonly");
        mapReadOnly.put("subcluster2", "/readonly");
        MountTable readOnlyEntry = MountTable.newInstance((String)"/readonly", mapReadOnly);
        readOnlyEntry.setReadOnly(true);
        this.resolver.addEntry(readOnlyEntry);
        LinkedHashMap<String, String> leaderFollowerMap = new LinkedHashMap<String, String>();
        leaderFollowerMap.put("subcluster1", "/leaderfollower");
        leaderFollowerMap.put("subcluster0", "/leaderfollower");
        leaderFollowerMap.put("subcluster2", "/leaderfollower");
        MountTable leaderFollowerEntry = MountTable.newInstance((String)"/leaderfollower", leaderFollowerMap);
        leaderFollowerEntry.setDestOrder(DestinationOrder.LEADER_FOLLOWER);
        this.resolver.addEntry(leaderFollowerEntry);
    }

    @Test
    public void testHashEqualDistribution() throws IOException {
        this.testEvenDistribution("/hash");
        this.testEvenDistribution("/hash/folder0", false);
        this.testEvenDistribution("/hashall");
        this.testEvenDistribution("/hashall/folder0");
    }

    @Test
    public void testHashAll() throws IOException {
        PathLocation dest0 = this.resolver.getDestinationForPath("/hashall/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest0);
        PathLocation dest1 = this.resolver.getDestinationForPath("/hashall/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest1);
        PathLocation dest2 = this.resolver.getDestinationForPath("/hashall/folder0");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest2);
        PathLocation dest3 = this.resolver.getDestinationForPath("/hashall/folder0/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest3);
        PathLocation dest4 = this.resolver.getDestinationForPath("/hashall/folder0/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest4);
        PathLocation dest5 = this.resolver.getDestinationForPath("/hashall/folder0/folder0/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest5);
        PathLocation dest6 = this.resolver.getDestinationForPath("/hashall/folder0/folder0/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest6);
        PathLocation dest7 = this.resolver.getDestinationForPath("/hashall/folder0/folder0/file2.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest7);
        PathLocation dest8 = this.resolver.getDestinationForPath("/hashall/folder1");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest8);
        PathLocation dest9 = this.resolver.getDestinationForPath("/hashall/folder1/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest9);
        PathLocation dest10 = this.resolver.getDestinationForPath("/hashall/folder1/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest10);
        PathLocation dest11 = this.resolver.getDestinationForPath("/hashall/folder2");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest11);
        PathLocation dest12 = this.resolver.getDestinationForPath("/hashall/folder2/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest12);
        PathLocation dest13 = this.resolver.getDestinationForPath("/hashall/folder2/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest13);
        PathLocation dest14 = this.resolver.getDestinationForPath("/hashall/folder2/file2.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest14);
    }

    @Test
    public void testHashFirst() throws IOException {
        PathLocation dest0 = this.resolver.getDestinationForPath("/hashall/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest0);
        PathLocation dest1 = this.resolver.getDestinationForPath("/hashall/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest1);
        PathLocation dest2 = this.resolver.getDestinationForPath("/hash/folder0");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest2);
        PathLocation dest3 = this.resolver.getDestinationForPath("/hash/folder0/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest3);
        PathLocation dest4 = this.resolver.getDestinationForPath("/hash/folder0/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest4);
        PathLocation dest5 = this.resolver.getDestinationForPath("/hash/folder0/folder0/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest5);
        PathLocation dest6 = this.resolver.getDestinationForPath("/hash/folder0/folder0/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest6);
        PathLocation dest7 = this.resolver.getDestinationForPath("/hash/folder1");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest7);
        PathLocation dest8 = this.resolver.getDestinationForPath("/hash/folder1/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest8);
        PathLocation dest9 = this.resolver.getDestinationForPath("/hash/folder1/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest9);
        PathLocation dest10 = this.resolver.getDestinationForPath("/hash/folder2");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest10);
        PathLocation dest11 = this.resolver.getDestinationForPath("/hash/folder2/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest11);
        PathLocation dest12 = this.resolver.getDestinationForPath("/hash/folder2/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest12);
    }

    @Test
    public void testRandomEqualDistribution() throws IOException {
        this.testEvenDistribution("/random");
    }

    @Test
    public void testSingleDestination() throws IOException {
        for (int f = 0; f < 100; ++f) {
            String filename = "/tmp/b/c/file" + f + ".txt";
            PathLocation destination = this.resolver.getDestinationForPath(filename);
            RemoteLocation loc = destination.getDefaultLocation();
            Assertions.assertEquals((Object)"subcluster0", (Object)loc.getNameserviceId());
            Assertions.assertEquals((Object)filename, (Object)loc.getDest());
        }
    }

    @Test
    public void testResolveSubdirectories() throws Exception {
        Random r = new Random();
        String testDir = "/sort/testdir" + r.nextInt();
        String file1 = testDir + "/file1" + r.nextInt();
        String file2 = testDir + "/file2" + r.nextInt();
        PathLocation testDirLocation = this.resolver.getDestinationForPath(testDir);
        RemoteLocation defaultLoc = testDirLocation.getDefaultLocation();
        String testDirNamespace = defaultLoc.getNameserviceId();
        PathLocation file1Location = this.resolver.getDestinationForPath(file1);
        RemoteLocation defaultLoc1 = file1Location.getDefaultLocation();
        Assertions.assertEquals((Object)testDirNamespace, (Object)defaultLoc1.getNameserviceId());
        PathLocation file2Location = this.resolver.getDestinationForPath(file2);
        RemoteLocation defaultLoc2 = file2Location.getDefaultLocation();
        Assertions.assertEquals((Object)testDirNamespace, (Object)defaultLoc2.getNameserviceId());
    }

    @Test
    public void testExtractTempFileName() {
        for (String teststring : new String[]{"testfile1.txt.COPYING", "testfile1.txt._COPYING_", "testfile1.txt._COPYING_.attempt_1486662804109_0055_m_000042_0", "testfile1.txt.tmp", "_temp/testfile1.txt", "_temporary/testfile1.txt.af77e2ab-4bc5-4959-ae08-299c880ee6b8", "_temporary/0/_temporary/attempt_201706281636_0007_m_000003_46/testfile1.txt"}) {
            String finalName = HashResolver.extractTempFileName((String)teststring);
            Assertions.assertEquals((Object)"testfile1.txt", (Object)finalName);
        }
        Assertions.assertEquals((Object)"file1.txt.COPYING1", (Object)HashResolver.extractTempFileName((String)"file1.txt.COPYING1"));
        Assertions.assertEquals((Object)"file1.txt.tmp2", (Object)HashResolver.extractTempFileName((String)"file1.txt.tmp2"));
        String finalName = HashResolver.extractTempFileName((String)"_temporary/part-00007.af77e2ab-4bc5-4959-ae08-299c880ee6b8");
        Assertions.assertEquals((Object)"part-00007", (Object)finalName);
        finalName = HashResolver.extractTempFileName((String)"_temporary/0/_temporary/attempt_201706281636_0007_m_000003_46/part-00003");
        Assertions.assertEquals((Object)"part-00003", (Object)finalName);
        finalName = HashResolver.extractTempFileName((String)"folder0/testfile1.txt._COPYING_");
        Assertions.assertEquals((Object)"folder0/testfile1.txt", (Object)finalName);
        finalName = HashResolver.extractTempFileName((String)"folder0/folder1/testfile1.txt._COPYING_");
        Assertions.assertEquals((Object)"folder0/folder1/testfile1.txt", (Object)finalName);
        finalName = HashResolver.extractTempFileName((String)"processedHrsData.txt/_temporary/0/_temporary/attempt_201706281636_0007_m_000003_46/part-00003");
        Assertions.assertEquals((Object)"processedHrsData.txt/part-00003", (Object)finalName);
    }

    @Test
    public void testReadOnly() throws IOException {
        MountTable mount = this.resolver.getMountPoint("/readonly");
        Assertions.assertTrue((boolean)mount.isReadOnly());
        PathLocation dest0 = this.resolver.getDestinationForPath("/readonly/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest0);
        PathLocation dest1 = this.resolver.getDestinationForPath("/readonly/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest1);
        PathLocation dest2 = this.resolver.getDestinationForPath("/readonly/folder0");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest2);
        PathLocation dest3 = this.resolver.getDestinationForPath("/readonly/folder0/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest3);
        PathLocation dest4 = this.resolver.getDestinationForPath("/readonly/folder0/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest4);
        PathLocation dest5 = this.resolver.getDestinationForPath("/readonly/folder0/folder0/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest5);
        PathLocation dest6 = this.resolver.getDestinationForPath("/readonly/folder0/folder0/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest6);
        PathLocation dest7 = this.resolver.getDestinationForPath("/readonly/folder1");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest7);
        PathLocation dest8 = this.resolver.getDestinationForPath("/readonly/folder1/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest8);
        PathLocation dest9 = this.resolver.getDestinationForPath("/readonly/folder1/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster2", dest9);
        PathLocation dest10 = this.resolver.getDestinationForPath("/readonly/folder2");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest10);
        PathLocation dest11 = this.resolver.getDestinationForPath("/readonly/folder2/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest11);
        PathLocation dest12 = this.resolver.getDestinationForPath("/readonly/folder2/file1.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest12);
    }

    @Test
    public void testLeaderFollower() throws IOException {
        PathLocation dest0 = this.resolver.getDestinationForPath("/leaderfollower/folder0/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster1", dest0);
    }

    @Test
    public void testLocalResolver() throws IOException {
        PathLocation dest0 = this.resolver.getDestinationForPath("/local/folder0/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest0);
    }

    @Test
    public void testRandomResolver() throws IOException {
        HashSet<String> destinations = new HashSet<String>();
        for (int i = 0; i < 30; ++i) {
            PathLocation dest = this.resolver.getDestinationForPath("/random/folder0/file0.txt");
            RemoteLocation firstDest = (RemoteLocation)dest.getDestinations().get(0);
            String nsId = firstDest.getNameserviceId();
            destinations.add(nsId);
        }
        Assertions.assertEquals((int)3, (int)destinations.size());
    }

    @Test
    public void testPrioritizeDestination() throws IOException {
        PathLocation dest0 = this.resolver.getDestinationForPath("/hashall/file0.txt");
        TestMultipleDestinationResolver.assertDest("subcluster0", dest0);
        PathLocation prioritizedDest = PathLocation.prioritizeDestination((PathLocation)dest0, (String)"subcluster1");
        TestMultipleDestinationResolver.assertDest("subcluster1", prioritizedDest);
    }

    private void testEvenDistribution(String path) throws IOException {
        this.testEvenDistribution(path, true);
    }

    private void testEvenDistribution(String path, boolean even) throws IOException {
        HashMap results = new HashMap();
        for (int f = 0; f < 10000; ++f) {
            String filename = path + "/file" + f + ".txt";
            PathLocation destination = this.resolver.getDestinationForPath(filename);
            RemoteLocation loc = destination.getDefaultLocation();
            Assertions.assertEquals((Object)filename, (Object)loc.getDest());
            String nsId = loc.getNameserviceId();
            if (!results.containsKey(nsId)) {
                results.put(nsId, new TreeSet());
            }
            ((Set)results.get(nsId)).add(filename);
        }
        if (!even) {
            Assertions.assertEquals((int)1, (int)results.size());
        } else {
            Assertions.assertEquals((int)3, (int)results.size());
            int count = 0;
            for (Set files : results.values()) {
                count += files.size();
            }
            int avg = count / results.keySet().size();
            for (Set files : results.values()) {
                int filesCount = files.size();
                Assertions.assertTrue((filesCount > 0 ? 1 : 0) != 0);
                Assertions.assertTrue((Math.abs(filesCount - avg) < avg / 5 ? 1 : 0) != 0);
            }
        }
    }

    private static void assertDest(String expectedDest, PathLocation loc) {
        Assertions.assertEquals((Object)expectedDest, (Object)((RemoteLocation)loc.getDestinations().get(0)).getNameserviceId());
    }
}

