/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInitializeMountTableResolver {
    @Test
    public void testDefaultNameserviceIsMissing() {
        Configuration conf = new Configuration();
        MountTableResolver mountTable = new MountTableResolver(conf);
        Assertions.assertEquals((Object)"", (Object)mountTable.getDefaultNamespace());
    }

    @Test
    public void testDefaultNameserviceWithEmptyString() {
        Configuration conf = new Configuration();
        conf.set("dfs.federation.router.default.nameserviceId", "");
        MountTableResolver mountTable = new MountTableResolver(conf);
        Assertions.assertEquals((Object)"", (Object)mountTable.getDefaultNamespace());
        Assertions.assertFalse((boolean)mountTable.isDefaultNSEnable(), (String)"Default NS should be disabled if default NS is set empty");
    }

    @Test
    public void testRouterDefaultNameservice() {
        Configuration conf = new Configuration();
        conf.set("dfs.federation.router.default.nameserviceId", "router_ns");
        MountTableResolver mountTable = new MountTableResolver(conf);
        Assertions.assertEquals((Object)"router_ns", (Object)mountTable.getDefaultNamespace());
    }

    @Test
    public void testRouterDefaultNameserviceDisabled() {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.federation.router.default.nameservice.enable", false);
        conf.set("dfs.nameservice.id", "ns_id");
        conf.set("dfs.nameservices", "nss");
        MountTableResolver mountTable = new MountTableResolver(conf);
        Assertions.assertEquals((Object)"", (Object)mountTable.getDefaultNamespace());
    }
}

