/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterClientMetrics {
    private static final Configuration CONF = new HdfsConfiguration();
    private static final String ROUTER_METRICS = "RouterClientActivity";
    private static final int NUM_SUBCLUSTERS = 2;
    private static final int NUM_DNS = 3;
    private static MiniRouterDFSCluster cluster;
    private MiniRouterDFSCluster.RouterContext routerContext;
    private Router router;
    private FileSystem routerFS;
    private FileSystem nnFS;

    @BeforeAll
    public static void globalSetUp() throws Exception {
        cluster = new MiniRouterDFSCluster(false, 2);
        cluster.setNumDatanodesPerNameservice(3);
        cluster.startCluster();
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().quota().build();
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
    }

    @BeforeEach
    public void testSetup() throws Exception {
        cluster.installMockLocations();
        cluster.deleteAllFiles();
        cluster.createTestDirectoriesNamenode();
        Thread.sleep(100L);
        this.routerContext = cluster.getRouters().get(0);
        this.routerFS = this.routerContext.getFileSystem();
        this.router = this.routerContext.getRouter();
        MockResolver resolver = (MockResolver)this.router.getSubclusterResolver();
        resolver.addLocation("/", cluster.getNameservices().get(1), "/");
    }

    @AfterAll
    public static void tearDown() throws Exception {
        cluster.shutdown();
    }

    @Test
    public void testGetListing() throws IOException {
        this.routerFS.listStatus(new Path("/"));
        MetricsAsserts.assertCounter((String)"GetListingOps", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
        MetricsAsserts.assertCounter((String)"ConcurrentGetListingOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
    }

    @Test
    public void testCreate() throws IOException {
        Path testFile = new Path("/testCreate");
        this.routerFS.create(testFile);
        MetricsAsserts.assertCounter((String)"CreateOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
    }

    @Test
    public void testGetServerDefaults() throws IOException {
        this.router.getRpcServer().getServerDefaults();
        MetricsAsserts.assertCounter((String)"GetServerDefaultsOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
    }

    @Test
    public void testSetQuota() throws Exception {
        this.router.getRpcServer().setQuota("/", 1L, 1L, null);
        MetricsAsserts.assertCounter((String)"SetQuotaOps", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
        MetricsAsserts.assertCounter((String)"ConcurrentSetQuotaOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
    }

    @Test
    public void testGetQuota() throws Exception {
        this.router.getRpcServer().getQuotaUsage("/");
        MetricsAsserts.assertCounter((String)"GetQuotaUsageOps", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
        MetricsAsserts.assertCounter((String)"ConcurrentGetQuotaUsageOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
    }

    @Test
    public void testRenewLease() throws Exception {
        this.router.getRpcServer().renewLease("test", null);
        MetricsAsserts.assertCounter((String)"RenewLeaseOps", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
        MetricsAsserts.assertCounter((String)"ConcurrentRenewLeaseOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
    }

    @Test
    public void testGetDatanodeReport() throws Exception {
        this.router.getRpcServer().getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        MetricsAsserts.assertCounter((String)"GetDatanodeReportOps", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
        MetricsAsserts.assertCounter((String)"ConcurrentGetDatanodeReportOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
    }

    @Test
    public void testGetSlowDatanodeReport() throws Exception {
        this.router.getRpcServer().getSlowDatanodeReport();
        MetricsAsserts.assertCounter((String)"GetSlowDatanodeReportOps", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
        MetricsAsserts.assertCounter((String)"ConcurrentGetSlowDatanodeReportOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)ROUTER_METRICS));
    }

    static {
        CONF.setLong("dfs.blocksize", 100L);
        CONF.setInt("dfs.bytes-per-checksum", 1);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setInt("dfs.namenode.redundancy.interval.seconds", 1);
    }
}

