/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import javax.management.MalformedObjectNameException;
import org.apache.commons.collections4.ListUtils;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationMBean;
import org.apache.hadoop.hdfs.server.federation.metrics.RBFMetrics;
import org.apache.hadoop.hdfs.server.federation.metrics.RouterMBean;
import org.apache.hadoop.hdfs.server.federation.metrics.TestMetricsBase;
import org.apache.hadoop.hdfs.server.federation.store.protocol.NamenodeHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipStats;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.hdfs.server.federation.store.records.StateStoreVersion;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRBFMetrics
extends TestMetricsBase {
    public static final String FEDERATION_BEAN = "Hadoop:service=Router,name=FederationState";
    public static final String ROUTER_BEAN = "Hadoop:service=Router,name=Router";

    @Test
    public void testClusterStatsJMX() throws MalformedObjectNameException, IOException {
        FederationMBean federationBean = FederationTestUtils.getBean(FEDERATION_BEAN, FederationMBean.class);
        this.validateClusterStatsFederationBean(federationBean);
        this.testCapacity(federationBean);
        RouterMBean routerBean = FederationTestUtils.getBean(ROUTER_BEAN, RouterMBean.class);
        this.validateClusterStatsRouterBean(routerBean);
    }

    @Test
    public void testClusterStatsDataSource() throws IOException {
        RBFMetrics metrics = this.getRouter().getMetrics();
        this.validateClusterStatsFederationBean((FederationMBean)metrics);
        this.validateClusterStatsRouterBean((RouterMBean)metrics);
    }

    @Test
    public void testMountTableStatsDataSource() throws IOException, JSONException {
        RBFMetrics metrics = this.getRouter().getMetrics();
        String jsonString = metrics.getMountTable();
        JSONArray jsonArray = new JSONArray(jsonString);
        Assertions.assertEquals((int)jsonArray.length(), (int)this.getMockMountTable().size());
        int match = 0;
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            String src = json.getString("sourcePath");
            for (MountTable entry : this.getMockMountTable()) {
                if (!entry.getSourcePath().equals(src)) continue;
                Assertions.assertEquals((Object)entry.getDefaultLocation().getNameserviceId(), (Object)json.getString("nameserviceId"));
                Assertions.assertEquals((Object)entry.getDefaultLocation().getDest(), (Object)json.getString("path"));
                Assertions.assertEquals((Object)entry.getOwnerName(), (Object)json.getString("ownerName"));
                Assertions.assertEquals((Object)entry.getGroupName(), (Object)json.getString("groupName"));
                Assertions.assertEquals((Object)entry.getMode().toString(), (Object)json.getString("mode"));
                Assertions.assertEquals((Object)entry.getQuota().toString(), (Object)json.getString("quota"));
                this.assertNotNullAndNotEmpty(json.getString("dateCreated"));
                this.assertNotNullAndNotEmpty(json.getString("dateModified"));
                ++match;
            }
        }
        Assertions.assertEquals((int)match, (int)this.getMockMountTable().size());
    }

    private MembershipState findMockNamenode(String nsId, String nnId) {
        List namenodes = ListUtils.union(this.getActiveMemberships(), this.getStandbyMemberships());
        for (MembershipState nn : namenodes) {
            if (!nn.getNamenodeId().equals(nnId) || !nn.getNameserviceId().equals(nsId)) continue;
            return nn;
        }
        return null;
    }

    @Test
    public void testNamenodeStatsDataSource() throws IOException, JSONException {
        RBFMetrics metrics = this.getRouter().getMetrics();
        String jsonString = metrics.getNamenodes();
        JSONObject jsonObject = new JSONObject(jsonString);
        Iterator keys = jsonObject.keys();
        int nnsFound = 0;
        while (keys.hasNext()) {
            JSONObject json = jsonObject.getJSONObject((String)keys.next());
            String nameserviceId = json.getString("nameserviceId");
            String namenodeId = json.getString("namenodeId");
            MembershipState mockEntry = this.findMockNamenode(nameserviceId, namenodeId);
            Assertions.assertNotNull((Object)mockEntry);
            Assertions.assertEquals((Object)json.getString("state"), (Object)mockEntry.getState().toString());
            MembershipStats stats = mockEntry.getStats();
            Assertions.assertEquals((long)json.getLong("numOfActiveDatanodes"), (long)stats.getNumOfActiveDatanodes());
            Assertions.assertEquals((long)json.getLong("numOfDeadDatanodes"), (long)stats.getNumOfDeadDatanodes());
            Assertions.assertEquals((long)json.getLong("numOfStaleDatanodes"), (long)stats.getNumOfStaleDatanodes());
            Assertions.assertEquals((long)json.getLong("numOfDecommissioningDatanodes"), (long)stats.getNumOfDecommissioningDatanodes());
            Assertions.assertEquals((long)json.getLong("numOfDecomActiveDatanodes"), (long)stats.getNumOfDecomActiveDatanodes());
            Assertions.assertEquals((long)json.getLong("numOfDecomDeadDatanodes"), (long)stats.getNumOfDecomDeadDatanodes());
            Assertions.assertEquals((long)json.getLong("numOfInMaintenanceLiveDataNodes"), (long)stats.getNumOfInMaintenanceLiveDataNodes());
            Assertions.assertEquals((long)json.getLong("numOfInMaintenanceDeadDataNodes"), (long)stats.getNumOfInMaintenanceDeadDataNodes());
            Assertions.assertEquals((long)json.getLong("numOfEnteringMaintenanceDataNodes"), (long)stats.getNumOfEnteringMaintenanceDataNodes());
            Assertions.assertEquals((long)json.getLong("numOfBlocks"), (long)stats.getNumOfBlocks());
            Assertions.assertEquals((Object)json.getString("rpcAddress"), (Object)mockEntry.getRpcAddress());
            Assertions.assertEquals((Object)json.getString("webScheme"), (Object)mockEntry.getWebScheme());
            Assertions.assertEquals((Object)json.getString("webAddress"), (Object)mockEntry.getWebAddress());
            ++nnsFound;
        }
        Assertions.assertEquals((int)(this.getActiveMemberships().size() + this.getStandbyMemberships().size()), (int)nnsFound);
    }

    @Test
    public void testNameserviceStatsDataSource() throws IOException, JSONException {
        RBFMetrics metrics = this.getRouter().getMetrics();
        String jsonString = metrics.getNameservices();
        JSONObject jsonObject = new JSONObject(jsonString);
        Iterator keys = jsonObject.keys();
        int nameservicesFound = 0;
        while (keys.hasNext()) {
            JSONObject json = jsonObject.getJSONObject((String)keys.next());
            String nameserviceId = json.getString("nameserviceId");
            String namenodeId = json.getString("namenodeId");
            MembershipState mockEntry = this.findMockNamenode(nameserviceId, namenodeId);
            Assertions.assertNotNull((Object)mockEntry);
            Assertions.assertEquals((Object)mockEntry.getState().toString(), (Object)json.getString("state"));
            Assertions.assertEquals((Object)"ACTIVE", (Object)json.getString("state"));
            MembershipStats stats = mockEntry.getStats();
            Assertions.assertEquals((long)stats.getNumOfFiles(), (long)json.getLong("numOfFiles"));
            Assertions.assertEquals((long)stats.getTotalSpace(), (long)json.getLong("totalSpace"));
            Assertions.assertEquals((long)stats.getAvailableSpace(), (long)json.getLong("availableSpace"));
            Assertions.assertEquals((long)stats.getNumOfBlocksMissing(), (long)json.getLong("numOfBlocksMissing"));
            Assertions.assertEquals((long)stats.getNumOfActiveDatanodes(), (long)json.getLong("numOfActiveDatanodes"));
            Assertions.assertEquals((long)stats.getNumOfDeadDatanodes(), (long)json.getLong("numOfDeadDatanodes"));
            Assertions.assertEquals((long)stats.getNumOfStaleDatanodes(), (long)json.getLong("numOfStaleDatanodes"));
            Assertions.assertEquals((long)stats.getNumOfDecommissioningDatanodes(), (long)json.getLong("numOfDecommissioningDatanodes"));
            Assertions.assertEquals((long)stats.getNumOfDecomActiveDatanodes(), (long)json.getLong("numOfDecomActiveDatanodes"));
            Assertions.assertEquals((long)stats.getNumOfDecomDeadDatanodes(), (long)json.getLong("numOfDecomDeadDatanodes"));
            Assertions.assertEquals((long)stats.getNumOfInMaintenanceLiveDataNodes(), (long)json.getLong("numOfInMaintenanceLiveDataNodes"));
            Assertions.assertEquals((long)stats.getNumOfInMaintenanceDeadDataNodes(), (long)json.getLong("numOfInMaintenanceDeadDataNodes"));
            Assertions.assertEquals((long)stats.getNumOfStaleDatanodes(), (long)json.getLong("numOfEnteringMaintenanceDataNodes"));
            Assertions.assertEquals((long)stats.getProvidedSpace(), (long)json.getLong("providedSpace"));
            Assertions.assertEquals((int)stats.getPendingSPSPaths(), (int)json.getInt("pendingSPSPaths"));
            ++nameservicesFound;
        }
        Assertions.assertEquals((int)this.getNameservices().size(), (int)nameservicesFound);
    }

    @Test
    public void testRouterStatsDataSource() throws IOException, JSONException {
        RBFMetrics metrics = this.getRouter().getMetrics();
        String jsonString = metrics.getRouters();
        JSONObject jsonObject = new JSONObject(jsonString);
        Iterator keys = jsonObject.keys();
        int routersFound = 0;
        while (keys.hasNext()) {
            JSONObject json = jsonObject.getJSONObject((String)keys.next());
            String address = json.getString("address");
            this.assertNotNullAndNotEmpty(address);
            RouterState router = this.findMockRouter(address);
            Assertions.assertNotNull((Object)router);
            Assertions.assertEquals((Object)router.getStatus().toString(), (Object)json.getString("status"));
            Assertions.assertEquals((Object)router.getCompileInfo(), (Object)json.getString("compileInfo"));
            Assertions.assertEquals((Object)router.getVersion(), (Object)json.getString("version"));
            Assertions.assertEquals((long)router.getDateStarted(), (long)json.getLong("dateStarted"));
            Assertions.assertEquals((long)router.getDateCreated(), (long)json.getLong("dateCreated"));
            Assertions.assertEquals((long)router.getDateModified(), (long)json.getLong("dateModified"));
            StateStoreVersion version = router.getStateStoreVersion();
            Assertions.assertEquals((Object)RBFMetrics.getDateString((long)version.getMembershipVersion()), (Object)json.get("lastMembershipUpdate"));
            Assertions.assertEquals((Object)RBFMetrics.getDateString((long)version.getMountTableVersion()), (Object)json.get("lastMountTableUpdate"));
            Assertions.assertEquals((Object)version.getMembershipVersion(), (Object)json.get("membershipVersion"));
            Assertions.assertEquals((Object)version.getMountTableVersion(), (Object)json.get("mountTableVersion"));
            ++routersFound;
        }
        Assertions.assertEquals((int)this.getMockRouters().size(), (int)routersFound);
    }

    private void assertNotNullAndNotEmpty(String field) {
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((field.length() > 0 ? 1 : 0) != 0);
    }

    private RouterState findMockRouter(String routerId) {
        for (RouterState router : this.getMockRouters()) {
            if (!router.getAddress().equals(routerId)) continue;
            return router;
        }
        return null;
    }

    private void validateClusterStatsFederationBean(FederationMBean bean) {
        long numBlocks = 0L;
        long numLive = 0L;
        long numDead = 0L;
        long numStale = 0L;
        long numDecom = 0L;
        long numDecomLive = 0L;
        long numDecomDead = 0L;
        long numInMaintenanceLive = 0L;
        long numInMaintenanceDead = 0L;
        long numEnteringMaintenance = 0L;
        int numCorruptsFilesCount = 0;
        long scheduledReplicationBlocks = 0L;
        long numberOfMissingBlocksWithReplicationFactorOne = 0L;
        long numberOfBadlyDistributedBlocks = 0L;
        long highestPriorityLowRedundancyReplicatedBlocks = 0L;
        long highestPriorityLowRedundancyECBlocks = 0L;
        long numFiles = 0L;
        int pendingSPSPaths = 0;
        for (MembershipState mock : this.getActiveMemberships()) {
            MembershipStats stats = mock.getStats();
            numBlocks += stats.getNumOfBlocks();
            numLive += (long)stats.getNumOfActiveDatanodes();
            numDead += (long)stats.getNumOfDeadDatanodes();
            numStale += (long)stats.getNumOfStaleDatanodes();
            numDecom += (long)stats.getNumOfDecommissioningDatanodes();
            numDecomLive += (long)stats.getNumOfDecomActiveDatanodes();
            numDecomDead += (long)stats.getNumOfDecomDeadDatanodes();
            numInMaintenanceLive += (long)stats.getNumOfInMaintenanceLiveDataNodes();
            numInMaintenanceDead += (long)stats.getNumOfInMaintenanceLiveDataNodes();
            numEnteringMaintenance += (long)stats.getNumOfEnteringMaintenanceDataNodes();
            numCorruptsFilesCount += stats.getCorruptFilesCount();
            scheduledReplicationBlocks += stats.getScheduledReplicationBlocks();
            numberOfMissingBlocksWithReplicationFactorOne += stats.getNumberOfMissingBlocksWithReplicationFactorOne();
            numberOfBadlyDistributedBlocks += stats.getNumberOfBadlyDistributedBlocks();
            highestPriorityLowRedundancyReplicatedBlocks += stats.getHighestPriorityLowRedundancyReplicatedBlocks();
            highestPriorityLowRedundancyECBlocks += stats.getHighestPriorityLowRedundancyECBlocks();
            pendingSPSPaths += stats.getPendingSPSPaths();
        }
        Assertions.assertEquals((long)numBlocks, (long)bean.getNumBlocks());
        Assertions.assertEquals((long)numLive, (long)bean.getNumLiveNodes());
        Assertions.assertEquals((long)numDead, (long)bean.getNumDeadNodes());
        Assertions.assertEquals((long)numStale, (long)bean.getNumStaleNodes());
        Assertions.assertEquals((long)numDecom, (long)bean.getNumDecommissioningNodes());
        Assertions.assertEquals((long)numDecomLive, (long)bean.getNumDecomLiveNodes());
        Assertions.assertEquals((long)numDecomDead, (long)bean.getNumDecomDeadNodes());
        Assertions.assertEquals((long)numInMaintenanceLive, (long)bean.getNumInMaintenanceLiveDataNodes());
        Assertions.assertEquals((long)numInMaintenanceDead, (long)bean.getNumInMaintenanceDeadDataNodes());
        Assertions.assertEquals((long)numEnteringMaintenance, (long)bean.getNumEnteringMaintenanceDataNodes());
        Assertions.assertEquals((long)numFiles, (long)bean.getNumFiles());
        Assertions.assertEquals((int)(this.getActiveMemberships().size() + this.getStandbyMemberships().size()), (int)bean.getNumNamenodes());
        Assertions.assertEquals((int)this.getNameservices().size(), (int)bean.getNumNameservices());
        Assertions.assertEquals((int)numCorruptsFilesCount, (int)bean.getCorruptFilesCount());
        Assertions.assertEquals((long)scheduledReplicationBlocks, (long)bean.getScheduledReplicationBlocks());
        Assertions.assertEquals((long)numberOfMissingBlocksWithReplicationFactorOne, (long)bean.getNumberOfMissingBlocksWithReplicationFactorOne());
        Assertions.assertEquals((long)numberOfBadlyDistributedBlocks, (long)bean.getNumberOfBadlyDistributedBlocks());
        Assertions.assertEquals((long)highestPriorityLowRedundancyReplicatedBlocks, (long)bean.getHighestPriorityLowRedundancyReplicatedBlocks());
        Assertions.assertEquals((long)highestPriorityLowRedundancyECBlocks, (long)bean.getHighestPriorityLowRedundancyECBlocks());
        Assertions.assertEquals((int)pendingSPSPaths, (int)bean.getPendingSPSPaths());
    }

    private void validateClusterStatsRouterBean(RouterMBean bean) {
        Assertions.assertTrue((bean.getVersion().length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((bean.getCompiledDate().length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((bean.getCompileInfo().length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((bean.getRouterStarted().length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((bean.getHostAndPort().length() > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)bean.isSecurityEnabled());
    }

    private void testCapacity(FederationMBean bean) throws IOException {
        List<MembershipState> memberships = this.getActiveMemberships();
        Assertions.assertTrue((memberships.size() > 1 ? 1 : 0) != 0);
        BigInteger availableCapacity = BigInteger.valueOf(0L);
        BigInteger totalCapacity = BigInteger.valueOf(0L);
        BigInteger unitCapacity = BigInteger.valueOf(Long.MAX_VALUE);
        for (MembershipState mock : memberships) {
            MembershipStats stats = mock.getStats();
            stats.setTotalSpace(Long.MAX_VALUE);
            stats.setAvailableSpace(Long.MAX_VALUE);
            mock.setStats(stats);
            Assertions.assertTrue((boolean)this.refreshNamenodeRegistration(NamenodeHeartbeatRequest.newInstance((MembershipState)mock)));
            totalCapacity = totalCapacity.add(unitCapacity);
            availableCapacity = availableCapacity.add(unitCapacity);
        }
        Assertions.assertEquals((Object)totalCapacity, (Object)bean.getTotalCapacityBigInt());
        Assertions.assertNotEquals((Object)totalCapacity, (Object)BigInteger.valueOf(bean.getTotalCapacity()));
        Assertions.assertEquals((Object)availableCapacity, (Object)bean.getRemainingCapacityBigInt());
        Assertions.assertNotEquals((Object)availableCapacity, (Object)BigInteger.valueOf(bean.getRemainingCapacity()));
    }
}

