/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.metrics.RBFMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.NamenodeHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.NamenodeHeartbeatResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RouterHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.hdfs.server.federation.store.records.StateStoreVersion;
import org.apache.hadoop.util.Time;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestMetricsBase {
    private StateStoreService stateStore;
    private MembershipStore membershipStore;
    private RouterStore routerStore;
    private Router router;
    private Configuration routerConfig;
    private List<MembershipState> activeMemberships;
    private List<MembershipState> standbyMemberships;
    private List<MountTable> mockMountTable;
    private List<RouterState> mockRouters;
    private List<String> nameservices;

    @BeforeEach
    public void setupBase() throws Exception {
        if (this.router == null) {
            this.routerConfig = new RouterConfigBuilder().stateStore().metrics().http().build();
            this.router = new Router();
            this.router.init(this.routerConfig);
            this.router.setRouterId("routerId");
            this.router.start();
            this.stateStore = this.router.getStateStore();
            this.membershipStore = (MembershipStore)this.stateStore.getRegisteredRecordStore(MembershipStore.class);
            this.routerStore = (RouterStore)this.stateStore.getRegisteredRecordStore(RouterStore.class);
            FederationStateStoreTestUtils.waitStateStore(this.stateStore, 10000L);
            this.createFixtures();
            this.stateStore.refreshCaches(true);
            Thread.sleep(1000L);
        }
    }

    @AfterEach
    public void tearDownBase() throws IOException {
        if (this.router != null) {
            this.router.stop();
            this.router.close();
            this.router = null;
        }
    }

    private void createFixtures() throws IOException {
        FederationStateStoreTestUtils.clearAllRecords(this.stateStore);
        this.nameservices = new ArrayList<String>();
        this.nameservices.add(FederationTestUtils.NAMESERVICES[0]);
        this.nameservices.add(FederationTestUtils.NAMESERVICES[1]);
        this.activeMemberships = new ArrayList<MembershipState>();
        this.standbyMemberships = new ArrayList<MembershipState>();
        for (String nameservice : this.nameservices) {
            MembershipState namenode1 = FederationStateStoreTestUtils.createMockRegistrationForNamenode(nameservice, FederationTestUtils.NAMENODES[0], FederationNamenodeServiceState.ACTIVE);
            NamenodeHeartbeatRequest request1 = NamenodeHeartbeatRequest.newInstance((MembershipState)namenode1);
            Assertions.assertTrue((boolean)this.membershipStore.namenodeHeartbeat(request1).getResult());
            this.activeMemberships.add(namenode1);
            MembershipState namenode2 = FederationStateStoreTestUtils.createMockRegistrationForNamenode(nameservice, FederationTestUtils.NAMENODES[1], FederationNamenodeServiceState.STANDBY);
            NamenodeHeartbeatRequest request2 = NamenodeHeartbeatRequest.newInstance((MembershipState)namenode2);
            Assertions.assertTrue((boolean)this.membershipStore.namenodeHeartbeat(request2).getResult());
            this.standbyMemberships.add(namenode2);
        }
        this.mockMountTable = FederationStateStoreTestUtils.createMockMountTable(this.nameservices);
        FederationStateStoreTestUtils.synchronizeRecords(this.stateStore, this.mockMountTable, MountTable.class);
        long t1 = Time.now();
        this.mockRouters = new ArrayList<RouterState>();
        RouterState router1 = RouterState.newInstance((String)"router1", (long)t1, (RouterServiceState)RouterServiceState.RUNNING);
        router1.setStateStoreVersion(StateStoreVersion.newInstance((long)(t1 - 1000L), (long)(t1 - 2000L)));
        RouterHeartbeatRequest heartbeatRequest = RouterHeartbeatRequest.newInstance((RouterState)router1);
        Assertions.assertTrue((boolean)this.routerStore.routerHeartbeat(heartbeatRequest).getStatus());
        GetRouterRegistrationRequest getRequest = GetRouterRegistrationRequest.newInstance((String)"router1");
        GetRouterRegistrationResponse getResponse = this.routerStore.getRouterRegistration(getRequest);
        RouterState routerState1 = getResponse.getRouter();
        this.mockRouters.add(routerState1);
        long t2 = Time.now();
        RouterState router2 = RouterState.newInstance((String)"router2", (long)t2, (RouterServiceState)RouterServiceState.RUNNING);
        router2.setStateStoreVersion(StateStoreVersion.newInstance((long)(t2 - 6000L), (long)(t2 - 7000L)));
        heartbeatRequest.setRouter(router2);
        Assertions.assertTrue((boolean)this.routerStore.routerHeartbeat(heartbeatRequest).getStatus());
        getRequest.setRouterId("router2");
        getResponse = this.routerStore.getRouterRegistration(getRequest);
        RouterState routerState2 = getResponse.getRouter();
        this.mockRouters.add(routerState2);
    }

    protected Router getRouter() {
        return this.router;
    }

    protected List<MountTable> getMockMountTable() {
        return this.mockMountTable;
    }

    protected List<MembershipState> getActiveMemberships() {
        return this.activeMemberships;
    }

    protected List<MembershipState> getStandbyMemberships() {
        return this.standbyMemberships;
    }

    protected List<String> getNameservices() {
        return this.nameservices;
    }

    protected List<RouterState> getMockRouters() {
        return this.mockRouters;
    }

    protected StateStoreService getStateStore() {
        return this.stateStore;
    }

    @Test
    public void testObserverMetrics() throws Exception {
        this.mockObserver();
        RBFMetrics metrics = this.router.getMetrics();
        String jsonString = metrics.getNameservices();
        JSONObject jsonObject = new JSONObject(jsonString);
        Map<String, String> map = TestMetricsBase.getNameserviceStateMap(jsonObject);
        Assertions.assertTrue((boolean)map.containsKey("ns0"), (String)("Cannot find ns0 in: " + jsonString));
        Assertions.assertEquals((Object)"OBSERVER", (Object)map.get("ns0"));
    }

    public static Map<String, String> getNameserviceStateMap(JSONObject jsonObject) throws JSONException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONObject json = jsonObject.getJSONObject(key);
            String nsId = json.getString("nameserviceId");
            String state = json.getString("state");
            map.put(nsId, state);
        }
        return map;
    }

    private void mockObserver() throws IOException {
        String ns = "ns0";
        String nn = "nn0";
        this.createRegistration(ns, nn, FederationTestUtils.ROUTERS[1], FederationNamenodeServiceState.OBSERVER);
        Assertions.assertTrue((boolean)this.stateStore.loadCache(MembershipStore.class, true));
        this.membershipStore.loadCache(true);
        MembershipNamenodeResolver resolver = (MembershipNamenodeResolver)this.router.getNamenodeResolver();
        resolver.loadCache(true);
    }

    private MembershipState createRegistration(String ns, String nn, String routerId, FederationNamenodeServiceState state) throws IOException {
        MembershipState record = MembershipState.newInstance((String)routerId, (String)ns, (String)nn, (String)"testcluster", (String)("testblock-" + ns), (String)("testrpc-" + ns + nn), (String)("testservice-" + ns + nn), (String)("testlifeline-" + ns + nn), (String)"http", (String)("testweb-" + ns + nn), (FederationNamenodeServiceState)state, (boolean)false);
        NamenodeHeartbeatRequest request = NamenodeHeartbeatRequest.newInstance((MembershipState)record);
        NamenodeHeartbeatResponse response = this.membershipStore.namenodeHeartbeat(request);
        Assertions.assertTrue((boolean)response.getResult());
        return record;
    }

    public boolean refreshNamenodeRegistration(NamenodeHeartbeatRequest request) throws IOException {
        boolean result = this.membershipStore.namenodeHeartbeat(request).getResult();
        this.membershipStore.loadCache(true);
        MembershipNamenodeResolver resolver = (MembershipNamenodeResolver)this.router.getNamenodeResolver();
        resolver.loadCache(true);
        return result;
    }
}

