/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.fairness;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.fairness.StaticRouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterRpcFairnessPolicyController {
    private static String nameServices = "ns1.nn1, ns1.nn2, ns2.nn1, ns2.nn2";

    @Test
    public void testHandlerAllocationEqualAssignment() {
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = this.getFairnessPolicyController(30);
        this.verifyHandlerAllocation(routerRpcFairnessPolicyController);
    }

    @Test
    public void testHandlerAllocationWithLeftOverHandler() {
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = this.getFairnessPolicyController(31);
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        this.verifyHandlerAllocation(routerRpcFairnessPolicyController);
    }

    @Test
    public void testHandlerAllocationPreconfigured() {
        int i;
        Configuration conf = this.createConf(40);
        conf.setInt("dfs.federation.router.fairness.handler.count.ns1", 30);
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        for (i = 0; i < 30; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        }
        for (i = 0; i < 5; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        }
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
    }

    @Test
    public void testAcquireTimeout() {
        Configuration conf = this.createConf(40);
        conf.setInt("dfs.federation.router.fairness.handler.count.ns1", 30);
        conf.setTimeDuration("dfs.federation.router.fairness.acquire.timeout", 100L, TimeUnit.MILLISECONDS);
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        for (int i = 0; i < 30; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        }
        long acquireBeginTimeMs = Time.monotonicNow();
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        long acquireTimeMs = Time.monotonicNow() - acquireBeginTimeMs;
        Assertions.assertTrue((acquireTimeMs >= 100L ? 1 : 0) != 0);
    }

    @Test
    public void testAllocationErrorWithZeroHandlers() {
        Configuration conf = this.createConf(0);
        this.verifyInstantiationError(conf, 0, 3);
    }

    @Test
    public void testAllocationErrorForLowDefaultHandlers() {
        Configuration conf = this.createConf(1);
        this.verifyInstantiationError(conf, 1, 3);
    }

    @Test
    public void testAllocationErrorForLowDefaultHandlersPerNS() {
        Configuration conf = this.createConf(1);
        conf.setInt("dfs.federation.router.fairness.handler.count.concurrent", 1);
        this.verifyInstantiationError(conf, 1, 3);
    }

    @Test
    public void testGetAvailableHandlerOnPerNs() {
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = this.getFairnessPolicyController(30);
        Assertions.assertEquals((Object)"{\"concurrent\":10,\"ns2\":10,\"ns1\":10}", (Object)routerRpcFairnessPolicyController.getAvailableHandlerOnPerNs());
        routerRpcFairnessPolicyController.acquirePermit("ns1");
        Assertions.assertEquals((Object)"{\"concurrent\":10,\"ns2\":10,\"ns1\":9}", (Object)routerRpcFairnessPolicyController.getAvailableHandlerOnPerNs());
    }

    @Test
    public void testGetAvailableHandlerOnPerNsForNoFairness() {
        Configuration conf = new Configuration();
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        Assertions.assertEquals((Object)"N/A", (Object)routerRpcFairnessPolicyController.getAvailableHandlerOnPerNs());
    }

    @Test
    public void testAllocationErrorForLowPreconfiguredHandlers() {
        Configuration conf = this.createConf(1);
        conf.setInt("dfs.federation.router.fairness.handler.count.ns1", 2);
        this.verifyInstantiationError(conf, 1, 4);
    }

    @Test
    public void testHandlerAllocationConcurrentConfigured() {
        Configuration conf = this.createConf(5);
        conf.setInt("dfs.federation.router.fairness.handler.count.ns1", 1);
        conf.setInt("dfs.federation.router.fairness.handler.count.ns2", 1);
        conf.setInt("dfs.federation.router.fairness.handler.count.concurrent", 1);
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        for (int i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        }
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
    }

    private void verifyInstantiationError(Configuration conf, int handlerCount, int totalDedicatedHandlers) {
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(StaticRouterRpcFairnessPolicyController.class));
        try {
            FederationUtil.newFairnessPolicyController((Configuration)conf);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String errorMsg = String.format("Configured handlers dfs.federation.router.handler.count= %d is less than the minimum required handlers %d", handlerCount, totalDedicatedHandlers);
        Assertions.assertTrue((boolean)logs.getOutput().contains(errorMsg), (String)("Should contain error message: " + errorMsg));
    }

    private RouterRpcFairnessPolicyController getFairnessPolicyController(int handlers) {
        return FederationUtil.newFairnessPolicyController((Configuration)this.createConf(handlers));
    }

    private void verifyHandlerAllocation(RouterRpcFairnessPolicyController routerRpcFairnessPolicyController) {
        for (int i = 0; i < 10; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        }
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        routerRpcFairnessPolicyController.releasePermit("ns1");
        routerRpcFairnessPolicyController.releasePermit("ns2");
        routerRpcFairnessPolicyController.releasePermit("concurrent");
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
    }

    private Configuration createConf(int handlers) {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.federation.router.handler.count", handlers);
        conf.set("dfs.federation.router.monitor.namenode", nameServices);
        conf.setClass("dfs.federation.router.fairness.policy.controller.class", StaticRouterRpcFairnessPolicyController.class, RouterRpcFairnessPolicyController.class);
        return conf;
    }
}

