/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.fairness;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterAsyncRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterAsyncRpcFairnessPolicyController {
    private static String nameServices = "ns1.nn1, ns1.nn2, ns2.nn1, ns2.nn2";
    private static int perNsPermits = 30;

    @Test
    public void testHandlerAllocationEqualAssignment() {
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = this.getFairnessPolicyController(perNsPermits);
        this.verifyHandlerAllocation(routerRpcFairnessPolicyController);
    }

    @Test
    public void testAcquireTimeout() {
        Configuration conf = this.createConf(perNsPermits);
        conf.setTimeDuration("dfs.federation.router.fairness.acquire.timeout", 100L, TimeUnit.MILLISECONDS);
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        for (int i = 0; i < perNsPermits; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        }
        long acquireBeginTimeMs = Time.monotonicNow();
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        long acquireTimeMs = Time.monotonicNow() - acquireBeginTimeMs;
        Assertions.assertTrue((acquireTimeMs >= 100L ? 1 : 0) != 0);
    }

    @Test
    public void testAllocationSuccessfullyWithZeroHandlers() {
        Configuration conf = this.createConf(0);
        this.verifyInstantiationStatus(conf, 20000);
    }

    @Test
    public void testAllocationSuccessfullyWithNegativePermits() {
        Configuration conf = this.createConf(-1);
        this.verifyInstantiationStatus(conf, 20000);
    }

    @Test
    public void testGetAvailableHandlerOnPerNs() {
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = this.getFairnessPolicyController(perNsPermits);
        Assertions.assertEquals((Object)"{\"concurrent\":30,\"ns2\":30,\"ns1\":30}", (Object)routerRpcFairnessPolicyController.getAvailableHandlerOnPerNs());
        routerRpcFairnessPolicyController.acquirePermit("ns1");
        Assertions.assertEquals((Object)"{\"concurrent\":30,\"ns2\":30,\"ns1\":29}", (Object)routerRpcFairnessPolicyController.getAvailableHandlerOnPerNs());
    }

    @Test
    public void testGetAvailableHandlerOnPerNsForNoFairness() {
        Configuration conf = new Configuration();
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        Assertions.assertEquals((Object)"N/A", (Object)routerRpcFairnessPolicyController.getAvailableHandlerOnPerNs());
    }

    private void verifyInstantiationStatus(Configuration conf, int permits) {
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(RouterAsyncRpcFairnessPolicyController.class));
        try {
            FederationUtil.newFairnessPolicyController((Configuration)conf);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String infoMsg = String.format("Max async call permits per nameservice: %d", permits);
        Assertions.assertTrue((boolean)logs.getOutput().contains(infoMsg), (String)("Should contain info message: " + infoMsg));
    }

    private RouterRpcFairnessPolicyController getFairnessPolicyController(int asyncCallPermits) {
        return FederationUtil.newFairnessPolicyController((Configuration)this.createConf(asyncCallPermits));
    }

    private void verifyHandlerAllocation(RouterRpcFairnessPolicyController routerRpcFairnessPolicyController) {
        for (int i = 0; i < perNsPermits; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        }
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        routerRpcFairnessPolicyController.releasePermit("ns1");
        routerRpcFairnessPolicyController.releasePermit("ns2");
        routerRpcFairnessPolicyController.releasePermit("concurrent");
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
    }

    private Configuration createConf(int asyncCallPermits) {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.federation.router.async.rpc.max.asynccall.permit", asyncCallPermits);
        conf.set("dfs.federation.router.monitor.namenode", nameServices);
        conf.setClass("dfs.federation.router.fairness.policy.controller.class", RouterAsyncRpcFairnessPolicyController.class, RouterRpcFairnessPolicyController.class);
        return conf;
    }
}

