/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.fairness;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.fairness.ProportionRouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProportionRouterRpcFairnessPolicyController {
    private static String nameServices = "ns1.nn1, ns1.nn2, ns2.nn1, ns2.nn2";

    @Test
    public void testHandlerAllocationDefault() {
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = this.getFairnessPolicyController(30);
        for (int i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        }
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        routerRpcFairnessPolicyController.releasePermit("ns1");
        routerRpcFairnessPolicyController.releasePermit("ns2");
        routerRpcFairnessPolicyController.releasePermit("concurrent");
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
    }

    @Test
    public void testHandlerAllocationPreconfigured() {
        int i;
        Configuration conf = this.createConf(40);
        conf.setDouble("dfs.federation.router.fairness.handler.proportion.ns1", 0.5);
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        for (i = 0; i < 20; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        }
        for (i = 0; i < 4; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        }
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
    }

    @Test
    public void testAcquireTimeout() {
        Configuration conf = this.createConf(40);
        conf.setDouble("dfs.federation.router.fairness.handler.proportion.ns1", 0.5);
        conf.setTimeDuration("dfs.federation.router.fairness.acquire.timeout", 100L, TimeUnit.MILLISECONDS);
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        for (int i = 0; i < 20; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        }
        long acquireBeginTimeMs = Time.monotonicNow();
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        long acquireTimeMs = Time.monotonicNow() - acquireBeginTimeMs;
        Assertions.assertTrue((acquireTimeMs >= 100L ? 1 : 0) != 0);
    }

    @Test
    public void testAllocationWithZeroProportion() {
        Configuration conf = this.createConf(40);
        conf.setDouble("dfs.federation.router.fairness.handler.proportion.ns1", 0.0);
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
    }

    @Test
    public void testAllocationHandlersGreaterThanCount() {
        int i;
        Configuration conf = this.createConf(40);
        conf.setDouble("dfs.federation.router.fairness.handler.proportion.ns1", 0.8);
        conf.setDouble("dfs.federation.router.fairness.handler.proportion.ns2", 0.8);
        conf.setDouble("dfs.federation.router.fairness.handler.proportion.concurrent", 1.0);
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        for (i = 0; i < 32; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns1"));
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns2"));
        }
        for (i = 0; i < 40; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("concurrent"));
        }
    }

    @Test
    public void testTransparentExtension() {
        Configuration conf = this.createConf(40);
        RouterRpcFairnessPolicyController routerRpcFairnessPolicyController = FederationUtil.newFairnessPolicyController((Configuration)conf);
        for (int i = 0; i < 4; ++i) {
            Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns_unregistered"));
        }
        Assertions.assertFalse((boolean)routerRpcFairnessPolicyController.acquirePermit("ns_unregistered"));
        routerRpcFairnessPolicyController.releasePermit("ns_unregistered");
        Assertions.assertTrue((boolean)routerRpcFairnessPolicyController.acquirePermit("ns_unregistered"));
    }

    private RouterRpcFairnessPolicyController getFairnessPolicyController(int handlers) {
        return FederationUtil.newFairnessPolicyController((Configuration)this.createConf(handlers));
    }

    private Configuration createConf(int handlers) {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.federation.router.handler.count", handlers);
        conf.set("dfs.federation.router.monitor.namenode", nameServices);
        conf.setClass("dfs.federation.router.fairness.policy.controller.class", ProportionRouterRpcFairnessPolicyController.class, RouterRpcFairnessPolicyController.class);
        return conf;
    }
}

