/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodePriorityComparator;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.util.Time;

public class MockResolver
implements ActiveNamenodeResolver,
FileSubclusterResolver {
    private Map<String, List<? extends FederationNamenodeContext>> resolver = new HashMap<String, List<? extends FederationNamenodeContext>>();
    private Map<String, List<RemoteLocation>> locations = new HashMap<String, List<RemoteLocation>>();
    private Set<FederationNamespaceInfo> namespaces = new HashSet<FederationNamespaceInfo>();
    private String defaultNamespace = null;
    private boolean disableDefaultNamespace = false;
    private volatile boolean disableRegistration = false;
    private TreeSet<String> disableNamespaces = new TreeSet();

    public MockResolver() {
        this.cleanRegistrations();
    }

    public MockResolver(Configuration conf) {
        this();
    }

    public MockResolver(Configuration conf, StateStoreService store) {
        this();
    }

    public MockResolver(Configuration conf, Router router) {
        this();
    }

    public void addLocation(String mount, String nsId, String location) {
        RemoteLocation remoteLocation;
        List<RemoteLocation> locationsList = this.locations.get(mount);
        if (locationsList == null) {
            locationsList = new LinkedList<RemoteLocation>();
            this.locations.put(mount, locationsList);
        }
        if (!locationsList.contains(remoteLocation = new RemoteLocation(nsId, location, mount))) {
            locationsList.add(remoteLocation);
        }
        if (this.defaultNamespace == null) {
            this.defaultNamespace = nsId;
        }
    }

    public boolean removeLocation(String mount, String nsId, String location) {
        List<RemoteLocation> locationsList = this.locations.get(mount);
        RemoteLocation remoteLocation = new RemoteLocation(nsId, location, mount);
        if (locationsList != null) {
            this.locations.remove(mount);
            return locationsList.remove(remoteLocation);
        }
        return false;
    }

    public synchronized void cleanRegistrations() {
        this.resolver = new HashMap<String, List<? extends FederationNamenodeContext>>();
        this.namespaces = new HashSet<FederationNamespaceInfo>();
    }

    public void setDisableRegistration(boolean isDisable) {
        this.disableRegistration = isDisable;
    }

    public void updateUnavailableNamenode(String ns, InetSocketAddress failedAddress) throws IOException {
        this.updateNameNodeState(ns, failedAddress, FederationNamenodeServiceState.UNAVAILABLE);
    }

    public void updateActiveNamenode(String nsId, InetSocketAddress successfulAddress) {
        this.updateNameNodeState(nsId, successfulAddress, FederationNamenodeServiceState.ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNameNodeState(String nsId, InetSocketAddress iAddr, FederationNamenodeServiceState state) {
        String sAddress = iAddr.getHostName() + ":" + iAddr.getPort();
        String key = nsId;
        if (key != null) {
            List<? extends FederationNamenodeContext> namenodes = this.resolver.get(key);
            for (FederationNamenodeContext federationNamenodeContext : namenodes) {
                if (!federationNamenodeContext.getRpcAddress().equals(sAddress)) continue;
                MockNamenodeContext nn = (MockNamenodeContext)federationNamenodeContext;
                nn.setState(state);
                break;
            }
            List<? extends FederationNamenodeContext> list = namenodes;
            synchronized (list) {
                Collections.sort(namenodes, new NamenodePriorityComparator());
            }
        }
    }

    public synchronized List<? extends FederationNamenodeContext> getNamenodesForNameserviceId(String nameserviceId, boolean observerRead) {
        List<? extends FederationNamenodeContext> namenodes = this.resolver.get(nameserviceId);
        if (namenodes == null) {
            namenodes = new ArrayList<FederationNamenodeContext>();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        if (observerRead) {
            Iterator<? extends FederationNamenodeContext> iterator = namenodes.iterator();
            ArrayList<FederationNamenodeContext> observerNN = new ArrayList<FederationNamenodeContext>();
            ArrayList<FederationNamenodeContext> nonObserverNN = new ArrayList<FederationNamenodeContext>();
            while (iterator.hasNext()) {
                FederationNamenodeContext membership = iterator.next();
                if (membership.getState() == FederationNamenodeServiceState.OBSERVER) {
                    observerNN.add(membership);
                    continue;
                }
                nonObserverNN.add(membership);
            }
            Collections.shuffle(observerNN);
            Collections.sort(nonObserverNN, new NamenodePriorityComparator());
            ret.addAll(observerNN);
            ret.addAll(nonObserverNN);
        } else {
            ret.addAll(namenodes);
            Collections.sort(ret, new NamenodePriorityComparator());
        }
        return Collections.unmodifiableList(ret);
    }

    public synchronized List<? extends FederationNamenodeContext> getNamenodesForBlockPoolId(String blockPoolId) {
        List<? extends FederationNamenodeContext> namenodes = this.resolver.get(blockPoolId);
        return Collections.unmodifiableList(new ArrayList<FederationNamenodeContext>(namenodes));
    }

    public synchronized boolean registerNamenode(NamenodeStatusReport report) throws IOException {
        if (this.disableRegistration) {
            return false;
        }
        MockNamenodeContext context = new MockNamenodeContext(report.getRpcAddress(), report.getServiceAddress(), report.getLifelineAddress(), report.getWebScheme(), report.getWebAddress(), report.getNameserviceId(), report.getNamenodeId(), report.getState());
        String nsId = report.getNameserviceId();
        String bpId = report.getBlockPoolId();
        String cId = report.getClusterId();
        List<? extends FederationNamenodeContext> existingItems = this.resolver.get(nsId);
        if (existingItems == null) {
            existingItems = new ArrayList<FederationNamenodeContext>();
            this.resolver.put(bpId, existingItems);
            this.resolver.put(nsId, existingItems);
        }
        boolean added = false;
        for (int i = 0; i < existingItems.size() && !added; ++i) {
            MockNamenodeContext existing = (MockNamenodeContext)existingItems.get(i);
            if (!existing.getNamenodeKey().equals(context.getNamenodeKey())) continue;
            existingItems.set(i, context);
            added = true;
        }
        if (!added) {
            existingItems.add(context);
        }
        Collections.sort(existingItems, new NamenodePriorityComparator());
        FederationNamespaceInfo info = new FederationNamespaceInfo(bpId, cId, nsId);
        this.namespaces.add(info);
        return true;
    }

    public synchronized Set<FederationNamespaceInfo> getNamespaces() throws IOException {
        TreeSet<FederationNamespaceInfo> ret = new TreeSet<FederationNamespaceInfo>();
        Set<String> disabled = this.getDisabledNamespaces();
        for (FederationNamespaceInfo ns : this.namespaces) {
            if (disabled.contains(ns.getNameserviceId())) continue;
            ret.add(ns);
        }
        return Collections.unmodifiableSet(ret);
    }

    public void clearDisableNamespaces() {
        this.disableNamespaces.clear();
    }

    public void disableNamespace(String nsId) {
        this.disableNamespaces.add(nsId);
    }

    public Set<String> getDisabledNamespaces() throws IOException {
        return this.disableNamespaces;
    }

    public PathLocation getDestinationForPath(String path) throws IOException {
        LinkedList<RemoteLocation> remoteLocations = new LinkedList<RemoteLocation>();
        ArrayList<String> keys = new ArrayList<String>(this.locations.keySet());
        Collections.sort(keys, Collections.reverseOrder());
        for (String key : keys) {
            if (!path.startsWith(key)) continue;
            for (RemoteLocation location : this.locations.get(key)) {
                Object finalPath = location.getDest();
                String extraPath = path.substring(key.length());
                if (((String)finalPath).endsWith("/") && extraPath.startsWith("/")) {
                    extraPath = extraPath.substring(1);
                }
                finalPath = (String)finalPath + extraPath;
                String nameservice = location.getNameserviceId();
                RemoteLocation remoteLocation = new RemoteLocation(nameservice, (String)finalPath, path);
                remoteLocations.add(remoteLocation);
            }
        }
        if (remoteLocations.isEmpty()) {
            return null;
        }
        return new PathLocation(path, remoteLocations);
    }

    public List<String> getMountPoints(String path) throws IOException {
        ArrayList<String> mountPoints = new ArrayList<String>();
        for (String mp : this.locations.keySet()) {
            if (!mp.startsWith(path)) continue;
            mountPoints.add(mp);
        }
        return FileSubclusterResolver.getMountPoints((String)path, mountPoints);
    }

    public void setRouterId(String router) {
    }

    public void rotateCache(String nsId, FederationNamenodeContext namenode, boolean listObserversFirst) {
    }

    public void setDisableNamespace(boolean b) {
        this.disableDefaultNamespace = b;
    }

    public String getDefaultNamespace() {
        if (this.disableDefaultNamespace) {
            return "";
        }
        return this.defaultNamespace;
    }

    private static class MockNamenodeContext
    implements FederationNamenodeContext {
        private String namenodeId;
        private String nameserviceId;
        private String webScheme;
        private String webAddress;
        private String rpcAddress;
        private String serviceAddress;
        private String lifelineAddress;
        private FederationNamenodeServiceState state;
        private long dateModified;

        MockNamenodeContext(String rpc, String service, String lifeline, String scheme, String web, String ns, String nn, FederationNamenodeServiceState state) {
            this.rpcAddress = rpc;
            this.serviceAddress = service;
            this.lifelineAddress = lifeline;
            this.webScheme = scheme;
            this.webAddress = web;
            this.namenodeId = nn;
            this.nameserviceId = ns;
            this.state = state;
            this.dateModified = Time.now();
        }

        public void setState(FederationNamenodeServiceState newState) {
            this.state = newState;
            this.dateModified = Time.now();
        }

        public String getRpcAddress() {
            return this.rpcAddress;
        }

        public String getServiceAddress() {
            return this.serviceAddress;
        }

        public String getLifelineAddress() {
            return this.lifelineAddress;
        }

        public String getWebScheme() {
            return this.webScheme;
        }

        public String getWebAddress() {
            return this.webAddress;
        }

        public String getNamenodeKey() {
            return this.nameserviceId + " " + this.namenodeId + " " + this.rpcAddress;
        }

        public String getNameserviceId() {
            return this.nameserviceId;
        }

        public String getNamenodeId() {
            return this.namenodeId;
        }

        public FederationNamenodeServiceState getState() {
            return this.state;
        }

        public long getDateModified() {
            return this.dateModified;
        }
    }
}

