/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.ObserverReadProxyProvider;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniRouterDFSCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MiniRouterDFSCluster.class);
    public static final String TEST_STRING = "teststring";
    public static final String TEST_DIR = "testdir";
    public static final String TEST_FILE = "testfile";
    private static final Random RND = new Random();
    private List<String> nameservices;
    private List<NamenodeContext> namenodes;
    private List<RouterContext> routers;
    private boolean highAvailability;
    private int numDatanodesPerNameservice = 2;
    private StorageType[][] storageTypes = null;
    private String[] racks = null;
    private MiniDFSCluster cluster;
    public static final long DEFAULT_HEARTBEAT_INTERVAL_MS = TimeUnit.SECONDS.toMillis(5L);
    public static final long DEFAULT_CACHE_INTERVAL_MS = TimeUnit.SECONDS.toMillis(5L);
    private long heartbeatInterval;
    private long cacheFlushInterval;
    private Configuration routerConf;
    private Configuration routerOverrides;
    private Configuration namenodeOverrides;
    private boolean sharedDNs = true;

    public MiniRouterDFSCluster(boolean ha, int numNameservices, int numNamenodes, long heartbeatInterval, long cacheFlushInterval, Configuration overrideConf) {
        this.highAvailability = ha;
        this.heartbeatInterval = heartbeatInterval;
        this.cacheFlushInterval = cacheFlushInterval;
        this.configureNameservices(numNameservices, numNamenodes, overrideConf);
    }

    public MiniRouterDFSCluster(boolean ha, int numNameservices, int numNamenodes, long heartbeatInterval, long cacheFlushInterval) {
        this(ha, numNameservices, numNamenodes, heartbeatInterval, cacheFlushInterval, null);
    }

    public MiniRouterDFSCluster(boolean ha, int numNameservices) {
        this(ha, numNameservices, 2, DEFAULT_HEARTBEAT_INTERVAL_MS, DEFAULT_CACHE_INTERVAL_MS, null);
    }

    public MiniRouterDFSCluster(boolean ha, int numNameservices, int numNamenodes) {
        this(ha, numNameservices, numNamenodes, DEFAULT_HEARTBEAT_INTERVAL_MS, DEFAULT_CACHE_INTERVAL_MS, null);
    }

    public MiniRouterDFSCluster(boolean ha, int numNameservices, Configuration overrideConf) {
        this(ha, numNameservices, 2, DEFAULT_HEARTBEAT_INTERVAL_MS, DEFAULT_CACHE_INTERVAL_MS, overrideConf);
    }

    public void addRouterOverrides(Configuration conf) {
        if (this.routerOverrides == null) {
            this.routerOverrides = conf;
        } else {
            this.routerOverrides.addResource(conf);
        }
    }

    public void addNamenodeOverrides(Configuration conf) {
        if (this.namenodeOverrides == null) {
            this.namenodeOverrides = conf;
        } else {
            this.namenodeOverrides.addResource(conf);
        }
    }

    public Configuration generateNamenodeConfiguration(String nsId) {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", this.getNameservicesKey());
        conf.set("fs.defaultFS", "hdfs://" + nsId);
        for (String ns : this.nameservices) {
            if (this.highAvailability) {
                conf.set("dfs.ha.namenodes." + ns, FederationTestUtils.NAMENODES[0] + "," + FederationTestUtils.NAMENODES[1]);
            }
            for (NamenodeContext context : this.getNamenodes(ns)) {
                String suffix = context.getConfSuffix();
                conf.set("dfs.namenode.rpc-address." + suffix, "127.0.0.1:" + context.rpcPort);
                conf.set("dfs.namenode.http-address." + suffix, "127.0.0.1:" + context.httpPort);
                conf.set("dfs.namenode.rpc-bind-host." + suffix, "0.0.0.0");
                conf.set("dfs.namenode.https-address." + suffix, "127.0.0.1:" + context.httpsPort);
                conf.set("dfs.client.failover.proxy.provider." + ns, ConfiguredFailoverProxyProvider.class.getName());
                boolean servicePortEnabled = false;
                if (!servicePortEnabled) continue;
                conf.set("dfs.namenode.servicerpc-address." + suffix, "127.0.0.1:" + context.servicePort);
                conf.set("dfs.namenode.servicerpc-bind-host." + suffix, "0.0.0.0");
            }
        }
        if (this.namenodeOverrides != null) {
            conf.addResource(this.namenodeOverrides);
        }
        return conf;
    }

    public Configuration generateClientConfiguration() {
        HdfsConfiguration conf = new HdfsConfiguration(false);
        String ns0 = this.getNameservices().get(0);
        conf.addResource(this.generateNamenodeConfiguration(ns0));
        return conf;
    }

    public Configuration generateRouterConfiguration(String nsId, String nnId) {
        Configuration conf = this.routerConf == null ? new Configuration(false) : new Configuration(this.routerConf);
        conf.addResource(this.generateNamenodeConfiguration(nsId));
        conf.setInt("dfs.federation.router.handler.count", 10);
        conf.set("dfs.federation.router.rpc-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.rpc-bind-host", "0.0.0.0");
        conf.set("dfs.federation.router.admin-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.admin-bind-host", "0.0.0.0");
        conf.set("dfs.federation.router.http-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.https-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.http-bind-host", "0.0.0.0");
        conf.set("dfs.federation.router.default.nameserviceId", this.nameservices.get(0));
        conf.setLong("dfs.federation.router.heartbeat.interval", this.heartbeatInterval);
        conf.setLong("dfs.federation.router.cache.ttl", this.cacheFlushInterval);
        conf.setClass("dfs.federation.router.namenode.resolver.client.class", MockResolver.class, ActiveNamenodeResolver.class);
        conf.setClass("dfs.federation.router.file.resolver.client.class", MockResolver.class, FileSubclusterResolver.class);
        conf.setBoolean("dfs.federation.router.safemode.enable", false);
        conf.set("dfs.nameservice.id", nsId);
        if (nnId != null) {
            conf.set("dfs.ha.namenode.id", nnId);
        }
        StringBuilder sb = new StringBuilder();
        for (String ns : this.nameservices) {
            for (NamenodeContext context : this.getNamenodes(ns)) {
                String suffix = context.getConfSuffix();
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(suffix);
            }
        }
        conf.set("dfs.federation.router.monitor.namenode", sb.toString());
        if (this.routerOverrides != null) {
            for (Map.Entry entry : this.routerOverrides) {
                String confKey = (String)entry.getKey();
                String confValue = (String)entry.getValue();
                conf.set(confKey, confValue);
            }
        }
        return conf;
    }

    public void configureNameservices(int numNameservices, int numNamenodes, Configuration overrideConf) {
        this.nameservices = new ArrayList<String>();
        this.namenodes = new ArrayList<NamenodeContext>();
        NamenodeContext context = null;
        int nnIndex = 0;
        for (int i = 0; i < numNameservices; ++i) {
            String ns = "ns" + i;
            this.nameservices.add("ns" + i);
            Configuration nnConf = this.generateNamenodeConfiguration(ns);
            if (overrideConf != null) {
                nnConf.addResource(overrideConf);
            }
            if (!this.highAvailability) {
                context = new NamenodeContext(nnConf, ns, null, nnIndex++);
                this.namenodes.add(context);
                continue;
            }
            for (int j = 0; j < numNamenodes; ++j) {
                context = new NamenodeContext(nnConf, ns, FederationTestUtils.NAMENODES[j], nnIndex++);
                this.namenodes.add(context);
            }
        }
    }

    public void setNumDatanodesPerNameservice(int num) {
        this.numDatanodesPerNameservice = num;
    }

    public void setStorageTypes(StorageType[][] storageTypes) {
        this.storageTypes = storageTypes;
    }

    public void setRacks(String[] racks) {
        this.racks = racks;
    }

    public void setIndependentDNs() {
        this.sharedDNs = false;
    }

    public String getNameservicesKey() {
        StringBuilder sb = new StringBuilder();
        for (String nsId : this.nameservices) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(nsId);
        }
        return sb.toString();
    }

    public String getRandomNameservice() {
        int randIndex = RND.nextInt(this.nameservices.size());
        return this.nameservices.get(randIndex);
    }

    public List<String> getNameservices() {
        return this.nameservices;
    }

    public List<NamenodeContext> getNamenodes(String nameservice) {
        ArrayList<NamenodeContext> nns = new ArrayList<NamenodeContext>();
        for (NamenodeContext c : this.namenodes) {
            if (!c.nameserviceId.equals(nameservice)) continue;
            nns.add(c);
        }
        return nns;
    }

    public NamenodeContext getRandomNamenode() {
        Random rand = new Random();
        int i = rand.nextInt(this.namenodes.size());
        return this.namenodes.get(i);
    }

    public List<NamenodeContext> getNamenodes() {
        return this.namenodes;
    }

    public boolean isHighAvailability() {
        return this.highAvailability;
    }

    public NamenodeContext getNamenode(String nameservice, String namenode) {
        for (NamenodeContext c : this.namenodes) {
            if (!c.nameserviceId.equals(nameservice)) continue;
            if (namenode == null || namenode.isEmpty() || c.namenodeId == null || c.namenodeId.isEmpty()) {
                return c;
            }
            if (!c.namenodeId.equals(namenode)) continue;
            return c;
        }
        return null;
    }

    public List<RouterContext> getRouters(String nameservice) {
        ArrayList<RouterContext> nns = new ArrayList<RouterContext>();
        for (RouterContext c : this.routers) {
            if (!c.nameserviceId.equals(nameservice)) continue;
            nns.add(c);
        }
        return nns;
    }

    public RouterContext getRouterContext(String nsId, String nnId) {
        for (RouterContext c : this.routers) {
            if (nnId == null) {
                return c;
            }
            if (!c.namenodeId.equals(nnId) || !c.nameserviceId.equals(nsId)) continue;
            return c;
        }
        return null;
    }

    public RouterContext getRandomRouter() {
        Random rand = new Random();
        return this.routers.get(rand.nextInt(this.routers.size()));
    }

    public List<RouterContext> getRouters() {
        return this.routers;
    }

    public RouterContext buildRouter(String nsId, String nnId) throws URISyntaxException, IOException {
        Configuration config = this.generateRouterConfiguration(nsId, nnId);
        RouterContext rc = new RouterContext(config, nsId, nnId);
        return rc;
    }

    public void startCluster() {
        this.startCluster(null);
    }

    public void startCluster(Configuration overrideConf) {
        block11: {
            try {
                MiniDFSNNTopology topology = new MiniDFSNNTopology();
                for (String ns : this.nameservices) {
                    MiniDFSNNTopology.NSConf conf = new MiniDFSNNTopology.NSConf(ns);
                    if (this.highAvailability) {
                        for (int i = 0; i < this.namenodes.size() / this.nameservices.size(); ++i) {
                            MiniDFSNNTopology.NNConf nnConf = new MiniDFSNNTopology.NNConf("nn" + i);
                            conf.addNN(nnConf);
                        }
                    } else {
                        MiniDFSNNTopology.NNConf nnConf = new MiniDFSNNTopology.NNConf(null);
                        conf.addNN(nnConf);
                    }
                    topology.addNameservice(conf);
                }
                topology.setFederation(true);
                String ns0 = this.nameservices.get(0);
                Configuration nnConf = this.generateNamenodeConfiguration(ns0);
                if (overrideConf != null) {
                    nnConf.addResource(overrideConf);
                    this.routerConf = new Configuration(overrideConf);
                }
                int numDNs = this.nameservices.size() * this.numDatanodesPerNameservice;
                Configuration[] dnConfs = null;
                if (!this.sharedDNs) {
                    dnConfs = new Configuration[numDNs];
                    int dnId = 0;
                    for (String nsId : this.nameservices) {
                        Configuration subclusterConf = new Configuration(nnConf);
                        subclusterConf.set("dfs.internal.nameservices", nsId);
                        for (int i = 0; i < this.numDatanodesPerNameservice; ++i) {
                            dnConfs[dnId] = subclusterConf;
                            ++dnId;
                        }
                    }
                }
                this.cluster = new MiniDFSCluster.Builder(nnConf).numDataNodes(numDNs).nnTopology(topology).dataNodeConfOverlays(dnConfs).checkExitOnShutdown(false).storageTypes(this.storageTypes).racks(this.racks).build();
                this.cluster.waitActive();
                for (int i = 0; i < this.namenodes.size(); ++i) {
                    NameNode nn = this.cluster.getNameNode(i);
                    this.namenodes.get(i).setNamenode(nn);
                }
            }
            catch (Exception e) {
                LOG.error("Cannot start Router DFS cluster: {}", (Object)e.getMessage(), (Object)e);
                if (this.cluster == null) break block11;
                this.cluster.shutdown();
            }
        }
    }

    public void startRouters() throws InterruptedException, URISyntaxException, IOException {
        this.routers = new ArrayList<RouterContext>();
        for (String ns : this.nameservices) {
            for (NamenodeContext context : this.getNamenodes(ns)) {
                RouterContext router = this.buildRouter(ns, context.namenodeId);
                this.routers.add(router);
            }
        }
        for (RouterContext router : this.routers) {
            router.router.start();
        }
        for (RouterContext router : this.routers) {
            this.waitActive(router);
            router.initRouter();
        }
    }

    public void waitActive(NamenodeContext nn) throws IOException {
        this.cluster.waitActive(nn.index);
    }

    public void waitActive(RouterContext router) throws InterruptedException {
        for (int loopCount = 0; loopCount < 20; ++loopCount) {
            if (router.router.getServiceState() == Service.STATE.STARTED) {
                return;
            }
            Thread.sleep(1000L);
        }
        Assertions.fail((String)("Timeout waiting for " + router.router + " to activate"));
    }

    public void registerNamenodes() throws IOException {
        for (RouterContext r : this.routers) {
            ActiveNamenodeResolver resolver = r.router.getNamenodeResolver();
            for (NamenodeContext nn : this.namenodes) {
                NamenodeStatusReport report = new NamenodeStatusReport(nn.nameserviceId, nn.namenodeId, nn.getRpcAddress(), nn.getServiceAddress(), nn.getLifelineAddress(), "http", nn.getWebAddress());
                FSImage fsImage = nn.namenode.getNamesystem().getFSImage();
                NamespaceInfo nsInfo = fsImage.getStorage().getNamespaceInfo();
                report.setNamespaceInfo(nsInfo);
                String nnState = nn.namenode.getState();
                HAServiceProtocol.HAServiceState haState = HAServiceProtocol.HAServiceState.ACTIVE;
                for (HAServiceProtocol.HAServiceState state : HAServiceProtocol.HAServiceState.values()) {
                    if (!nnState.equalsIgnoreCase(state.name())) continue;
                    haState = state;
                    break;
                }
                report.setHAServiceState(haState);
                resolver.registerNamenode(report);
            }
        }
    }

    public void waitNamenodeRegistration() throws Exception {
        for (RouterContext r : this.routers) {
            Router router = r.router;
            for (NamenodeContext nn : this.namenodes) {
                ActiveNamenodeResolver nnResolver = router.getNamenodeResolver();
                FederationTestUtils.waitNamenodeRegistered(nnResolver, nn.nameserviceId, nn.namenodeId, null);
            }
        }
    }

    public void waitRouterRegistrationQuorum(RouterContext router, FederationNamenodeServiceState state, String nsId, String nnId) throws Exception {
        LOG.info("Waiting for NN {} {} to transition to {}", new Object[]{nsId, nnId, state});
        ActiveNamenodeResolver nnResolver = router.router.getNamenodeResolver();
        FederationTestUtils.waitNamenodeRegistered(nnResolver, nsId, nnId, state);
    }

    public void waitActiveNamespaces() throws Exception {
        for (RouterContext r : this.routers) {
            Router router = r.router;
            ActiveNamenodeResolver resolver = router.getNamenodeResolver();
            for (FederationNamespaceInfo ns : resolver.getNamespaces()) {
                String nsId = ns.getNameserviceId();
                FederationTestUtils.waitNamenodeRegistered(resolver, nsId, FederationNamenodeServiceState.ACTIVE);
            }
        }
    }

    public String getFederatedPathForNS(String nsId) {
        return "/" + nsId;
    }

    public String getNamenodePathForNS(String nsId) {
        return "/target-" + nsId;
    }

    public String getFederatedTestDirectoryForNS(String nsId) {
        return this.getFederatedPathForNS(nsId) + "/testdir";
    }

    public String getNamenodeTestDirectoryForNS(String nsId) {
        return this.getNamenodePathForNS(nsId) + "/testdir";
    }

    public String getFederatedTestFileForNS(String nsId) {
        return this.getFederatedPathForNS(nsId) + "/testfile";
    }

    public String getNamenodeTestFileForNS(String nsId) {
        return this.getNamenodePathForNS(nsId) + "/testfile";
    }

    public void switchToActive(String nsId, String nnId) {
        try {
            int total = this.cluster.getNumNameNodes();
            MiniDFSCluster.NameNodeInfo[] nns = this.cluster.getNameNodeInfos();
            for (int i = 0; i < total; ++i) {
                MiniDFSCluster.NameNodeInfo nn = nns[i];
                if (!nn.getNameserviceId().equals(nsId) || !nn.getNamenodeId().equals(nnId)) continue;
                this.cluster.transitionToActive(i);
            }
        }
        catch (Throwable e) {
            LOG.error("Cannot transition to active", e);
        }
    }

    public void switchToStandby(String nsId, String nnId) {
        try {
            int total = this.cluster.getNumNameNodes();
            MiniDFSCluster.NameNodeInfo[] nns = this.cluster.getNameNodeInfos();
            for (int i = 0; i < total; ++i) {
                MiniDFSCluster.NameNodeInfo nn = nns[i];
                if (!nn.getNameserviceId().equals(nsId) || !nn.getNamenodeId().equals(nnId)) continue;
                this.cluster.transitionToStandby(i);
            }
        }
        catch (Throwable e) {
            LOG.error("Cannot transition to standby", e);
        }
    }

    public void switchToObserver(String nsId, String nnId) {
        try {
            int total = this.cluster.getNumNameNodes();
            MiniDFSCluster.NameNodeInfo[] nns = this.cluster.getNameNodeInfos();
            for (int i = 0; i < total; ++i) {
                MiniDFSCluster.NameNodeInfo nn = nns[i];
                if (!nn.getNameserviceId().equals(nsId) || !nn.getNamenodeId().equals(nnId)) continue;
                this.cluster.transitionToObserver(i);
            }
        }
        catch (Throwable e) {
            LOG.error("Cannot transition to active", e);
        }
    }

    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        if (this.routers != null) {
            for (RouterContext context : this.routers) {
                this.stopRouter(context);
            }
        }
    }

    public void stopRouter(RouterContext router) {
        try {
            router.router.shutDown();
            int loopCount = 0;
            while (router.router.getServiceState() != Service.STATE.STOPPED) {
                Thread.sleep(1000L);
                if (++loopCount <= 20) continue;
                LOG.error("Cannot shutdown router {}", (Object)router.rpcPort);
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void createTestDirectoriesNamenode() throws IOException {
        for (String ns : this.getNameservices()) {
            NamenodeContext context = this.getNamenode(ns, null);
            if (this.createTestDirectoriesNamenode(context)) continue;
            throw new IOException("Cannot create test directory for ns " + ns);
        }
    }

    public boolean createTestDirectoriesNamenode(NamenodeContext nn) throws IOException {
        FileSystem fs = nn.getFileSystem();
        String testDir = this.getNamenodeTestDirectoryForNS(nn.nameserviceId);
        return FederationTestUtils.addDirectory(fs, testDir);
    }

    public void deleteAllFiles() throws IOException {
        for (NamenodeContext context : this.getNamenodes()) {
            FileSystem fs = context.getFileSystem();
            FileStatus[] status = fs.listStatus(new Path("/"));
            for (int i = 0; i < status.length; ++i) {
                Path p = status[i].getPath();
                fs.delete(p, true);
            }
            status = fs.listStatus(new Path("/"));
            Assertions.assertEquals((int)status.length, (int)0);
        }
    }

    public void installMockLocations() {
        for (RouterContext r : this.routers) {
            MockResolver resolver = (MockResolver)r.router.getSubclusterResolver();
            for (String nsId : this.nameservices) {
                String routerPath = this.getFederatedPathForNS(nsId);
                String nnPath = this.getNamenodePathForNS(nsId);
                resolver.addLocation(routerPath, nsId, nnPath);
            }
            String ns0 = this.nameservices.get(0);
            resolver.addLocation("/", ns0, "/");
        }
    }

    public MiniDFSCluster getCluster() {
        return this.cluster;
    }

    public void waitClusterUp() throws IOException {
        this.cluster.waitClusterUp();
        this.registerNamenodes();
        try {
            this.waitNamenodeRegistration();
        }
        catch (Exception e) {
            throw new IOException("Cannot wait for the namenodes", e);
        }
    }

    public long getCacheFlushInterval() {
        return this.cacheFlushInterval;
    }

    public class NamenodeContext {
        private Configuration conf;
        private NameNode namenode;
        private String nameserviceId;
        private String namenodeId;
        private FileContext fileContext;
        private int rpcPort;
        private int servicePort;
        private int lifelinePort;
        private int httpPort;
        private int httpsPort;
        private URI fileSystemUri;
        private int index;
        private DFSClient client;

        public NamenodeContext(Configuration conf, String nsId, String nnId, int index) {
            this.conf = conf;
            this.nameserviceId = nsId;
            this.namenodeId = nnId;
            this.index = index;
        }

        public NameNode getNamenode() {
            return this.namenode;
        }

        public String getNameserviceId() {
            return this.nameserviceId;
        }

        public String getNamenodeId() {
            return this.namenodeId;
        }

        public FileContext getFileContext() {
            return this.fileContext;
        }

        public void setNamenode(NameNode nn) throws URISyntaxException {
            this.namenode = nn;
            this.rpcPort = nn.getNameNodeAddress().getPort();
            this.servicePort = nn.getServiceRpcAddress().getPort();
            this.lifelinePort = nn.getServiceRpcAddress().getPort();
            if (nn.getHttpAddress() != null) {
                this.httpPort = nn.getHttpAddress().getPort();
            }
            if (nn.getHttpsAddress() != null) {
                this.httpsPort = nn.getHttpsAddress().getPort();
            }
            this.fileSystemUri = new URI("hdfs://" + this.namenode.getHostAndPort());
            DistributedFileSystem.setDefaultUri((Configuration)this.conf, (URI)this.fileSystemUri);
            try {
                this.fileContext = FileContext.getFileContext((Configuration)this.conf);
            }
            catch (UnsupportedFileSystemException e) {
                this.fileContext = null;
            }
        }

        public String getRpcAddress() {
            return this.namenode.getNameNodeAddress().getHostName() + ":" + this.rpcPort;
        }

        public String getServiceAddress() {
            return this.namenode.getServiceRpcAddress().getHostName() + ":" + this.servicePort;
        }

        public String getLifelineAddress() {
            return this.namenode.getServiceRpcAddress().getHostName() + ":" + this.lifelinePort;
        }

        public String getWebAddress() {
            if (this.conf.get("dfs.http.policy").equals(HttpConfig.Policy.HTTPS_ONLY.name())) {
                return this.getHttpsAddress();
            }
            return this.getHttpAddress();
        }

        public String getHttpAddress() {
            return this.namenode.getHttpAddress().getHostName() + ":" + this.httpPort;
        }

        public String getHttpsAddress() {
            return this.namenode.getHttpsAddress().getHostName() + ":" + this.httpsPort;
        }

        public FileSystem getFileSystem() throws IOException {
            return DistributedFileSystem.get((Configuration)this.conf);
        }

        public void resetClient() {
            this.client = null;
        }

        public DFSClient getClient(UserGroupInformation user) throws IOException, URISyntaxException, InterruptedException {
            LOG.info("Connecting to namenode at {}", (Object)this.fileSystemUri);
            return (DFSClient)user.doAs(() -> new DFSClient(this.fileSystemUri, this.conf));
        }

        public DFSClient getClient() throws IOException, URISyntaxException {
            if (this.client == null) {
                LOG.info("Connecting to namenode at {}", (Object)this.fileSystemUri);
                this.client = new DFSClient(this.fileSystemUri, this.conf);
            }
            return this.client;
        }

        public String getConfSuffix() {
            Object suffix = this.nameserviceId;
            if (MiniRouterDFSCluster.this.highAvailability) {
                suffix = (String)suffix + "." + this.namenodeId;
            }
            return suffix;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }

    public static class RouterContext {
        private Router router;
        private FileContext fileContext;
        private String nameserviceId;
        private String namenodeId;
        private int rpcPort;
        private int httpPort;
        private DFSClient client;
        private Configuration conf;
        private RouterClient adminClient;
        private URI fileSystemUri;

        public RouterContext(Configuration conf, String nsId, String nnId) {
            this.conf = conf;
            this.nameserviceId = nsId;
            this.namenodeId = nnId;
            this.router = new Router();
            this.router.init(conf);
        }

        public Router getRouter() {
            return this.router;
        }

        public String getNameserviceId() {
            return this.nameserviceId;
        }

        public String getNamenodeId() {
            return this.namenodeId;
        }

        public int getRpcPort() {
            return this.rpcPort;
        }

        public int getHttpPort() {
            return this.httpPort;
        }

        public FileContext getFileContext() {
            return this.fileContext;
        }

        public URI getFileSystemURI() {
            return this.fileSystemUri;
        }

        public String getHttpAddress() {
            InetSocketAddress httpAddress = this.router.getHttpServerAddress();
            return NetUtils.getHostPortString((InetSocketAddress)httpAddress);
        }

        public void initRouter() throws URISyntaxException {
            InetSocketAddress httpAddress;
            InetSocketAddress rpcAddress = this.router.getRpcServerAddress();
            if (rpcAddress != null) {
                this.rpcPort = rpcAddress.getPort();
                this.fileSystemUri = URI.create("hdfs://" + NetUtils.getHostPortString((InetSocketAddress)rpcAddress));
                DistributedFileSystem.setDefaultUri((Configuration)this.conf, (URI)this.fileSystemUri);
                try {
                    this.fileContext = FileContext.getFileContext((Configuration)this.conf);
                }
                catch (UnsupportedFileSystemException e) {
                    this.fileContext = null;
                }
            }
            if ((httpAddress = this.router.getHttpServerAddress()) != null) {
                this.httpPort = httpAddress.getPort();
            }
        }

        public FileSystem getFileSystem() throws IOException {
            return DistributedFileSystem.get((Configuration)this.conf);
        }

        public FileSystem getFileSystem(Configuration configuration) throws IOException {
            configuration.addResource(this.conf);
            return DistributedFileSystem.get((Configuration)configuration);
        }

        public FileSystem getFileSystemWithObserverReadProxyProvider() throws IOException {
            return this.getFileSystemWithProxyProvider(ObserverReadProxyProvider.class.getName());
        }

        public FileSystem getFileSystemWithConfiguredFailoverProxyProvider() throws IOException {
            return this.getFileSystemWithProxyProvider(ConfiguredFailoverProxyProvider.class.getName());
        }

        private FileSystem getFileSystemWithProxyProvider(String proxyProviderClassName) throws IOException {
            this.conf.set("dfs.nameservices", this.conf.get("dfs.nameservices") + ",router-service");
            this.conf.set("dfs.ha.namenodes.router-service", "router1");
            this.conf.set("dfs.namenode.rpc-address.router-service.router1", this.getFileSystemURI().toString());
            this.conf.set("dfs.client.failover.proxy.provider.router-service", proxyProviderClassName);
            DistributedFileSystem.setDefaultUri((Configuration)this.conf, (String)"hdfs://router-service");
            return DistributedFileSystem.get((Configuration)this.conf);
        }

        public DFSClient getClient(UserGroupInformation user) throws IOException, URISyntaxException, InterruptedException {
            LOG.info("Connecting to router at {}", (Object)this.fileSystemUri);
            return (DFSClient)user.doAs(() -> new DFSClient(this.fileSystemUri, this.conf));
        }

        public RouterClient getAdminClient() throws IOException {
            if (this.adminClient == null) {
                InetSocketAddress routerSocket = this.router.getAdminServerAddress();
                LOG.info("Connecting to router admin at {}", (Object)routerSocket);
                this.adminClient = new RouterClient(routerSocket, this.conf);
            }
            return this.adminClient;
        }

        public void resetAdminClient() {
            this.adminClient = null;
        }

        public DFSClient getClient() throws IOException, URISyntaxException {
            if (this.client == null) {
                LOG.info("Connecting to router at {}", (Object)this.fileSystemUri);
                this.client = new DFSClient(this.fileSystemUri, this.conf);
            }
            return this.client;
        }

        public Configuration getConf() {
            return this.conf;
        }

        public RouterRpcServer getRouterRpcServer() {
            return this.router.getRpcServer();
        }

        public RouterRpcClient getRouterRpcClient() {
            return this.getRouterRpcServer().getRPCClient();
        }
    }
}

