/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocolPB.AsyncRpcProtocolPBUtil;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.RouterClientProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.RouterGetUserMappingsProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.RouterNamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.RouterRefreshUserMappingsProtocolTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterClientSideTranslatorPB {
    private static MiniDFSCluster cluster = null;
    private static InetSocketAddress nnAddress = null;
    private static Configuration conf = null;
    private static RouterClientProtocolTranslatorPB clientProtocolTranslatorPB;
    private static RouterGetUserMappingsProtocolTranslatorPB getUserMappingsProtocolTranslatorPB;
    private static RouterNamenodeProtocolTranslatorPB namenodeProtocolTranslatorPB;
    private static RouterRefreshUserMappingsProtocolTranslatorPB refreshUserMappingsProtocolTranslatorPB;
    private static final String TEST_DIR_PATH = "/test";
    private boolean mode;

    @BeforeAll
    public static void setUp() throws Exception {
        AsyncRpcProtocolPBUtil.setAsyncResponderExecutor((Executor)ForkJoinPool.commonPool());
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitClusterUp();
        nnAddress = cluster.getNameNode().getNameNodeAddress();
        clientProtocolTranslatorPB = new RouterClientProtocolTranslatorPB(TestRouterClientSideTranslatorPB.createProxy(ClientNamenodeProtocolPB.class));
        getUserMappingsProtocolTranslatorPB = new RouterGetUserMappingsProtocolTranslatorPB(TestRouterClientSideTranslatorPB.createProxy(GetUserMappingsProtocolPB.class));
        namenodeProtocolTranslatorPB = new RouterNamenodeProtocolTranslatorPB(TestRouterClientSideTranslatorPB.createProxy(NamenodeProtocolPB.class));
        refreshUserMappingsProtocolTranslatorPB = new RouterRefreshUserMappingsProtocolTranslatorPB(TestRouterClientSideTranslatorPB.createProxy(RefreshUserMappingsProtocolPB.class));
    }

    @AfterAll
    public static void tearDown() throws Exception {
        if (clientProtocolTranslatorPB != null) {
            clientProtocolTranslatorPB.close();
        }
        if (getUserMappingsProtocolTranslatorPB != null) {
            getUserMappingsProtocolTranslatorPB.close();
        }
        if (namenodeProtocolTranslatorPB != null) {
            namenodeProtocolTranslatorPB.close();
        }
        if (refreshUserMappingsProtocolTranslatorPB != null) {
            refreshUserMappingsProtocolTranslatorPB.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setAsync() {
        this.mode = Client.isAsynchronousMode();
        Client.setAsynchronousMode((boolean)true);
    }

    @AfterEach
    public void unsetAsync() {
        Client.setAsynchronousMode((boolean)this.mode);
    }

    @Test
    public void testRouterClientProtocolTranslatorPB() throws Exception {
        clientProtocolTranslatorPB.mkdirs(TEST_DIR_PATH, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL), false);
        Boolean success = (Boolean)AsyncUtil.syncReturn(Boolean.class);
        Assertions.assertTrue((boolean)success);
        clientProtocolTranslatorPB.setPermission(TEST_DIR_PATH, new FsPermission(FsAction.READ_WRITE, FsAction.READ, FsAction.NONE));
        AsyncUtil.syncReturn(Void.class);
        clientProtocolTranslatorPB.getFileInfo(TEST_DIR_PATH);
        HdfsFileStatus hdfsFileStatus = (HdfsFileStatus)AsyncUtil.syncReturn(HdfsFileStatus.class);
        Assertions.assertEquals((Object)hdfsFileStatus.getPermission(), (Object)new FsPermission(FsAction.READ_WRITE, FsAction.READ, FsAction.NONE));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.DEFAULT, (AclEntryType)AclEntryType.USER, (String)"tmpUser", (FsAction)FsAction.ALL)});
        clientProtocolTranslatorPB.setAcl(TEST_DIR_PATH, (List)aclSpec);
        AsyncUtil.syncReturn(Void.class);
        clientProtocolTranslatorPB.setOwner(TEST_DIR_PATH, "tmpUser", "tmpUserGroup");
        AsyncUtil.syncReturn(Void.class);
        clientProtocolTranslatorPB.getFileInfo(TEST_DIR_PATH);
        hdfsFileStatus = (HdfsFileStatus)AsyncUtil.syncReturn(HdfsFileStatus.class);
        Assertions.assertEquals((Object)"tmpUser", (Object)hdfsFileStatus.getOwner());
        Assertions.assertEquals((Object)"tmpUserGroup", (Object)hdfsFileStatus.getGroup());
        clientProtocolTranslatorPB.create("/test/testCreate.file", new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL), "testAsyncClient", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), false, (short)1, 0x8000000L, new CryptoProtocolVersion[]{CryptoProtocolVersion.ENCRYPTION_ZONES}, null, null);
        hdfsFileStatus = (HdfsFileStatus)AsyncUtil.syncReturn(HdfsFileStatus.class);
        Assertions.assertTrue((boolean)hdfsFileStatus.isFile());
        Assertions.assertEquals((long)0x8000000L, (long)hdfsFileStatus.getBlockSize());
        clientProtocolTranslatorPB.getListing(TEST_DIR_PATH, new byte[1], true);
        DirectoryListing directoryListing = (DirectoryListing)AsyncUtil.syncReturn(DirectoryListing.class);
        Assertions.assertEquals((int)1, (int)directoryListing.getPartialListing().length);
        clientProtocolTranslatorPB.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
        DatanodeInfo[] datanodeInfos = (DatanodeInfo[])AsyncUtil.syncReturn(DatanodeInfo[].class);
        Assertions.assertEquals((int)1, (int)datanodeInfos.length);
        clientProtocolTranslatorPB.createSymlink("/test/testCreate.file", "/link/link.file", new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL), true);
        AsyncUtil.syncReturn(Void.class);
        clientProtocolTranslatorPB.getFileLinkInfo("/link/link.file");
        hdfsFileStatus = (HdfsFileStatus)AsyncUtil.syncReturn(HdfsFileStatus.class);
        Assertions.assertEquals((Object)"testCreate.file", (Object)hdfsFileStatus.getSymlink().getName());
        clientProtocolTranslatorPB.rename("/test/testCreate.file", "/test/testRename.file");
        success = (Boolean)AsyncUtil.syncReturn(Boolean.TYPE);
        Assertions.assertTrue((boolean)success);
        clientProtocolTranslatorPB.delete(TEST_DIR_PATH, true);
        success = (Boolean)AsyncUtil.syncReturn(Boolean.TYPE);
        Assertions.assertTrue((boolean)success);
        LambdaTestUtils.intercept(RemoteException.class, (String)"Parent directory doesn't exist: /test", () -> {
            clientProtocolTranslatorPB.mkdirs("/test/testCreate.file", new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL), false);
            AsyncUtil.syncReturn(Boolean.TYPE);
        });
    }

    @Test
    public void testRouterGetUserMappingsProtocolTranslatorPB() throws Exception {
        getUserMappingsProtocolTranslatorPB.getGroupsForUser("root");
        String[] strings = (String[])AsyncUtil.syncReturn(String[].class);
        Assertions.assertTrue((strings.length != 0 ? 1 : 0) != 0);
        getUserMappingsProtocolTranslatorPB.getGroupsForUser("tmp");
        strings = (String[])AsyncUtil.syncReturn(String[].class);
        Assertions.assertEquals((int)0, (int)strings.length);
    }

    @Test
    public void testRouterNamenodeProtocolTranslatorPB() throws Exception {
        namenodeProtocolTranslatorPB.getTransactionID();
        Long id = (Long)AsyncUtil.syncReturn(Long.class);
        Assertions.assertTrue((id > 0L ? 1 : 0) != 0);
        namenodeProtocolTranslatorPB.getBlockKeys();
        ExportedBlockKeys exportedBlockKeys = (ExportedBlockKeys)AsyncUtil.syncReturn(ExportedBlockKeys.class);
        Assertions.assertNotNull((Object)exportedBlockKeys);
        namenodeProtocolTranslatorPB.rollEditLog();
        CheckpointSignature checkpointSignature = (CheckpointSignature)AsyncUtil.syncReturn(CheckpointSignature.class);
        Assertions.assertNotNull((Object)checkpointSignature);
    }

    @Test
    public void testRouterRefreshUserMappingsProtocolTranslatorPB() throws Exception {
        refreshUserMappingsProtocolTranslatorPB.refreshUserToGroupsMappings();
        AsyncUtil.syncReturn(Void.class);
        refreshUserMappingsProtocolTranslatorPB.refreshSuperUserGroupsConfiguration();
        AsyncUtil.syncReturn(Void.class);
    }

    public static <P> P createProxy(Class<P> protocol) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine2.class);
        long version = RPC.getProtocolVersion(protocol);
        return (P)RPC.getProtocolProxy(protocol, (long)version, (InetSocketAddress)nnAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)RPC.getRpcTimeout((Configuration)conf), null, (AtomicBoolean)new AtomicBoolean(false)).getProxy();
    }
}

