/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocolPB.AsyncRpcProtocolPBUtil;
import org.apache.hadoop.hdfs.protocolPB.TestClientProtocol;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.ipc.protobuf.TestProtos;

public class TestClientProtocolTranslatorPB
implements TestClientProtocol,
Closeable {
    private final TestRpcBase.TestRpcService rpcProxy;

    public TestClientProtocolTranslatorPB(TestRpcBase.TestRpcService rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void ping() throws IOException {
        TestProtos.EmptyRequestProto req = TestProtos.EmptyRequestProto.newBuilder().build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.ping(null, req), res -> null, Void.class);
    }

    @Override
    public String echo(String echoMessage) throws IOException {
        TestProtos.EchoRequestProto req = TestProtos.EchoRequestProto.newBuilder().setMessage(echoMessage).build();
        return (String)AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.echo(null, req), res -> res.getMessage(), String.class);
    }

    @Override
    public void error() throws IOException {
        TestProtos.EmptyRequestProto req = TestProtos.EmptyRequestProto.newBuilder().build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.error(null, req), res -> null, Void.class);
    }

    @Override
    public int add(int num1, int num2) throws IOException {
        TestProtos.AddRequestProto req = TestProtos.AddRequestProto.newBuilder().setParam1(num1).setParam2(num2).build();
        return (Integer)AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.add(null, req), res -> res.getResult(), Integer.class);
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }
}

