/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocolPB.AsyncRpcProtocolPBUtil;
import org.apache.hadoop.hdfs.protocolPB.TestClientProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.TestClientProtocolTranslatorPB;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.ipc.protobuf.TestRpcServiceProtos;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAsyncRpcProtocolPBUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TestAsyncRpcProtocolPBUtil.class);
    private static final int SERVER_PROCESS_COST_MS = 100;
    private TestClientProtocolTranslatorPB clientPB;
    private Server rpcServer;

    @BeforeEach
    public void setUp() throws IOException {
        AsyncRpcProtocolPBUtil.setAsyncResponderExecutor((Executor)ForkJoinPool.commonPool());
        Configuration conf = new Configuration();
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        TestClientProtocolServerSideTranslatorPB serverImpl = new TestClientProtocolServerSideTranslatorPB(100);
        BlockingService service = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService((TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface)serverImpl);
        this.rpcServer = new RPC.Builder(conf).setProtocol(TestRpcBase.TestRpcService.class).setInstance((Object)service).setBindAddress("0.0.0.0").setPort(0).setNumHandlers(1).setVerbose(true).build();
        this.rpcServer.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)this.rpcServer);
        TestRpcBase.TestRpcService proxy = (TestRpcBase.TestRpcService)RPC.getProxy(TestRpcBase.TestRpcService.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
        this.clientPB = new TestClientProtocolTranslatorPB(proxy);
        Client.setAsynchronousMode((boolean)true);
        this.clientPB.ping();
    }

    @AfterEach
    public void clear() {
        if (this.clientPB != null) {
            this.clientPB.close();
        }
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
    }

    @Test
    public void testAsyncIpcClient() throws Exception {
        Client.setAsynchronousMode((boolean)true);
        long start = Time.monotonicNow();
        this.clientPB.add(1, 2);
        long cost = Time.monotonicNow() - start;
        LOG.info("rpc client add {} {}, cost: {}ms", new Object[]{1, 2, cost});
        Integer res = (Integer)AsyncUtil.syncReturn(Integer.class);
        this.checkResult(3, res, cost);
        start = Time.monotonicNow();
        this.clientPB.echo("test echo!");
        cost = Time.monotonicNow() - start;
        LOG.info("rpc client echo {}, cost: {}ms", (Object)"test echo!", (Object)cost);
        String value = (String)AsyncUtil.syncReturn(String.class);
        this.checkResult("test echo!", value, cost);
        start = Time.monotonicNow();
        this.clientPB.error();
        LOG.info("rpc client error, cost: {}ms", (Object)(Time.monotonicNow() - start));
        LambdaTestUtils.intercept(RemoteException.class, (String)"test!", () -> (String)AsyncUtil.syncReturn(String.class));
    }

    private void checkResult(Object expected, Object actual, long cost) {
        Assertions.assertTrue((cost < 100L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

