/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.router.web;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.contract.hdfs.HDFSContract;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterWebHDFSContract
extends HDFSContract {
    public static final Logger LOG = LoggerFactory.getLogger(WebHdfsFileSystem.class);
    public static final String CONTRACT_WEBHDFS_XML = "contract/webhdfs.xml";
    private static MiniRouterDFSCluster cluster;

    public RouterWebHDFSContract(Configuration conf) {
        super(conf);
        this.addConfResource(CONTRACT_WEBHDFS_XML);
    }

    public static void createCluster() throws IOException {
        RouterWebHDFSContract.createCluster((Configuration)new HdfsConfiguration());
    }

    public static void createCluster(Configuration conf) throws IOException {
        try {
            conf.addResource("contract/hdfs.xml");
            conf.addResource(CONTRACT_WEBHDFS_XML);
            cluster = new MiniRouterDFSCluster(true, 2, conf);
            cluster.setIndependentDNs();
            cluster.setNumDatanodesPerNameservice(3);
            cluster.startCluster(conf);
            cluster.startRouters();
            cluster.registerNamenodes();
            cluster.waitNamenodeRegistration();
            cluster.installMockLocations();
            if (cluster.isHighAvailability()) {
                for (String ns : cluster.getNameservices()) {
                    cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                    cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
                }
            }
            cluster.waitActiveNamespaces();
        }
        catch (Exception e) {
            cluster = null;
            throw new IOException(e.getCause());
        }
    }

    public static void destroyCluster() {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    public static MiniDFSCluster getCluster() {
        return cluster.getCluster();
    }

    public FileSystem getTestFileSystem() throws IOException {
        return RouterWebHDFSContract.getFileSystem();
    }

    public static FileSystem getFileSystem() throws IOException {
        Assertions.assertNotNull((Object)cluster, (String)"cluster not created");
        try {
            MiniRouterDFSCluster.RouterContext router = cluster.getRandomRouter();
            String uriStr = "webhdfs://" + router.getHttpAddress();
            URI uri = new URI(uriStr);
            HdfsConfiguration conf = new HdfsConfiguration();
            return FileSystem.get((URI)uri, (Configuration)conf);
        }
        catch (URISyntaxException e) {
            LOG.error("Cannot create URI for the WebHDFS filesystem", (Throwable)e);
            return null;
        }
    }

    public String getScheme() {
        return "webhdfs";
    }
}

