/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;

public class RouterQuotaManager {
    private TreeMap<String, RouterQuotaUsage> cache;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public RouterQuotaManager() {
        this.cache = new TreeMap();
    }

    public Set<String> getAll() {
        this.readLock.lock();
        try {
            Set<String> set = this.cache.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    boolean isMountEntry(String path) {
        this.readLock.lock();
        try {
            boolean bl = this.cache.containsKey(path);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterQuotaUsage getQuotaUsage(String path) {
        this.readLock.lock();
        try {
            RouterQuotaUsage quotaUsage = this.cache.get(path);
            if (quotaUsage != null && RouterQuotaManager.isQuotaSet(quotaUsage)) {
                RouterQuotaUsage routerQuotaUsage = quotaUsage;
                return routerQuotaUsage;
            }
            int pos = path.lastIndexOf("/");
            if (pos != -1) {
                String parentPath = path.substring(0, pos);
                RouterQuotaUsage routerQuotaUsage = this.getQuotaUsage(parentPath);
                return routerQuotaUsage;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPaths(String parentPath) {
        this.readLock.lock();
        try {
            String from = parentPath;
            String to = parentPath + "\uffff";
            SortedMap<String, RouterQuotaUsage> subMap = this.cache.subMap(from, to);
            HashSet<String> validPaths = new HashSet<String>();
            if (subMap != null) {
                for (String path : subMap.keySet()) {
                    if (!DFSUtil.isParentEntry((String)path, (String)parentPath)) continue;
                    validPaths.add(path);
                }
            }
            HashSet<String> hashSet = validPaths;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeMap<String, RouterQuotaUsage> getParentsContainingQuota(String childPath) {
        TreeMap<String, RouterQuotaUsage> res = new TreeMap<String, RouterQuotaUsage>();
        this.readLock.lock();
        try {
            Map.Entry<String, RouterQuotaUsage> entry = this.cache.floorEntry(childPath);
            while (entry != null) {
                String mountPath = entry.getKey();
                RouterQuotaUsage quota = entry.getValue();
                if (RouterQuotaManager.isQuotaSet(quota) && DFSUtil.isParentEntry((String)childPath, (String)mountPath)) {
                    res.put(mountPath, quota);
                }
                entry = this.cache.lowerEntry(mountPath);
            }
            TreeMap<String, RouterQuotaUsage> treeMap = res;
            return treeMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void put(String path, RouterQuotaUsage quotaUsage) {
        this.writeLock.lock();
        try {
            this.cache.put(path, quotaUsage);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQuota(String path, RouterQuotaUsage quota) {
        this.writeLock.lock();
        try {
            RouterQuotaUsage.Builder builder = new RouterQuotaUsage.Builder().quota(quota.getQuota()).spaceQuota(quota.getSpaceQuota());
            RouterQuotaUsage current = this.cache.get(path);
            if (current != null) {
                builder.fileAndDirectoryCount(current.getFileAndDirectoryCount()).spaceConsumed(current.getSpaceConsumed());
            }
            this.cache.put(path, builder.build());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void remove(String path) {
        this.writeLock.lock();
        try {
            this.cache.remove(path);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static boolean isQuotaSet(QuotaUsage quota) {
        if (quota != null) {
            long nsQuota = quota.getQuota();
            long ssQuota = quota.getSpaceQuota();
            if (nsQuota != -1L || ssQuota != -1L || Quota.orByStorageType(t -> quota.getTypeQuota(t) != -1L)) {
                return true;
            }
        }
        return false;
    }
}

