/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BatchedDirectoryListing;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RouterResolveException;
import org.apache.hadoop.hdfs.server.federation.router.ErasureCoding;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.NoLocationException;
import org.apache.hadoop.hdfs.server.federation.router.NoNamenodesAvailableException;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.router.RemoteLocationContext;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.RemoteResult;
import org.apache.hadoop.hdfs.server.federation.router.RouterCacheAdmin;
import org.apache.hadoop.hdfs.server.federation.router.RouterFederationRename;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterSnapshot;
import org.apache.hadoop.hdfs.server.federation.router.RouterStoragePolicy;
import org.apache.hadoop.hdfs.server.federation.router.security.RouterSecurityManager;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterClientProtocol
implements ClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger((String)RouterClientProtocol.class.getName());
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final RouterFederationRename rbfRename;
    private final FileSubclusterResolver subclusterResolver;
    private final ActiveNamenodeResolver namenodeResolver;
    private volatile FsServerDefaults serverDefaults;
    private volatile long serverDefaultsLastUpdate;
    private final long serverDefaultsValidityPeriod;
    private final boolean allowPartialList;
    private long mountStatusTimeOut;
    private final boolean defaultNameServiceEnabled;
    private String superUser;
    private final String superGroup;
    private final ErasureCoding erasureCoding;
    private final RouterCacheAdmin routerCacheAdmin;
    private final RouterStoragePolicy storagePolicy;
    private final RouterSnapshot snapshotProto;
    private RouterSecurityManager securityManager = null;
    private static GetListingComparator comparator = new GetListingComparator();

    RouterClientProtocol(Configuration conf, RouterRpcServer rpcServer) {
        this.rpcServer = rpcServer;
        this.rpcClient = rpcServer.getRPCClient();
        this.subclusterResolver = rpcServer.getSubclusterResolver();
        this.namenodeResolver = rpcServer.getNamenodeResolver();
        this.allowPartialList = conf.getBoolean("dfs.federation.router.client.allow-partial-listing", true);
        this.mountStatusTimeOut = conf.getTimeDuration("dfs.federation.router.client.mount-status.time-out", RBFConfigKeys.DFS_ROUTER_CLIENT_MOUNT_TIME_OUT_DEFAULT, TimeUnit.MILLISECONDS);
        this.serverDefaultsValidityPeriod = conf.getTimeDuration("dfs.client.server-defaults.validity.period.ms", HdfsClientConfigKeys.DFS_CLIENT_SERVER_DEFAULTS_VALIDITY_PERIOD_MS_DEFAULT, TimeUnit.MILLISECONDS);
        try {
            this.superUser = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException ex) {
            LOG.warn("Unable to get user name. Fall back to system property user.name", (Throwable)ex);
            this.superUser = System.getProperty("user.name");
        }
        this.superGroup = conf.get("dfs.permissions.superusergroup", "supergroup");
        this.erasureCoding = new ErasureCoding(rpcServer);
        this.storagePolicy = new RouterStoragePolicy(rpcServer);
        this.snapshotProto = new RouterSnapshot(rpcServer);
        this.routerCacheAdmin = new RouterCacheAdmin(rpcServer);
        this.securityManager = rpcServer.getRouterSecurityManager();
        this.rbfRename = new RouterFederationRename(rpcServer, conf);
        this.defaultNameServiceEnabled = conf.getBoolean("dfs.federation.router.default.nameservice.enable", true);
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        return this.securityManager.getDelegationToken(renewer);
    }

    public Map<FederationNamespaceInfo, Token<DelegationTokenIdentifier>> getDelegationTokens(Text renewer) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
        return null;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        return this.securityManager.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        this.securityManager.cancelDelegationToken(token);
    }

    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod remoteMethod = new RemoteMethod("getBlockLocations", new Class[]{String.class, Long.TYPE, Long.TYPE}, new RemoteParam(), offset, length);
        return this.rpcClient.invokeSequential(locations, remoteMethod, LocatedBlocks.class, null);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        long now = Time.monotonicNow();
        if (this.serverDefaults == null || now - this.serverDefaultsLastUpdate > this.serverDefaultsValidityPeriod) {
            RemoteMethod method = new RemoteMethod("getServerDefaults");
            this.serverDefaults = this.rpcServer.invokeAtAvailableNs(method, FsServerDefaults.class);
            this.serverDefaultsLastUpdate = now;
        }
        return this.serverDefaults;
    }

    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, String ecPolicyName, String storagePolicy) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        if (createParent && this.rpcServer.isPathAll(src)) {
            int index = src.lastIndexOf("/");
            String parent = src.substring(0, index);
            LOG.debug("Creating {} requires creating parent {}", (Object)src, (Object)parent);
            FsPermission parentPermissions = RouterClientProtocol.getParentPermission(masked);
            boolean success = this.mkdirs(parent, parentPermissions, createParent);
            if (!success) {
                LOG.error("Couldn't create parents for {}", (Object)src);
            }
        }
        RemoteMethod method = new RemoteMethod("create", new Class[]{String.class, FsPermission.class, String.class, EnumSetWritable.class, Boolean.TYPE, Short.TYPE, Long.TYPE, CryptoProtocolVersion[].class, String.class, String.class}, new RemoteParam(), masked, clientName, flag, createParent, replication, blockSize, supportedVersions, ecPolicyName, storagePolicy);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteLocation createLocation = null;
        try {
            createLocation = this.rpcServer.getCreateLocation(src, locations);
            HdfsFileStatus status = this.rpcClient.invokeSingle(createLocation, method, HdfsFileStatus.class);
            status.setNamespace(createLocation.getNameserviceId());
            return status;
        }
        catch (IOException ioe) {
            List<RemoteLocation> newLocations = this.checkFaultTolerantRetry(method, src, ioe, createLocation, locations);
            return this.rpcClient.invokeSequential(newLocations, method, HdfsFileStatus.class, null);
        }
    }

    protected static boolean isUnavailableSubclusterException(IOException ioe) {
        if (ioe instanceof ConnectException || ioe instanceof ConnectTimeoutException || ioe instanceof NoNamenodesAvailableException) {
            return true;
        }
        if (ioe.getCause() instanceof IOException) {
            IOException cause = (IOException)ioe.getCause();
            return RouterClientProtocol.isUnavailableSubclusterException(cause);
        }
        return false;
    }

    private List<RemoteLocation> checkFaultTolerantRetry(RemoteMethod method, String src, IOException ioe, RemoteLocation excludeLoc, List<RemoteLocation> locations) throws IOException {
        List<RemoteLocation> newLocations;
        if (!RouterClientProtocol.isUnavailableSubclusterException(ioe)) {
            LOG.debug("{} exception cannot be retried", (Object)ioe.getClass().getSimpleName());
            throw ioe;
        }
        if (!this.rpcServer.isPathFaultTolerant(src)) {
            LOG.debug("{} does not allow retrying a failed subcluster", (Object)src);
            throw ioe;
        }
        if (excludeLoc == null) {
            LOG.error("Cannot invoke {} for {}: {}", new Object[]{method, src, ioe.getMessage()});
            newLocations = locations;
        } else {
            LOG.error("Cannot invoke {} for {} in {}: {}", new Object[]{method, src, excludeLoc, ioe.getMessage()});
            newLocations = new ArrayList<RemoteLocation>();
            for (RemoteLocation loc : locations) {
                if (loc.equals(excludeLoc)) continue;
                newLocations.add(loc);
            }
        }
        LOG.info("{} allows retrying failed subclusters in {}", (Object)src, newLocations);
        return newLocations;
    }

    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("append", new Class[]{String.class, String.class, EnumSetWritable.class}, new RemoteParam(), clientName, flag);
        RemoteResult result = this.rpcClient.invokeSequential(method, locations, LastBlockWithStatus.class, null);
        LastBlockWithStatus lbws = (LastBlockWithStatus)result.getResult();
        lbws.getFileStatus().setNamespace(((RemoteLocationContext)result.getLocation()).getNameserviceId());
        return lbws;
    }

    public boolean recoverLease(String src, String clientName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true, false);
        RemoteMethod method = new RemoteMethod("recoverLease", new Class[]{String.class, String.class}, new RemoteParam(), clientName);
        Boolean result = this.rpcClient.invokeSequential(locations, method, Boolean.class, null);
        return result;
    }

    public boolean setReplication(String src, short replication) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("setReplication", new Class[]{String.class, Short.TYPE}, new RemoteParam(), replication);
        if (this.rpcServer.isInvokeConcurrent(src)) {
            return !this.rpcClient.invokeConcurrent(locations, method, Boolean.class).containsValue(false);
        }
        return this.rpcClient.invokeSequential(locations, method, Boolean.class, (Object)Boolean.TRUE);
    }

    public void setStoragePolicy(String src, String policyName) throws IOException {
        this.storagePolicy.setStoragePolicy(src, policyName);
    }

    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        return this.storagePolicy.getStoragePolicies();
    }

    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("setPermission", new Class[]{String.class, FsPermission.class}, new RemoteParam(), permissions);
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("setOwner", new Class[]{String.class, String.class, String.class}, new RemoteParam(), username, groupname);
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, long fileId, String[] favoredNodes, EnumSet<AddBlockFlag> addBlockFlags) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("addBlock", new Class[]{String.class, String.class, ExtendedBlock.class, DatanodeInfo[].class, Long.TYPE, String[].class, EnumSet.class}, new RemoteParam(), clientName, previous, excludedNodes, fileId, favoredNodes, addBlockFlags);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        if (previous != null) {
            return this.rpcClient.invokeSingle(previous, method, locations, LocatedBlock.class);
        }
        return this.rpcClient.invokeSequential(locations, method, LocatedBlock.class, null);
    }

    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getAdditionalDatanode", new Class[]{String.class, Long.TYPE, ExtendedBlock.class, DatanodeInfo[].class, String[].class, DatanodeInfo[].class, Integer.TYPE, String.class}, new RemoteParam(), fileId, blk, existings, existingStorageIDs, excludes, numAdditionalNodes, clientName);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        if (blk != null) {
            return this.rpcClient.invokeSingle(blk, method, locations, LocatedBlock.class);
        }
        return this.rpcClient.invokeSequential(locations, method, LocatedBlock.class, null);
    }

    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("abandonBlock", new Class[]{ExtendedBlock.class, Long.TYPE, String.class, String.class}, b, fileId, new RemoteParam(), holder);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        this.rpcClient.invokeSingle(b, method, locations, Void.class);
    }

    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("complete", new Class[]{String.class, String.class, ExtendedBlock.class, Long.TYPE}, new RemoteParam(), clientName, last, fileId);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        if (last != null) {
            return this.rpcClient.invokeSingle(last, method, locations, Boolean.class);
        }
        return this.rpcClient.invokeSequential(locations, method, Boolean.class, null);
    }

    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("updateBlockForPipeline", new Class[]{ExtendedBlock.class, String.class}, block, clientName);
        return this.rpcClient.invokeSingle(block, method, LocatedBlock.class);
    }

    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("updatePipeline", new Class[]{String.class, ExtendedBlock.class, ExtendedBlock.class, DatanodeID[].class, String[].class}, clientName, oldBlock, newBlock, newNodes, newStorageIDs);
        this.rpcClient.invokeSingleBlockPool(oldBlock.getBlockPoolId(), method);
    }

    public long getPreferredBlockSize(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true, false);
        RemoteMethod method = new RemoteMethod("getPreferredBlockSize", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, Long.class, null);
    }

    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> srcLocations = this.rpcServer.getLocationsForPath(src, true, false);
        List<RemoteLocation> dstLocations = this.rpcServer.getLocationsForPath(dst, false, false);
        LinkedList<RemoteLocation> locs = new LinkedList<RemoteLocation>(srcLocations);
        RemoteParam dstParam = this.getRenameDestinations(locs, dstLocations);
        if (locs.isEmpty()) {
            return this.rbfRename.routerFedRename(src, dst, srcLocations, dstLocations);
        }
        RemoteMethod method = new RemoteMethod("rename", new Class[]{String.class, String.class}, new RemoteParam(), dstParam);
        if (this.isMultiDestDirectory(src)) {
            if (locs.size() != srcLocations.size()) {
                throw new IOException("Rename of " + src + " to " + dst + " is not allowed. The number of remote locations for both source and target should be same.");
            }
            return this.rpcClient.invokeAll(locs, method);
        }
        return this.rpcClient.invokeSequential(locs, method, Boolean.class, (Object)Boolean.TRUE);
    }

    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> srcLocations = this.rpcServer.getLocationsForPath(src, true, false);
        List<RemoteLocation> dstLocations = this.rpcServer.getLocationsForPath(dst, false, false);
        LinkedList<RemoteLocation> locs = new LinkedList<RemoteLocation>(srcLocations);
        RemoteParam dstParam = this.getRenameDestinations(locs, dstLocations);
        if (locs.isEmpty()) {
            this.rbfRename.routerFedRename(src, dst, srcLocations, dstLocations);
            return;
        }
        RemoteMethod method = new RemoteMethod("rename2", new Class[]{String.class, String.class, options.getClass()}, new RemoteParam(), dstParam, options);
        if (this.isMultiDestDirectory(src)) {
            if (locs.size() != srcLocations.size()) {
                throw new IOException("Rename of " + src + " to " + dst + " is not allowed. The number of remote locations for both source and target should be same.");
            }
            this.rpcClient.invokeConcurrent(locs, method);
        } else {
            this.rpcClient.invokeSequential(locs, method, null, null);
        }
    }

    public void concat(String trg, String[] src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        LocatedBlocks targetBlocks = this.getBlockLocations(trg, 0L, 1L);
        if (targetBlocks == null) {
            throw new IOException("Cannot locate blocks for target file - " + trg);
        }
        LocatedBlock lastLocatedBlock = targetBlocks.getLastLocatedBlock();
        String targetBlockPoolId = lastLocatedBlock.getBlock().getBlockPoolId();
        for (String source : src) {
            LocatedBlocks sourceBlocks = this.getBlockLocations(source, 0L, 1L);
            if (sourceBlocks == null) {
                throw new IOException("Cannot located blocks for source file " + source);
            }
            String sourceBlockPoolId = sourceBlocks.getLastLocatedBlock().getBlock().getBlockPoolId();
            if (sourceBlockPoolId.equals(targetBlockPoolId)) continue;
            throw new IOException("Cannot concatenate source file " + source + " because it is located in a different namespace with block pool id " + sourceBlockPoolId + " from the target file with block pool id " + targetBlockPoolId);
        }
        RemoteLocation targetDestination = this.rpcServer.getLocationForPath(trg, true, targetBlockPoolId);
        String[] sourceDestinations = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            String sourceFile = src[i];
            RemoteLocation location = this.rpcServer.getLocationForPath(sourceFile, true, targetBlockPoolId);
            sourceDestinations[i] = location.getDest();
        }
        RemoteMethod method = new RemoteMethod("concat", new Class[]{String.class, String[].class}, targetDestination.getDest(), sourceDestinations);
        this.rpcClient.invokeSingle(targetDestination, method, Void.class);
    }

    public boolean truncate(String src, long newLength, String clientName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("truncate", new Class[]{String.class, Long.TYPE, String.class}, new RemoteParam(), newLength, clientName);
        return this.rpcClient.invokeSequential(locations, method, Boolean.class, null);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true, false);
        RemoteMethod method = new RemoteMethod("delete", new Class[]{String.class, Boolean.TYPE}, new RemoteParam(), recursive);
        if (this.rpcServer.isPathAll(src)) {
            return this.rpcClient.invokeAll(locations, method);
        }
        return this.rpcClient.invokeSequential(locations, method, Boolean.class, (Object)Boolean.TRUE);
    }

    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("mkdirs", new Class[]{String.class, FsPermission.class, Boolean.TYPE}, new RemoteParam(), masked, createParent);
        if (this.rpcServer.isPathAll(src)) {
            return this.rpcClient.invokeAll(locations, method);
        }
        if (locations.size() > 1) {
            try {
                HdfsFileStatus fileStatus = this.getFileInfo(src);
                if (fileStatus != null) {
                    return true;
                }
            }
            catch (IOException ioe) {
                LOG.error("Error getting file info for {} while proxying mkdirs: {}", (Object)src, (Object)ioe.getMessage());
            }
        }
        RemoteLocation firstLocation = locations.get(0);
        try {
            return this.rpcClient.invokeSingle(firstLocation, method, Boolean.class);
        }
        catch (IOException ioe) {
            List<RemoteLocation> newLocations = this.checkFaultTolerantRetry(method, src, ioe, firstLocation, locations);
            return this.rpcClient.invokeSequential(newLocations, method, Boolean.class, (Object)Boolean.TRUE);
        }
    }

    private Map<String, FederationNamespaceInfo> getAvailableNamespaces() throws IOException {
        HashMap<String, FederationNamespaceInfo> allAvailableNamespaces = new HashMap<String, FederationNamespaceInfo>();
        this.namenodeResolver.getNamespaces().forEach(k -> allAvailableNamespaces.put(k.getNameserviceId(), (FederationNamespaceInfo)k));
        return allAvailableNamespaces;
    }

    private List<FederationNamespaceInfo> getRenewLeaseNSs(List<String> namespaces) throws IOException {
        if (namespaces == null || namespaces.isEmpty()) {
            return new ArrayList<FederationNamespaceInfo>(this.namenodeResolver.getNamespaces());
        }
        ArrayList<FederationNamespaceInfo> result = new ArrayList<FederationNamespaceInfo>();
        Map<String, FederationNamespaceInfo> allAvailableNamespaces = this.getAvailableNamespaces();
        for (String namespace : namespaces) {
            if (!allAvailableNamespaces.containsKey(namespace)) {
                return new ArrayList<FederationNamespaceInfo>(this.namenodeResolver.getNamespaces());
            }
            result.add(allAvailableNamespaces.get(namespace));
        }
        return result;
    }

    public void renewLease(String clientName, List<String> namespaces) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("renewLease", new Class[]{String.class, List.class}, clientName, null);
        List<FederationNamespaceInfo> nss = this.getRenewLeaseNSs(namespaces);
        if (nss.size() == 1) {
            this.rpcClient.invokeSingle(nss.get(0).getNameserviceId(), method);
        } else {
            this.rpcClient.invokeConcurrent(nss, method, false, false);
        }
    }

    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        List<String> children;
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteResult<RemoteLocation, DirectoryListing>> listings = this.getListingInt(src, startAfter, needLocation);
        TreeMap<byte[], HdfsFileStatus> nnListing = new TreeMap<byte[], HdfsFileStatus>(comparator);
        int totalRemainingEntries = 0;
        int remainingEntries = 0;
        boolean namenodeListingExists = false;
        byte[] lastName = null;
        if (listings != null) {
            DirectoryListing listing;
            for (RemoteResult<RemoteLocation, DirectoryListing> result : listings) {
                if (result.hasException()) {
                    IOException ioe = result.getException();
                    if (ioe instanceof FileNotFoundException) {
                        RemoteLocation location = result.getLocation();
                        LOG.debug("Cannot get listing from {}", (Object)location);
                        continue;
                    }
                    if (this.allowPartialList) continue;
                    throw ioe;
                }
                if (result.getResult() == null) continue;
                listing = result.getResult();
                totalRemainingEntries += listing.getRemainingEntries();
                HdfsFileStatus[] partialListing = listing.getPartialListing();
                int length = partialListing.length;
                if (length <= 0) continue;
                HdfsFileStatus lastLocalEntry = partialListing[length - 1];
                byte[] lastLocalName = lastLocalEntry.getLocalNameInBytes();
                if (lastName != null && comparator.compare(lastName, lastLocalName) <= 0) continue;
                lastName = lastLocalName;
            }
            for (RemoteResult<RemoteLocation, DirectoryListing> result : listings) {
                listing = result.getResult();
                if (listing == null) continue;
                namenodeListingExists = true;
                for (HdfsFileStatus file : listing.getPartialListing()) {
                    byte[] filename = file.getLocalNameInBytes();
                    if (totalRemainingEntries > 0 && comparator.compare(filename, lastName) > 0) {
                        ++remainingEntries;
                        continue;
                    }
                    nnListing.put(filename, file);
                }
                remainingEntries += listing.getRemainingEntries();
            }
        }
        if ((children = this.subclusterResolver.getMountPoints(src)) != null) {
            Map<String, Long> dates = this.getMountPointDates(src);
            for (String child : children) {
                long date = 0L;
                if (dates != null && dates.containsKey(child)) {
                    date = dates.get(child);
                }
                Path childPath = new Path(src, child);
                HdfsFileStatus dirStatus = this.getMountPointStatus(childPath.toString(), 0, date);
                byte[] bChild = DFSUtil.string2Bytes((String)child);
                if (lastName == null) {
                    nnListing.put(bChild, dirStatus);
                    continue;
                }
                if (!RouterClientProtocol.shouldAddMountPoint(bChild, lastName, startAfter, remainingEntries)) continue;
                nnListing.put(bChild, dirStatus);
            }
            if (nnListing.size() > 0) {
                byte[] lastListing = nnListing.lastKey();
                for (int i = 0; i < children.size(); ++i) {
                    byte[] bChild = DFSUtil.string2Bytes((String)children.get(i));
                    if (comparator.compare(bChild, lastListing) <= 0) continue;
                    remainingEntries += children.size() - i;
                    break;
                }
            }
        }
        if (!namenodeListingExists && nnListing.size() == 0 && children == null) {
            return null;
        }
        HdfsFileStatus[] combinedData = new HdfsFileStatus[nnListing.size()];
        combinedData = nnListing.values().toArray(combinedData);
        return new DirectoryListing(combinedData, remainingEntries);
    }

    public BatchedDirectoryListing getBatchedListing(String[] srcs, byte[] startAfter, boolean needLocation) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        HdfsFileStatus ret = null;
        IOException noLocationException = null;
        try {
            List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
            RemoteMethod method = new RemoteMethod("getFileInfo", new Class[]{String.class}, new RemoteParam());
            ret = this.rpcServer.isPathAll(src) ? this.getFileInfoAll(locations, method) : this.rpcClient.invokeSequential(locations, method, HdfsFileStatus.class, null);
        }
        catch (RouterResolveException | NoLocationException e) {
            noLocationException = e;
        }
        if (ret == null) {
            List<String> children = this.subclusterResolver.getMountPoints(src);
            if (children != null && !children.isEmpty()) {
                Map<String, Long> dates = this.getMountPointDates(src);
                long date = 0L;
                if (dates != null && dates.containsKey(src)) {
                    date = dates.get(src);
                }
                ret = this.getMountPointStatus(src, children.size(), date, false);
            } else if (children != null) {
                ret = this.getMountPointStatus(src, 0, 0L, false);
            }
        }
        if (ret == null && noLocationException != null) {
            throw noLocationException;
        }
        return ret;
    }

    public boolean isFileClosed(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("isFileClosed", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, Boolean.class, null);
    }

    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("getFileLinkInfo", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, HdfsFileStatus.class, null);
    }

    public HdfsLocatedFileStatus getLocatedFileInfo(String src, boolean needBlockToken) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("getLocatedFileInfo", new Class[]{String.class, Boolean.TYPE}, new RemoteParam(), needBlockToken);
        return (HdfsLocatedFileStatus)this.rpcClient.invokeSequential(locations, method, HdfsFileStatus.class, null);
    }

    public long[] getStats() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("getStats");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, long[]> results = this.rpcClient.invokeConcurrent(nss, method, true, false, long[].class);
        long[] combinedData = new long[9];
        for (long[] data : results.values()) {
            for (int i = 0; i < combinedData.length && i < data.length; ++i) {
                if (data[i] < 0L) continue;
                int n = i;
                combinedData[n] = combinedData[n] + data[i];
            }
        }
        return combinedData;
    }

    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        return this.rpcServer.getDatanodeReport(type, true, 0L);
    }

    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        Map<String, DatanodeStorageReport[]> dnSubcluster = this.rpcServer.getDatanodeStorageReportMap(type);
        return this.mergeDtanodeStorageReport(dnSubcluster);
    }

    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type, boolean requireResponse, long timeOutMs) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        Map<String, DatanodeStorageReport[]> dnSubcluster = this.rpcServer.getDatanodeStorageReportMap(type, requireResponse, timeOutMs);
        return this.mergeDtanodeStorageReport(dnSubcluster);
    }

    private DatanodeStorageReport[] mergeDtanodeStorageReport(Map<String, DatanodeStorageReport[]> dnSubcluster) {
        LinkedHashMap<String, DatanodeStorageReport> datanodesMap = new LinkedHashMap<String, DatanodeStorageReport>();
        for (DatanodeStorageReport[] dns : dnSubcluster.values()) {
            for (DatanodeStorageReport dn : dns) {
                DatanodeInfo dnInfo = dn.getDatanodeInfo();
                String nodeId = dnInfo.getXferAddr();
                DatanodeStorageReport oldDn = (DatanodeStorageReport)datanodesMap.get(nodeId);
                if (oldDn == null || dnInfo.getLastUpdate() > oldDn.getDatanodeInfo().getLastUpdate()) {
                    datanodesMap.put(nodeId, dn);
                    continue;
                }
                LOG.debug("{} is in multiple subclusters", (Object)nodeId);
            }
        }
        Collection datanodes = datanodesMap.values();
        DatanodeStorageReport[] combinedData = new DatanodeStorageReport[datanodes.size()];
        combinedData = datanodes.toArray(combinedData);
        return combinedData;
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("setSafeMode", new Class[]{HdfsConstants.SafeModeAction.class, Boolean.TYPE}, action, isChecked);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Boolean> results = this.rpcClient.invokeConcurrent(nss, method, true, !isChecked, Boolean.class);
        int numSafemode = 0;
        for (boolean safemode : results.values()) {
            if (!safemode) continue;
            ++numSafemode;
        }
        return numSafemode == results.size();
    }

    public boolean restoreFailedStorage(String arg) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("restoreFailedStorage", new Class[]{String.class}, arg);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Boolean> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, Boolean.class);
        boolean success = true;
        for (boolean s : ret.values()) {
            if (s) continue;
            success = false;
            break;
        }
        return success;
    }

    public boolean saveNamespace(long timeWindow, long txGap) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("saveNamespace", new Class[]{Long.TYPE, Long.TYPE}, timeWindow, txGap);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Boolean> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, Boolean.TYPE);
        boolean success = true;
        for (boolean s : ret.values()) {
            if (s) continue;
            success = false;
            break;
        }
        return success;
    }

    public long rollEdits() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("rollEdits", new Class[0], new Object[0]);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Long> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, Long.TYPE);
        long txid = 0L;
        for (long t : ret.values()) {
            if (t <= txid) continue;
            txid = t;
        }
        return txid;
    }

    public void refreshNodes() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("refreshNodes", new Class[0], new Object[0]);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, true);
    }

    public void finalizeUpgrade() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("finalizeUpgrade", new Class[0], new Object[0]);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public boolean upgradeStatus() throws IOException {
        String methodName = RouterRpcServer.getMethodName();
        throw new UnsupportedOperationException("Operation \"" + methodName + "\" is not supported");
    }

    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("rollingUpgrade", new Class[]{HdfsConstants.RollingUpgradeAction.class}, action);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, RollingUpgradeInfo> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, RollingUpgradeInfo.class);
        RollingUpgradeInfo info = null;
        for (RollingUpgradeInfo infoNs : ret.values()) {
            if (info != null || infoNs == null) continue;
            info = infoNs;
        }
        return info;
    }

    public void metaSave(String filename) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("metaSave", new Class[]{String.class}, filename);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, false, false);
        RemoteMethod method = new RemoteMethod("listCorruptFileBlocks", new Class[]{String.class, String.class}, new RemoteParam(), cookie);
        return this.rpcClient.invokeSequential(locations, method, CorruptFileBlocks.class, null);
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("setBalancerBandwidth", new Class[]{Long.TYPE}, bandwidth);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    @VisibleForTesting
    Map<String, List<RemoteLocation>> getAllLocations(String path) throws IOException {
        HashMap<String, List<RemoteLocation>> locations = new HashMap<String, List<RemoteLocation>>();
        try {
            List<RemoteLocation> parentLocations = this.rpcServer.getLocationsForPath(path, false, false);
            parentLocations.forEach(l -> locations.computeIfAbsent(l.getNameserviceId(), k -> new ArrayList()).add(l));
        }
        catch (RouterResolveException | NoLocationException e) {
            LOG.debug("Cannot find locations for {}.", (Object)path);
        }
        List<String> children = this.subclusterResolver.getMountPoints(path);
        if (children != null) {
            for (String child : children) {
                String childPath = new Path(path, child).toUri().getPath();
                Map<String, List<RemoteLocation>> childLocations = this.getAllLocations(childPath);
                childLocations.forEach((k, v) -> locations.computeIfAbsent((String)k, l -> new ArrayList()).addAll(v));
            }
        }
        return locations;
    }

    @VisibleForTesting
    List<RemoteLocation> getLocationsForContentSummary(String path) throws IOException {
        Map<String, List<RemoteLocation>> ns2Locations = this.getAllLocations(path);
        if (ns2Locations.isEmpty()) {
            throw new NoLocationException(path, this.subclusterResolver.getClass());
        }
        ArrayList<RemoteLocation> locations = new ArrayList<RemoteLocation>();
        ns2Locations.forEach((k, v) -> {
            List sortedList = v.stream().sorted().collect(Collectors.toList());
            int size = sortedList.size();
            for (int i = size - 1; i > -1; --i) {
                RemoteLocation currentLocation = (RemoteLocation)sortedList.get(i);
                if (i == 0) {
                    locations.add(currentLocation);
                    continue;
                }
                RemoteLocation preLocation = (RemoteLocation)sortedList.get(i - 1);
                if (!currentLocation.getDest().startsWith(preLocation.getDest() + "/")) {
                    locations.add(currentLocation);
                    continue;
                }
                LOG.debug("Ignore redundant location {}, because there is an ancestor location {}", (Object)currentLocation, (Object)preLocation);
            }
        });
        return locations;
    }

    public ContentSummary getContentSummary(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        ArrayList<ContentSummary> summaries = new ArrayList<ContentSummary>();
        List<RemoteLocation> locations = this.getLocationsForContentSummary(path);
        RemoteMethod method = new RemoteMethod("getContentSummary", new Class[]{String.class}, new RemoteParam());
        List<RemoteResult<RemoteLocation, ContentSummary>> results = this.rpcClient.invokeConcurrent(locations, method, false, -1L, ContentSummary.class);
        FileNotFoundException notFoundException = null;
        for (RemoteResult<RemoteLocation, ContentSummary> result : results) {
            if (result.hasException()) {
                IOException ioe = result.getException();
                if (ioe instanceof FileNotFoundException) {
                    notFoundException = (FileNotFoundException)ioe;
                    continue;
                }
                if (this.allowPartialList) continue;
                throw ioe;
            }
            if (result.getResult() == null) continue;
            summaries.add(result.getResult());
        }
        if (summaries.isEmpty() && notFoundException != null) {
            throw notFoundException;
        }
        return this.aggregateContentSummary(summaries);
    }

    public void fsync(String src, long fileId, String clientName, long lastBlockLength) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true, false);
        RemoteMethod method = new RemoteMethod("fsync", new Class[]{String.class, Long.TYPE, String.class, Long.TYPE}, new RemoteParam(), fileId, clientName, lastBlockLength);
        this.rpcClient.invokeSequential(locations, method);
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("setTimes", new Class[]{String.class, Long.TYPE, Long.TYPE}, new RemoteParam(), mtime, atime);
        this.rpcClient.invokeSequential(locations, method);
    }

    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> targetLocations = this.rpcServer.getLocationsForPath(target, true);
        List<RemoteLocation> linkLocations = this.rpcServer.getLocationsForPath(link, true);
        RemoteLocation linkLocation = linkLocations.get(0);
        RemoteMethod method = new RemoteMethod("createSymlink", new Class[]{String.class, String.class, FsPermission.class, Boolean.TYPE}, new RemoteParam(), linkLocation.getDest(), dirPerms, createParent);
        this.rpcClient.invokeSequential(targetLocations, method);
    }

    public String getLinkTarget(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, false, false);
        RemoteMethod method = new RemoteMethod("getLinkTarget", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, String.class, null);
    }

    public void allowSnapshot(String snapshotRoot) throws IOException {
        this.snapshotProto.allowSnapshot(snapshotRoot);
    }

    public void disallowSnapshot(String snapshot) throws IOException {
        this.snapshotProto.disallowSnapshot(snapshot);
    }

    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        this.snapshotProto.renameSnapshot(snapshotRoot, snapshotOldName, snapshotNewName);
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        return this.snapshotProto.getSnapshottableDirListing();
    }

    public SnapshotStatus[] getSnapshotListing(String snapshotRoot) throws IOException {
        return this.snapshotProto.getSnapshotListing(snapshotRoot);
    }

    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName) throws IOException {
        return this.snapshotProto.getSnapshotDiffReport(snapshotRoot, earlierSnapshotName, laterSnapshotName);
    }

    public SnapshotDiffReportListing getSnapshotDiffReportListing(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName, byte[] startPath, int index) throws IOException {
        return this.snapshotProto.getSnapshotDiffReportListing(snapshotRoot, earlierSnapshotName, laterSnapshotName, startPath, index);
    }

    public long addCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        return this.routerCacheAdmin.addCacheDirective(path, flags);
    }

    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        this.routerCacheAdmin.modifyCacheDirective(directive, flags);
    }

    public void removeCacheDirective(long id) throws IOException {
        this.routerCacheAdmin.removeCacheDirective(id);
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        return this.routerCacheAdmin.listCacheDirectives(prevId, filter);
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        this.routerCacheAdmin.addCachePool(info);
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.routerCacheAdmin.modifyCachePool(info);
    }

    public void removeCachePool(String cachePoolName) throws IOException {
        this.routerCacheAdmin.removeCachePool(cachePoolName);
    }

    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        return this.routerCacheAdmin.listCachePools(prevKey);
    }

    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("modifyAclEntries", new Class[]{String.class, List.class}, new RemoteParam(), aclSpec);
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("removeAclEntries", new Class[]{String.class, List.class}, new RemoteParam(), aclSpec);
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public void removeDefaultAcl(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("removeDefaultAcl", new Class[]{String.class}, new RemoteParam());
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public void removeAcl(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("removeAcl", new Class[]{String.class}, new RemoteParam());
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("setAcl", new Class[]{String.class, List.class}, new RemoteParam(), aclSpec);
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public AclStatus getAclStatus(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("getAclStatus", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, AclStatus.class, null);
    }

    public void createEncryptionZone(String src, String keyName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("createEncryptionZone", new Class[]{String.class, String.class}, new RemoteParam(), keyName);
        this.rpcClient.invokeSequential(locations, method);
    }

    public EncryptionZone getEZForPath(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("getEZForPath", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, EncryptionZone.class, null);
    }

    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public void reencryptEncryptionZone(String zone, HdfsConstants.ReencryptAction action) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> listReencryptionStatus(long prevId) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("setXAttr", new Class[]{String.class, XAttr.class, EnumSet.class}, new RemoteParam(), xAttr, flag);
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("getXAttrs", new Class[]{String.class, List.class}, new RemoteParam(), xAttrs);
        return this.rpcClient.invokeSequential(locations, method, List.class, null);
    }

    public List<XAttr> listXAttrs(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("listXAttrs", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, List.class, null);
    }

    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod method = new RemoteMethod("removeXAttr", new Class[]{String.class, XAttr.class}, new RemoteParam(), xAttr);
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public void checkAccess(String path, FsAction mode) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, false, false);
        RemoteMethod method = new RemoteMethod("checkAccess", new Class[]{String.class, FsAction.class}, new RemoteParam(), mode);
        this.rpcClient.invokeSequential(locations, method);
    }

    public long getCurrentEditLogTxid() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getCurrentEditLogTxid", new Class[0], new Object[0]);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Long> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, Long.TYPE);
        long txid = 0L;
        for (long t : ret.values()) {
            if (t <= txid) continue;
            txid = t;
        }
        return txid;
    }

    public EventBatchList getEditsFromTxid(long txid) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        return this.snapshotProto.createSnapshot(snapshotRoot, snapshotName);
    }

    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.snapshotProto.deleteSnapshot(snapshotRoot, snapshotName);
    }

    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws IOException {
        this.rpcServer.getQuotaModule().setQuota(path, namespaceQuota, storagespaceQuota, type, true);
    }

    public QuotaUsage getQuotaUsage(String path) throws IOException {
        return this.rpcServer.getQuotaModule().getQuotaUsage(path);
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        HashMap<String, LinkedList<LocatedBlock>> blockLocations = new HashMap<String, LinkedList<LocatedBlock>>();
        for (LocatedBlock block : blocks) {
            String bpId = block.getBlock().getBlockPoolId();
            LinkedList<LocatedBlock> bpBlocks = (LinkedList<LocatedBlock>)blockLocations.get(bpId);
            if (bpBlocks == null) {
                bpBlocks = new LinkedList<LocatedBlock>();
                blockLocations.put(bpId, bpBlocks);
            }
            bpBlocks.add(block);
        }
        for (Map.Entry entry : blockLocations.entrySet()) {
            String bpId = (String)entry.getKey();
            List bpBlocks = (List)entry.getValue();
            LocatedBlock[] bpBlocksArray = bpBlocks.toArray(new LocatedBlock[bpBlocks.size()]);
            RemoteMethod method = new RemoteMethod("reportBadBlocks", new Class[]{LocatedBlock[].class}, new Object[]{bpBlocksArray});
            this.rpcClient.invokeSingleBlockPool(bpId, method);
        }
    }

    public void unsetStoragePolicy(String src) throws IOException {
        this.storagePolicy.unsetStoragePolicy(src);
    }

    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        return this.storagePolicy.getStoragePolicy(path);
    }

    public ErasureCodingPolicyInfo[] getErasureCodingPolicies() throws IOException {
        return this.erasureCoding.getErasureCodingPolicies();
    }

    public Map<String, String> getErasureCodingCodecs() throws IOException {
        return this.erasureCoding.getErasureCodingCodecs();
    }

    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies) throws IOException {
        return this.erasureCoding.addErasureCodingPolicies(policies);
    }

    public void removeErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.erasureCoding.removeErasureCodingPolicy(ecPolicyName);
    }

    public void disableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.erasureCoding.disableErasureCodingPolicy(ecPolicyName);
    }

    public void enableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.erasureCoding.enableErasureCodingPolicy(ecPolicyName);
    }

    public ErasureCodingPolicy getErasureCodingPolicy(String src) throws IOException {
        return this.erasureCoding.getErasureCodingPolicy(src);
    }

    public void setErasureCodingPolicy(String src, String ecPolicyName) throws IOException {
        this.erasureCoding.setErasureCodingPolicy(src, ecPolicyName);
    }

    public void unsetErasureCodingPolicy(String src) throws IOException {
        this.erasureCoding.unsetErasureCodingPolicy(src);
    }

    public ECTopologyVerifierResult getECTopologyResultForPolicies(String ... policyNames) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED, true);
        return this.erasureCoding.getECTopologyResultForPolicies(policyNames);
    }

    public ECBlockGroupStats getECBlockGroupStats() throws IOException {
        return this.erasureCoding.getECBlockGroupStats();
    }

    public ReplicatedBlockStats getReplicatedBlockStats() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getReplicatedBlockStats");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, ReplicatedBlockStats> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, ReplicatedBlockStats.class);
        return ReplicatedBlockStats.merge(ret.values());
    }

    @Deprecated
    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId) throws IOException {
        return this.listOpenFiles(prevId, EnumSet.of(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES), "/");
    }

    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId, EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes, String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public void msync() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, true);
        Set<FederationNamespaceInfo> allNamespaces = this.namenodeResolver.getNamespaces();
        RemoteMethod method = new RemoteMethod("msync");
        Set namespacesEligibleForObserverReads = allNamespaces.stream().filter(ns -> this.rpcClient.isNamespaceObserverReadEligible(ns.getNameserviceId())).collect(Collectors.toSet());
        if (namespacesEligibleForObserverReads.isEmpty()) {
            return;
        }
        this.rpcClient.invokeConcurrent(namespacesEligibleForObserverReads, method);
    }

    public void satisfyStoragePolicy(String path) throws IOException {
        this.storagePolicy.satisfyStoragePolicy(path);
    }

    public DatanodeInfo[] getSlowDatanodeReport() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        return this.rpcServer.getSlowDatanodeReport(true, 0L);
    }

    public Path getEnclosingRoot(String src) throws IOException {
        MountTableResolver mountTable;
        Path mountPath = null;
        if (this.defaultNameServiceEnabled) {
            mountPath = new Path("/");
        }
        if (this.subclusterResolver instanceof MountTableResolver && (mountTable = (MountTableResolver)this.subclusterResolver).getMountPoint(src) != null) {
            mountPath = new Path(mountTable.getMountPoint(src).getSourcePath());
        }
        if (mountPath == null) {
            throw new IOException(String.format("No mount point for %s", src));
        }
        EncryptionZone zone = this.getEZForPath(src);
        if (zone == null) {
            return mountPath;
        }
        Path zonePath = new Path(zone.getPath());
        return zonePath.depth() > mountPath.depth() ? zonePath : mountPath;
    }

    public HAServiceProtocol.HAServiceState getHAServiceState() {
        if (this.rpcServer.isSafeMode()) {
            return HAServiceProtocol.HAServiceState.STANDBY;
        }
        return HAServiceProtocol.HAServiceState.ACTIVE;
    }

    private RemoteParam getRenameDestinations(List<RemoteLocation> srcLocations, List<RemoteLocation> dstLocations) throws IOException {
        HashMap<RemoteLocation, String> dstMap = new HashMap<RemoteLocation, String>();
        Iterator<RemoteLocation> iterator = srcLocations.iterator();
        while (iterator.hasNext()) {
            RemoteLocation srcLocation = iterator.next();
            RemoteLocation eligibleDst = this.getFirstMatchingLocation(srcLocation, dstLocations);
            if (eligibleDst != null) {
                dstMap.put(srcLocation, eligibleDst.getDest());
                continue;
            }
            iterator.remove();
        }
        return new RemoteParam(dstMap);
    }

    private RemoteLocation getFirstMatchingLocation(RemoteLocation location, List<RemoteLocation> locations) {
        for (RemoteLocation loc : locations) {
            if (!loc.getNameserviceId().equals(location.getNameserviceId())) continue;
            return loc;
        }
        return null;
    }

    private ContentSummary aggregateContentSummary(Collection<ContentSummary> summaries) {
        if (summaries.size() == 1) {
            return summaries.iterator().next();
        }
        long length = 0L;
        long fileCount = 0L;
        long directoryCount = 0L;
        long quota = 0L;
        long spaceConsumed = 0L;
        long spaceQuota = 0L;
        long snapshotDirectoryCount = 0L;
        long snapshotFileCount = 0L;
        String ecPolicy = "";
        for (ContentSummary summary : summaries) {
            length += summary.getLength();
            fileCount += summary.getFileCount();
            directoryCount += summary.getDirectoryCount();
            quota = summary.getQuota();
            spaceConsumed += summary.getSpaceConsumed();
            spaceQuota = summary.getSpaceQuota();
            snapshotDirectoryCount += summary.getSnapshotDirectoryCount();
            snapshotFileCount += summary.getSnapshotFileCount();
            if (!ecPolicy.isEmpty()) continue;
            ecPolicy = summary.getErasureCodingPolicy();
        }
        ContentSummary ret = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).erasureCodingPolicy(ecPolicy).snapshotDirectoryCount(snapshotDirectoryCount).snapshotFileCount(snapshotFileCount).build();
        return ret;
    }

    private HdfsFileStatus getFileInfoAll(List<RemoteLocation> locations, RemoteMethod method) throws IOException {
        return this.getFileInfoAll(locations, method, -1L);
    }

    private HdfsFileStatus getFileInfoAll(List<RemoteLocation> locations, RemoteMethod method, long timeOutMs) throws IOException {
        Map<RemoteLocation, HdfsFileStatus> results = this.rpcClient.invokeConcurrent(locations, method, false, false, timeOutMs, HdfsFileStatus.class);
        int children = 0;
        HdfsFileStatus dirStatus = null;
        for (RemoteLocation loc : locations) {
            HdfsFileStatus fileStatus = results.get(loc);
            if (fileStatus == null) continue;
            children += fileStatus.getChildrenNum();
            if (!fileStatus.isDirectory()) {
                return fileStatus;
            }
            if (dirStatus != null) continue;
            dirStatus = fileStatus;
        }
        if (dirStatus != null) {
            return FederationUtil.updateMountPointStatus(dirStatus, children);
        }
        return null;
    }

    private static FsPermission getParentPermission(FsPermission mask) {
        FsPermission ret = new FsPermission(mask.getUserAction().or(FsAction.WRITE_EXECUTE), mask.getGroupAction(), mask.getOtherAction());
        return ret;
    }

    @VisibleForTesting
    HdfsFileStatus getMountPointStatus(String name, int childrenNum, long date) {
        return this.getMountPointStatus(name, childrenNum, date, true);
    }

    @VisibleForTesting
    HdfsFileStatus getMountPointStatus(String name, int childrenNum, long date, boolean setPath) {
        EnumSet flags;
        String group;
        String owner;
        FsPermission permission;
        long accessTime;
        long modTime;
        block9: {
            modTime = date;
            accessTime = date;
            permission = FsPermission.getDirDefault();
            owner = this.superUser;
            group = this.superGroup;
            flags = EnumSet.noneOf(HdfsFileStatus.Flags.class);
            if (this.subclusterResolver instanceof MountTableResolver) {
                try {
                    Object mName = name.startsWith("/") ? name : "/" + name;
                    MountTableResolver mountTable = (MountTableResolver)this.subclusterResolver;
                    MountTable entry = mountTable.getMountPoint((String)mName);
                    if (entry == null) break block9;
                    permission = entry.getMode();
                    owner = entry.getOwnerName();
                    group = entry.getGroupName();
                    RemoteMethod method = new RemoteMethod("getFileInfo", new Class[]{String.class}, new RemoteParam());
                    HdfsFileStatus fInfo = this.getFileInfoAll(entry.getDestinations(), method, this.mountStatusTimeOut);
                    if (fInfo != null) {
                        permission = fInfo.getPermission();
                        owner = fInfo.getOwner();
                        group = fInfo.getGroup();
                        childrenNum = fInfo.getChildrenNum();
                        flags = DFSUtil.getFlags((boolean)fInfo.isEncrypted(), (boolean)fInfo.isErasureCoded(), (boolean)fInfo.isSnapshotEnabled(), (boolean)fInfo.hasAcl());
                    }
                }
                catch (IOException e) {
                    LOG.error("Cannot get mount point: {}", (Object)e.getMessage());
                }
            } else {
                try {
                    UserGroupInformation ugi = RouterRpcServer.getRemoteUser();
                    owner = ugi.getUserName();
                    group = ugi.getPrimaryGroupName();
                }
                catch (IOException e) {
                    String msg = "Cannot get remote user: " + e.getMessage();
                    if (UserGroupInformation.isSecurityEnabled()) {
                        LOG.error(msg);
                    }
                    LOG.debug(msg);
                }
            }
        }
        long inodeId = 0L;
        HdfsFileStatus.Builder builder = new HdfsFileStatus.Builder();
        if (setPath) {
            Path path = new Path(name);
            String nameStr = path.getName();
            builder.path(DFSUtil.string2Bytes((String)nameStr));
        }
        return builder.isdir(true).mtime(modTime).atime(accessTime).perm(permission).owner(owner).group(group).symlink(new byte[0]).fileId(inodeId).children(childrenNum).flags(flags).build();
    }

    private Map<String, Long> getMountPointDates(String path) {
        TreeMap<String, Long> ret = new TreeMap<String, Long>();
        if (this.subclusterResolver instanceof MountTableResolver) {
            try {
                List<String> children = this.subclusterResolver.getMountPoints(path);
                for (String child : children) {
                    Long modTime = this.getModifiedTime(ret, path, child);
                    ret.put(child, modTime);
                }
            }
            catch (IOException e) {
                LOG.error("Cannot get mount point", (Throwable)e);
            }
        }
        return ret;
    }

    private long getModifiedTime(Map<String, Long> ret, String path, String child) {
        MountTableResolver mountTable = (MountTableResolver)this.subclusterResolver;
        String srcPath = path.equals("/") ? "/" + child : path + "/" + child;
        Long modTime = 0L;
        try {
            MountTable entry = mountTable.getMountPoint(srcPath);
            if (entry == null) {
                List<MountTable> entries = mountTable.getMounts(srcPath);
                for (MountTable eachEntry : entries) {
                    if (ret.get(child) != null && ret.get(child) >= eachEntry.getDateModified()) continue;
                    modTime = eachEntry.getDateModified();
                }
            } else {
                modTime = entry.getDateModified();
            }
        }
        catch (IOException e) {
            LOG.error("Cannot get mount point", (Throwable)e);
        }
        return modTime;
    }

    private List<RemoteResult<RemoteLocation, DirectoryListing>> getListingInt(String src, byte[] startAfter, boolean needLocation) throws IOException {
        try {
            List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
            if (locations.isEmpty()) {
                return new ArrayList<RemoteResult<RemoteLocation, DirectoryListing>>();
            }
            RemoteMethod method = new RemoteMethod("getListing", new Class[]{String.class, startAfter.getClass(), Boolean.TYPE}, new RemoteParam(), startAfter, needLocation);
            List<RemoteResult<RemoteLocation, DirectoryListing>> listings = this.rpcClient.invokeConcurrent(locations, method, false, -1L, DirectoryListing.class);
            return listings;
        }
        catch (RouterResolveException | NoLocationException e) {
            LOG.debug("Cannot get locations for {}, {}.", (Object)src, (Object)e.getMessage());
            return new ArrayList<RemoteResult<RemoteLocation, DirectoryListing>>();
        }
    }

    private static boolean shouldAddMountPoint(byte[] mountPoint, byte[] lastEntry, byte[] startAfter, int remainingEntries) {
        if (comparator.compare(mountPoint, startAfter) > 0 && comparator.compare(mountPoint, lastEntry) <= 0) {
            return true;
        }
        return remainingEntries == 0 && comparator.compare(mountPoint, lastEntry) >= 0;
    }

    @VisibleForTesting
    boolean isMultiDestDirectory(String src) throws IOException {
        try {
            if (this.rpcServer.isPathAll(src)) {
                List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
                RemoteMethod method = new RemoteMethod("getFileInfo", new Class[]{String.class}, new RemoteParam());
                HdfsFileStatus fileStatus = this.rpcClient.invokeSequential(locations, method, HdfsFileStatus.class, null);
                if (fileStatus != null) {
                    return fileStatus.isDirectory();
                }
                LOG.debug("The destination {} doesn't exist.", (Object)src);
            }
        }
        catch (UnresolvedPathException e) {
            LOG.debug("The destination {} is a symlink.", (Object)src);
        }
        return false;
    }

    public int getRouterFederationRenameCount() {
        return this.rbfRename.getRouterFederationRenameCount();
    }

    private static class GetListingComparator
    implements Comparator<byte[]>,
    Serializable {
        private GetListingComparator() {
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return DFSUtilClient.compareBytes((byte[])o1, (byte[])o2);
        }
    }
}

