/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.lib.wsrs.Param;
import org.apache.hadoop.lib.wsrs.Parameters;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class ParametersProvider {
    private String driverParam;
    private Class<? extends Enum> enumClass;
    private Map<Enum, Class<Param<?>>[]> paramsDef;

    public ParametersProvider(String driverParam, Class<? extends Enum> enumClass, Map<Enum, Class<Param<?>>[]> paramsDef) {
        this.driverParam = driverParam;
        this.enumClass = enumClass;
        this.paramsDef = paramsDef;
    }

    private Param<?> newParam(Class<Param<?>> paramClass) {
        try {
            return paramClass.newInstance();
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException(MessageFormat.format("Param class [{0}] does not have default constructor", paramClass.getName()));
        }
    }

    public Parameters get(HttpServletRequest request) {
        Enum op;
        HashMap map = new HashMap();
        Map queryString = request.getParameterMap();
        String str = null;
        if (queryString.containsKey(this.driverParam)) {
            str = ((String[])queryString.get(this.driverParam))[0];
        }
        if (str == null) {
            throw new IllegalArgumentException(MessageFormat.format("Missing Operation parameter [{0}]", this.driverParam));
        }
        try {
            op = Enum.valueOf(this.enumClass, StringUtils.toUpperCase(str));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid Operation [{0}]", str));
        }
        if (!this.paramsDef.containsKey(op)) {
            throw new IllegalArgumentException(MessageFormat.format("Unsupported Operation [{0}]", op));
        }
        for (Class<Param<?>> paramClass : this.paramsDef.get(op)) {
            Param<?> param = this.newParam(paramClass);
            ArrayList paramList = Lists.newArrayList();
            String[] ps = (String[])queryString.get(param.getName());
            if (ps != null) {
                for (String p : ps) {
                    try {
                        param.parseParam(p);
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(ex.toString(), ex);
                    }
                    paramList.add(param);
                    param = this.newParam(paramClass);
                }
            } else {
                paramList.add(param);
            }
            map.put(param.getName(), paramList);
        }
        return new Parameters(map);
    }
}

